/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.UtilitiesCollection;
import com.anylogic.engine.markup.AbstractDrawableMarkupAggregator;
import com.anylogic.engine.markup.AbstractMarkup;
import com.anylogic.engine.markup.AbstractRailwayMarkup;
import com.anylogic.engine.markup.PositionOnTrack;
import com.anylogic.engine.markup.RailwaySwitch;
import com.anylogic.engine.markup.RailwayTrack;
import com.anylogic.engine.presentation.ShapeDrawMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class RailwayNetwork
extends AbstractDrawableMarkupAggregator {
    private static final long serialVersionUID = -897041126840714279L;
    private List<RailwayTrack> j = new ArrayList<RailwayTrack>();
    private List<RailwaySwitch> i = new ArrayList<RailwaySwitch>();
    private List<PositionOnTrack> d = new ArrayList<PositionOnTrack>();
    private double l = 0.0;
    private double g;

    public RailwayNetwork(Agent agent, String string, ShapeDrawMode shapeDrawMode, double d2) {
        super(agent, string, shapeDrawMode);
        this.l = d2;
    }

    public RailwayNetwork(Agent agent, String string, ShapeDrawMode shapeDrawMode, double d2, boolean bl2, boolean bl3) {
        this(agent, string, shapeDrawMode, d2);
        this.m = bl2;
        this.k = bl3;
    }

    public RailwayNetwork(Agent agent, String string, ShapeDrawMode shapeDrawMode, double d2, boolean bl2, boolean bl3, AbstractRailwayMarkup ... abstractRailwayMarkupArray) {
        this(agent, string, shapeDrawMode, d2, bl2, bl3);
        this.addAll(abstractRailwayMarkupArray);
        this.initialize();
    }

    public void addAll(AbstractRailwayMarkup ... abstractRailwayMarkupArray) {
        AbstractRailwayMarkup[] abstractRailwayMarkupArray2 = abstractRailwayMarkupArray;
        int n2 = abstractRailwayMarkupArray.length;
        int n3 = 0;
        while (n3 < n2) {
            AbstractRailwayMarkup abstractRailwayMarkup = abstractRailwayMarkupArray2[n3];
            if (abstractRailwayMarkup instanceof RailwayTrack) {
                this.add((RailwayTrack)abstractRailwayMarkup);
            } else if (abstractRailwayMarkup instanceof RailwaySwitch) {
                this.add((RailwaySwitch)abstractRailwayMarkup);
            } else if (abstractRailwayMarkup instanceof PositionOnTrack) {
                this.add((PositionOnTrack)abstractRailwayMarkup);
            } else {
                throw new IllegalArgumentException("Unsupported element: " + abstractRailwayMarkup);
            }
            ++n3;
        }
    }

    public Agent getSpace() {
        return (Agent)this.a;
    }

    public double getZ() {
        return this.l;
    }

    public double getScale() {
        return this.g;
    }

    public List<RailwayTrack> getTracks() {
        this.k();
        return this.j;
    }

    public List<RailwaySwitch> getSwitches() {
        this.k();
        return this.i;
    }

    public List<PositionOnTrack> getPointOnTracks() {
        this.k();
        return this.d;
    }

    @Override
    void n() {
        super.n();
        this.j = Collections.unmodifiableList(this.j);
        this.i = Collections.unmodifiableList(this.i);
        this.d = Collections.unmodifiableList(this.d);
    }

    @Override
    Stream<? extends AbstractMarkup> h() {
        return UtilitiesCollection.streamOfElements(this.j, this.i, this.d);
    }

    public void add(RailwayTrack railwayTrack) {
        this.m();
        railwayTrack.a(this);
        this.j.add(railwayTrack);
    }

    public void add(RailwaySwitch railwaySwitch) {
        this.m();
        railwaySwitch.a(this);
        this.i.add(railwaySwitch);
    }

    public void add(PositionOnTrack positionOnTrack) {
        this.m();
        positionOnTrack.a(this);
        this.d.add(positionOnTrack);
    }

    public double pixelsToMeters(double d2) {
        this.k();
        return this.getSpace().toLengthUnits(d2, LengthUnits.METER);
    }

    public double metersToPixels(double d2) {
        this.k();
        return this.getSpace().toPixels(d2, LengthUnits.METER);
    }
}

