/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.markup.AbstractRailwayMarkup;
import com.anylogic.engine.markup.RailwayTrack;
import com.anylogic.engine.markup.SwitchDataSource;
import com.anylogic.engine.presentation.LineStyle;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeDrawMode;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RailwaySwitch
extends AbstractRailwayMarkup {
    private static final long serialVersionUID = 3490247508785288178L;
    private static final double a = 0.001;
    private static final double n = 1.0E-6;
    private double i;
    private double d;
    private double l;
    private double g;
    private double c;
    private double b = 1.0;
    private Color f = UtilitiesColor.markupDefaultSwitchSelection;
    private Paint e = UtilitiesColor.markupDefaultSwitch;
    @AnyLogicCustomSerialization
    private transient RailwayTrack ac;
    @AnyLogicCustomSerialization
    private transient List<RailwayTrack> mk;
    @AnyLogicCustomSerialization
    private transient RailwayTrack bf;
    @AnyLogicCustomSerialization
    private transient SwitchDataSource bl;

    public RailwaySwitch() {
    }

    public RailwaySwitch(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl2) {
        super(agent, shapeDrawMode, bl2);
    }

    public RailwaySwitch(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl2, double d2, Color color, Paint paint, RailwayTrack railwayTrack, RailwayTrack ... railwayTrackArray) {
        super(agent, shapeDrawMode, bl2);
        this.b = d2;
        this.e = paint;
        this.f = color;
        this.setSwitch(railwayTrack, railwayTrackArray);
        this.initialize();
    }

    @Override
    void h_() {
        this.setColor(UtilitiesColor.red);
    }

    public void setSwitch(RailwayTrack railwayTrack, RailwayTrack ... railwayTrackArray) {
        this.j();
        if (railwayTrack == null) {
            this.error("Argument 'track' is null");
        }
        if (railwayTrackArray == null) {
            this.error("Argument 'alternativeTracks' is null");
        }
        this.ac = railwayTrack;
        this.mk = new ArrayList<RailwayTrack>(railwayTrackArray.length);
        RailwayTrack[] railwayTrackArray2 = railwayTrackArray;
        int n2 = railwayTrackArray.length;
        int n3 = 0;
        while (n3 < n2) {
            RailwayTrack railwayTrack2 = railwayTrackArray2[n3];
            if (railwayTrack2 != null) {
                this.mk.add(railwayTrack2);
            }
            ++n3;
        }
    }

    @Override
    void g_() {
        super.g_();
        if (this.ac == null) {
            this.error("Main track is not defined. Please check that this switch has three connected tracks");
        }
        if (this.mk.size() == 0 || this.mk.size() > 2) {
            this.error("There should be 1-2 alternative tracks. Please check that this switch has three connected tracks");
        }
        Point[] pointArray = new Point[]{this.ac.k(), this.ac.b()};
        Point point = null;
        boolean[] blArray = new boolean[this.mk.size() + 1];
        int n2 = 0;
        while (n2 < pointArray.length) {
            blArray[0] = n2 == 0;
            point = pointArray[n2];
            int n3 = 0;
            while (n3 < this.mk.size()) {
                boolean bl2 = blArray[n3 + 1] = point.distanceSq(this.mk.get(n3).k()) <= 1.0E-6;
                if (!blArray[n3 + 1] && point.distanceSq(this.mk.get(n3).b()) > 1.0E-6) {
                    point = null;
                    break;
                }
                ++n3;
            }
            if (point != null) break;
            ++n2;
        }
        if (point == null) {
            this.error("Error during switch initialization: couldn't find matching point on alternative track");
        }
        this.i = point.x;
        this.d = point.y;
        double d2 = blArray[0] ? 0.0 : this.ac.length();
        Position position = this.ac.getPositionAtOffset(d2, new Position());
        this.l = position.z;
        int n4 = 0;
        while (n4 < blArray.length) {
            if (blArray[n4]) {
                if (n4 == 0) {
                    this.ac.a(this);
                } else {
                    this.mk.get(n4 - 1).a(this);
                }
            } else if (n4 == 0) {
                this.ac.n(this);
            } else {
                this.mk.get(n4 - 1).n(this);
            }
            ++n4;
        }
        this.bf = this.mk.get(0);
        this.mk = Collections.unmodifiableList(this.mk);
        this.k();
    }

    private void k() {
        double d2 = this.b * 1.5;
        boolean bl2 = this.bf.getStartSwitch() == this;
        double d3 = bl2 ? d2 : this.bf.length() - d2;
        Position position = this.bf.getPositionAtOffset(d3, new Position());
        this.g = position.x - this.i;
        this.c = position.y - this.d;
    }

    public void setDataSource(SwitchDataSource switchDataSource) {
        if (switchDataSource == null) {
            this.a(hg.ihf, "dataSource");
        }
        if (switchDataSource == this.bl) {
            return;
        }
        if (this.bl != null) {
            this.a(hg.mjl, switchDataSource);
        }
        this.bl = switchDataSource;
    }

    public double getX() {
        return this.i;
    }

    public double getY() {
        return this.d;
    }

    public double getZ() {
        return this.l;
    }

    public double getRadius() {
        return this.b;
    }

    public void setRadius(double d2) {
        this.b = d2;
        if (this.mk != null) {
            this.k();
        }
    }

    public Color getSelectionColor() {
        return this.f;
    }

    public void setSelectionColor(Color color) {
        this.f = color;
    }

    public Paint getColor() {
        return this.e;
    }

    public void setColor(Paint paint) {
        this.e = paint;
    }

    public RailwayTrack getMainTrack() {
        return this.ac;
    }

    public List<RailwayTrack> getAlternativeTracks() {
        return this.mk;
    }

    public RailwayTrack getTrack(int n2) {
        this.h();
        if (n2 == 0) {
            return this.ac;
        }
        return this.mk.get(n2 - 1);
    }

    public RailwayTrack getSelectedTrack() {
        this.h();
        return this.bf;
    }

    public void setSelectedTrack(RailwayTrack railwayTrack) {
        this.h();
        if (!this.mk.contains(railwayTrack)) {
            this.a("The track %s is not connected to the switch '%s'", railwayTrack.getName(), this.getName());
        }
        this.bf = railwayTrack;
        this.k();
        if (this.bl != null) {
            this.bl.onToggle();
        }
    }

    public void toggle() {
        this.h();
        int n2 = this.mk.indexOf(this.bf);
        if (++n2 == this.mk.size()) {
            n2 = 0;
        }
        this.setSelectedTrack(this.mk.get(n2));
    }

    public RailwayTrack nextTrack(RailwayTrack railwayTrack) {
        this.h();
        if (railwayTrack == this.ac) {
            return this.bf;
        }
        if (this.mk.contains(railwayTrack)) {
            return this.ac;
        }
        this.a("The track %s is not connected to the switch '%s'", railwayTrack.getName(), this.getName());
        return null;
    }

    public boolean isTrailingPoint(RailwayTrack railwayTrack) {
        this.h();
        if (railwayTrack == this.ac) {
            return false;
        }
        if (this.mk.contains(railwayTrack)) {
            return true;
        }
        this.a("The track %s is not connected to the switch '%s'", railwayTrack.getName(), this.getName());
        return false;
    }

    public boolean trackStarts(RailwayTrack railwayTrack) {
        this.h();
        if (railwayTrack != this.ac && !this.mk.contains(railwayTrack)) {
            this.a("The track %s is not connected to the switch '%s'", railwayTrack.getName(), this.getName());
        }
        return railwayTrack.getStartSwitch() == this;
    }

    @Override
    public boolean contains(double d2, double d3) {
        return d2 == this.i && d3 == this.d;
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl2) {
        if (!this.a(bl2)) {
            return;
        }
        com.anylogic.engine.internal.presentation.e.a(graphics2D, this.e);
        com.anylogic.engine.internal.presentation.e.n(panel, graphics2D, affineTransform, this.i, this.d, 0.0, 1.0, 1.0, this.e, null, this.b, this.b, 2.0, LineStyle.LINE_STYLE_SOLID);
        graphics2D.setStroke(com.anylogic.engine.internal.presentation.e.n());
        com.anylogic.engine.internal.presentation.e.a(panel, graphics2D, affineTransform, this.i, this.d, 0.0, 1.0, 1.0, this.f, this.g, this.c, 1.0f, LineStyle.LINE_STYLE_SOLID);
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public boolean onClick(double d2, double d3) {
        this.toggle();
        return true;
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public boolean onClickAt(double d2, double d3, boolean bl2) {
        if (!this.a(bl2)) {
            this.ma = false;
            return false;
        }
        double d4 = d2 - this.i;
        double d5 = d3 - this.d;
        this.ma = Utilities.getLengthSq(d4, d5) <= this.b * this.b;
        if (this.ma) {
            return this.onClick(d4, d5);
        }
        return false;
    }
}

