/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicCustomProposalType;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AnyLogicInternalLibraryAPI;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.Point;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.SpeedUnits;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.lh;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.internal.y.d;
import com.anylogic.engine.internal.y.db;
import com.anylogic.engine.internal.y.fd;
import com.anylogic.engine.internal.y.he;
import com.anylogic.engine.internal.y.l;
import com.anylogic.engine.markup.AbstractRoadConnectableElement;
import com.anylogic.engine.markup.AbstractRoadPart;
import com.anylogic.engine.markup.AbstractRoadSidePart;
import com.anylogic.engine.markup.BusStop;
import com.anylogic.engine.markup.MarkupSegment;
import com.anylogic.engine.markup.MarkupSegmentLine;
import com.anylogic.engine.markup.ParkingLot;
import com.anylogic.engine.markup.PathDrawingType;
import com.anylogic.engine.markup.RoadConnectionPoint;
import com.anylogic.engine.markup.RoadDataSource;
import com.anylogic.engine.markup.RoadDrivingDirection;
import com.anylogic.engine.markup.RoadEnd;
import com.anylogic.engine.markup.RoadLineStyle;
import com.anylogic.engine.markup.RoadNetwork;
import com.anylogic.engine.markup.StopLine;
import com.anylogic.engine.markup.a;
import com.anylogic.engine.markup.j;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeDrawMode;
import com.anylogic.engine.presentation.Texture;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Road
extends AbstractRoadConnectableElement {
    private static final long serialVersionUID = -1857481195856280351L;
    private int i;
    private int d;
    private double l;
    private final a g = new a(0.0);
    private Paint c = Color.green;
    private List<MarkupSegment> b = new ArrayList<MarkupSegment>();
    private List<ArrayList<MarkupSegment>> f = new ArrayList<ArrayList<MarkupSegment>>();
    private List<ArrayList<MarkupSegment>> e = new ArrayList<ArrayList<MarkupSegment>>();
    private List<RoadConnectionPoint> ac = new ArrayList<RoadConnectionPoint>();
    private List<RoadConnectionPoint> mk = new ArrayList<RoadConnectionPoint>();
    private List<RoadConnectionPoint> bf = new ArrayList<RoadConnectionPoint>();
    private List<RoadConnectionPoint> bl = new ArrayList<RoadConnectionPoint>();
    private Map<RoadConnectionPoint, Integer> ca = new HashMap<RoadConnectionPoint, Integer>();
    @AnyLogicCustomSerialization
    private transient RoadDataSource mi;
    private transient Path2D be;
    private transient Map<Path2D, Float> kh;
    private transient List<Path2D> kn;
    private transient List<StopLine> ck;
    private transient List<ParkingLot> bh;
    private transient List<BusStop> di;
    public static final float[] DOUBLE_DASH = new float[]{10.0f, 5.0f};
    public static final float[] SINGLE_DASH = new float[]{5.0f, 10.0f};
    private static /* synthetic */ int[] bm;

    private void b() {
        if (this.b.size() == 0) {
            this.error("Error while creating road segment: Axis segments count cannot be 0.");
        }
        if (this.i < 0) {
            this.error("Error while creating road segment: Forward lanes count cannot be negative.");
        }
        if (this.d < 0) {
            this.error("Error while creating road segment: Backward lanes count cannot be negative.");
        }
        if (!this.g.n()) {
            this.error("Error while creating road segment: Median strip width should not be negative.");
        }
    }

    public Road() {
    }

    public Road(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl2, int n2, int n3, double d2, Paint paint, MarkupSegment ... markupSegmentArray) {
        super(agent, shapeDrawMode, bl2);
        this.i = n2;
        this.d = n3;
        this.g.n(d2);
        this.c = paint;
        Collections.addAll(this.b, markupSegmentArray);
        this.initialize();
    }

    @AnyLogicInternalLibraryAPI
    public void setDataSource(RoadDataSource roadDataSource) {
        if (roadDataSource == null) {
            this.a(hg.ihf, "dataSource");
        }
        if (roadDataSource == this.mi) {
            return;
        }
        if (this.mi != null) {
            this.a(hg.mjl, roadDataSource);
        }
        this.mi = roadDataSource;
    }

    public double averageSpeed(boolean bl2, double d2, SpeedUnits speedUnits) {
        return this.mi == null ? 0.0 : this.mi.averageSpeed(bl2, d2, speedUnits);
    }

    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.MPS)
    public double averageSpeed(boolean bl2, double d2) {
        return this.averageSpeed(bl2, d2, SpeedUnits.MPS);
    }

    public int nCars(boolean bl2) {
        return this.mi == null ? 0 : this.mi.nCars(bl2);
    }

    public List<Agent> getCars(boolean bl2) {
        return this.mi == null ? Collections.emptyList() : this.mi.getCars(bl2);
    }

    public void setForwardLanesCount(int n2) {
        this.j();
        this.i = n2;
    }

    public void setBackwardLanesCount(int n2) {
        this.j();
        this.d = n2;
    }

    public void setMedianStripWidth(double d2) {
        this.j();
        this.g.a(d2);
    }

    public void setMedianStripWidth(double d2, LengthUnits lengthUnits) {
        this.j();
        this.g.a(d2, lengthUnits);
    }

    public void addSegment(MarkupSegment markupSegment) {
        this.j();
        this.b.add(markupSegment);
    }

    public int getSegmentCount() {
        return this.b.size();
    }

    public MarkupSegment getSegment(int n2) {
        return this.b.get(n2);
    }

    public Iterator<MarkupSegment> iterator() {
        return new lh<MarkupSegment>(this.b.iterator());
    }

    @Override
    void g_() {
        super.g_();
        this.b();
    }

    @Override
    protected void i() {
        double d2;
        super.i();
        int n2 = 0;
        while (n2 < this.i) {
            this.f.add(new ArrayList());
            ++n2;
        }
        n2 = 0;
        while (n2 < this.d) {
            this.e.add(new ArrayList());
            ++n2;
        }
        double d3 = com.anylogic.engine.markup.j.a(this);
        double d4 = this.n.getLaneWidth();
        this.l = d4 * (double)(this.i + this.d) + d3;
        double d5 = this.n.getDrivingDirection() == RoadDrivingDirection.ROAD_RIGHT_HAND ? 1 : -1;
        int n3 = 0;
        while (n3 < this.i) {
            d2 = d5 * (d3 / 2.0 + d4 / 2.0 + (double)n3 * d4);
            this.f.get(this.i - n3 - 1).addAll((Collection<MarkupSegment>)com.anylogic.engine.markup.j.a(this.b, d2));
            ++n3;
        }
        n3 = 0;
        while (n3 < this.d) {
            d2 = d5 * -(d3 / 2.0 + d4 / 2.0 + (double)n3 * d4);
            this.e.get(this.d - n3 - 1).addAll(com.anylogic.engine.markup.j.a((List<MarkupSegment>)com.anylogic.engine.markup.j.a(this.b, d2)));
            ++n3;
        }
        this.e();
    }

    private void e() {
        RoadConnectionPoint roadConnectionPoint;
        MarkupSegmentLine markupSegmentLine;
        MarkupSegmentLine markupSegmentLine2;
        RoadConnectionPoint roadConnectionPoint2;
        MarkupSegmentLine markupSegmentLine3;
        MarkupSegmentLine markupSegmentLine4;
        MarkupSegment markupSegment;
        MarkupSegment markupSegment2;
        int n2 = 0;
        while (n2 < this.i) {
            markupSegment2 = this.f.get(n2).get(0);
            markupSegment = this.f.get(n2).get(this.f.get(n2).size() - 1);
            markupSegmentLine4 = com.anylogic.engine.markup.j.a(markupSegment2, true, 2.0);
            markupSegmentLine3 = Road.a(markupSegmentLine4, this.n.getLaneWidth());
            roadConnectionPoint2 = new RoadConnectionPoint(markupSegmentLine3, markupSegmentLine4, this, true);
            this.ac.add(roadConnectionPoint2);
            this.ca.put(roadConnectionPoint2, n2);
            markupSegmentLine2 = com.anylogic.engine.markup.j.a(markupSegment, false, 2.0);
            markupSegmentLine = Road.a(markupSegmentLine2, this.n.getLaneWidth());
            roadConnectionPoint = new RoadConnectionPoint(markupSegmentLine, markupSegmentLine2, this, false);
            this.bl.add(roadConnectionPoint);
            this.ca.put(roadConnectionPoint, n2);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.d) {
            markupSegment2 = this.e.get(n2).get(0);
            markupSegment = this.e.get(n2).get(this.e.get(n2).size() - 1);
            markupSegmentLine4 = com.anylogic.engine.markup.j.a(markupSegment2, true, 2.0);
            markupSegmentLine3 = Road.a(markupSegmentLine4, this.n.getLaneWidth());
            roadConnectionPoint2 = new RoadConnectionPoint(markupSegmentLine3, markupSegmentLine4, this, true);
            this.bf.add(roadConnectionPoint2);
            this.ca.put(roadConnectionPoint2, n2);
            markupSegmentLine2 = com.anylogic.engine.markup.j.a(markupSegment, false, 2.0);
            markupSegmentLine = Road.a(markupSegmentLine2, this.n.getLaneWidth());
            roadConnectionPoint = new RoadConnectionPoint(markupSegmentLine, markupSegmentLine2, this, false);
            this.mk.add(roadConnectionPoint);
            this.ca.put(roadConnectionPoint, n2);
            ++n2;
        }
    }

    private static MarkupSegmentLine a(MarkupSegmentLine markupSegmentLine, double d2) {
        Point point = markupSegmentLine.getStart(new Point());
        Point point2 = markupSegmentLine.getEnd(new Point());
        Point point3 = com.anylogic.engine.markup.j.a(point2, 1.5707963267948966, point);
        MarkupSegmentLine markupSegmentLine2 = com.anylogic.engine.markup.j.a(point, point3);
        Point point4 = com.anylogic.engine.markup.j.a((MarkupSegment)markupSegmentLine2, d2 / 2.0);
        Point point5 = com.anylogic.engine.markup.j.a((MarkupSegment)markupSegmentLine2, -d2 / 2.0);
        return com.anylogic.engine.markup.j.a(point4, point5);
    }

    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.PIXEL)
    public double getWidth() {
        return this.l;
    }

    public double getWidth(LengthUnits lengthUnits) {
        return this.gf.toLengthUnits(this.l, lengthUnits);
    }

    @AnyLogicInternalLibraryAPI
    public List<RoadConnectionPoint> getIncomingConnectionPoints(RoadEnd.Type type) {
        switch (Road.k()[type.ordinal()]) {
            case 1: {
                return this.ac;
            }
            case 2: {
                return this.bf;
            }
        }
        throw this.a(hg.dhh, new Object[]{"type", type});
    }

    @AnyLogicInternalLibraryAPI
    public List<RoadConnectionPoint> getOutgoingConnectionPoints(RoadEnd.Type type) {
        switch (Road.k()[type.ordinal()]) {
            case 1: {
                return this.mk;
            }
            case 2: {
                return this.bl;
            }
        }
        throw this.a(hg.dhh, new Object[]{"type", type});
    }

    @AnyLogicInternalLibraryAPI
    public List<RoadConnectionPoint> getBeginConnectionPoints() {
        ArrayList<RoadConnectionPoint> arrayList = new ArrayList<RoadConnectionPoint>();
        arrayList.addAll(this.mk);
        ArrayList<RoadConnectionPoint> arrayList2 = new ArrayList<RoadConnectionPoint>();
        arrayList2.addAll(this.ac);
        Collections.reverse(arrayList2);
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    @AnyLogicInternalLibraryAPI
    public List<RoadConnectionPoint> getEndConnectionPoints() {
        ArrayList<RoadConnectionPoint> arrayList = new ArrayList<RoadConnectionPoint>();
        arrayList.addAll(this.bl);
        ArrayList<RoadConnectionPoint> arrayList2 = new ArrayList<RoadConnectionPoint>();
        arrayList2.addAll(this.bf);
        Collections.reverse(arrayList2);
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    @AnyLogicInternalLibraryAPI
    public int getLaneIndex(RoadConnectionPoint roadConnectionPoint) {
        Integer n2 = this.ca.get(roadConnectionPoint);
        return n2 != null ? n2 : -1;
    }

    @AnyLogicInternalLibraryAPI
    public RoadConnectionPoint getForwardIncomingConnectionPoint(int n2) {
        if (n2 < 0 || n2 >= this.ac.size()) {
            return null;
        }
        return this.ac.get(n2);
    }

    @AnyLogicInternalLibraryAPI
    public boolean isConnectionPointOnForwardDirection(RoadConnectionPoint roadConnectionPoint) {
        return this.ac.contains(roadConnectionPoint) || this.bl.contains(roadConnectionPoint);
    }

    @AnyLogicInternalLibraryAPI
    public RoadConnectionPoint getForwardOutgoingConnectionPoint(int n2) {
        if (n2 < 0 || n2 >= this.bl.size()) {
            return null;
        }
        return this.bl.get(n2);
    }

    @AnyLogicInternalLibraryAPI
    public RoadConnectionPoint getBackwardIncomingConnectionPoint(int n2) {
        if (n2 < 0 || n2 >= this.bf.size()) {
            return null;
        }
        return this.bf.get(n2);
    }

    public void setMedianStripColor(Color color) {
        this.setMedianStripColor((Paint)color);
    }

    public void setMedianStripColor(Paint paint) {
        this.c = paint;
    }

    public Color getMedianStripColor() {
        return this.c instanceof Color ? (Color)this.c : null;
    }

    public Texture getMedianStripTexture() {
        return this.c instanceof Texture ? (Texture)this.c : null;
    }

    @AnyLogicInternalLibraryAPI
    public RoadConnectionPoint getBackwardOutgoingConnectionPoint(int n2) {
        if (n2 < 0 || n2 >= this.mk.size()) {
            return null;
        }
        return this.mk.get(n2);
    }

    public int getForwardLanesCount() {
        return this.i;
    }

    public int getBackwardLanesCount() {
        return this.d;
    }

    @AnyLogicInternalLibraryAPI
    public List<MarkupSegment> getForwardLaneMarkupSegments(int n2) {
        return this.f.get(n2);
    }

    @AnyLogicInternalLibraryAPI
    public List<MarkupSegment> getBackwardLaneMarkupSegments(int n2) {
        return this.e.get(n2);
    }

    @AnyLogicInternalLibraryAPI
    public List<MarkupSegment> getAxisMarkupSegments() {
        return this.b;
    }

    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.PIXEL)
    public double getMedianStripWidth() {
        return this.g.a(this);
    }

    public double getMedianStripWidth(LengthUnits lengthUnits) {
        return this.g.a(this, lengthUnits);
    }

    private Map<List<MarkupSegment>, Double> k(boolean bl2) {
        boolean bl3;
        HashMap<List<MarkupSegment>, Double> hashMap = new HashMap<List<MarkupSegment>, Double>();
        double d2 = this.n.getLaneWidth();
        double d3 = com.anylogic.engine.markup.j.a(this);
        Paint paint = d3 != 0.0 ? this.c : com.anylogic.engine.markup.j.a(this.n);
        boolean bl4 = this.n.getDrivingDirection() == RoadDrivingDirection.ROAD_RIGHT_HAND;
        int n2 = bl4 ? this.i : this.d;
        int n3 = bl4 ? this.d : this.i;
        boolean bl5 = n2 != 0 && n3 != 0;
        boolean bl6 = paint == null && d3 != 0.0;
        boolean bl7 = bl3 = bl5 && (bl2 || bl6);
        if (bl3) {
            double d4 = d2 * (double)n2;
            double d5 = d2 * (double)n3;
            double d6 = (d4 + d3) / 2.0;
            double d7 = -(d5 + d3) / 2.0;
            double d8 = com.anylogic.engine.markup.j.a(this.b, d6);
            hashMap.put((List<MarkupSegment>)d8, d4);
            double d9 = com.anylogic.engine.markup.j.a(this.b, d7);
            hashMap.put((List<MarkupSegment>)d9, d5);
        } else {
            Object object = this.b;
            double d10 = d2 * (double)(n2 + n3) + d3;
            double d11 = (double)(n2 - n3) * d2 / 2.0;
            if (d11 != 0.0) {
                object = com.anylogic.engine.markup.j.a(this.b, d11);
            }
            hashMap.put((List<MarkupSegment>)object, d10);
        }
        return hashMap;
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl2) {
        boolean bl3;
        this.h();
        if (!this.a(bl2)) {
            return;
        }
        double d2 = com.anylogic.engine.markup.j.a(this);
        Paint paint = d2 != 0.0 ? this.c : com.anylogic.engine.markup.j.a(this.n);
        boolean bl4 = this.i != 0 && this.d != 0;
        boolean bl5 = bl3 = bl4 && paint != null;
        if (this.be == null && bl3) {
            this.be = com.anylogic.engine.internal.presentation.e.a(this.b);
        }
        if (this.kh == null) {
            this.kh = new HashMap<Path2D, Float>();
            Map<List<MarkupSegment>, Double> object = this.k(false);
            for (List<MarkupSegment> list : object.keySet()) {
                double d3 = object.get(list);
                this.kh.put(com.anylogic.engine.internal.presentation.e.a(list), Float.valueOf((float)d3));
            }
        }
        if (this.kn == null) {
            this.kn = new ArrayList<Path2D>();
            boolean bl6 = this.n.getDrivingDirection() == RoadDrivingDirection.ROAD_RIGHT_HAND;
            int n2 = bl6 ? this.i : this.d;
            int n3 = bl6 ? this.d : this.i;
            this.a(this.kn, n2, true);
            this.a(this.kn, n3, false);
        }
        if (this.be == null && bl3) {
            this.be = com.anylogic.engine.internal.presentation.e.a(this.b);
        }
        com.anylogic.engine.internal.presentation.e.a(graphics2D, affineTransform);
        if (this.kh != null) {
            for (Path2D path2D : this.kh.keySet()) {
                com.anylogic.engine.internal.presentation.e.a(graphics2D, this.kh.get(path2D).floatValue(), Presentable.LINE_STYLE_SOLID, false);
                com.anylogic.engine.internal.presentation.e.a(graphics2D, com.anylogic.engine.markup.j.k(this.n));
                graphics2D.draw(path2D);
            }
        }
        for (Path2D path2D : this.kn) {
            this.a(graphics2D, path2D, this.n.getLanesDelimitingLineStyle(), com.anylogic.engine.markup.j.n(this.n));
        }
        if (this.be != null) {
            if (d2 != 0.0) {
                com.anylogic.engine.internal.presentation.e.a(graphics2D, this.be, PathDrawingType.PATH_LINE, (float)d2, paint);
            } else {
                this.a(graphics2D, this.be, this.n.getDirectionsDelimitingLineStyle(), com.anylogic.engine.markup.j.a(this.n));
            }
        }
    }

    private void a(Graphics2D graphics2D, Path2D path2D, RoadLineStyle roadLineStyle, Paint paint) {
        boolean bl2 = RoadLineStyle.DOUBLE_STYLES.contains((Object)roadLineStyle);
        boolean bl3 = RoadLineStyle.DASHED_STYLES.contains((Object)roadLineStyle);
        float f2 = (float)this.a(roadLineStyle);
        float f3 = (float)(3.0 * this.a(roadLineStyle));
        if (bl2) {
            BasicStroke basicStroke = bl3 ? new BasicStroke(f3, 0, 2, 4.0f, DOUBLE_DASH, 0.0f) : com.anylogic.engine.internal.presentation.e.a(f3, Presentable.LINE_STYLE_SOLID, true);
            com.anylogic.engine.internal.presentation.e.a(graphics2D, paint);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(path2D);
            com.anylogic.engine.internal.presentation.e.a(graphics2D, com.anylogic.engine.markup.j.k(this.n));
            com.anylogic.engine.internal.presentation.e.a(graphics2D, f2, Presentable.LINE_STYLE_SOLID, true);
            graphics2D.draw(path2D);
        } else {
            BasicStroke basicStroke = bl3 ? new BasicStroke(f2, 0, 2, 4.0f, SINGLE_DASH, 0.0f) : com.anylogic.engine.internal.presentation.e.a(f2, Presentable.LINE_STYLE_SOLID, true);
            com.anylogic.engine.internal.presentation.e.a(graphics2D, paint);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(path2D);
        }
    }

    @Override
    @AnyLogicInternalLibraryAPI
    public List<RoadConnectionPoint> getConnectionPoints() {
        ArrayList<RoadConnectionPoint> arrayList = new ArrayList<RoadConnectionPoint>(2);
        arrayList.addAll(this.getBeginConnectionPoints());
        arrayList.addAll(this.getEndConnectionPoints());
        return arrayList;
    }

    @Override
    @AnyLogicInternalAPI
    public void update3D(Panel panel, boolean bl2) {
        if (!this.getDrawMode().has3D()) {
            return;
        }
        this.a(panel, bl2);
    }

    @Override
    int f_() {
        return super.f_() + 3;
    }

    @Override
    l[] g() {
        l[] lArray = super.g();
        int n2 = super.f_();
        lArray[n2] = this.nd();
        lArray[n2 + 1] = this.ac();
        lArray[n2 + 2] = this.mk();
        return lArray;
    }

    private l ac() {
        return new d(this, d.a.a, com.anylogic.engine.markup.j.k(this.n));
    }

    private l mk() {
        return new d(this, d.a.n, !this.g.k() ? this.c : com.anylogic.engine.markup.j.a(this.n));
    }

    private l nd() {
        Paint paint;
        double d2;
        double d3 = 0.0;
        ArrayList<MarkupSegment> arrayList = new ArrayList<MarkupSegment>();
        if (com.anylogic.engine.markup.j.n(this.n) != null) {
            boolean bl2 = this.n.getDrivingDirection() == RoadDrivingDirection.ROAD_RIGHT_HAND;
            int n2 = bl2 ? this.i : this.d;
            int n3 = bl2 ? this.d : this.i;
            this.a(arrayList, n2, 1);
            this.a(arrayList, n3, -1);
        }
        ArrayList<MarkupSegment> arrayList2 = new ArrayList();
        double d4 = com.anylogic.engine.markup.j.a(this);
        if (d4 != 0.0) {
            d2 = d4;
            paint = this.c;
            arrayList2 = this.b;
        } else {
            d2 = this.a(this.n.getDirectionsDelimitingLineStyle());
            paint = com.anylogic.engine.markup.j.a(this.n);
            if (paint != null && this.d != 0) {
                this.a(arrayList2, this.n.getDirectionsDelimitingLineStyle(), 0);
            }
        }
        return new he(this, d3, this.k(true), com.anylogic.engine.markup.j.k(this.n), arrayList2, d2, paint, arrayList, this.a(this.n.getLanesDelimitingLineStyle()), com.anylogic.engine.markup.j.n(this.n));
    }

    private double a(RoadLineStyle roadLineStyle) {
        return com.anylogic.engine.markup.j.m(this.n);
    }

    private void a(List<Path2D> list, int n2, boolean bl2) {
        double d2 = this.n.getLaneWidth();
        double d3 = com.anylogic.engine.markup.j.a(this);
        int n3 = 0;
        while (n3 < n2 - 1) {
            double d4 = d3 / 2.0 + d2 * (double)(n3 + 1);
            if (!bl2) {
                d4 *= -1.0;
            }
            double d5 = com.anylogic.engine.markup.j.a(this.b, d4);
            list.add(com.anylogic.engine.internal.presentation.e.a((List<MarkupSegment>)d5));
            ++n3;
        }
    }

    private void a(List<MarkupSegment> list, int n2, int n3) {
        RoadLineStyle roadLineStyle = this.n.getLanesDelimitingLineStyle();
        int n4 = 0;
        while (n4 < n2 - 1) {
            this.a(list, roadLineStyle, n3 * (n4 + 1));
            ++n4;
        }
    }

    private void a(List<MarkupSegment> list, RoadLineStyle roadLineStyle, int n2) {
        double d2 = this.n.getLaneWidth();
        double d3 = com.anylogic.engine.markup.j.a(this);
        double d4 = this.a(roadLineStyle);
        double d5 = (d4 + this.a(roadLineStyle)) / 2.0;
        boolean bl2 = RoadLineStyle.DOUBLE_STYLES.contains((Object)roadLineStyle);
        boolean bl3 = RoadLineStyle.DASHED_STYLES.contains((Object)roadLineStyle);
        float[] fArray = bl2 ? DOUBLE_DASH : SINGLE_DASH;
        double d6 = fArray[0];
        double d7 = fArray[1];
        double d8 = (double)Math.signum(n2) * (d3 / 2.0 + d2 * (double)Math.abs(n2));
        Object object = com.anylogic.engine.markup.j.a(this.b, d8);
        if (bl3) {
            object = com.anylogic.engine.markup.j.k((List<MarkupSegment>)object, d6, d7);
        }
        if (bl2) {
            List<MarkupSegment> list2 = com.anylogic.engine.markup.j.a((List<MarkupSegment>)object, -d5, true);
            List<MarkupSegment> list3 = com.anylogic.engine.markup.j.a((List<MarkupSegment>)object, d5, true);
            list.addAll(list2);
            list.addAll(list3);
        } else {
            list.addAll((Collection<MarkupSegment>)object);
        }
    }

    @Override
    void a(db db2) {
        super.a(db2);
        if (this.n(ha)) {
            db2.a(this.nd());
        }
        if (this.n(bn)) {
            db2.a(this.ac());
        }
    }

    @Override
    fd f() {
        double d2 = 0.0;
        return new fd(this, 0.0, 0.0, d2, 1.0, 1.0, 1.0, 0.0);
    }

    private <T extends AbstractRoadSidePart> List<T> a(Function<RoadNetwork, List<T>> function) {
        this.h();
        List list = function.apply(this.n).stream().filter(abstractRoadSidePart -> abstractRoadSidePart.getRoad() == this).sorted(Comparator.comparingDouble(AbstractRoadPart::getOffset)).collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }

    public List<StopLine> getStopLines() {
        if (this.ck == null) {
            this.ck = this.a(RoadNetwork::getStopLines);
        }
        return this.ck;
    }

    public List<ParkingLot> getParkingLots() {
        if (this.bh == null) {
            this.bh = this.a(RoadNetwork::getParkingLots);
        }
        return this.bh;
    }

    public List<BusStop> getBusStops() {
        if (this.di == null) {
            this.di = this.a(RoadNetwork::getBusStops);
        }
        return this.di;
    }

    static /* synthetic */ int[] k() {
        if (bm != null) {
            return bm;
        }
        int[] nArray = new int[RoadEnd.Type.values().length];
        try {
            nArray[RoadEnd.Type.BEGIN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RoadEnd.Type.END.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        bm = nArray;
        return nArray;
    }
}

