/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Point;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.markup.AbstractRoadConnectableElement;
import com.anylogic.engine.markup.MarkupSegmentLine;
import com.anylogic.engine.markup.j;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeLine;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.Serializable;

@AnyLogicInternalAPI
public class RoadConnectionPoint
implements Serializable {
    private static final long serialVersionUID = 4487047768871132519L;
    private final MarkupSegmentLine a;
    private final MarkupSegmentLine n;
    @AnyLogicCustomSerialization
    private transient AbstractRoadConnectableElement k;
    @AnyLogicCustomSerialization
    private transient RoadConnectionPoint m;
    private final boolean h;
    @Deprecated
    private ShapeLine j = new ShapeLine();
    @Deprecated
    private ShapeLine i = new ShapeLine();

    RoadConnectionPoint(MarkupSegmentLine markupSegmentLine, MarkupSegmentLine markupSegmentLine2, AbstractRoadConnectableElement abstractRoadConnectableElement, boolean bl2) {
        this.a = markupSegmentLine;
        this.n = markupSegmentLine2;
        this.k = abstractRoadConnectableElement;
        this.h = bl2;
        this.a(markupSegmentLine, markupSegmentLine2);
    }

    public MarkupSegmentLine getConnectionSegment() {
        return this.a;
    }

    public MarkupSegmentLine getDirectionSegment() {
        return this.n;
    }

    public AbstractRoadConnectableElement getOwner() {
        return this.k;
    }

    public RoadConnectionPoint getConnectedPoint() {
        return this.m;
    }

    public boolean isIncoming() {
        return this.h;
    }

    public Point getCentralPoint() {
        return this.n.getStart(new Point());
    }

    public void connectTo(RoadConnectionPoint roadConnectionPoint) {
        if (!this.canConnectTo(roadConnectionPoint)) {
            throw new RuntimeException("Cannot connect to the specified connection point.");
        }
        this.m = roadConnectionPoint;
        this.a();
        roadConnectionPoint.m = this;
        roadConnectionPoint.a();
    }

    public boolean canConnectTo(RoadConnectionPoint roadConnectionPoint) {
        return com.anylogic.engine.markup.j.a(this.n.getStart(new Point()).distance(roadConnectionPoint.getDirectionSegment().getStart(new Point()))) && com.anylogic.engine.markup.j.a(this.n.getEnd(new Point()).distance(roadConnectionPoint.getDirectionSegment().getEnd(new Point())));
    }

    public RoadConnectionPoint createConnectedPoint(AbstractRoadConnectableElement abstractRoadConnectableElement) {
        RoadConnectionPoint roadConnectionPoint = new RoadConnectionPoint(this.a, this.n, abstractRoadConnectableElement, !this.h);
        this.connectTo(roadConnectionPoint);
        return roadConnectionPoint;
    }

    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl2) {
        this.a(panel, graphics2D, affineTransform, bl2);
    }

    @Deprecated
    private void a() {
        Color color = this.getConnectedPoint() == null ? UtilitiesColor.darkGray : UtilitiesColor.darkGreen;
        this.j.setColor(color);
        this.i.setColor(color);
        this.j.setLineWidth(2.0);
        this.i.setLineWidth(1.0);
        this.j.setLineStyle(Presentable.LINE_STYLE_SOLID);
        this.i.setLineStyle(Presentable.LINE_STYLE_SOLID);
    }

    @Deprecated
    private void a(MarkupSegmentLine markupSegmentLine, MarkupSegmentLine markupSegmentLine2) {
        this.j.setX(markupSegmentLine.getStartX());
        this.j.setY(markupSegmentLine.getStartY());
        this.j.setEndX(markupSegmentLine.getEndX());
        this.j.setEndY(markupSegmentLine.getEndY());
        this.i.setX(markupSegmentLine2.getStartX());
        this.i.setY(markupSegmentLine2.getStartY());
        this.i.setEndX(markupSegmentLine2.getEndX());
        this.i.setEndY(markupSegmentLine2.getEndY());
        this.a();
    }

    @Deprecated
    private void a(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl2) {
        this.j.draw(panel, graphics2D, affineTransform, true);
        this.i.draw(panel, graphics2D, affineTransform, false);
    }
}

