/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicCustomProposalType;
import com.anylogic.engine.ExtRootModelAgent;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.UtilitiesCollection;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.markup.AbstractDrawableMarkupAggregator;
import com.anylogic.engine.markup.AbstractRoadConnectableElement;
import com.anylogic.engine.markup.AbstractRoadMarkup;
import com.anylogic.engine.markup.BusStop;
import com.anylogic.engine.markup.Intersection;
import com.anylogic.engine.markup.ParkingLot;
import com.anylogic.engine.markup.Road;
import com.anylogic.engine.markup.RoadConnectionPoint;
import com.anylogic.engine.markup.RoadDrivingDirection;
import com.anylogic.engine.markup.RoadLineStyle;
import com.anylogic.engine.markup.StopLine;
import com.anylogic.engine.markup.TrafficLight;
import com.anylogic.engine.presentation.ShapeDrawMode;
import com.anylogic.engine.presentation.Texture;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class RoadNetwork
extends AbstractDrawableMarkupAggregator {
    private static final long serialVersionUID = -937909314958968329L;
    private RoadDrivingDirection j = RoadDrivingDirection.ROAD_RIGHT_HAND;
    private double i;
    private double d;
    private boolean l;
    private Paint g = Color.gray;
    private Paint c = Color.white;
    private RoadLineStyle b = RoadLineStyle.ROAD_LINE_SINGLE_DASHED;
    private Paint f = Color.white;
    private RoadLineStyle e = RoadLineStyle.ROAD_LINE_SINGLE;
    private List<Road> ac = new ArrayList<Road>();
    private List<Intersection> mk = new ArrayList<Intersection>();
    private List<StopLine> nd = new ArrayList<StopLine>();
    private List<ParkingLot> mf = new ArrayList<ParkingLot>();
    private List<BusStop> hl = new ArrayList<BusStop>();
    private List<TrafficLight<?>> gf = new ArrayList();

    public RoadNetwork(Agent agent, String string, ShapeDrawMode shapeDrawMode) {
        super(agent, string, shapeDrawMode);
        this.setLaneWidth(3.5, LengthUnits.METER);
    }

    public RoadNetwork(Agent agent, String string, ShapeDrawMode shapeDrawMode, boolean bl2, boolean bl3, RoadDrivingDirection roadDrivingDirection, double d2, Paint paint, Paint paint2, RoadLineStyle roadLineStyle, Paint paint3, RoadLineStyle roadLineStyle2, boolean bl4) {
        super(agent, string, shapeDrawMode);
        this.m = bl2;
        this.k = bl3;
        this.j = roadDrivingDirection;
        this.setLaneWidth(d2, LengthUnits.METER);
        this.g = paint;
        this.c = paint2;
        this.b = roadLineStyle;
        this.f = paint3;
        this.e = roadLineStyle2;
        this.l = bl4;
        this.i();
    }

    public RoadNetwork(Agent agent, String string, ShapeDrawMode shapeDrawMode, boolean bl2, boolean bl3, RoadDrivingDirection roadDrivingDirection, double d2, Paint paint, Paint paint2, RoadLineStyle roadLineStyle, Paint paint3, RoadLineStyle roadLineStyle2, boolean bl4, TrafficLight<?>[] trafficLightArray, AbstractRoadMarkup ... abstractRoadMarkupArray) {
        this(agent, string, shapeDrawMode, bl2, bl3, roadDrivingDirection, d2, paint, paint2, roadLineStyle, paint3, roadLineStyle2, bl4);
        Stream.of(trafficLightArray).forEach(trafficLight -> this.add((TrafficLight<?>)trafficLight));
        this.addAll(abstractRoadMarkupArray);
        this.initialize();
    }

    private void i() {
        if (this.i <= 0.0) {
            throw this.a(hg.dhh, "laneWidthInMeters", this.i);
        }
    }

    public void addAll(AbstractRoadMarkup ... abstractRoadMarkupArray) {
        AbstractRoadMarkup[] abstractRoadMarkupArray2 = abstractRoadMarkupArray;
        int n2 = abstractRoadMarkupArray.length;
        int n3 = 0;
        while (n3 < n2) {
            AbstractRoadMarkup abstractRoadMarkup = abstractRoadMarkupArray2[n3];
            if (abstractRoadMarkup instanceof Road) {
                this.add((Road)abstractRoadMarkup);
            } else if (abstractRoadMarkup instanceof Intersection) {
                this.add((Intersection)abstractRoadMarkup);
            } else if (abstractRoadMarkup instanceof StopLine) {
                this.add((StopLine)abstractRoadMarkup);
            } else if (abstractRoadMarkup instanceof ParkingLot) {
                this.add((ParkingLot)abstractRoadMarkup);
            } else if (abstractRoadMarkup instanceof BusStop) {
                this.add((BusStop)abstractRoadMarkup);
            } else {
                throw new IllegalArgumentException("Unsupported element: " + abstractRoadMarkup);
            }
            ++n3;
        }
    }

    public void add(Road road) {
        this.m();
        road.setRoadNetwork(this);
        this.ac.add(road);
    }

    public void add(Intersection intersection) {
        this.m();
        intersection.setRoadNetwork(this);
        this.mk.add(intersection);
    }

    public void add(StopLine stopLine) {
        this.m();
        stopLine.setRoadNetwork(this);
        this.nd.add(stopLine);
    }

    public void add(ParkingLot parkingLot) {
        this.m();
        parkingLot.setRoadNetwork(this);
        this.mf.add(parkingLot);
    }

    public void add(BusStop busStop) {
        this.m();
        busStop.setRoadNetwork(this);
        this.hl.add(busStop);
    }

    public void add(TrafficLight<?> trafficLight) {
        this.m();
        trafficLight.setRoadNetwork(this);
        this.gf.add(trafficLight);
    }

    public List<Road> getRoads() {
        this.k();
        return this.ac;
    }

    public List<StopLine> getStopLines() {
        this.k();
        return this.nd;
    }

    public List<Intersection> getIntersections() {
        this.k();
        return this.mk;
    }

    public List<ParkingLot> getParkingLots() {
        this.k();
        return this.mf;
    }

    public List<BusStop> getBusStops() {
        this.k();
        return this.hl;
    }

    public List<TrafficLight<?>> getTrafficLights() {
        this.k();
        return this.gf;
    }

    public RoadDrivingDirection getDrivingDirection() {
        return this.j;
    }

    public void setDrivingDirection(RoadDrivingDirection roadDrivingDirection) {
        this.m();
        this.j = roadDrivingDirection;
    }

    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.PIXEL)
    public double getLaneWidth() {
        return this.d;
    }

    public double getLaneWidth(LengthUnits lengthUnits) {
        return LengthUnits.METER.convertTo(this.i, lengthUnits);
    }

    public void setLaneWidth(double d2) {
        this.m();
        this.i = ((Agent)this.a).toLengthUnits(d2, LengthUnits.METER);
        this.d = d2;
    }

    public void setLaneWidth(double d2, LengthUnits lengthUnits) {
        this.m();
        this.i = lengthUnits.convertTo(d2, LengthUnits.METER);
        this.d = ((Agent)this.a).toPixels(this.i, LengthUnits.METER);
    }

    public void setRoadBackgroundColor(Color color) {
        this.setRoadBackgroundColor((Paint)color);
    }

    public void setRoadBackgroundColor(Paint paint) {
        this.g = paint;
    }

    public Color getRoadBackgroundColor() {
        return this.g instanceof Color ? (Color)this.g : null;
    }

    public Texture getRoadBackgroundTexture() {
        return this.g instanceof Texture ? (Texture)this.g : null;
    }

    public void setLanesDelimitingLineColor(Color color) {
        this.setLanesDelimitingLineColor((Paint)color);
    }

    public void setLanesDelimitingLineColor(Paint paint) {
        this.m();
        this.c = paint;
    }

    public Color getLanesDelimitingLineColor() {
        return this.c instanceof Color ? (Color)this.c : null;
    }

    public Texture getLanesDelimitingLineTexture() {
        return this.c instanceof Texture ? (Texture)this.c : null;
    }

    public void setLanesDelimitingLineStyle(RoadLineStyle roadLineStyle) {
        this.b = roadLineStyle;
    }

    public RoadLineStyle getLanesDelimitingLineStyle() {
        return this.b;
    }

    public void setDirectionsDelimitingLineColor(Color color) {
        this.setDirectionsDelimitingLineColor((Paint)color);
    }

    public void setDirectionsDelimitingLineColor(Paint paint) {
        this.m();
        this.f = paint;
    }

    public Color getDirectionsDelimitingLineColor() {
        return this.f instanceof Color ? (Color)this.f : null;
    }

    public Texture getDirectionsDelimitingLineTexture() {
        return this.f instanceof Texture ? (Texture)this.f : null;
    }

    public void setDirectionsDelimitingLineStyle(RoadLineStyle roadLineStyle) {
        this.m();
        this.e = roadLineStyle;
    }

    public RoadLineStyle getDirectionsDelimitingLineStyle() {
        return this.e;
    }

    public boolean isSignalStateAnimationVisible() {
        return this.l;
    }

    public void setSignalStateAnimationVisible(boolean bl2) {
        this.l = bl2;
    }

    @Override
    void n() {
        super.n();
        this.ac = Collections.unmodifiableList(this.ac);
        this.mk = Collections.unmodifiableList(this.mk);
        this.nd = Collections.unmodifiableList(this.nd);
        this.mf = Collections.unmodifiableList(this.mf);
        this.hl = Collections.unmodifiableList(this.hl);
        this.gf = Collections.unmodifiableList(this.gf);
        this.d();
    }

    private void d() {
        ExtRootModelAgent extRootModelAgent = ((Agent)this.getOwner()).getRootAgent().ext(ExtRootModelAgent.class);
        Set set = extRootModelAgent.getCustomObject(RoadNetwork.class, LinkedHashSet::new);
        set.add(this);
    }

    @Override
    void a() {
        super.a();
        this.l();
    }

    private void l() {
        ArrayList<AbstractRoadConnectableElement> arrayList = new ArrayList<AbstractRoadConnectableElement>();
        arrayList.addAll(this.ac);
        arrayList.addAll(this.mk);
        for (AbstractRoadConnectableElement abstractRoadConnectableElement : arrayList) {
            for (RoadConnectionPoint roadConnectionPoint : abstractRoadConnectableElement.getConnectionPoints()) {
                for (AbstractRoadConnectableElement abstractRoadConnectableElement2 : arrayList) {
                    if (abstractRoadConnectableElement2 == abstractRoadConnectableElement) continue;
                    for (RoadConnectionPoint roadConnectionPoint2 : abstractRoadConnectableElement2.getConnectionPoints()) {
                        if (!roadConnectionPoint.canConnectTo(roadConnectionPoint2) || roadConnectionPoint.getConnectedPoint() != null) continue;
                        roadConnectionPoint.connectTo(roadConnectionPoint2);
                    }
                }
            }
        }
    }

    @Override
    Stream<? extends AbstractRoadMarkup> h() {
        return UtilitiesCollection.streamOfElements(this.ac, this.mk, this.nd, this.mf, this.hl);
    }

    @Deprecated
    public void setDebugInfoVisible(boolean bl2) {
        this.h().forEach(abstractRoadMarkup -> abstractRoadMarkup.setDebugInfoVisible(bl2));
    }
}

