/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.Path2D;
import com.anylogic.engine.Point;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.markup.AbstractGroundMarkup;
import com.anylogic.engine.markup.GroundMarkup;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeDrawMode;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Random;

public class TargetLine
extends AbstractGroundMarkup
implements GroundMarkup {
    private static final long serialVersionUID = -5644504854285254364L;
    protected double a;
    protected double n;
    protected double[] i;
    protected double[] d;
    protected Color l = UtilitiesColor.markupDefaultPedestrian;
    private double g;
    private double[] c;
    private transient Path2D b = null;

    public TargetLine() {
    }

    public TargetLine(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl2, double d2, double d3, double[] dArray, double[] dArray2, Color color) {
        super(agent, shapeDrawMode, bl2);
        this.a = d2;
        this.n = d3;
        this.l = color;
        if (dArray == null || dArray2 == null || dArray.length == 0 || dArray.length != dArray2.length) {
            throw this.error("Error: Invalid dx, dy arguments: should be not empty arrays with equal sizes");
        }
        this.i = dArray;
        this.d = dArray2;
        this.initialize();
    }

    @Override
    void h_() {
        this.setColor(UtilitiesColor.red);
    }

    public double getX() {
        return this.a;
    }

    public double getY() {
        return this.n;
    }

    public void setPos(double d2, double d3) {
        this.j();
        this.a = d2;
        this.n = d3;
    }

    public void addPoint(double d2, double d3) {
        int n2;
        int n3;
        this.j();
        if (this.i == null) {
            this.i = new double[11];
            this.i[0] = 0.0;
        }
        if ((n3 = (n2 = (int)(this.i[0] = this.i[0] + 1.0)) * 2 + 1) > this.i.length) {
            double[] dArray = this.i;
            this.i = new double[n2 * 4 + 1];
            System.arraycopy(dArray, 0, this.i, 0, (n2 - 1) * 2 + 1);
        }
        n3 -= 2;
        this.i[n3++] = d2;
        this.i[n3++] = d3;
    }

    @Override
    void g_() {
        int n2;
        int n3;
        super.g_();
        if (this.d == null) {
            if (this.i == null || this.i[0] < 2.0) {
                throw this.error("Error: line should have at least 2 points");
            }
            n3 = (int)this.i[0];
            double[] dArray = this.i;
            this.i = new double[n3];
            this.d = new double[n3];
            n2 = 1;
            int n4 = 0;
            while (n4 < n3) {
                this.i[n4] = dArray[n2++];
                this.d[n4] = dArray[n2++];
                ++n4;
            }
        }
        if ((n3 = this.i.length) < 2) {
            throw this.error("Error: line should have at least 2 points");
        }
        this.c = new double[n3 - 1];
        int n5 = 0;
        n2 = 0;
        while (n2 < this.c.length) {
            double d2 = Utilities.getDistance(this.i[n2], this.d[n2], this.i[n2 + 1], this.d[n2 + 1]);
            if (d2 == 0.0) {
                this.error("Empty segment in line");
            }
            n5 = (int)((double)n5 + d2);
            this.c[n2] = n5;
            ++n2;
        }
        this.g = n5;
        if (n5 == 0) {
            this.error("Empty line");
        }
    }

    public int getNPoints() {
        return this.i.length;
    }

    public double getPointDx(int n2) {
        return this.i[n2];
    }

    public double getPointDy(int n2) {
        return this.d[n2];
    }

    public void setColor(Color color) {
        this.l = color;
    }

    public Color getColor() {
        return this.l instanceof Color ? this.l : null;
    }

    public final double length() {
        this.h();
        return this.g;
    }

    public final Point getPointAtOffset(double d2, Point point) {
        if (point == null) {
            point = new Point();
        }
        this.a(d2, point);
        return point;
    }

    private void a(double d2, Point point) {
        this.h();
        if (d2 > this.g) {
            if (d2 < this.g + 1.0E-4) {
                d2 = this.g;
            } else {
                this.a("Offset (%s) is greater than length (%s)", d2, this.g);
            }
        } else if (d2 < 0.0) {
            if (d2 > -1.0E-4) {
                d2 = 0.0;
            } else {
                this.a("Offset (%s) is negative", d2);
            }
        }
        int n2 = Arrays.binarySearch(this.c, d2);
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        double d3 = n2 > 0 ? this.c[n2 - 1] : 0.0;
        double d4 = (d2 - d3) / (this.c[n2] - d3);
        point.x = this.a + this.i[n2] + d4 * (this.i[n2 + 1] - this.i[n2]);
        point.y = this.n + this.d[n2] + d4 * (this.d[n2 + 1] - this.d[n2]);
    }

    @Override
    public boolean contains(double d2, double d3) {
        return this.containsSq(d2, d3, 1.0E-8);
    }

    public boolean contains(double d2, double d3, double d4) {
        return this.containsSq(d2, d3, Utilities.sqr(d4));
    }

    public boolean containsSq(double d2, double d3, double d4) {
        this.h();
        d2 -= this.a;
        d3 -= this.n;
        int n2 = 1;
        while (n2 < this.i.length) {
            if (Utilities.getDistanceFromPointToSegmentSq(this.i[n2 - 1], this.d[n2 - 1], this.i[n2], this.d[n2], d2, d3) <= d4) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl2) {
        this.h();
        if (!this.a(bl2)) {
            return;
        }
        if (this.l == null) {
            return;
        }
        e.a(panel, graphics2D, affineTransform, this.a, this.n, 0.0, 1.0, 1.0, (Paint)this.l, null, this.i.length, this.i, this.d, false, 2.0, Presentable.LINE_STYLE_SOLID, false);
        graphics2D.setStroke(e.n());
        e.a(graphics2D, this.i[0], this.d[0], this.i[1], this.d[1]);
        e.a(graphics2D, this.i[this.i.length - 1], this.d[this.i.length - 1], this.i[this.i.length - 2], this.d[this.i.length - 2]);
    }

    public Point randomPointInside() {
        return this.randomPointInside(this.gf.getEngine().getDefaultRandomGenerator(), null);
    }

    public final Point randomPointInside(Random random, Point point) {
        double d2 = Utilities.uniform(0.0, this.length(), random);
        if (point == null) {
            point = new Point();
        }
        this.a(d2, point);
        return point;
    }

    public double getNearestPoint(double d2, double d3, Point point) {
        this.h();
        double d4 = Double.POSITIVE_INFINITY;
        Point point2 = new Point();
        d2 -= this.a;
        d3 -= this.n;
        int n2 = 1;
        while (n2 < this.i.length) {
            Utilities.getNearestPointOnSegment(point2, this.i[n2 - 1], this.d[n2 - 1], this.i[n2], this.d[n2], d2, d3);
            double d5 = point2.distanceSq(d2, d3);
            if (d5 < d4) {
                d4 = d5;
                point.setLocation(point2);
            }
            ++n2;
        }
        point.x += this.a;
        point.y += this.n;
        return d4;
    }

    public Path2D toPath2D() {
        if (this.b == null) {
            this.h();
            this.b = new Path2D(){

                @Override
                public double getY() {
                    return TargetLine.this.n;
                }

                @Override
                public double getX() {
                    return TargetLine.this.a;
                }

                @Override
                public double getPointDy(int n2) {
                    return TargetLine.this.d[n2];
                }

                @Override
                public double getPointDx(int n2) {
                    return TargetLine.this.i[n2];
                }

                @Override
                public int getNPoints() {
                    return TargetLine.this.i.length;
                }
            };
        }
        return this.b;
    }
}

