/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicCustomProposalType;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.TimeUnits;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.markup.ISignalable;
import com.anylogic.engine.markup.RoadNetwork;
import com.anylogic.engine.markup.TrafficLightDelegate;
import com.anylogic.engine.markup.TrafficLightSignal;
import com.anylogic.engine.markup.TrafficLightType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class TrafficLight<T extends ISignalable>
implements Serializable {
    private static final long serialVersionUID = -4780502985438811152L;
    private final TrafficLightType n;
    private final List<T> k;
    private final List<Double> m;
    private boolean h = false;
    private final List<List<TrafficLightSignal>> j;
    private TrafficLightDelegate i;
    private final Map<T, Integer> d;
    @AnyLogicCustomSerialization
    protected transient RoadNetwork a;

    public TrafficLight(T[] TArray, double[] dArray, TrafficLightSignal[][] trafficLightSignalArray2) {
        this.n = TArray == null ? TrafficLightType.STOP_LINE : TrafficLightType.valueOf(TArray.getClass().getComponentType());
        this.k = TArray == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(TArray));
        this.d = TArray == null ? Collections.emptyMap() : IntStream.range(0, TArray.length).boxed().collect(Collectors.toMap(n2 -> TArray[n2], n2 -> n2));
        this.m = DoubleStream.of(dArray).boxed().collect(Collectors.toList());
        this.j = Collections.unmodifiableList(Stream.of(trafficLightSignalArray2).map(trafficLightSignalArray -> Arrays.asList(trafficLightSignalArray)).collect(Collectors.toList()));
        this.a();
    }

    private void a() {
        if (this.k.size() != this.j.size()) {
            ff.m("phaseSignals.length != signalElements.length");
        }
        int n2 = 0;
        while (n2 < this.k.size()) {
            if (this.j.get(n2).size() != this.m.size()) {
                ff.m("phaseSignals.[signalElements].length != phaseDurations.length");
            }
            ++n2;
        }
    }

    private List<Double> n() {
        if (!this.h) {
            this.h = true;
            int n2 = 0;
            while (n2 < this.m.size()) {
                this.m.set(n2, this.calcPhaseDurationInSeconds(n2));
                ++n2;
            }
        }
        return this.m;
    }

    public void setRoadNetwork(RoadNetwork roadNetwork) {
        if (roadNetwork == null) {
            throw ff.a(hg.ihf, new Object[]{"roadNetwork"});
        }
        if (roadNetwork == this.a) {
            return;
        }
        if (this.a != null) {
            ff.a(hg.anh, new Object[]{this.a.getName(), roadNetwork.getName()});
        }
        this.a = roadNetwork;
    }

    public RoadNetwork getRoadNetwork() {
        return this.a;
    }

    @AnyLogicInternalAPI
    public TrafficLightType getType() {
        return this.n;
    }

    public List<T> getSignalElements() {
        return this.k;
    }

    public List<List<TrafficLightSignal>> getPhaseSignals() {
        return this.j;
    }

    public int getPhasesNumber() {
        return this.n().size();
    }

    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.MTU)
    public double getPhaseDuration(int n2) {
        return ((Agent)this.a.getOwner()).toModelTime(this.n().get(n2), TimeUnits.SECOND);
    }

    public double getPhaseDuration(int n2, TimeUnits timeUnits) {
        return TimeUnits.SECOND.convertTo((double)this.n().get(n2), timeUnits);
    }

    @AnyLogicInternalAPI
    public double calcPhaseDurationInSeconds(int n2) {
        return this.n().get(n2);
    }

    @AnyLogicInternalAPI
    public void setDelegate(TrafficLightDelegate trafficLightDelegate) {
        if (trafficLightDelegate == null) {
            ff.a(hg.ihf, new Object[]{"delegate"});
        }
        if (trafficLightDelegate == this.i) {
            return;
        }
        if (this.i != null) {
            ff.a(hg.mjl, new Object[]{trafficLightDelegate});
        }
        this.i = trafficLightDelegate;
    }

    public void turnOn() {
        this.turnOn(0.0);
    }

    public void turnOn(@AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.MTU) double d2) {
        this.k().turnOn(d2);
    }

    public void turnOn(double d2, TimeUnits timeUnits) {
        this.turnOn(((Agent)this.getRoadNetwork().getOwner()).toModelTime(d2, timeUnits));
    }

    public void turnOff() {
        this.k().turnOff();
    }

    public boolean isOn() {
        return this.i != null && this.i.getCurrentPhaseIndex() != -1;
    }

    private TrafficLightDelegate k() {
        if (this.i == null) {
            throw ff.m(String.format("Internal error: library object hasn't been set to this traffic light,%nplease ensure your traffic light controls some intersection or stoplines%nand you have Road Library flowchart and try checking isOn() function of this traffic light", new Object[0]));
        }
        return this.i;
    }

    public void switchToNextPhase() {
        this.k().switchToNextPhase();
    }

    public int getCurrentPhaseIndex() {
        return this.isOn() ? this.k().getCurrentPhaseIndex() : -1;
    }

    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.MTU)
    public double getCurrentPhaseDuration() {
        return this.isOn() ? this.getPhaseDuration(this.getCurrentPhaseIndex()) : -1.0;
    }

    public double getCurrentPhaseDuration(TimeUnits timeUnits) {
        return this.isOn() ? this.getPhaseDuration(this.getCurrentPhaseIndex(), timeUnits) : -1.0;
    }

    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.MTU)
    public double getCurrentPhaseElapsedTime() {
        return this.isOn() ? this.k().getCurrentPhaseElapsedTime() : -1.0;
    }

    public double getCurrentPhaseElapsedTime(TimeUnits timeUnits) {
        return this.isOn() ? ((Agent)this.a.getOwner()).toTimeUnits(this.getCurrentPhaseElapsedTime(), timeUnits) : -1.0;
    }

    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.MTU)
    public double getCurrentPhaseRemainingTime() {
        return this.isOn() ? this.getCurrentPhaseDuration() - this.getCurrentPhaseElapsedTime() : -1.0;
    }

    public double getCurrentPhaseRemainingTime(TimeUnits timeUnits) {
        return this.isOn() ? ((Agent)this.a.getOwner()).toTimeUnits(this.getCurrentPhaseRemainingTime(), timeUnits) : -1.0;
    }

    public TrafficLightSignal getCurrentSignal(ISignalable iSignalable) {
        Integer n2 = this.d.get(iSignalable);
        if (n2 == null) {
            return null;
        }
        int n3 = this.getCurrentPhaseIndex();
        if (n3 == -1) {
            return null;
        }
        return this.j.get(n2).get(n3);
    }

    @AnyLogicInternalAPI
    public void setCurrentPhaseIndex(int n2) {
        this.onPhaseChanged(n2);
        if (n2 != -1) {
            int n3 = (n2 + this.getPhasesNumber() - 1) % this.getPhasesNumber();
            this.n().set(n3, this.calcPhaseDurationInSeconds(n3));
        }
    }

    @AnyLogicInternalCodegenAPI
    public void onPhaseChanged(int n2) {
    }

    public String toString() {
        if (this.i == null) {
            return hg.lfc;
        }
        if (!this.isOn()) {
            return hg.kin;
        }
        String string = ", " + TimeUnits.SECOND.getName();
        return Utilities.toStringAlignedNameValues(0, hg.jmi, this.getPhasesNumber(), String.valueOf(hg.bgl) + " (0.." + (this.getPhasesNumber() - 1) + ")", this.getCurrentPhaseIndex(), "  " + hg.nfi + string, this.getCurrentPhaseDuration(TimeUnits.SECOND), "  " + hg.mem + string, this.getCurrentPhaseRemainingTime(TimeUnits.SECOND));
    }
}

