/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.presentation;

import com.anylogic.engine.AbstractShapeGISMap;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.Point;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.gis.AbstractGISRouteProvider;
import com.anylogic.engine.gis.BuiltInTileCache;
import com.anylogic.engine.gis.GISMultiRegion;
import com.anylogic.engine.gis.IGISRouteProvider;
import com.anylogic.engine.gis.IImageLoadedListener;
import com.anylogic.engine.gis.ITileURLProvider;
import com.anylogic.engine.gis.NominatimSearch;
import com.anylogic.engine.gis.PlainGISRouteProvider;
import com.anylogic.engine.gis.RouteProviderTransportType;
import com.anylogic.engine.gis.RoutingMethod;
import com.anylogic.engine.gis.TileFactory;
import com.anylogic.engine.gis.TileImageProvider;
import com.anylogic.engine.gis.TileURLProvider;
import com.anylogic.engine.gis.YoursOSMRouteProvider;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.presentation.SharedUtils;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.internal.presentation.f;
import com.anylogic.engine.internal.presentation.j;
import com.anylogic.engine.internal.t.d;
import com.anylogic.engine.internal.y.cb;
import com.anylogic.engine.internal.y.db;
import com.anylogic.engine.internal.y.fa;
import com.anylogic.engine.internal.y.l;
import com.anylogic.engine.markup.GISMarkupElement;
import com.anylogic.engine.markup.GISNode;
import com.anylogic.engine.markup.GISPoint;
import com.anylogic.engine.markup.GISRegion;
import com.anylogic.engine.markup.GISRoute;
import com.anylogic.engine.presentation.ImageChangedListener;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.Presentation;
import com.anylogic.engine.presentation.ShapeDrawMode;
import com.anylogic.engine.presentation.UIEventData;
import com.anylogic.engine.presentation.UIEventListener;
import com.anylogic.engine.presentation.UIEventType;
import com.anylogic.engine.presentation.UIPointEventData;
import com.bbn.openmap.Environment;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.dataAccess.mapTile.MapTileFactory;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.layer.imageTile.MapTileLayer;
import com.bbn.openmap.layer.shape.SpatialIndex;
import com.bbn.openmap.layer.shape.areas.AreaShapeLayer;
import com.bbn.openmap.layer.shape.areas.PoliticalArea;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMList;
import com.bbn.openmap.proj.Cartesian;
import com.bbn.openmap.proj.CartesianLoader;
import com.bbn.openmap.proj.Gnomonic;
import com.bbn.openmap.proj.GnomonicLoader;
import com.bbn.openmap.proj.LLXY;
import com.bbn.openmap.proj.LLXYLoader;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.MercatorLoader;
import com.bbn.openmap.proj.Planet;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class ShapeGISMap
extends AbstractShapeGISMap
implements UIEventListener {
    private static final long serialVersionUID = 8850502783383997658L;
    private static final ProjectionFactory na = new ProjectionFactory();
    private Point ha;
    private int en;
    private int fj;
    private transient NominatimSearch me;
    private static int lj;
    private final IGISRouteProvider bf;
    private boolean bl;
    private transient OMGraphicList ca = new OMGraphicList();
    private transient BufferedImage mi;
    private ITileURLProvider be;
    private double[] kh;
    private transient ProjectionLoader kn;
    private static final UIEventType[] ck;
    private transient boolean bh;
    private static final String di = ".shp";
    private static final String bm = ".ssx";
    @AnyLogicCustomSerialization
    private transient Presentable gn;
    private final String kc;
    private double bi = 50.0;
    private double ne = 50.0;
    private double nl = 1.0;
    private double mn = 1.0;
    private double ak;
    private double gc;
    private double el;
    private final Color kb;
    private final Color ji;
    private final Layer[] hm;
    private transient boolean ek = false;
    private transient double jk;
    private transient double cn;
    private transient BufferedImage nn;
    private transient Projection jn;
    private transient boolean gj = true;
    private AtomicBoolean mj = new AtomicBoolean();
    private boolean cl = true;
    private transient long li;
    private volatile transient a an;
    private volatile transient a ge;
    private transient MapTileLayer dj;
    private Class<? extends Projection> jl;
    public static final ITileURLProvider ANYLOGIC;
    public static final ITileURLProvider CLASSIC;
    public static final ITileURLProvider GERMANSTYLE;
    public static final ITileURLProvider LANDSTAT;
    public static final ITileURLProvider TRANSPORT;
    public static final ITileURLProvider CYCLEMAP;
    public static final ITileURLProvider HUMANITARIAN;
    public static final AbstractGISRouteProvider STRAIGHT;
    public static Class<? extends Projection> MERCATOR;
    public static Class<? extends Projection> LLXY;
    public static Class<? extends Projection> CARTESIAN;
    public static Class<? extends Projection> GNOMONIC;
    com.anylogic.engine.internal.a<ImageChangedListener> a = new com.anylogic.engine.internal.a();
    private boolean ni = true;
    private transient BufferedImage mm;

    static {
        na.addProjectionLoader((ProjectionLoader)new MercatorLoader());
        na.addProjectionLoader((ProjectionLoader)new LLXYLoader());
        na.addProjectionLoader((ProjectionLoader)new CartesianLoader(){

            public Projection create(Properties properties) throws ProjectionException {
                try {
                    Point2D point2D = (Point2D)properties.get("CENTER");
                    float f2 = PropUtils.floatFromProperties((Properties)properties, (String)"SCALE", (float)1.0E7f);
                    int n2 = PropUtils.intFromProperties((Properties)properties, (String)"HEIGHT", (int)100);
                    int n3 = PropUtils.intFromProperties((Properties)properties, (String)"WIDTH", (int)100);
                    Cartesian cartesian = new Cartesian(point2D, f2, n3, n2){

                        public void init() {
                            super.init();
                            this.scaleFactor = 3.672E8;
                        }
                    };
                    cartesian.setLimits(this.topLimit, this.bottomLimit, this.leftLimit, this.rightLimit, this.limitAnchorPoint);
                    return cartesian;
                }
                catch (Exception exception) {
                    if (Debug.debugging((String)"proj")) {
                        Debug.output((String)("CartesianLoader: problem creating Cartesian projection " + exception.getMessage()));
                    }
                    throw new ProjectionException("CartesianLoader: problem creating Cartesian projection");
                }
            }
        });
        na.addProjectionLoader((ProjectionLoader)new GnomonicLoader());
        lj = 90;
        ck = new UIEventType[]{UIEventType.MOUSE_PRESSED, UIEventType.MOUSE_DRAGGED, UIEventType.MOUSE_WHEEL};
        ANYLOGIC = new d();
        CLASSIC = new TileURLProvider("OSM classic", "http://%s.tile.openstreetmap.org/%s/%s/%s.png", "a", "b", "c");
        GERMANSTYLE = new TileURLProvider("OSM german", "http://%s.tile.openstreetmap.de/tiles/osmde/%s/%s/%s.png", "a", "b", "c", "d");
        LANDSTAT = new TileURLProvider("LandSat", "http://irs.gis-lab.info/?layers=landsat&request=GetTile&z=%s&x=%s&y=%s", new String[0]);
        TRANSPORT = new TileURLProvider("Transport", "http://www.openptmap.org/tiles/%s/%s/%s.png", new String[0]);
        CYCLEMAP = new TileURLProvider("Cycle map", "http://%s.tile.opencyclemap.org/cycle/%s/%s/%s.png", "a", "b", "c");
        HUMANITARIAN = new TileURLProvider("OSM Humanitarian", "http://tile-%s.openstreetmap.fr/hot/%s/%s/%s.png", "a", "b", "c");
        STRAIGHT = new PlainGISRouteProvider();
        MERCATOR = Mercator.class;
        LLXY = LLXY.class;
        CARTESIAN = Cartesian.class;
        GNOMONIC = Gnomonic.class;
    }

    public ShapeGISMap(Presentable presentable, ShapeDrawMode shapeDrawMode, boolean bl2, Class<? extends Projection> clazz, double d2, double d3, double d4, double d5, String string, Layer[] layerArray, double d6, double d7, double d8, Color color, Color color2, boolean bl3, ITileURLProvider iTileURLProvider, IGISRouteProvider iGISRouteProvider, int n2, boolean bl4) {
        this.gn = presentable;
        this.jl = clazz;
        this.bl = bl3;
        this.be = iTileURLProvider;
        this.bf = iGISRouteProvider;
        this.fj = n2;
        if (iGISRouteProvider != null && iGISRouteProvider instanceof AbstractGISRouteProvider) {
            AbstractGISRouteProvider abstractGISRouteProvider = (AbstractGISRouteProvider)iGISRouteProvider;
            abstractGISRouteProvider.setThrowError(bl4);
            abstractGISRouteProvider.setPrecisionInMeters(n2);
        }
        if (layerArray == null) {
            layerArray = new Layer[]{};
        }
        ShapeGISMap.a(presentable.getPresentation());
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        this.kc = string;
        this.ma = bl2;
        this.gd = d2;
        this.nm = d3;
        this.bi = d4;
        this.ne = d5;
        this.ak = ShapeGISMap.a(d7);
        this.gc = ShapeGISMap.k(d6);
        this.el = d8;
        this.hm = layerArray;
        this.kb = color;
        this.ji = color2;
        this.g();
        this.a(clazz, d6, d7, d4, d5, 1.0 / d8);
        SharedUtils.setProxySettings();
        this.ac();
    }

    public ShapeGISMap(Presentable presentable, ShapeDrawMode shapeDrawMode, boolean bl2, double d2, double d3, double d4, double d5, String string, Layer[] layerArray, double d6, double d7, double d8, Color color, Color color2, boolean bl3, ITileURLProvider iTileURLProvider, IGISRouteProvider iGISRouteProvider, int n2, boolean bl4, ProjectionLoader projectionLoader) {
        this(presentable, shapeDrawMode, bl2, projectionLoader.getProjectionClass(), d2, d3, d4, d5, string, layerArray, d6, d7, d8, color, color2, bl3, iTileURLProvider, iGISRouteProvider, n2, bl4);
        na.addProjectionLoader(projectionLoader);
        this.a(this.jl, d6, d7, d4, d5, 1.0 / d8);
    }

    private void a(Class<? extends Projection> clazz, double d2, double d3, double d4, double d5, double d6) {
        Projection projection = ShapeGISMap.makeProjection(clazz, d2, d3, d6, (int)d4, (int)d5);
        Point2D point2D = projection.inverse(0.0, d5);
        Point2D point2D2 = projection.inverse(d4, 0.0);
        this.kh = new double[4];
        this.setSearchBounds(point2D.getY(), point2D.getX(), point2D2.getY(), point2D2.getX());
    }

    private void g() {
        this.dj = new MapTileLayer();
        TileImageProvider tileImageProvider = new TileImageProvider(new BuiltInTileCache(this.be));
        TileFactory tileFactory = new TileFactory(tileImageProvider);
        this.dj.setTileFactory((MapTileFactory)tileFactory);
        tileImageProvider.addImageLoadedListener(new IImageLoadedListener(){
            private static final long serialVersionUID = 6588694594262395619L;

            @Override
            public void imageLoaded() {
                boolean bl2 = ShapeGISMap.this.mj.getAndSet(true);
                if (!bl2) {
                    ShapeGISMap.this.a((int)(ShapeGISMap.this.bi / ShapeGISMap.this.nl), (int)(ShapeGISMap.this.ne / ShapeGISMap.this.mn));
                }
            }
        });
    }

    @Deprecated
    public ShapeGISMap(Presentable presentable, boolean bl2, double d2, double d3, double d4, double d5, String string, Layer[] layerArray, double d6, double d7, double d8, Color color, Color color2) {
        this(presentable, ShapeDrawMode.SHAPE_DRAW_2D, bl2, MERCATOR, d2, d3, d4, d5, string, layerArray, d7, d6, d8, color, color2, true, ANYLOGIC, new YoursOSMRouteProvider(presentable, string, RouteProviderTransportType.CAR, RoutingMethod.FASTEST), 1000, false);
    }

    private Point a(Panel panel, MouseEvent mouseEvent) {
        double d2 = mouseEvent.getX() - panel.xToScreen(this.getX());
        double d3 = mouseEvent.getY() - panel.yToScreen(this.getY());
        return new Point(d2, d3);
    }

    private Point a(Point point, Projection projection) {
        Point2D point2D = projection.inverse(point.x, point.y);
        return new Point(point2D.getY(), point2D.getX());
    }

    private boolean a(Point point, Panel panel) {
        return point.x >= 0.0 && point.x <= this.bi * panel.getZoom() && point.y >= 0.0 && point.y <= this.ne * panel.getZoom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() {
        if (this.ek) {
            return;
        }
        Layer[] layerArray = this.hm;
        synchronized (this.hm) {
            if (this.ek) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.b();
            this.ek = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void b() {
        if (this.hm == null) {
            throw new IllegalArgumentException(hg.hkg);
        }
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        Layer[] layerArray = this.hm;
        int n2 = this.hm.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            Layer layer = layerArray[n3];
            if (layer.i != null) {
                throw new RuntimeException(hg.cda);
            }
            layer.i = this;
            String string = ff.a(this.gn, this.kc, layer.a);
            f f2 = new f();
            if (this.gn.getPresentation() == null || this.gn.getPresentation().getMode() != Presentation.MODE_APPLET) {
                try {
                    f2.setSpatialIndex(SpatialIndex.locateAndSetShapeData((String)string));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if ((n4 = string.length() - di.length()) < 0 || !di.equalsIgnoreCase(string.substring(n4))) {
                throw new IllegalArgumentException(String.format(hg.hdh, di, string));
            }
            Properties properties = new Properties();
            properties.setProperty("shapeFile", string);
            string.substring(0, string.length() - di.length());
            String string2 = layer.n;
            if (string2 != null && BinaryFile.exists((String)(string2 = ff.a(this.gn, this.kc, string2)))) {
                properties.setProperty("dbfFile", string2);
            }
            String string3 = String.valueOf(layer.h);
            properties.setProperty("nameIndex", string3);
            properties.setProperty("keyIndex", string3);
            properties.setProperty("lineColor", ShapeGISMap.a(layer.k));
            properties.setProperty("fillColor", ShapeGISMap.a(layer.m));
            f2.setProperties(properties);
            d2 = Math.max(d2, (double)f2.getMinScale());
            d3 = Math.min(d3, (double)f2.getMaxScale());
            DrawingAttributes.DEFAULT.setProperties((Properties)properties.clone());
            layer.j = f2;
            ++n3;
        }
        this.jk = 1.0 / d3;
        this.cn = 1.0 / d2;
    }

    private static String a(Color color) {
        if (color == null) {
            return "00000000";
        }
        return Integer.toHexString(color.getRGB());
    }

    public void setWidth(double d2) {
        if (d2 == this.bi) {
            return;
        }
        this.bi = d2;
        this.a(hn);
        this.e();
    }

    public double getWidth() {
        return this.bi;
    }

    public void setHeight(double d2) {
        if (d2 == this.ne) {
            return;
        }
        this.ne = d2;
        this.a(hn);
        this.e();
    }

    public double getHeight() {
        return this.ne;
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public boolean onClickAt(double d2, double d3, boolean bl2) {
        double d4;
        if (!this.canHandleClick(bl2)) {
            this.hl = false;
            return false;
        }
        double d5 = com.anylogic.engine.internal.presentation.e.a(d2, d3, this.gd, this.nm, this.ib, this.ml);
        this.hl = com.anylogic.engine.internal.presentation.e.n(d5, d4 = com.anylogic.engine.internal.presentation.e.n(d2, d3, this.gd, this.nm, this.ib, this.dd), this.bi, this.ne);
        if (this.hl) {
            this.f();
            Point2D.Double double_ = new Point2D.Double();
            this.jn.inverse(d5 / this.nl, d4 / this.mn, (Point2D)double_);
            double d6 = double_.y;
            double d7 = double_.x;
            if (Math.abs(d7) > 180.0) {
                d7 = ShapeGISMap.a(d7);
            }
            if (Math.abs(d6) > 90.0) {
                d6 = ShapeGISMap.k(d6);
            }
            return this.onClick(d6, d7);
        }
        return false;
    }

    private void a(double d2, double d3, Point point) {
        Point2D.Double double_ = new Point2D.Double();
        this.jn.inverse(d2, d3, (Point2D)double_);
        point.x = double_.y;
        point.y = double_.x;
    }

    private void n(double d2, double d3, Point point) {
        Point2D.Double double_ = new Point2D.Double();
        this.jn.forward(d2, d3, (Point2D)double_);
        point.x = double_.x;
        point.y = double_.y;
    }

    @Override
    public void updateDynamicProperties(boolean bl2) {
        if (!this.a(bl2)) {
            return;
        }
        this.a(this.ca, bl2);
    }

    private void a(OMGraphicList oMGraphicList, boolean bl2) {
        for (OMGraphic oMGraphic : oMGraphicList) {
            GISMarkupElement gISMarkupElement = GISMarkupElement.getFromOMGraphic(oMGraphic);
            if (gISMarkupElement != null) {
                gISMarkupElement.updateDynamicProperties(bl2);
            }
            if (!(oMGraphic instanceof OMList)) continue;
            this.a((OMGraphicList)oMGraphic, bl2);
        }
    }

    @Override
    public boolean contains(double d2, double d3) {
        double d4 = com.anylogic.engine.internal.presentation.e.a(d2, d3, this.gd, this.nm, this.ib, this.ml);
        double d5 = com.anylogic.engine.internal.presentation.e.n(d2, d3, this.gd, this.nm, this.ib, this.dd);
        return com.anylogic.engine.internal.presentation.e.n(d4, d5, this.bi, this.ne);
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl2) {
        int n2;
        double d2;
        int n3;
        if (!this.n(bl2)) {
            return;
        }
        if (this.bi == 0.0 || this.ne == 0.0) {
            return;
        }
        com.anylogic.engine.internal.presentation.e.a(graphics2D, affineTransform, this.gd, this.nm, this.ib, this.ml, this.dd);
        double d3 = 1.0;
        AffineTransform affineTransform2 = graphics2D.getTransform();
        double[] dArray = com.anylogic.engine.internal.presentation.e.c.get();
        affineTransform2.transform(dArray, 0, dArray, 6, 3);
        double d4 = Utilities.getLength(dArray[8] - dArray[6], dArray[9] - dArray[7]);
        double d5 = Utilities.getLength(dArray[10] - dArray[6], dArray[11] - dArray[7]);
        if (d4 < 1.0 || d5 < 1.0) {
            if (d4 == d5) {
                d5 = 1.0;
                d4 = 1.0;
            } else if (d4 < d5) {
                d5 /= d4;
                d4 = 1.0;
            } else {
                d4 /= d5;
                d5 = 1.0;
            }
        }
        double d6 = d4 * this.bi;
        double d7 = d5 * this.ne;
        while (!this.a(n3 = Utilities.roundToInt((d2 = Math.sqrt(d3)) * d6), n2 = Utilities.roundToInt(d2 * d7))) {
            d3 /= 1.5;
        }
        this.nl = this.bi / (double)this.nn.getWidth();
        this.mn = this.ne / (double)this.nn.getHeight();
        this.mk();
        int n4 = (int)this.bi;
        int n5 = (int)this.ne;
        Rectangle2D.Double double_ = null;
        if (this.ji != null) {
            double_ = com.anylogic.engine.internal.presentation.e.d.get();
            double_.setRect(0.0, 0.0, this.bi, this.ne);
            graphics2D.setColor(this.ji);
            graphics2D.fill(double_);
        }
        if (this.bl) {
            graphics2D.drawImage(this.mi, 0, 0, n4, n5, null);
        }
        graphics2D.drawImage(this.nn, 0, 0, n4, n5, null);
        if (this.jn != null) {
            SharedUtils.drawGISRuler(graphics2D, this.jn, n4, n5 ^ SharedUtils.class.hashCode(), this.nl);
        }
        if (this.kb != null) {
            if (double_ == null) {
                double_ = com.anylogic.engine.internal.presentation.e.d.get();
                double_.setRect(0.0, 0.0, this.bi, this.ne);
            }
            graphics2D.setColor(this.kb);
            graphics2D.draw(double_);
        }
        if (this.ni && panel != null) {
            panel.getUIEventsManager().confirmUIEventListener(this);
        }
    }

    @Override
    public double getMapScale() {
        return this.el;
    }

    @Override
    public void setMapScale(double d2) {
        d2 = Math.min(this.getMaxMapScale(), Math.max(this.getMinMapScale(), d2));
        if (d2 != this.el) {
            this.el = d2;
            this.e();
            this.a(ng);
        }
    }

    @Override
    public double getMinMapScale() {
        this.f();
        return Math.max(this.jk, 1.0 / (double)this.jn.getMaxScale() * (this.bi / (double)this.jn.getWidth()));
    }

    @Override
    public double getMaxMapScale() {
        this.f();
        return Math.min(this.cn, 1.0 / (double)this.jn.getMinScale() * (this.bi / (double)this.jn.getWidth()));
    }

    @Override
    public void zoomIn() {
        this.hl();
        this.setMapScale(this.getMapScale() * 2.0);
    }

    @Override
    public void zoomOut() {
        this.hl();
        this.setMapScale(this.getMapScale() / 2.0);
    }

    @Override
    public void pan(double d2, double d3) {
        double d4;
        this.f();
        java.awt.Point point = new java.awt.Point();
        LatLonPoint.Double double_ = new LatLonPoint.Double();
        double d5 = this.ak;
        double d6 = this.gc;
        if (d2 != 0.0) {
            point.setLocation(d2 > 0.0 ? this.nn.getWidth() - 1 : 0, this.nn.getHeight() / 2);
            this.jn.inverse((Point2D)point, (Point2D)double_);
            d4 = (double)double_.getLongitude() - this.ak;
            if (d2 > 0.0 && d4 < 0.0) {
                d4 += 360.0;
            } else if (d2 < 0.0 && d4 > 0.0) {
                d4 -= 360.0;
            }
            d5 = this.ak + (d4 /= 2.0) * Math.abs(d2);
        }
        if (d3 != 0.0) {
            point.setLocation(this.nn.getWidth() / 2, d3 > 0.0 ? 0 : this.nn.getHeight() - 1);
            this.jn.inverse((Point2D)point, (Point2D)double_);
            d4 = ((double)double_.getLatitude() - this.gc) / 2.0;
            d6 = this.gc + d4 * Math.abs(d3);
        }
        this.setProjectionCenter(d6, d5);
    }

    @Override
    public double getCenterLatitude() {
        return this.gc;
    }

    @Override
    public double getCenterLongitude() {
        return this.ak;
    }

    @Override
    public void setProjectionCenter(double d2, double d3) {
        this.a(d2, d3, true);
    }

    private void a(double d2, double d3, boolean bl2) {
        this.hl();
        d2 = ShapeGISMap.k(d2);
        d3 = ShapeGISMap.a(d3);
        if (d3 != this.ak || d2 != this.gc) {
            this.ak = d3;
            this.gc = this.n(d2);
            if (bl2) {
                this.e();
            }
        }
    }

    private double n(double d2) {
        if (d2 > (double)lj) {
            d2 = lj;
        } else if (d2 < (double)(-lj)) {
            d2 = -lj;
        }
        return d2;
    }

    @Override
    public void setCenterLatitude(double d2) {
        if ((d2 = ShapeGISMap.k(d2)) != this.gc) {
            this.gc = this.n(d2);
            this.e();
            this.a(ng);
        }
    }

    @Override
    public void setCenterLongitude(double d2) {
        if ((d2 = ShapeGISMap.a(d2)) != this.ak) {
            this.ak = d2;
            this.e();
            this.a(ng);
        }
    }

    @Override
    public double convertXForward(double d2, double d3) {
        a a2 = this.n(d2, d3);
        return a2.x * this.nl;
    }

    @Override
    public double convertYForward(double d2, double d3) {
        a a2 = this.n(d2, d3);
        return a2.y * this.mn;
    }

    @Override
    public Point convertForward(double d2, double d3) {
        a a2 = this.n(d2, d3);
        return new Point(a2.x * this.nl, a2.y * this.mn);
    }

    @Override
    public Point convertForward(double d2, double d3, Point point) {
        if (point == null) {
            point = new Point();
        }
        this.f();
        this.n(d2, d3, point);
        point.x *= this.nl;
        point.y *= this.mn;
        return point;
    }

    @Override
    public double convertRotationAngleForward(double d2, double d3, double d4) {
        return -d4;
    }

    @Override
    public double convertXInverse(double d2, double d3) {
        a a2 = this.a(d2, d3);
        return a2.x;
    }

    @Override
    public double convertYInverse(double d2, double d3) {
        a a2 = this.a(d2, d3);
        return a2.y;
    }

    @Override
    public Point convertInverse(double d2, double d3) {
        a a2 = this.a(d2, d3);
        return new Point(a2);
    }

    @Override
    public Point convertInverse(double d2, double d3, Point point) {
        if (point == null) {
            point = new Point();
        }
        this.f();
        this.a(d2 / this.nl, d3 / this.mn, point);
        return point;
    }

    private a a(double d2, double d3) {
        return this.k(d2 / this.nl, d3 / this.mn);
    }

    @Override
    public double convertRotationAngleInverse(double d2, double d3, double d4) {
        return -d4;
    }

    @Override
    public boolean projectionContains(double d2, double d3) {
        a a2 = this.n(d2, d3);
        return a2.x >= 0.0 && a2.x < (double)this.jn.getWidth() && a2.y >= 0.0 && a2.y < (double)this.jn.getHeight();
    }

    @Override
    @Deprecated
    public float[] createTrajectory(double d2, double d3, double d4, double d5, int n2) {
        return Utilities.createTrajectoryGIS(d2, d3, d4, d5, n2);
    }

    @Override
    public double getDistance(double d2, double d3, double d4, double d5) {
        return Utilities.getDistanceGIS(d2, d3, d4, d5);
    }

    @Override
    public double getDistance(GISPoint gISPoint, GISPoint gISPoint2) {
        return Utilities.getDistanceGIS(gISPoint.getLatitude(), gISPoint.getLongitude(), gISPoint2.getLatitude(), gISPoint2.getLongitude());
    }

    @Override
    public double getDistanceByRoute(double d2, double d3, double d4, double d5) {
        return this.getRouteProvider().getDistance(d2, d3, d4, d5);
    }

    @Override
    public double getDistanceByRoute(GISPoint gISPoint, GISPoint gISPoint2) {
        return this.getRouteProvider().getDistance(gISPoint.getLatitude(), gISPoint.getLongitude(), gISPoint2.getLatitude(), gISPoint2.getLongitude());
    }

    public Layer[] getLayers() {
        this.c();
        return this.hm;
    }

    public void requestRedraw() {
        this.e();
    }

    public void destroy() {
        Layer[] layerArray = this.hm;
        int n2 = this.hm.length;
        int n3 = 0;
        while (n3 < n2) {
            SpatialIndex spatialIndex;
            Layer layer = layerArray[n3];
            f f2 = layer.j;
            if (f2 != null && (spatialIndex = f2.getSpatialIndex()) != null) {
                spatialIndex.close(true);
            }
            ++n3;
        }
    }

    @Override
    @AnyLogicInternalAPI
    public void setUIEventListenerConfirmed(boolean bl2) {
        this.bh = bl2;
    }

    @Override
    @AnyLogicInternalAPI
    public boolean isUIEventListenerConfirmed() {
        return this.bh;
    }

    @Override
    @AnyLogicInternalAPI
    public UIEventType[] getUIEventSubscriptions() {
        return ck;
    }

    @Override
    @AnyLogicInternalAPI
    public void uiEventOccurred(UIEventData<?> uIEventData) {
        if (!(uIEventData instanceof UIPointEventData)) {
            return;
        }
        UIPointEventData uIPointEventData = (UIPointEventData)uIEventData;
        double d2 = uIPointEventData.getX();
        double d3 = uIPointEventData.getY();
        double d4 = com.anylogic.engine.internal.presentation.e.a(d2, d3, this.gd, this.nm, this.ib, this.ml);
        double d5 = com.anylogic.engine.internal.presentation.e.n(d2, d3, this.gd, this.nm, this.ib, this.dd);
        uIPointEventData.setXY(d4, d5);
        switch (uIEventData.getType()) {
            case MOUSE_PRESSED: {
                if (this.contains(d2, d3)) {
                    uIPointEventData = (UIPointEventData)uIEventData;
                    MouseEvent mouseEvent = (MouseEvent)uIPointEventData.getOriginalData();
                    this.en = mouseEvent.getButton();
                    this.ha = new Point(uIPointEventData.getX(), uIPointEventData.getY());
                    break;
                }
                this.ha = null;
                break;
            }
            case MOUSE_DRAGGED: {
                if (this.ha == null) break;
                if (this.en != 1) {
                    return;
                }
                uIPointEventData = (UIPointEventData)uIEventData;
                Point point = new Point(uIPointEventData.getX(), uIPointEventData.getY());
                double d6 = this.ha.x - point.x;
                double d7 = this.ha.y - point.y;
                Point2D point2D = this.jn.forward(this.gc, this.ak);
                point2D.setLocation(point2D.getX() + d6, point2D.getY() + d7);
                Point2D point2D2 = this.jn.inverse(point2D.getX(), point2D.getY());
                this.setProjectionCenter(point2D2.getY(), point2D2.getX());
                this.ha = point;
                break;
            }
            case MOUSE_WHEEL: {
                if (!this.contains(d2, d3)) break;
                uIPointEventData = (UIPointEventData)uIEventData;
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)uIPointEventData.getOriginalData();
                this.en = mouseWheelEvent.getButton();
                this.ha = new Point(uIPointEventData.getX(), uIPointEventData.getY());
                if (mouseWheelEvent.isControlDown()) {
                    return;
                }
                Point point = new Point(uIPointEventData.getX(), uIPointEventData.getY());
                if (mouseWheelEvent.getWheelRotation() > 0) {
                    this.zoomOut();
                    break;
                }
                Point point2 = this.a(point, this.jn);
                this.a((point2.getLatitude() + this.gc) / 2.0, (point2.getLongitude() + this.ak) / 2.0, false);
                this.zoomIn();
            }
        }
    }

    private static void a(Presentation presentation) {
        Applet applet;
        Applet applet2 = applet = presentation != null && presentation.getMode() == Presentation.MODE_APPLET && presentation.getContainer() instanceof Applet ? (Applet)presentation.getContainer() : null;
        if (applet != Environment.getApplet()) {
            ShapeGISMap.a(applet);
        } else if (Environment.getProperties() == null) {
            ShapeGISMap.a(applet);
        }
    }

    private static void a(Applet applet) {
        if (applet != null) {
            Environment.init((Applet)applet);
        } else {
            Environment.init();
        }
    }

    private a n(double d2, double d3) {
        a a2 = this.an;
        if (!a2.a(d2, d3)) {
            this.f();
            a2 = new a(d2, d3);
            this.n(d2, d3, a2);
            this.an = a2;
        }
        return a2;
    }

    private a k(double d2, double d3) {
        a a2 = this.ge;
        if (!a2.a(d2, d3)) {
            this.f();
            a2 = new a(d2, d3);
            this.a(d2, d3, a2);
            this.ge = a2;
        }
        return a2;
    }

    private static double k(double d2) {
        return Math.max(-90.0, Math.min(90.0, d2));
    }

    private boolean a(int n2, int n3) {
        boolean bl2 = !this.gj && this.jn != null && Math.abs(this.jn.getWidth() - n2) <= 1 && Math.abs(this.jn.getHeight() - n3) <= 1;
        boolean bl3 = this.mj.get();
        if (!(!bl2 || this.cl || this.bl && bl3)) {
            return true;
        }
        this.c();
        if ((long)n2 * (long)n3 >= this.li) {
            return false;
        }
        try {
            if (!bl2) {
                Projection projection = this.n(n2, n3);
                this.n(projection, n2, n3);
                this.a(projection, n2, n3);
                this.jn = projection;
                this.gj = false;
                this.mk();
            } else {
                if (bl3) {
                    this.n(this.jn, n2, n3);
                }
                if (this.cl) {
                    this.a(this.jn, n2, n3);
                }
            }
            this.ma();
            return true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.li = Math.min(this.li, (long)(n2 * n3));
            return false;
        }
    }

    private void a(Projection projection, int n2, int n3) {
        BufferedImage bufferedImage = ff.a(n2, n3, true);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            this.a(projection, graphics2D);
            this.a(projection, graphics2D, true);
        }
        finally {
            graphics2D.dispose();
        }
        this.nn = bufferedImage;
    }

    private Projection n(int n2, int n3) {
        double d2 = 1.0 / this.el * (this.bi / (double)n2);
        Class clazz = this.kn != null ? this.kn.getProjectionClass() : this.jl;
        Projection projection = ShapeGISMap.makeProjection(clazz, this.gc, this.ak, d2, n2, n3);
        return projection;
    }

    @AnyLogicInternalAPI
    public static Projection makeProjection(Class<? extends Projection> clazz, double d2, double d3, double d4, int n2, int n3) {
        return na.makeProjection(clazz, (Point2D)new LatLonPoint.Double(d2, d3), (float)d4, n2, n3);
    }

    private void n(Projection projection, int n2, int n3) {
        if (!this.bl) {
            return;
        }
        BufferedImage bufferedImage = ff.a(n2, n3, true);
        this.dj.setProjection(projection.makeClone());
        OMGraphicList oMGraphicList = this.dj.prepare();
        this.dj.setList(oMGraphicList);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            oMGraphicList.render((Graphics)graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
        this.mi = bufferedImage;
        TileImageProvider tileImageProvider = this.gf();
        if (tileImageProvider == null || !tileImageProvider.isLoading()) {
            this.mj.set(false);
            this.a(ng);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Projection projection, Graphics2D graphics2D, boolean bl2) {
        OMGraphicList oMGraphicList = this.ca;
        synchronized (oMGraphicList) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (bl2) {
                this.ca.generate(projection.makeClone());
            }
            this.ca.render((Graphics)graphics2D);
            this.cl = false;
        }
    }

    private void a(Projection projection, Graphics2D graphics2D) {
        Layer[] layerArray = this.hm;
        int n2 = this.hm.length;
        int n3 = 0;
        while (n3 < n2) {
            Layer layer = layerArray[n3];
            if (layer.d) {
                f f2 = layer.j;
                f2.setProjection(projection.makeClone());
                OMGraphicList oMGraphicList = f2.prepare();
                f2.setList(oMGraphicList);
                oMGraphicList.render((Graphics)graphics2D);
            }
            ++n3;
        }
    }

    private synchronized void f() {
        if (this.gj && !this.a((int)(this.bi / this.nl), (int)(this.ne / this.mn))) {
            throw new RuntimeException("Internal error when trying to create projection");
        }
    }

    private void e() {
        this.gj = true;
        this.mk();
    }

    @Override
    public Presentable getPresentable() {
        return this.gn;
    }

    @Override
    @Deprecated
    @AnyLogicInternalCodegenAPI
    public void restoreOwner(Object object) {
        if (object instanceof Presentable) {
            this.gn = (Presentable)object;
        } else {
            super.restoreOwner(object);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (OMGraphic oMGraphic : this.ca) {
            GISMarkupElement gISMarkupElement = GISMarkupElement.getFromOMGraphic(oMGraphic);
            if (gISMarkupElement == null) continue;
            objectOutputStream.writeObject(gISMarkupElement);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.ac();
        this.g();
        this.jn = this.n((int)this.bi, (int)this.ne);
        this.gj = true;
        this.ca = new OMGraphicList();
        while ((object = objectInputStream.readObject()) instanceof GISMarkupElement) {
            this.add((GISMarkupElement)object);
        }
    }

    private void ac() {
        this.li = Long.MAX_VALUE;
        this.mk();
        this.me = new NominatimSearch(this, this.kc);
        this.me.setPrecisionInMeters(this.fj);
    }

    private void mk() {
        this.an = new a(Double.NaN, Double.NaN);
        this.ge = new a(-2.147483648E9, -2.147483648E9);
    }

    public List<GISNode> search(String string, boolean bl2, boolean bl3) {
        if (bl3) {
            double[] dArray = this.mf();
            return this.me.search(string, bl2, dArray[0], dArray[1], dArray[2], dArray[3]);
        }
        return this.me.search(string, bl2);
    }

    public List<GISPoint> search(String string) {
        double[] dArray = this.mf();
        return this.me.search(string, dArray[0], dArray[1], dArray[2], dArray[3], false);
    }

    public List<GISRegion> searchRegion(String string) {
        double[] dArray = this.mf();
        return this.me.searchRegion(string, dArray[0], dArray[1], dArray[2], dArray[3], false);
    }

    public List<GISMultiRegion> searchMultiRegion(String string) {
        double[] dArray = this.mf();
        return this.me.searchMultiRegion(string, dArray[0], dArray[1], dArray[2], dArray[3], false);
    }

    @Override
    public GISPoint searchFirst(String string) {
        double[] dArray = this.mf();
        List list = this.me.search(string, dArray[0], dArray[1], dArray[2], dArray[3], true);
        if (list.size() > 0) {
            return (GISPoint)list.get(0);
        }
        return null;
    }

    public GISRegion searchFirstRegion(String string) {
        double[] dArray = this.mf();
        List list = this.me.searchRegion(string, dArray[0], dArray[1], dArray[2], dArray[3], true);
        if (list.size() > 0) {
            return (GISRegion)list.get(0);
        }
        return null;
    }

    public GISMultiRegion searchFirstMultiRegion(String string) {
        double[] dArray = this.mf();
        List<GISMultiRegion> list = this.me.searchMultiRegion(string, dArray[0], dArray[1], dArray[2], dArray[3], true);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    private double[] mf() {
        return this.kh;
    }

    public void setLayerVisibility(String string, boolean bl2) {
        Layer[] layerArray = this.hm;
        int n2 = this.hm.length;
        int n3 = 0;
        while (n3 < n2) {
            Layer layer = layerArray[n3];
            if (layer.a.equals(string)) {
                if (layer.isVisible() != bl2) {
                    layer.setVisible(bl2);
                    this.cl = true;
                }
                return;
            }
            ++n3;
        }
    }

    private void hl() {
        TileImageProvider tileImageProvider = this.gf();
        if (tileImageProvider != null) {
            tileImageProvider.cancelLoading();
        }
    }

    private TileImageProvider gf() {
        if (!this.bl) {
            return null;
        }
        TileImageProvider tileImageProvider = null;
        if (this.dj.getTileFactory() instanceof TileFactory) {
            TileFactory tileFactory = (TileFactory)this.dj.getTileFactory();
            tileImageProvider = tileFactory.getTileImageProvider();
        }
        return tileImageProvider;
    }

    @Override
    public IGISRouteProvider getRouteProvider() {
        return this.bf;
    }

    @Override
    public GISRoute getRoute(GISPoint gISPoint, GISPoint gISPoint2) {
        return new GISRoute(this, this.bf.getPathData(gISPoint.getLatitude(), gISPoint.getLongitude(), gISPoint2.getLatitude(), gISPoint2.getLongitude()), gISPoint, gISPoint2, false);
    }

    @Override
    public GISRoute getRoute(double d2, double d3, double d4, double d5) {
        return new GISRoute(this, this.bf.getPathData(d2, d3, d4, d5));
    }

    @AnyLogicInternalAPI
    public void addImageChangedListener(ImageChangedListener imageChangedListener) {
        this.a.a(imageChangedListener);
    }

    @AnyLogicInternalAPI
    public void removeImageChangedListener(ImageChangedListener imageChangedListener) {
        this.a.n(imageChangedListener);
    }

    private void ma() {
        for (ImageChangedListener imageChangedListener : this.a) {
            imageChangedListener.imageChanged();
        }
    }

    @Override
    public double getMPP() {
        return 1.0 / this.el / (double)SharedUtils.getPPM(this.jn) / 2.0;
    }

    @AnyLogicInternalAPI
    public void onMarkupChanged() {
        if (!this.cl) {
            this.cl = true;
        }
    }

    public void add(GISMarkupElement gISMarkupElement) {
        OMGraphic oMGraphic = gISMarkupElement.getOmGraphic(true);
        oMGraphic.generate(this.jn);
        boolean bl2 = this.ca.add(oMGraphic);
        if (bl2) {
            this.onMarkupChanged();
        }
    }

    public void remove(GISMarkupElement gISMarkupElement) {
        boolean bl2 = this.ca.remove((Object)gISMarkupElement.getOmGraphic(false));
        if (bl2) {
            this.onMarkupChanged();
        }
    }

    public void add(GISMultiRegion gISMultiRegion) {
        boolean bl2 = false;
        for (GISRegion gISRegion : gISMultiRegion) {
            OMGraphic oMGraphic = gISRegion.getOmGraphic(true);
            oMGraphic.generate(this.jn);
            boolean bl3 = bl2 = this.ca.add(oMGraphic) || bl2;
        }
        if (bl2) {
            this.onMarkupChanged();
        }
    }

    public void remove(GISMultiRegion gISMultiRegion) {
        boolean bl2 = false;
        for (GISRegion gISRegion : gISMultiRegion) {
            boolean bl3 = bl2 = this.ca.remove((Object)gISRegion.getOmGraphic(false)) || bl2;
        }
        if (bl2) {
            this.onMarkupChanged();
        }
    }

    public double toLengthUnits(double d2, LengthUnits lengthUnits) {
        return LengthUnits.METER.convertTo(d2, lengthUnits);
    }

    public double fromLengthUnits(double d2, LengthUnits lengthUnits) {
        return lengthUnits.convertTo(d2, LengthUnits.METER);
    }

    public void setSearchBounds(double d2, double d3, double d4, double d5) {
        this.kh[0] = d2;
        this.kh[1] = d3;
        this.kh[2] = d4;
        this.kh[3] = d5;
    }

    public boolean isMouseNavigationEnabled() {
        return this.ni;
    }

    public void setMouseNavigationEnabled(boolean bl2) {
        this.ni = bl2;
    }

    public void fitBounds(double d2, double d3, double d4, double d5) {
        double d6 = MoreMath.asinh((double)Math.tan(Math.toRadians(d2)));
        double d7 = MoreMath.asinh((double)Math.tan(Math.toRadians(d4)));
        double d8 = this.ne / (d7 - d6);
        double d9 = (double)Planet.defaultPixelsPerMeter * 6378137.0 / d8;
        double d10 = this.ne / 2.0 / d8 + d6;
        double d11 = Math.toDegrees(Math.atan((Math.exp(2.0 * d10) - 1.0) / (2.0 * Math.exp(d10))));
        if (d3 >= d5) {
            d5 += 360.0;
        }
        double d12 = Math.round(d3 * Math.pow(10.0, 4.0)) == Math.round(d5 * Math.pow(10.0, 4.0)) ? (d5 > 90.0 ? d5 - 90.0 : (d5 < -90.0 ? d5 + 90.0 : d5)) : (d3 + d5) / 2.0;
        if (d12 > 180.0) {
            d12 -= 360.0;
        }
        this.a(d11, d12, false);
        this.setMapScale(1.0 / d9);
    }

    @Override
    protected int k() {
        return super.k() + 2;
    }

    @Override
    protected l[] m() {
        l[] lArray = super.m();
        int n2 = super.k();
        lArray[n2++] = this.gd();
        lArray[n2] = this.nm();
        return lArray;
    }

    @Override
    protected void a(db db2) {
        super.a(db2);
        if (this.n(hn)) {
            db2.a(this.gd());
        }
        if (this.n(ng)) {
            db2.a(this.nm());
        }
    }

    private l gd() {
        return new cb(this, (float)this.bi, (float)this.ne);
    }

    private l nm() {
        double d2 = this.getPresentable().getPresentation().getPanel().getZoom();
        int n2 = (int)(this.bi * d2);
        int n3 = (int)(this.ne * d2);
        if (this.mm == null || this.mm.getWidth() != n2 || this.mm.getHeight() != n3) {
            this.mm = ff.a(n2, n3, true);
        }
        Graphics2D graphics2D = this.mm.createGraphics();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d2, d2);
        affineTransform.translate(-this.gd, -this.nm);
        try {
            graphics2D.clearRect(0, 0, n2, n3);
            this.draw(null, graphics2D, affineTransform, true);
        }
        finally {
            graphics2D.dispose();
        }
        return new fa(this, this.mm);
    }

    @Override
    @AnyLogicInternalAPI
    public void setContextReference_xjal(Presentable presentable) {
    }

    @AnyLogicInternalAPI
    public void dispose() {
        this.destroy();
        this.a.h();
        if (this.nn != null) {
            this.nn.flush();
        }
        this.nn = null;
        if (this.mm != null) {
            this.mm.flush();
        }
        this.mm = null;
        if (this.mi != null) {
            this.mi.flush();
        }
        this.mi = null;
        this.jn = null;
        this.dj = null;
        this.me = null;
    }

    private static class a
    extends Point {
        private static final long serialVersionUID = 5617126723210331856L;
        private final double a;
        private final double n;

        private a(double d2, double d3) {
            this.a = d2;
            this.n = d3;
        }

        private boolean a(double d2, double d3) {
            return this.a == d2 && this.n == d3;
        }
    }

    public static class Layer
    implements Serializable {
        private static final long serialVersionUID = -7736077865162188752L;
        private final String a;
        private final String n;
        private final Color k;
        private final Color m;
        private final int h;
        private transient f j;
        private transient ShapeGISMap i;
        private boolean d;

        public Layer(String string, String string2, Color color, Color color2, int n2, boolean bl2) {
            this.a = string;
            this.n = string2;
            this.k = color;
            this.m = color2;
            this.h = n2;
            this.d = bl2;
        }

        public Collection<PoliticalArea> getPoliticalAreas() {
            return this.j.a().a();
        }

        public PoliticalArea findPoliticalArea(String string) {
            return this.j.a().findPoliticalArea(string);
        }

        public PoliticalArea[] findPoliticalAreas(double d2, double d3) {
            return this.j.a().a(d2, d3, this.j.getProjection());
        }

        public PoliticalArea findPoliticalArea(double d2, double d3) {
            return this.j.a().n(d2, d3, this.j.getProjection());
        }

        public OMGraphicList getObjects(double d2, double d3) {
            this.a();
            j j2 = this.j.a();
            if (j2 != null) {
                return j2.getGraphics(d2, d3 - (double)5.0E-4f, d2, d3 + (double)5.1E-4f, this.j.getProjection());
            }
            return new OMGraphicList();
        }

        public OMGraphicList getObjects(String string) {
            OMGraphicList oMGraphicList;
            this.a();
            j j2 = this.j.a();
            OMGraphicList oMGraphicList2 = new OMGraphicList();
            if (j2 != null && (oMGraphicList = j2.getGraphics()) != null) {
                int n2 = 1;
                while (n2 <= oMGraphicList.size()) {
                    String string2 = j2.getName(n2);
                    if (string2 != null && string2.equalsIgnoreCase(string)) {
                        OMGraphic oMGraphic = oMGraphicList.getOMGraphicAt(n2 - 1);
                        if (oMGraphic instanceof OMGraphicList) {
                            OMGraphicList oMGraphicList3 = (OMGraphicList)oMGraphic;
                            int n3 = 0;
                            while (n3 < oMGraphicList3.size()) {
                                oMGraphicList2.add(oMGraphicList3.getOMGraphicAt(n3));
                                ++n3;
                            }
                        } else {
                            oMGraphicList2.add(oMGraphic);
                        }
                    }
                    ++n2;
                }
            }
            return oMGraphicList2;
        }

        public AreaShapeLayer getLayerObject() {
            this.a();
            return this.j;
        }

        private void a() {
            if (this.j == null) {
                throw new UnsupportedOperationException(hg.mnh);
            }
        }

        public boolean isVisible() {
            return this.d;
        }

        public void setVisible(boolean bl2) {
            this.d = bl2;
        }
    }
}

