/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.presentation;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.presentation.ShapeControl;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class ShapeTextField
extends ShapeControl
implements FocusListener,
KeyListener {
    private static final long serialVersionUID = 8846118861755981113L;
    @AnyLogicInternalAPI
    public String value;
    private JTextField a = new JTextField();
    private final ShapeControl.ValueType n;
    private String k;
    private double m;
    private double h;
    private static Color j = null;
    private static Color i = null;

    @Deprecated
    public ShapeTextField(Presentable presentable, boolean bl2, int n2, int n3, int n4, int n5, Color color, Color color2, Font font) {
        this(presentable, bl2, (double)n2, (double)n3, (double)n4, (double)n5, color, color2, font);
    }

    public ShapeTextField(Presentable presentable, boolean bl2, double d2, double d3, double d4, double d5, Color color, Color color2, Font font) {
        this(presentable, bl2, d2, d3, d4, d5, color, color2, true, font);
    }

    public ShapeTextField(Presentable presentable, boolean bl2, double d2, double d3, double d4, double d5, Color color, Color color2, boolean bl3, Font font) {
        this(presentable, bl2, d2, d3, d4, d5, color, color2, bl3, font, TYPE_STRING, Double.NaN, Double.NaN);
    }

    @Deprecated
    public ShapeTextField(Presentable presentable, boolean bl2, int n2, int n3, int n4, int n5, Color color, Color color2, Font font, ShapeControl.ValueType valueType, double d2, double d3) {
        this(presentable, bl2, (double)n2, (double)n3, (double)n4, (double)n5, color, color2, font, valueType, d2, d3);
    }

    public ShapeTextField(Presentable presentable, boolean bl2, double d2, double d3, double d4, double d5, Color color, Color color2, Font font, ShapeControl.ValueType valueType, double d6, double d7) {
        this(presentable, bl2, d2, d3, d4, d5, color, color2, true, font, valueType, d6, d7);
    }

    public ShapeTextField(Presentable presentable, boolean bl2, double d2, double d3, double d4, double d5, Color color, Color color2, boolean bl3, Font font, ShapeControl.ValueType valueType, double d6, double d7) {
        super(presentable, bl2, d2, d3, d4, d5);
        this.h(true);
        this.k = "";
        this.m = Double.NEGATIVE_INFINITY;
        this.h = Double.POSITIVE_INFINITY;
        this.n = ShapeTextField.a(valueType);
        ShapeTextField.a(this.a, color);
        ShapeTextField.n(this.a, color2);
        this.setEnabled(bl3);
        this.a.setFont(font);
        this.a.setHorizontalAlignment(4);
        if (valueType == TYPE_DOUBLE || valueType == TYPE_INT) {
            this.a.setText("0");
            this.setRange(d6, d7);
        }
        this.a.addFocusListener(this);
        this.a.addKeyListener(this);
    }

    private static ShapeControl.ValueType a(ShapeControl.ValueType valueType) {
        if (valueType != TYPE_STRING && valueType != TYPE_DOUBLE && valueType != TYPE_INT) {
            throw new IllegalArgumentException(String.format(hg.bmm, new Object[]{valueType, "TYPE_STRING, TYPE_DOUBLE, TYPE_INT"}));
        }
        return valueType;
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public void action() {
        this.jj.executeShapeControlAction(this.jb, this.hn, this.value);
    }

    @Override
    public JComponent getJComponent() {
        return this.a;
    }

    public void setBackgroundColor(Color color) {
        if (color == UtilitiesColor.CONTROL_DEFAULT) {
            color = j;
        }
        if (color != null) {
            if (this.a.isOpaque() != color.getAlpha() > 0) {
                this.a.setOpaque(color.getAlpha() > 0);
            } else {
                this.a.setBackground(color);
            }
        }
    }

    public void setTextColor(Color color) {
        if (color == UtilitiesColor.CONTROL_DEFAULT) {
            color = i;
        }
        this.a.setForeground(color);
    }

    @Override
    public void setValueToDefault() {
        this.setText(this.jj.getShapeControlDefaultValueString(this.jb, this.hn));
    }

    public void setText(String string) {
        this.setText(string, false);
    }

    public void setText(String string, boolean bl2) {
        try {
            this.a(this.a(string), bl2);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setText(double d2) {
        this.setText(d2, false);
    }

    public void setText(double d2, boolean bl2) {
        d2 = this.n(d2);
        this.a(this.a(d2), bl2);
    }

    private String a(double d2) {
        return this.n == TYPE_INT ? String.valueOf((int)d2) : String.valueOf(d2);
    }

    private void a(String string, boolean bl2) {
        this.na = !bl2;
        this.ih = true;
        this.a.setText(string);
        this.k = string;
        this.a_();
        this.ih = false;
        this.na = false;
    }

    private double n(double d2) {
        if (this.n == TYPE_INT) {
            d2 = Math.round(d2);
        }
        return Utilities.limit(this.m, d2, this.h);
    }

    private String a(String string) throws NumberFormatException {
        double d2;
        if (string == null) {
            switch (this.n) {
                case TYPE_DOUBLE: 
                case TYPE_INT: {
                    throw new NumberFormatException("null");
                }
            }
            return "";
        }
        switch (this.n) {
            case TYPE_DOUBLE: {
                string = string.trim();
                try {
                    d2 = Double.parseDouble(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        String string2 = string.replace(',', '.');
                        d2 = Double.parseDouble(string2);
                        string = string2;
                        break;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw numberFormatException;
                    }
                }
            }
            case TYPE_INT: {
                string = string.trim();
                try {
                    d2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        d2 = Math.round(Double.parseDouble(string));
                    }
                    catch (NumberFormatException numberFormatException3) {
                        try {
                            d2 = Math.round(Double.parseDouble(string.replace(',', '.')));
                        }
                        catch (NumberFormatException numberFormatException4) {
                            throw numberFormatException;
                        }
                    }
                    string = this.a(d2);
                }
                break;
            }
            default: {
                return string;
            }
        }
        if (d2 < this.m) {
            string = this.a(this.m);
        } else if (d2 > this.h) {
            string = this.a(this.h);
        }
        return string;
    }

    public String getText() {
        return this.a.getText();
    }

    public int getIntValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format(hg.kfk, this.getName(), exception.toString()), exception);
        }
    }

    public double getDoubleValue() {
        try {
            return Double.parseDouble(this.getText());
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format(hg.kfk, this.getName(), exception.toString()), exception);
        }
    }

    public void setRange(double d2, double d3) {
        this.setRange(d2, d3, false);
    }

    public void setRange(double d2, double d3, boolean bl2) {
        this.m();
        if (this.n == TYPE_INT) {
            d2 = Math.max(-2.147483648E9, Math.ceil(d2));
            d3 = Math.min(2.147483647E9, Math.floor(d3));
        }
        if (d2 == 0.0 && d3 == 0.0) {
            d3 = 100.0;
        }
        if (d2 >= d3) {
            throw new RuntimeException(String.format(hg.bih, d2, d3));
        }
        if (d2 == this.m && d3 == this.h) {
            return;
        }
        this.m = d2;
        this.h = d3;
        this.na = !bl2;
        this.ih = true;
        double d4 = this.getDoubleValue();
        if (d4 < d2) {
            this.setText(d2);
        } else if (d4 > d3) {
            this.setText(d3);
        }
        this.ih = false;
        this.na = false;
    }

    private void m() {
        if (this.n != TYPE_DOUBLE && this.n != TYPE_INT) {
            throw new UnsupportedOperationException(String.format(hg.nlf, this.getName()));
        }
    }

    public double getMin() {
        this.m();
        return this.m;
    }

    public double getMax() {
        this.m();
        return this.h;
    }

    @AnyLogicInternalAPI
    ShapeTextField(Presentable presentable, int n2, int n3) {
        super(presentable, n2, n3);
        this.h(true);
        this.k = "";
        this.m = Double.NEGATIVE_INFINITY;
        this.h = Double.POSITIVE_INFINITY;
        this.n = ShapeTextField.a(presentable.getShapeControlValueType(n2, n3));
        ShapeTextField.a(this.a, presentable.getShapeFillColor(n2, n3));
        ShapeTextField.n(this.a, presentable.getShapeLineColor(n2, n3));
        this.a.setFont(presentable.getShapeFont(n2, n3));
        this.a.setHorizontalAlignment(4);
        if (this.n == TYPE_DOUBLE || this.n == TYPE_INT) {
            this.a.setText("0");
            this.setRange(presentable.getShapeControlMinimum(n2, n3), presentable.getShapeControlMaximum(n2, n3));
        }
        this.setValueToDefault();
        this.a.addFocusListener(this);
        this.a.addKeyListener(this);
    }

    @Override
    void b_() {
        this.value = this.getText();
        super.b_();
    }

    @Override
    @AnyLogicInternalAPI
    public void update() {
        if (this.n == TYPE_DOUBLE || this.n == TYPE_INT) {
            double d2 = this.jj.getShapeControlMinimum(this.jb, this.hn);
            double d3 = this.jj.getShapeControlMaximum(this.jb, this.hn);
            this.setRange(d2, d3, false);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.h(false);
    }

    @Override
    void a_() {
        if (this.na) {
            return;
        }
        String string = this.getText();
        try {
            String string2 = this.a(string);
            if (!string2.equals(string)) {
                this.a(string2, false);
            } else {
                this.k = string;
            }
            super.a_();
        }
        catch (NumberFormatException numberFormatException) {
            this.setText(this.k, false);
        }
    }

    @Override
    @AnyLogicInternalAPI
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    @AnyLogicInternalAPI
    public void focusLost(FocusEvent focusEvent) {
        this.a_();
    }

    @Override
    @AnyLogicInternalAPI
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.a_();
        }
    }

    @Override
    @AnyLogicInternalAPI
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    @AnyLogicInternalAPI
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void h(boolean bl2) {
        if (j == null && i == null) {
            JTextField jTextField = bl2 ? this.a : new JTextField();
            j = jTextField.getBackground();
            i = jTextField.getForeground();
        }
    }
}

