/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.presentation;

import com.anylogic.engine.internal.ff;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URL;
import javax.imageio.ImageIO;

public class Texture
implements Paint,
Serializable {
    private static final long serialVersionUID = -590137493246379374L;
    private final String a;
    private final Color n;
    private final Color k;
    private final Color m;
    private final URL h;
    private final URL j;
    private final URL i;
    private final URL d;
    private final double l;
    private transient Paint g;

    Texture(String string, Color color, Color color2, Color color3, URL uRL, URL uRL2, URL uRL3, URL uRL4, double d2) {
        this.a = string;
        this.n = color;
        this.k = color2;
        this.m = color3;
        this.h = uRL != null ? uRL : uRL2;
        this.j = uRL2;
        this.i = uRL3;
        this.d = uRL4;
        this.l = uRL2 != null ? d2 : Double.NaN;
    }

    String a() {
        return this.a;
    }

    public String toString() {
        return this.a != null ? this.a : super.toString();
    }

    public Color getAmbientColor() {
        return this.n;
    }

    public Color getDiffuseColor() {
        return this.k;
    }

    public Color getSpecularColor() {
        return this.m;
    }

    public URL getTexture2D() {
        return this.h;
    }

    public URL getTexture3D() {
        return this.j;
    }

    public URL getTexture3DNormals_xjal() {
        return this.i;
    }

    public URL getTexture3DHeightMap_xjal() {
        return this.d;
    }

    public double getTexture3DScale() {
        return this.l;
    }

    public Paint getPaint_xjal() {
        if (this.g == null) {
            if (this.h != null) {
                try {
                    BufferedImage bufferedImage = ImageIO.read(this.h);
                    int n2 = bufferedImage.getWidth();
                    int n3 = bufferedImage.getHeight();
                    boolean bl2 = bufferedImage.getTransparency() != 1;
                    int[] nArray = new int[n2 * n3];
                    bufferedImage.getRGB(0, 0, n2, n3, nArray, 0, n2);
                    bufferedImage = null;
                    bufferedImage = ff.a(n2, n3, bl2);
                    bufferedImage.setRGB(0, 0, n2, n3, nArray, 0, n2);
                    nArray = null;
                    this.g = new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, n2, n3));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(String.format(hg.jmc, this.h), iOException);
                }
            } else {
                this.g = this.k != null ? this.k : (this.n != null ? this.n : (this.m != null ? this.m : UtilitiesColor.transparent));
            }
        }
        return this.g;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return this.getPaint_xjal().createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }

    @Override
    public int getTransparency() {
        return this.getPaint_xjal().getTransparency();
    }

    protected Object readResolve() throws ObjectStreamException {
        Texture texture;
        if (this.a != null && (texture = UtilitiesColor.a.get(this.a)) != null) {
            return texture;
        }
        return this;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.n == null ? 0 : this.n.hashCode());
        n2 = 31 * n2 + (this.k == null ? 0 : this.k.hashCode());
        n2 = 31 * n2 + (this.m == null ? 0 : this.m.hashCode());
        n2 = 31 * n2 + (this.h == null ? 0 : this.h.hashCode());
        n2 = 31 * n2 + (this.j == null ? 0 : this.j.hashCode());
        n2 = 31 * n2 + (this.i == null ? 0 : this.i.hashCode());
        long l2 = Double.doubleToLongBits(this.l);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Texture texture = (Texture)object;
        if (this.n == null ? texture.n != null : !this.n.equals(texture.n)) {
            return false;
        }
        if (this.k == null ? texture.k != null : !this.k.equals(texture.k)) {
            return false;
        }
        if (this.m == null ? texture.m != null : !this.m.equals(texture.m)) {
            return false;
        }
        if (this.h == null ? texture.h != null : !this.h.equals(texture.h)) {
            return false;
        }
        if (this.j == null ? texture.j != null : !this.j.equals(texture.j)) {
            return false;
        }
        if (this.i == null ? texture.i != null : !this.i.equals(texture.i)) {
            return false;
        }
        return Double.doubleToLongBits(this.l) == Double.doubleToLongBits(texture.l);
    }
}

