/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.Point;
import org.geolatte.geom.Points;
import org.geolatte.geom.crs.CrsId;

public class Envelope {
    public static final Envelope EMPTY = new Envelope(Double.NaN, Double.NaN, Double.NaN, Double.NaN, CrsId.UNDEFINED);
    private final CrsId crsId;
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;

    public Envelope(Point lowerLeft, Point upperRight) {
        if (!lowerLeft.getCrsId().equals(upperRight.getCrsId())) {
            throw new IllegalArgumentException("LowerLeft and UpperRight points must have same Coordinate Ref. System.");
        }
        this.crsId = lowerLeft.getCrsId();
        this.minX = lowerLeft.getX();
        this.minY = lowerLeft.getY();
        this.maxX = upperRight.getX();
        this.maxY = upperRight.getY();
    }

    public Envelope(double minX, double minY, double maxX, double maxY) {
        this(minX, minY, maxX, maxY, CrsId.UNDEFINED);
    }

    public Envelope(double minX, double minY, double maxX, double maxY, CrsId crsId) {
        if (minX > maxX || minY > maxY) {
            this.minX = Double.NaN;
            this.minY = Double.NaN;
            this.maxX = Double.NaN;
            this.maxY = Double.NaN;
            this.crsId = CrsId.UNDEFINED;
        } else {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
            this.crsId = crsId != null ? crsId : CrsId.UNDEFINED;
        }
    }

    public CrsId getCrsId() {
        return this.crsId;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public Point lowerLeft() {
        return Points.create2D(this.minX, this.minY, this.crsId);
    }

    public Point upperRight() {
        return Points.create2D(this.maxX, this.maxY, this.crsId);
    }

    public Point upperLeft() {
        return Points.create2D(this.minX, this.maxY, this.crsId);
    }

    public Point lowerRight() {
        return Points.create2D(this.maxX, this.minY, this.crsId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.crsId.toString());
        builder.append("LL: ").append(this.minX).append(",").append(this.minY).append(" - UR: ").append(this.maxX).append(",").append(this.maxY);
        return builder.toString();
    }

    public static Envelope union(Envelope b1, Envelope b2) {
        if (b1 == null || b1.isEmpty()) {
            return b2;
        }
        if (b2 == null || b2.isEmpty()) {
            return b1;
        }
        if (!b1.getCrsId().equals(b2.getCrsId())) {
            throw new IllegalArgumentException("Envelopes have different CRS.");
        }
        double minX = Math.min(b1.getMinX(), b2.getMinX());
        double minY = Math.min(b1.getMinY(), b2.getMinY());
        double maxX = Math.max(b1.getMaxX(), b2.getMaxX());
        double maxY = Math.max(b1.getMaxY(), b2.getMaxY());
        return new Envelope(minX, minY, maxX, maxY, b1.getCrsId());
    }

    public Envelope intersect(Envelope other) {
        if (this.isEmpty() || other.isEmpty()) {
            return EMPTY;
        }
        if (!this.getCrsId().equals(other.getCrsId())) {
            throw new IllegalArgumentException("Envelopes have different CRS.");
        }
        double minX = Math.max(other.getMinX(), this.getMinX());
        double minY = Math.max(other.getMinY(), this.getMinY());
        double maxX = Math.min(other.getMaxX(), this.getMaxX());
        double maxY = Math.min(other.getMaxY(), this.getMaxY());
        if (minX > maxX || minY > maxY) {
            return EMPTY;
        }
        return new Envelope(minX, minY, maxX, maxY, this.getCrsId());
    }

    public boolean isEmpty() {
        return Double.isNaN(this.minX) || Double.isNaN(this.minY) || Double.isNaN(this.maxX) || Double.isNaN(this.maxY);
    }

    public boolean within(Envelope other) {
        if (this.isEmpty()) {
            return true;
        }
        if (other.isEmpty()) {
            return false;
        }
        if (!this.getCrsId().equals(other.getCrsId())) {
            throw new IllegalArgumentException("Envelopes have different CRS.");
        }
        return other.getMinX() <= this.getMinX() && other.getMaxX() >= this.getMaxX() && other.getMinY() <= this.getMinY() && other.getMaxY() >= this.getMaxY();
    }

    public boolean contains(Envelope other) {
        return other.within(this);
    }

    public boolean contains(Point p) {
        if (!this.getCrsId().equals(p.getCrsId())) {
            throw new IllegalArgumentException("Envelopes have different CRS.");
        }
        if (this.isEmpty()) {
            return false;
        }
        return this.getMinX() <= p.getX() && this.getMaxX() >= p.getX() && this.getMinY() <= p.getY() && this.getMaxY() >= p.getY();
    }

    public boolean intersects(Envelope other) {
        return !(this.isEmpty() || other.isEmpty() || this.maxX < other.minX || this.minX > other.maxX || this.maxY < other.minY || this.minY > other.maxY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Envelope)) {
            return false;
        }
        Envelope that = (Envelope)o;
        if (this.isEmpty() && that.isEmpty()) {
            return true;
        }
        if (!this.getCrsId().equals(that.getCrsId())) {
            return false;
        }
        if (Double.compare(that.maxX, this.maxX) != 0) {
            return false;
        }
        if (Double.compare(that.maxY, this.maxY) != 0) {
            return false;
        }
        if (Double.compare(that.minX, this.minX) != 0) {
            return false;
        }
        return Double.compare(that.minY, this.minY) == 0;
    }

    public int hashCode() {
        long temp = this.minX != 0.0 ? Double.doubleToLongBits(this.minX) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.maxX != 0.0 ? Double.doubleToLongBits(this.maxX) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.minY != 0.0 ? Double.doubleToLongBits(this.minY) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.maxY != 0.0 ? Double.doubleToLongBits(this.maxY) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

