/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Arrays;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.EmptyPointSequence;
import org.geolatte.geom.NestedPointCollection;
import org.geolatte.geom.PackedPointSequence;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.crs.CrsId;

public class PointCollectionFactory {
    public static PointSequence createEmpty() {
        return EmptyPointSequence.INSTANCE;
    }

    public static PointSequence create(double[] coordinates, DimensionalFlag dimensionalFlag, CrsId crsId) {
        return new PackedPointSequence(Arrays.copyOf(coordinates, coordinates.length), dimensionalFlag, crsId);
    }

    public static PointCollection create(PointCollection[] pointCollections) {
        if (pointCollections == null || pointCollections.length == 0) {
            return EmptyPointSequence.INSTANCE;
        }
        return new NestedPointCollection(pointCollections);
    }
}

