/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.PolyHedralSurface;
import org.geolatte.geom.Polygon;

enum WkbGeometryType {
    POINT(1, Point.class),
    GEOMETRY_COLLECTION(7, GeometryCollection.class),
    LINE_STRING(2, LineString.class),
    POLYGON(3, Polygon.class),
    POLYHEDRAL_SURFACE(15, PolyHedralSurface.class),
    MULTI_POINT(4, MultiPoint.class),
    MULTI_POLYGON(6, MultiPolygon.class),
    MULTI_LINE_STRING(5, MultiLineString.class);

    private final int wkbType;
    private final Class<? extends Geometry> geometryClass;

    private WkbGeometryType(int type, Class<? extends Geometry> geometryClass) {
        this.wkbType = type;
        this.geometryClass = geometryClass;
    }

    public int getTypeCode() {
        return this.wkbType;
    }

    public static WkbGeometryType parse(int typeCode) {
        for (WkbGeometryType type : WkbGeometryType.values()) {
            if (type.wkbType != typeCode) continue;
            return type;
        }
        throw new IllegalArgumentException("Type code " + typeCode + " is not known.");
    }

    public static WkbGeometryType forClass(Class<? extends Geometry> geomClass) {
        WkbGeometryType candidate = null;
        for (WkbGeometryType type : WkbGeometryType.values()) {
            if (!type.geometryClass.isAssignableFrom(geomClass) || !WkbGeometryType.isMoreSpecificClassMatch(candidate, type)) continue;
            candidate = type;
        }
        return candidate;
    }

    private static boolean isMoreSpecificClassMatch(WkbGeometryType candidate, WkbGeometryType type) {
        return candidate == null || candidate.geometryClass.isAssignableFrom(type.geometryClass);
    }
}

