/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.sqlserver.Decoder;
import org.geolatte.geom.codec.sqlserver.GeometryCollectionDecoder;
import org.geolatte.geom.codec.sqlserver.LineStringDecoder;
import org.geolatte.geom.codec.sqlserver.MultiLineStringDecoder;
import org.geolatte.geom.codec.sqlserver.MultiPointDecoder;
import org.geolatte.geom.codec.sqlserver.MultiPolygonDecoder;
import org.geolatte.geom.codec.sqlserver.OpenGisType;
import org.geolatte.geom.codec.sqlserver.PointDecoder;
import org.geolatte.geom.codec.sqlserver.PolygonDecoder;
import org.geolatte.geom.codec.sqlserver.SqlServerGeometry;

public class Decoders {
    private static final List<Decoder<? extends Geometry>> DECODERS = new ArrayList<Decoder<? extends Geometry>>();

    private static Decoder<? extends Geometry> decoderFor(SqlServerGeometry object) {
        for (Decoder<? extends Geometry> decoder : DECODERS) {
            if (!decoder.accepts(object)) continue;
            return decoder;
        }
        throw new IllegalArgumentException("No decoder for type " + (Object)((Object)object.openGisType()));
    }

    public static Geometry decode(byte[] raw) {
        SqlServerGeometry sqlServerGeom = SqlServerGeometry.deserialize(raw);
        Decoder<? extends Geometry> decoder = Decoders.decoderFor(sqlServerGeom);
        return decoder.decode(sqlServerGeom);
    }

    public static Decoder<? extends Geometry> decoderFor(OpenGisType type) {
        for (Decoder<? extends Geometry> decoder : DECODERS) {
            if (!decoder.accepts(type)) continue;
            return decoder;
        }
        throw new IllegalArgumentException("No decoder for type " + (Object)((Object)type));
    }

    static {
        DECODERS.add(new PointDecoder());
        DECODERS.add(new LineStringDecoder());
        DECODERS.add(new PolygonDecoder());
        DECODERS.add(new MultiLineStringDecoder());
        DECODERS.add(new MultiPolygonDecoder());
        DECODERS.add(new MultiPointDecoder());
        DECODERS.add(new GeometryCollectionDecoder());
    }
}

