/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.codec.sqlserver.AbstractDecoder;
import org.geolatte.geom.codec.sqlserver.IndexRange;
import org.geolatte.geom.codec.sqlserver.OpenGisType;
import org.geolatte.geom.codec.sqlserver.SqlServerGeometry;

class PointDecoder
extends AbstractDecoder<Point> {
    PointDecoder() {
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.POINT;
    }

    @Override
    protected Point createNullGeometry() {
        return Point.createEmpty();
    }

    @Override
    protected Point createGeometry(SqlServerGeometry nativeGeom) {
        return this.createPoint(nativeGeom, 0);
    }

    @Override
    protected Point createGeometry(SqlServerGeometry nativeGeom, int shapeIndex) {
        if (nativeGeom.isEmptyShape(shapeIndex)) {
            return this.createNullGeometry();
        }
        int figureOffset = nativeGeom.getFiguresForShape((int)shapeIndex).start;
        int pntOffset = nativeGeom.getPointsForFigure((int)figureOffset).start;
        return this.createPoint(nativeGeom, pntOffset);
    }

    private Point createPoint(SqlServerGeometry nativeGeom, int pntOffset) {
        DimensionalFlag df = DimensionalFlag.valueOf(nativeGeom.hasZValues(), nativeGeom.hasMValues());
        PointSequence pointSequence = nativeGeom.coordinateRange(new IndexRange(pntOffset, pntOffset + 1));
        return new Point(pointSequence);
    }
}

