/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.util.SimpleColumnMatcher;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.converters.SQLConverter;

public class IndexSelector {
    private Index bestIndex;
    private boolean primaryCursor;
    private Table table;

    public IndexSelector(Table table) {
        this.table = table;
    }

    public Index getBestIndex() {
        if (this.bestIndex == null) {
            List li = this.table.getIndexes();
            for (Index idx : li) {
                if (!idx.isPrimaryKey()) continue;
                this.bestIndex = idx;
                this.primaryCursor = true;
                break;
            }
            if (this.bestIndex == null) {
                for (Index idx : li) {
                    if (!idx.isUnique()) continue;
                    this.bestIndex = idx;
                    break;
                }
            }
            if (this.bestIndex == null && li.size() == 1) {
                this.bestIndex = (Index)li.get(0);
            }
        }
        return this.bestIndex;
    }

    public Cursor getCursor() throws IOException {
        Index idx = this.getBestIndex();
        CursorBuilder cb = this.table.newCursor();
        Cursor cursor = idx == null ? cb.toCursor() : cb.setIndex(idx).toCursor();
        cursor.setColumnMatcher((com.healthmarketscience.jackcess.util.ColumnMatcher)new ColumnMatcher());
        return cursor;
    }

    public boolean isPrimaryCursor() {
        return this.primaryCursor;
    }

    private class ColumnMatcher
    extends SimpleColumnMatcher {
        private ColumnMatcher() {
        }

        public boolean matches(Table table, String columnName, Object currVal, Object dbVal) {
            if (currVal == null && dbVal == null) {
                return true;
            }
            if (currVal == null || dbVal == null) {
                return false;
            }
            if (currVal instanceof Date && dbVal instanceof Date) {
                return ((Date)currVal).compareTo((Date)dbVal) == 0;
            }
            if (currVal instanceof BigDecimal && dbVal instanceof BigDecimal) {
                return ((BigDecimal)currVal).compareTo((BigDecimal)dbVal) == 0;
            }
            if (dbVal instanceof BigDecimal && currVal instanceof Number) {
                return ((BigDecimal)dbVal).compareTo(new BigDecimal(currVal.toString())) == 0;
            }
            if (currVal instanceof BigDecimal && dbVal instanceof Number) {
                return ((BigDecimal)currVal).compareTo(new BigDecimal(dbVal.toString())) == 0;
            }
            if (currVal instanceof Integer && dbVal instanceof Short) {
                return ((Integer)currVal).intValue() == ((Short)dbVal).intValue();
            }
            if (dbVal instanceof Integer && currVal instanceof Short) {
                return ((Integer)dbVal).intValue() == ((Short)currVal).intValue();
            }
            if (currVal instanceof Integer && dbVal instanceof Byte) {
                return (Integer)currVal == SQLConverter.asUnsigned((Byte)dbVal);
            }
            if (dbVal instanceof Integer && currVal instanceof Byte) {
                return (Integer)dbVal == SQLConverter.asUnsigned((Byte)currVal);
            }
            if (dbVal instanceof Float && currVal instanceof Double || dbVal instanceof Double && currVal instanceof Float) {
                return new BigDecimal(dbVal.toString()).compareTo(new BigDecimal(currVal.toString())) == 0;
            }
            if (currVal instanceof byte[] && dbVal instanceof byte[]) {
                byte[] val1 = (byte[])currVal;
                byte[] val2 = (byte[])dbVal;
                if (val1.length != val2.length) {
                    return false;
                }
                int y = 0;
                while (y < val1.length) {
                    if (val1[y] != val2[y]) {
                        return false;
                    }
                    ++y;
                }
                return true;
            }
            if (currVal instanceof ComplexBase[] && dbVal instanceof ComplexValueForeignKey) {
                try {
                    boolean eq = Arrays.equals((ComplexBase[])currVal, ComplexBase.convert((ComplexValueForeignKey)dbVal));
                    return eq;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return super.matches(table, columnName, currVal, dbVal);
        }
    }
}

