/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import net.ucanaccess.commands.AutoNumberAction;
import net.ucanaccess.commands.DeleteCommand;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.complex.Attachment;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.complex.SingleValue;
import net.ucanaccess.complex.Version;
import net.ucanaccess.converters.Persist2Jet;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.triggers.AutoNumberManager;

public class InsertCommand
implements ICommand {
    private Database dbIO;
    private String execId;
    private Object[] newRow;
    private Table table;
    private String tableName;

    public InsertCommand(String tableName, Database dbIO, Object[] newRow, String execId) {
        this.tableName = tableName;
        this.dbIO = dbIO;
        this.newRow = newRow;
        this.execId = execId;
    }

    public InsertCommand(Table table, Object[] newRow, String execId) {
        this.table = table;
        this.tableName = table.getName();
        this.newRow = newRow;
        this.execId = execId;
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public ICommand.TYPES getType() {
        return ICommand.TYPES.INSERT;
    }

    private Object[] mementoRow() {
        Object[] clone = new Object[this.newRow.length];
        int i = 0;
        Object[] objectArray = this.newRow;
        int n = this.newRow.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj;
            clone[i] = obj = objectArray[n2];
            ++i;
            ++n2;
        }
        return clone;
    }

    private void initComplex() {
        int i = 0;
        while (i < this.newRow.length) {
            if (this.newRow[i] instanceof ComplexBase) {
                this.newRow[i] = Column.AUTO_NUMBER;
            }
            ++i;
        }
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        try {
            AutoNumberAction ana = null;
            if (this.table == null) {
                this.table = this.dbIO.getTable(this.tableName);
            }
            Object[] memento = this.mementoRow();
            this.initComplex();
            int j = 0;
            List<Column> lc = this.table.getColumns();
            if (this.table.getDatabase().getColumnOrder().equals((Object)Table.ColumnOrder.DISPLAY)) {
                Object[] newRowReorded = new Object[this.newRow.length];
                Column[] cllReorded = new Column[this.newRow.length];
                for (Column cli : this.table.getColumns()) {
                    newRowReorded[cli.getColumnIndex()] = this.newRow[j];
                    memento[cli.getColumnIndex()] = this.newRow[j];
                    cllReorded[cli.getColumnIndex()] = cli;
                    ++j;
                }
                this.newRow = newRowReorded;
                lc = Arrays.asList(cllReorded);
            }
            this.table.addRow(this.newRow);
            j = 0;
            for (Column cli : lc) {
                ColumnImpl cl = (ColumnImpl)cli;
                if (cl.isAutoNumber() && cl.getAutoNumberGenerator().getType().equals((Object)DataType.LONG) && !memento[j].equals(this.newRow[j])) {
                    AutoNumberManager.reset((Column)cl, (Integer)this.newRow[j]);
                    ana = new AutoNumberAction(this.table, memento, this.newRow);
                }
                if (cl.getType() == DataType.COMPLEX_TYPE) {
                    ComplexBase v;
                    ComplexBase[] vs;
                    int n;
                    int n2;
                    ComplexBase[] complexBaseArray;
                    ComplexValueForeignKey rowFk = (ComplexValueForeignKey)cl.getRowValue(this.newRow);
                    if (memento[j] instanceof Attachment[]) {
                        Attachment[] atcs = (Attachment[])memento[j];
                        complexBaseArray = atcs;
                        n2 = atcs.length;
                        n = 0;
                        while (n < n2) {
                            ComplexBase atc = complexBaseArray[n];
                            rowFk.addAttachment(((Attachment)atc).getUrl(), ((Attachment)atc).getName(), ((Attachment)atc).getType(), ((Attachment)atc).getData(), ((Attachment)atc).getTimeStamp(), ((Attachment)atc).getFlags());
                            ++n;
                        }
                    } else if (memento[j] instanceof SingleValue[]) {
                        vs = (SingleValue[])memento[j];
                        complexBaseArray = vs;
                        n2 = vs.length;
                        n = 0;
                        while (n < n2) {
                            v = complexBaseArray[n];
                            rowFk.addMultiValue(((SingleValue)v).getValue());
                            ++n;
                        }
                    } else if (memento[j] instanceof Version[]) {
                        vs = (Version[])memento[j];
                        complexBaseArray = vs;
                        n2 = vs.length;
                        n = 0;
                        while (n < n2) {
                            v = complexBaseArray[n];
                            rowFk.addVersion(((Version)v).getValue(), ((Version)v).getModifiedDate());
                            ++n;
                        }
                    }
                }
                ++j;
            }
            return ana;
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public IFeedbackAction rollback() throws SQLException {
        if (this.table != null) {
            DeleteCommand dc = new DeleteCommand(this.table, new Persist2Jet().getRowPattern(this.newRow, this.table), this.execId);
            return dc.persist();
        }
        return null;
    }
}

