/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.impl.IndexData;
import com.healthmarketscience.jackcess.impl.IndexImpl;
import com.healthmarketscience.jackcess.query.Query;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.converters.DFunction;
import net.ucanaccess.converters.Functions;
import net.ucanaccess.converters.Pivot;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.converters.TypesMap;
import net.ucanaccess.ext.FunctionType;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.util.Logger;

public class LoadJet {
    private static int namingCounter = 0;
    private Connection conn;
    private Database dbIO;
    private boolean err;
    private FunctionsLoader functionsLoader = new FunctionsLoader();
    private ArrayList<String> loadedIndexes = new ArrayList();
    private ArrayList<String> loadedQueries = new ArrayList();
    private ArrayList<String> loadedTables = new ArrayList();
    private LogsFlusher logsFlusher = new LogsFlusher();
    private TablesLoader tablesLoader = new TablesLoader();
    private TriggersLoader triggersGenerator = new TriggersLoader();
    private ViewsLoader viewsLoader = new ViewsLoader();
    private boolean sysSchema;
    private boolean ff1997;

    public LoadJet(Connection conn, Database dbIO) {
        this.conn = conn;
        this.dbIO = dbIO;
        try {
            this.ff1997 = Database.FileFormat.V1997.equals((Object)this.dbIO.getFileFormat());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadDefaultValues(Table t) throws SQLException, IOException {
        this.tablesLoader.defaultValues(t);
    }

    private static boolean hasAutoNumberColumn(Table t) {
        List lc = t.getColumns();
        for (Column cl : lc) {
            if (!cl.isAutoNumber() && !DataType.BOOLEAN.equals((Object)cl.getType())) continue;
            return true;
        }
        return false;
    }

    public void addFunctions(Class<?> clazz) throws SQLException {
        this.functionsLoader.addFunctions(clazz);
    }

    private void execCreate(String expression, boolean logging) throws SQLException {
        Statement st = null;
        try {
            try {
                st = this.conn.createStatement();
                st.executeUpdate(expression);
            }
            catch (SQLException e) {
                if (logging && e.getErrorCode() != -5528) {
                    Logger.log("Cannot execute:" + expression + " " + e.getMessage());
                }
                throw e;
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    private void execInsert(PreparedStatement st, ArrayList<Object> values) throws SQLException {
        int i = 1;
        for (Object value : values) {
            st.setObject(i++, value);
        }
        st.execute();
    }

    public SQLWarning getLoadingWarnings() {
        String message;
        if (this.viewsLoader.notLoaded.size() == 0 && this.tablesLoader.unresolvedTables.size() == 0) {
            return null;
        }
        SQLWarning sqlw = null;
        for (String s : this.viewsLoader.notLoaded.keySet()) {
            String string = message = s.length() > 0 ? "Cannot load view " + s + " " + (String)this.viewsLoader.notLoaded.get(s) : "Cannot load views ";
            if (sqlw == null) {
                sqlw = new SQLWarning(message);
                continue;
            }
            sqlw.setNextWarning(new SQLWarning(message));
        }
        for (String s : this.tablesLoader.unresolvedTables) {
            message = "Cannot resolve table " + s;
            if (sqlw == null) {
                sqlw = new SQLWarning(message);
                continue;
            }
            sqlw.setNextWarning(new SQLWarning(message));
        }
        return sqlw;
    }

    public void loadDB() throws SQLException, IOException {
        try {
            this.functionsLoader.loadMappedFunctions();
            this.tablesLoader.loadTables();
            this.viewsLoader.loadViews();
            this.conn.commit();
            SQLConverter.cleanEscaped();
        }
        finally {
            Logger.log("Loaded Tables:");
            this.logsFlusher.dumpList(this.loadedTables);
            Logger.log("Loaded Queries:");
            this.logsFlusher.dumpList(this.loadedQueries);
            Logger.log("Loaded Indexes:");
            this.logsFlusher.dumpList(this.loadedIndexes, true);
            this.conn.close();
        }
    }

    public void synchronisationTriggers(String tableName, boolean hasAutoNumberColumn, boolean hasAppendOnly) throws SQLException {
        this.triggersGenerator.synchronisationTriggers(tableName, hasAutoNumberColumn, hasAppendOnly);
    }

    private boolean tryDefault(Object defaulT) throws SQLException {
        Statement st = null;
        try {
            st = this.conn.createStatement();
            st.executeQuery("SELECT " + defaulT + " FROM   INFORMATION_SCHEMA.SYSTEM_TABLES  where 2=1");
            return true;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public void setSysSchema(boolean sysSchema) {
        this.sysSchema = sysSchema;
    }

    private final class FunctionsLoader {
        private HashSet<String> functionsDefinition = new HashSet();

        private FunctionsLoader() {
        }

        private void addAggregates() {
            this.functionsDefinition.add(this.getAggregate("LONGVARCHAR", "last"));
            this.functionsDefinition.add(this.getAggregate("DECIMAL(100,10)", "last"));
            this.functionsDefinition.add(this.getAggregate("BOOLEAN", "last"));
            this.functionsDefinition.add(this.getAggregate("TIMESTAMP", "last"));
            this.functionsDefinition.add(this.getAggregate("LONGVARCHAR", "first"));
            this.functionsDefinition.add(this.getAggregate("DECIMAL(100,10)", "first"));
            this.functionsDefinition.add(this.getAggregate("BOOLEAN", "first"));
            this.functionsDefinition.add(this.getAggregate("TIMESTAMP", "first"));
        }

        private void addFunction(String functionName, String methodName, String returnType, String ... parTypes) {
            StringBuffer funDef = new StringBuffer();
            if (DBReference.is2xx()) {
                funDef.append("CREATE FUNCTION ").append(functionName).append("(");
                String comma = "";
                int i = 0;
                while (i < parTypes.length) {
                    funDef.append(comma).append("par").append(i).append(" ").append(parTypes[i]);
                    comma = ",";
                    ++i;
                }
                funDef.append(")");
                funDef.append(" RETURNS ");
                funDef.append(returnType);
                funDef.append("  LANGUAGE JAVA DETERMINISTIC NO SQL  EXTERNAL NAME 'CLASSPATH:");
                funDef.append(methodName).append("'");
            } else {
                funDef.append("CREATE ALIAS ").append(functionName).append(" FOR \"").append(methodName).append("\"");
            }
            this.functionsDefinition.add(funDef.toString());
        }

        private void addFunctions(Class<?> clazz) throws SQLException {
            Method[] mths = clazz.getDeclaredMethods();
            HashMap<String, String> tmap = TypesMap.getAccess2HsqlTypesMap();
            Method[] methodArray = mths;
            int n = mths.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation[] ants;
                Method mth = methodArray[n2];
                Annotation[] annotationArray = ants = mth.getAnnotations();
                int n3 = ants.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation ant = annotationArray[n4];
                    if (ant.annotationType().equals(FunctionType.class)) {
                        String returnType;
                        FunctionType ft = (FunctionType)ant;
                        String methodName = String.valueOf(clazz.getName()) + "." + mth.getName();
                        String functionName = ft.functionName();
                        if (functionName == null) {
                            functionName = methodName;
                        }
                        TypesMap.AccessType[] acts = ft.argumentTypes();
                        TypesMap.AccessType ret = ft.returnType();
                        String retTypeName = ret.name();
                        String string = returnType = tmap.containsKey(retTypeName) ? tmap.get(retTypeName) : retTypeName;
                        if (TypesMap.AccessType.TEXT.equals((Object)ret)) {
                            returnType = String.valueOf(returnType) + "(255)";
                        }
                        String[] args = new String[acts.length];
                        int i = 0;
                        while (i < args.length) {
                            String typeName = acts[i].name();
                            String string2 = args[i] = tmap.containsKey(typeName) ? tmap.get(typeName) : typeName;
                            if (TypesMap.AccessType.TEXT.equals((Object)acts[i])) {
                                int n5 = i;
                                args[n5] = String.valueOf(args[n5]) + "(255)";
                            }
                            ++i;
                        }
                        if (ft.namingConflict()) {
                            SQLConverter.addWAFunctionName(functionName);
                            functionName = String.valueOf(functionName) + "WA";
                        }
                        this.addFunction(functionName, methodName, returnType, args);
                    }
                    ++n4;
                }
                ++n2;
            }
            this.createFunctions();
        }

        private void createFunctions() throws SQLException {
            for (String functionDef : this.functionsDefinition) {
                LoadJet.this.execCreate(functionDef, true);
            }
            this.functionsDefinition.clear();
        }

        private String getAggregate(String type, String fun) {
            String createLast = "CREATE AGGREGATE FUNCTION " + fun + "(IN val " + type + ", IN flag BOOLEAN, INOUT register  " + type + ", INOUT counter INT) " + "  RETURNS  " + type + "  NO SQL  LANGUAGE JAVA " + "  EXTERNAL NAME 'CLASSPATH:net.ucanaccess.converters.FunctionsAggregate." + fun + "'";
            return createLast;
        }

        private void loadMappedFunctions() throws SQLException {
            this.addFunctions(Functions.class);
            this.addAggregates();
            this.createFunctions();
        }
    }

    private final class LogsFlusher {
        private LogsFlusher() {
        }

        private void dumpList(List<String> logs) {
            this.dumpList(logs, false);
        }

        private void dumpList(List<String> logs, boolean cr) {
            String comma = "";
            StringBuffer sb = new StringBuffer();
            String crs = cr ? System.getProperty("line.separator") : "";
            for (String log : logs) {
                sb.append(comma).append(log).append(crs);
                comma = ", ";
            }
            Logger.log(sb.toString());
            logs.clear();
        }
    }

    private final class TablesLoader {
        private static final int HSQL_FK_ALREADY_EXISTS = -5528;
        private static final int HSQL_UK_ALREADY_EXISTS = -5522;
        private static final String SYSTEM_SCHEMA = "SYS";
        private ArrayList<String> unresolvedTables = new ArrayList();
        private ArrayList<String> calculatedFieldsTriggers = new ArrayList();
        private LinkedList<String> loadingOrder = new LinkedList();
        private HashSet<Column> alreadyIndexed = new HashSet();

        private TablesLoader() {
        }

        private String commaSeparated(List<? extends Index.Column> columns) {
            String comma = "";
            StringBuffer sb = new StringBuffer(" (");
            for (Index.Column column : columns) {
                sb.append(comma).append(SQLConverter.escapeIdentifier(column.getColumn().getName()));
                comma = ",";
            }
            return sb.append(") ").toString();
        }

        private String schema(String name, boolean systemTable) {
            if (systemTable) {
                return "SYS." + name;
            }
            return name;
        }

        private DataType getReturnType(Column cl) throws IOException {
            if (cl.getProperties().get("Expression") == null || cl.getProperties().get("ResultType") == null) {
                return null;
            }
            byte pos = (Byte)cl.getProperties().get("ResultType").getValue();
            return DataType.fromByte((byte)pos);
        }

        private String getHsqldbColumnType(Column cl) throws IOException {
            String htype;
            DataType dtyp = cl.getType();
            DataType rtyp = this.getReturnType(cl);
            boolean calcType = false;
            if (rtyp != null) {
                dtyp = rtyp;
                calcType = true;
            }
            if (dtyp.equals((Object)DataType.TEXT)) {
                short ln = LoadJet.this.ff1997 ? cl.getLength() : cl.getLengthInUnits();
                htype = "VARCHAR(" + ln + ")";
            } else {
                htype = dtyp.equals((Object)DataType.NUMERIC) && (cl.getScale() > 0 || calcType) ? (calcType ? "NUMERIC(100 ,4)" : "NUMERIC(" + (cl.getPrecision() > 0 ? (int)cl.getPrecision() : 100) + "," + cl.getScale() + ")") : (dtyp.equals((Object)DataType.FLOAT) && calcType ? "NUMERIC(" + (cl.getPrecision() > 0 ? (int)cl.getPrecision() : 100) + "," + 4 + ")" : TypesMap.map2hsqldb(dtyp));
            }
            return htype;
        }

        private String getCalculatedFieldTrigger(String ntn, Column cl, boolean isCreate) throws IOException {
            DataType dt = this.getReturnType(cl);
            String fun = null;
            if (this.isNumeric(dt)) {
                fun = "formulaToNumeric";
            } else if (this.isBoolean(dt)) {
                fun = "formulaToBoolean";
            } else if (this.isDate(dt)) {
                fun = "formulaToDate";
            } else if (this.isTextual(dt)) {
                fun = "formulaToText";
            }
            String call = fun == null ? "%s" : String.valueOf(fun) + "(%s,'" + dt.name() + "')";
            String trg = isCreate ? "CREATE TRIGGER expr%d after insert ON " + ntn + " REFERENCING NEW  AS newrow  FOR EACH ROW " + " BEGIN  ATOMIC " + " SET newrow." + SQLConverter.escapeIdentifier(cl.getName()) + " = " + call + "; END " : "CREATE TRIGGER expr%d after update ON " + ntn + " REFERENCING NEW  AS newrow OLD AS OLDROW FOR EACH ROW " + " BEGIN  ATOMIC IF %s THEN " + " SET newrow." + SQLConverter.escapeIdentifier(cl.getName()) + " = " + call + "; ELSEIF newrow." + SQLConverter.escapeIdentifier(cl.getName()) + " <> oldrow." + SQLConverter.escapeIdentifier(cl.getName()) + " THEN SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = '" + Logger.getMessage(Logger.Messages.TRIGGER_UPDATE_CF_ERR.name()) + cl.getName() + "'" + ";  END IF ; END ";
            return trg;
        }

        private boolean isNumeric(DataType dt) {
            return this.typeGroup(dt, DataType.NUMERIC, DataType.MONEY, DataType.DOUBLE, DataType.FLOAT, DataType.LONG, DataType.INT, DataType.BYTE);
        }

        private boolean isDate(DataType dt) {
            return this.typeGroup(dt, DataType.SHORT_DATE_TIME);
        }

        private boolean isBoolean(DataType dt) {
            return this.typeGroup(dt, DataType.BOOLEAN);
        }

        private boolean isTextual(DataType dt) {
            return this.typeGroup(dt, DataType.MEMO, DataType.TEXT);
        }

        private boolean typeGroup(DataType dt, DataType ... gr) {
            DataType[] dataTypeArray = gr;
            int n = gr.length;
            int n2 = 0;
            while (n2 < n) {
                DataType el = dataTypeArray[n2];
                if (el.equals((Object)dt)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private void createSyncrTable(Table t, boolean systemTable) throws SQLException, IOException {
            String tn = t.getName();
            String ntn = this.schema(SQLConverter.escapeIdentifier(tn), systemTable);
            StringBuffer sbC = new StringBuffer("CREATE  CACHED TABLE ").append(ntn).append("(");
            List lc = t.getColumns();
            String comma = "";
            for (Column cl : lc) {
                String expr;
                if ("USER".equalsIgnoreCase(cl.getName())) {
                    Logger.logParametricWarning(Logger.Messages.USER_AS_COLUMNNAME, t.getName());
                }
                if ((expr = this.getExpression(cl)) != null) {
                    String tgrI = this.getCalculatedFieldTrigger(ntn, cl, true);
                    String tgrU = this.getCalculatedFieldTrigger(ntn, cl, false);
                    Object[] objectArray = new Object[2];
                    int n = namingCounter;
                    namingCounter = n + 1;
                    objectArray[0] = n;
                    objectArray[1] = SQLConverter.convertFormula(expr);
                    this.calculatedFieldsTriggers.add(String.format(tgrI, objectArray));
                    String uc = this.getUpdateConditions(cl);
                    if (uc.length() > 0) {
                        Object[] objectArray2 = new Object[3];
                        int n2 = namingCounter;
                        namingCounter = n2 + 1;
                        objectArray2[0] = n2;
                        objectArray2[1] = uc;
                        objectArray2[2] = SQLConverter.convertFormula(expr);
                        this.calculatedFieldsTriggers.add(String.format(tgrU, objectArray2));
                    }
                }
                String htype = this.getHsqldbColumnType(cl);
                sbC.append(comma).append(SQLConverter.escapeIdentifier(cl.getName())).append(" ").append(htype);
                PropertyMap pm = cl.getProperties();
                Object required = pm.getValue("Required");
                if (required != null && required instanceof Boolean && ((Boolean)required).booleanValue()) {
                    sbC.append(" NOT NULL ");
                }
                comma = ",";
            }
            sbC.append(")");
            LoadJet.this.execCreate(sbC.toString(), true);
        }

        private String getExpression(Column cl) throws IOException {
            PropertyMap map = cl.getProperties();
            PropertyMap.Property exprp = map.get("Expression");
            if (exprp != null) {
                Table tl = cl.getTable();
                String expr = SQLConverter.convertPowOperator((String)exprp.getValue());
                for (Column cl1 : tl.getColumns()) {
                    expr = expr.replaceAll("\\[(?i)(" + Pattern.quote(cl1.getName()) + ")\\]", "newrow.$0");
                }
                return expr;
            }
            return null;
        }

        private String getUpdateConditions(Column cl) throws IOException {
            Set<String> setu;
            PropertyMap map = cl.getProperties();
            PropertyMap.Property exprp = map.get("Expression");
            if (exprp != null && (setu = SQLConverter.getFormulaDependencies(exprp.getValue().toString())).size() > 0) {
                String or = "";
                StringBuffer cw = new StringBuffer();
                for (String dep : setu) {
                    cw.append(or).append("oldrow.").append(dep).append("<>").append("newrow.").append(dep);
                    or = " OR ";
                }
                return cw.toString();
            }
            return " FALSE ";
        }

        private void defaultValues(Table t) throws SQLException, IOException {
            String tn = t.getName();
            String ntn = SQLConverter.escapeIdentifier(tn);
            List lc = t.getColumns();
            ArrayList<String> arTrigger = new ArrayList<String>();
            for (Column cl : lc) {
                String guidExp;
                PropertyMap pm = cl.getProperties();
                String ncn = SQLConverter.escapeIdentifier(cl.getName());
                Object defaulT = pm.getValue("DefaultValue");
                if (defaulT == null) continue;
                String cdefaulT = SQLConverter.convertSQL(" " + defaulT.toString());
                if (cdefaulT.trim().startsWith("=")) {
                    cdefaulT = cdefaulT.trim().substring(1);
                }
                if (cl.getType().equals((Object)DataType.BOOLEAN) && ("=yes".equalsIgnoreCase(cdefaulT) || "yes".equalsIgnoreCase(cdefaulT))) {
                    cdefaulT = "true";
                }
                if (cl.getType().equals((Object)DataType.BOOLEAN) && ("=no".equalsIgnoreCase(cdefaulT) || "no".equalsIgnoreCase(cdefaulT))) {
                    cdefaulT = "false";
                }
                if (!(!cl.getType().equals((Object)DataType.MEMO) && !cl.getType().equals((Object)DataType.TEXT) || defaulT.toString().startsWith("\"") && defaulT.toString().endsWith("\""))) {
                    cdefaulT = "'" + cdefaulT.replaceAll("'", "''") + "'";
                }
                if ((guidExp = "GenGUID()").equals(defaulT)) continue;
                if (!LoadJet.this.tryDefault(cdefaulT)) {
                    Logger.logParametricWarning(Logger.Messages.UNKNOWN_EXPRESSION, "" + defaulT, cl.getName(), cl.getTable().getName());
                    continue;
                }
                if (cl.getType() == DataType.TEXT && defaulT.toString().startsWith("'") && defaulT.toString().endsWith("'") && defaulT.toString().length() > cl.getLengthInUnits()) {
                    Logger.logParametricWarning(Logger.Messages.DEFAULT_VALUES_DELIMETERS, "" + defaulT, cl.getName(), cl.getTable().getName(), "" + cl.getLengthInUnits());
                }
                StringBuilder stringBuilder = new StringBuilder("CREATE TRIGGER DEFAULT_TRIGGER");
                int n = namingCounter;
                namingCounter = n + 1;
                arTrigger.add(stringBuilder.append(n).append(" BEFORE INSERT ON ").append(ntn).append("  REFERENCING NEW ROW AS NEW FOR EACH ROW IF NEW.").append(ncn).append(" IS NULL THEN ").append("SET NEW.").append(ncn).append("= ").append(cdefaulT).append(" ; END IF").toString());
            }
            for (String trigger : arTrigger) {
                LoadJet.this.execCreate(trigger, true);
            }
        }

        private int countFKs() throws IOException {
            int i = 0;
            for (String tn : this.loadingOrder) {
                Table table = LoadJet.this.dbIO.getTable(tn);
                if (this.unresolvedTables.contains(tn)) continue;
                for (Index idxi : table.getIndexes()) {
                    IndexImpl idx = (IndexImpl)idxi;
                    if (!idx.isForeignKey() || idx.getReference().isPrimaryTable()) continue;
                    ++i;
                }
            }
            return i;
        }

        private boolean reorder() throws IOException, SQLException {
            int maxIteration = this.countFKs() + 1;
            int i = 0;
            while (i < maxIteration) {
                boolean change = false;
                ArrayList<String> loadingOrder0 = new ArrayList<String>();
                loadingOrder0.addAll(this.loadingOrder);
                for (String tn : loadingOrder0) {
                    Table table = LoadJet.this.dbIO.getTable(tn);
                    if (this.unresolvedTables.contains(tn)) continue;
                    for (Index idxi : table.getIndexes()) {
                        IndexImpl idx = (IndexImpl)idxi;
                        if (!idx.isForeignKey() || idx.getReference().isPrimaryTable() || this.tryReorder((Index)idx)) continue;
                        change = true;
                    }
                }
                if (!change) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean tryReorder(Index idxi) throws IOException {
            int irt;
            IndexImpl idx = (IndexImpl)idxi;
            String ctn = idx.getTable().getName();
            String rtn = idx.getReferencedIndex().getTable().getName();
            int ict = this.loadingOrder.indexOf(ctn);
            if (ict < (irt = this.loadingOrder.indexOf(rtn))) {
                this.loadingOrder.remove(ctn);
                this.loadingOrder.add(irt, ctn);
                return false;
            }
            return true;
        }

        private void loadForeignKey(Index idxi) throws IOException, SQLException {
            String ntn;
            IndexImpl idx = (IndexImpl)idxi;
            String ctn = idx.getTable().getName();
            String rtn = idx.getReferencedIndex().getTable().getName();
            List cls = idx.getColumns();
            if (cls.size() == 1) {
                this.alreadyIndexed.add((Column)((IndexData.ColumnDescriptor)cls.get(0)).getColumn());
            }
            if ((ntn = SQLConverter.escapeIdentifier(ctn)) == null) {
                return;
            }
            String nin = SQLConverter.escapeIdentifier(idx.getName());
            nin = (String.valueOf(ntn) + "_" + nin).replaceAll("\"", "").replaceAll("\\W", "_");
            String colsIdx = this.commaSeparated(cls);
            String colsIdxRef = this.commaSeparated(idx.getReferencedIndex().getColumns());
            StringBuffer ci = new StringBuffer("ALTER TABLE ").append(ntn);
            ci.append(" ADD CONSTRAINT ").append(nin);
            String nrt = SQLConverter.escapeIdentifier(rtn);
            if (nrt == null) {
                return;
            }
            ci.append(" FOREIGN KEY ").append(colsIdx).append(" REFERENCES ").append(nrt).append(colsIdxRef);
            if (idx.getReference().isCascadeDeletes()) {
                ci.append(" ON DELETE CASCADE ");
            }
            if (idx.getReference().isCascadeUpdates()) {
                ci.append(" ON UPDATE CASCADE ");
            }
            try {
                LoadJet.this.execCreate(ci.toString(), true);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -5528) {
                    Logger.log(e.getMessage());
                }
                throw e;
            }
            LoadJet.this.loadedIndexes.add("FK on " + ntn + " Columns:" + colsIdx + " References " + nrt + " Columns:" + colsIdxRef);
        }

        /*
         * Unable to fully structure code
         */
        private void loadIndex(Index idx) throws IOException, SQLException {
            block12: {
                ntn = SQLConverter.escapeIdentifier(idx.getTable().getName());
                if (ntn == null) {
                    return;
                }
                nin = SQLConverter.escapeIdentifier(idx.getName());
                nin = (String.valueOf(ntn) + "_" + nin).replaceAll("\"", "").replaceAll("\\W", "_");
                uk = idx.isUnique();
                pk = idx.isPrimaryKey();
                if (!uk && !pk && idx.getColumns().size() == 1 && this.alreadyIndexed.contains(cl = ((Index.Column)idx.getColumns().get(0)).getColumn())) {
                    return;
                }
                if (uk && idx.getColumns().size() == 1 && (dt = (cl = ((Index.Column)idx.getColumns().get(0)).getColumn()).getType()).equals((Object)DataType.COMPLEX_TYPE)) {
                    return;
                }
                ci = new StringBuffer("ALTER TABLE ").append(ntn);
                colsIdx = this.commaSeparated(idx.getColumns());
                if (pk) {
                    ci.append(" ADD PRIMARY KEY ").append(colsIdx);
                } else if (uk) {
                    ci.append(" ADD CONSTRAINT ").append(nin);
                    ci.append(" UNIQUE ").append(colsIdx);
                } else {
                    ci = new StringBuffer("CREATE INDEX ").append(nin).append(" ON ").append(ntn).append(colsIdx);
                }
                try {
                    LoadJet.access$0(LoadJet.this, ci.toString(), true);
                }
                catch (SQLException e) {
                    if (-5522 == e.getErrorCode()) {
                        return;
                    }
                    if (!idx.isUnique()) break block12;
                    ** for (cd : idx.getColumns())
                }
lbl-1000:
                // 1 sources

                {
                    if (!cd.getColumn().getType().equals((Object)DataType.COMPLEX_TYPE)) continue;
                    return;
                }
            }
            Logger.logWarning(e.getMessage());
            return;
            catch (Exception e) {
                Logger.logWarning(e.getMessage());
                return;
            }
            pre = pk != false ? "Primary Key " : (uk != false ? "Index Unique " : "Index");
            LoadJet.access$6(LoadJet.this).add(String.valueOf(pre) + " on " + ntn + " Columns:" + colsIdx);
        }

        private void createTable(Table t) throws SQLException, IOException {
            this.createTable(t, false);
        }

        private void createTable(Table t, boolean systemTable) throws SQLException, IOException {
            String ntn;
            String tn = t.getName();
            if (tn.indexOf(" ") > 0) {
                SQLConverter.addWhiteSpacedTableNames(tn);
            }
            if ((ntn = SQLConverter.escapeIdentifier(tn)) == null) {
                return;
            }
            this.createSyncrTable(t, systemTable);
        }

        private boolean hasAppendOnly(Table t) {
            for (Column c : t.getColumns()) {
                if (!c.isAppendOnly()) continue;
                return true;
            }
            return false;
        }

        private void loadTableData(Table t, boolean systemTable) throws IOException, SQLException {
            Statement ps = null;
            try {
                int i = 0;
                for (Row row : t) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    if (row == null) continue;
                    if (ps == null) {
                        ps = this.sqlInsert(t, (Map<String, Object>)row, systemTable);
                    }
                    Collection ce = row.values();
                    int j = 0;
                    for (Object obj : ce) {
                        values.add(this.value(obj));
                        ++j;
                    }
                    LoadJet.this.execInsert((PreparedStatement)ps, values);
                    if (i > 0 && i % 1000 == 0 || i == t.getRowCount() - 1) {
                        LoadJet.this.conn.commit();
                    }
                    ++i;
                }
                if (i != t.getRowCount()) {
                    Logger.logParametricWarning(Logger.Messages.ROW_COUNT, t.getName(), String.valueOf(t.getRowCount()), String.valueOf(i));
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }

        private void loadTableFKs(String tableName) throws IOException, SQLException {
            Table table = LoadJet.this.dbIO.getTable(tableName);
            for (Index idxi : table.getIndexes()) {
                IndexImpl idx = (IndexImpl)idxi;
                if (!idx.isForeignKey() || idx.getReference().isPrimaryTable()) continue;
                this.loadForeignKey((Index)idx);
            }
        }

        private void createCalculatedFieldsTriggers() {
            for (String trigger : this.calculatedFieldsTriggers) {
                try {
                    LoadJet.this.execCreate(trigger, false);
                }
                catch (SQLException e) {
                    Logger.logWarning(e.getMessage());
                    break;
                }
            }
        }

        private void loadTableIndexesUK(String tableName) throws IOException, SQLException {
            Table table = LoadJet.this.dbIO.getTable(tableName);
            for (Index idx : table.getIndexes()) {
                if (idx.isForeignKey() || !idx.isPrimaryKey() && !idx.isUnique()) continue;
                this.loadIndex(idx);
            }
        }

        private void loadTableIndexesNotUK(String tableName) throws IOException, SQLException {
            Table table = LoadJet.this.dbIO.getTable(tableName);
            for (Index idx : table.getIndexes()) {
                if (idx.isForeignKey() || idx.isPrimaryKey() || idx.isUnique()) continue;
                this.loadIndex(idx);
            }
        }

        private void createTables() throws SQLException, IOException {
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                Table t = null;
                try {
                    t = LoadJet.this.dbIO.getTable(tn);
                }
                catch (Exception e) {
                    Logger.logWarning(e.getMessage());
                    this.unresolvedTables.add(tn);
                }
                if (t == null) continue;
                this.createTable(t);
                this.loadingOrder.add(t.getName());
            }
        }

        private void createIndexesUK() throws SQLException, IOException {
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                if (this.unresolvedTables.contains(tn)) continue;
                this.loadTableIndexesUK(tn);
                LoadJet.this.conn.commit();
            }
        }

        private void createIndexesNotUK() throws SQLException, IOException {
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                if (this.unresolvedTables.contains(tn)) continue;
                this.loadTableIndexesNotUK(tn);
                LoadJet.this.conn.commit();
            }
        }

        private void createFKs() throws SQLException, IOException {
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                if (this.unresolvedTables.contains(tn)) continue;
                this.loadTableFKs(tn);
                LoadJet.this.conn.commit();
            }
        }

        private void loadTablesData() throws SQLException, IOException {
            for (String tn : this.loadingOrder) {
                if (this.unresolvedTables.contains(tn)) continue;
                Table t = LoadJet.this.dbIO.getTable(tn);
                this.loadTableData(t, false);
                LoadJet.this.conn.commit();
            }
        }

        private void createTriggers() throws IOException, SQLException {
            this.createCalculatedFieldsTriggers();
            for (String tn : this.loadingOrder) {
                if (this.unresolvedTables.contains(tn)) continue;
                Table t = LoadJet.this.dbIO.getTable(tn);
                this.createSyncrTriggers(t);
            }
        }

        private void createSystemTables() throws SQLException, IOException {
            if (LoadJet.this.sysSchema) {
                this.createSystemSchema();
                for (String tn : LoadJet.this.dbIO.getSystemTableNames()) {
                    Table t = null;
                    try {
                        t = LoadJet.this.dbIO.getSystemTable(tn);
                        if (t == null) continue;
                        this.createTable(t, true);
                        this.loadTableData(t, true);
                        LoadJet.this.execCreate("SET TABLE " + this.schema(SQLConverter.escapeIdentifier(t.getName()), true) + " READONLY TRUE ", false);
                        LoadJet.this.execCreate("GRANT SELECT  ON " + this.schema(SQLConverter.escapeIdentifier(t.getName()), true) + " TO PUBLIC ", false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private void loadTables() throws SQLException, IOException {
            this.createTables();
            this.createIndexesUK();
            boolean reorder = this.reorder();
            if (reorder) {
                this.createFKs();
            }
            this.createIndexesNotUK();
            this.loadTablesData();
            this.createTriggers();
            if (!reorder) {
                this.createFKs();
            }
            this.createSystemTables();
        }

        private void createSystemSchema() throws SQLException {
            LoadJet.this.execCreate("CREATE SCHEMA SYS AUTHORIZATION DBA", false);
        }

        private void createSyncrTriggers(Table t) throws SQLException, IOException {
            this.defaultValues(t);
            String ntn = SQLConverter.escapeIdentifier(t.getName());
            LoadJet.this.triggersGenerator.synchronisationTriggers(ntn, LoadJet.hasAutoNumberColumn(t), this.hasAppendOnly(t));
            LoadJet.this.loadedTables.add(ntn);
        }

        private PreparedStatement sqlInsert(Table t, Map<String, Object> row, boolean systemTable) throws IOException, SQLException {
            String tn = t.getName();
            String ntn = this.schema(SQLConverter.escapeIdentifier(tn), systemTable);
            String comma = "";
            StringBuffer sbI = new StringBuffer(" INSERT INTO ").append(ntn).append(" (");
            StringBuffer sbE = new StringBuffer(" VALUES( ");
            Set<String> se = row.keySet();
            comma = "";
            for (String cn : se) {
                sbI.append(comma).append(SQLConverter.escapeIdentifier(cn));
                sbE.append(comma).append(" ? ");
                comma = ",";
            }
            sbI.append(") ");
            sbE.append(")");
            sbI.append(sbE);
            return LoadJet.this.conn.prepareStatement(sbI.toString());
        }

        private Object value(Object value) throws SQLException {
            if (value == null) {
                return null;
            }
            if (value instanceof Float) {
                BigDecimal bd = new BigDecimal(value.toString());
                return bd;
            }
            if (value instanceof Date && !(value instanceof Timestamp)) {
                Timestamp ts = new Timestamp(((Date)value).getTime());
                return ts;
            }
            if (value instanceof ComplexValueForeignKey) {
                try {
                    return ComplexBase.convert((ComplexValueForeignKey)value);
                }
                catch (IOException e) {
                    throw new UcanaccessSQLException(e);
                }
            }
            if (value instanceof Byte) {
                return SQLConverter.asUnsigned((Byte)value);
            }
            return value;
        }
    }

    private final class TriggersLoader {
        private static final String DEFAULT_TRIGGERS_PACKAGE = "net.ucanaccess.triggers";

        private TriggersLoader() {
        }

        private void loadTrigger(String tableName, String namePrefix, String when, String className) throws SQLException {
            String q0 = DBReference.is2xx() ? "" : " QUEUE 0  ";
            String triggerName = String.valueOf(namePrefix) + "_" + tableName.replaceAll("\"", "").replaceAll(" ", "_");
            LoadJet.this.execCreate("CREATE TRIGGER " + triggerName + "  " + when + " ON " + tableName + "   FOR EACH ROW\t" + q0 + "   CALL \"" + className + "\" ", true);
        }

        private void loadTriggerNP(String tableName, String namePrefix, String when, String className) throws SQLException {
            this.loadTrigger(tableName, namePrefix, when, "net.ucanaccess.triggers." + className);
        }

        private void synchronisationTriggers(String tableName, boolean hasAutoNumberColumn, boolean hasAutoAppendOnly) throws SQLException {
            this.loadTriggerNP(tableName, "genericInsert", "AFTER INSERT", "TriggerInsert");
            this.loadTriggerNP(tableName, "genericUpdate", "AFTER UPDATE", "TriggerUpdate");
            this.loadTriggerNP(tableName, "genericDelete", "AFTER DELETE", "TriggerDelete");
            if (hasAutoAppendOnly) {
                this.loadTriggerNP(tableName, "appendOnly", "BEFORE INSERT", "TriggerAppendOnly");
                this.loadTriggerNP(tableName, "appendOnly_upd", "BEFORE UPDATE", "TriggerAppendOnly");
            }
            if (hasAutoNumberColumn) {
                this.loadTriggerNP(tableName, "autonumber", "BEFORE INSERT", "TriggerAutoNumber");
                this.loadTriggerNP(tableName, "autonumber_validate", "BEFORE UPDATE", "TriggerAutoNumber");
            }
        }
    }

    private final class ViewsLoader {
        private HashMap<String, String> notLoaded = new HashMap();
        private static final int OBJECT_ALREADY_EXISTS = -5504;

        private ViewsLoader() {
        }

        private boolean loadView(Query q) throws SQLException {
            return this.loadView(q, null);
        }

        private boolean loadView(Query q, String queryWKT) throws SQLException {
            String qnn = SQLConverter.basicEscapingIdentifier(q.getName());
            if (qnn == null) {
                return false;
            }
            if (qnn.indexOf(" ") > 0) {
                SQLConverter.addWhiteSpacedTableNames(q.getName());
            }
            String escqn = qnn.indexOf(32) > 0 ? "[" + qnn + "]" : qnn;
            String querySQL = queryWKT == null ? q.toSQLString() : queryWKT;
            Pivot pivot = null;
            if (q.getType().equals((Object)Query.Type.CROSS_TAB) && (!(pivot = new Pivot(LoadJet.this.conn)).parsePivot(querySQL) || (querySQL = pivot.toSQL()) == null)) {
                this.notLoaded.put(q.getName(), "cannot load this query");
                return false;
            }
            querySQL = new DFunction(LoadJet.this.conn, querySQL).toSQL();
            StringBuffer sb = new StringBuffer("CREATE VIEW ").append(escqn).append(" AS ").append(querySQL);
            String v = null;
            try {
                v = SQLConverter.convertSQL(sb.toString(), true);
                if (v.trim().endsWith(";")) {
                    v = v.trim().substring(0, v.length() - 1);
                }
                LoadJet.this.execCreate(v, false);
                LoadJet.this.loadedQueries.add(qnn);
                this.notLoaded.remove(qnn);
                if (pivot != null) {
                    pivot.registerPivot(qnn);
                }
                return true;
            }
            catch (Exception e) {
                if (e instanceof SQLSyntaxErrorException && queryWKT == null && ((SQLSyntaxErrorException)e).getErrorCode() == -5504) {
                    return this.loadView(q, this.solveAmbiguous(querySQL));
                }
                String cause = UcanaccessSQLException.explaneCause(e);
                this.notLoaded.put(q.getName(), ": " + cause);
                if (!LoadJet.this.err) {
                    Logger.log("Error occured while loading:" + q.getName());
                    Logger.log("Converted view was :" + v);
                    Logger.log("Error message was :" + e.getMessage());
                    LoadJet.this.err = true;
                }
                return false;
            }
        }

        private String solveAmbiguous(String sql) {
            try {
                sql = sql.replaceAll("[\n\r]", " ");
                Pattern pt = Pattern.compile("(.*)[\n\r\\s]*(?i)SELECT([\n\r\\s].*[\n\r\\s])(?i)FROM([\n\r\\s])(.*)");
                Matcher mtc = pt.matcher(sql);
                if (mtc.find()) {
                    String select = mtc.group(2);
                    String pre = mtc.group(1) == null ? "" : mtc.group(1);
                    String[] splitted = select.split(",", -1);
                    StringBuffer sb = new StringBuffer(String.valueOf(pre) + " select ");
                    LinkedList<String> lkl = new LinkedList<String>();
                    String[] stringArray = splitted;
                    int n = splitted.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        int j = s.lastIndexOf(".");
                        Pattern aliasPt = Pattern.compile("[\\s\n\r]+(?i)AS[\\s\n\r]+");
                        boolean alias = aliasPt.matcher(s).find();
                        if (j < 0 || alias) {
                            lkl.add(s);
                        } else {
                            String k = s.substring(j + 1);
                            if (lkl.contains(k)) {
                                int idx = lkl.indexOf(k);
                                String old = (String)lkl.get(lkl.indexOf(k));
                                lkl.remove(old);
                                lkl.add(idx, String.valueOf(splitted[idx]) + " AS [" + splitted[idx].trim() + "]");
                                lkl.add(String.valueOf(s) + " AS [" + s.trim() + "]");
                            } else {
                                lkl.add(k);
                            }
                        }
                        ++n2;
                    }
                    String comma = "";
                    for (String s : lkl) {
                        sb.append(comma).append(s);
                        comma = ",";
                    }
                    sb.append(" FROM ").append(mtc.group(4));
                    return sb.toString();
                }
                return sql;
            }
            catch (Exception e) {
                return sql;
            }
        }

        private void loadViews() throws SQLException, IOException {
            List lq = null;
            try {
                lq = LoadJet.this.dbIO.getQueries();
                Iterator it = lq.iterator();
                while (it.hasNext()) {
                    Query q = (Query)it.next();
                    if (q.getType().equals((Object)Query.Type.SELECT) || q.getType().equals((Object)Query.Type.UNION) || q.getType().equals((Object)Query.Type.CROSS_TAB)) continue;
                    it.remove();
                }
                this.queryPorting(lq);
            }
            catch (Exception e) {
                this.notLoaded.put("", "");
            }
        }

        private void queryPorting(List<Query> lq) throws SQLException {
            ArrayList<String> arn = new ArrayList<String>();
            for (Query q : lq) {
                arn.add(q.getName().toLowerCase());
            }
            boolean heavy = false;
            while (lq.size() > 0) {
                ArrayList<Query> arq = new ArrayList<Query>();
                for (Query q : lq) {
                    String qtxt = null;
                    boolean qryGot = true;
                    try {
                        qtxt = q.toSQLString().toLowerCase();
                    }
                    catch (Exception ignore) {
                        qryGot = false;
                    }
                    boolean foundDep = false;
                    if (qryGot && !heavy) {
                        for (String name : arn) {
                            if (qtxt.indexOf(name) == -1) continue;
                            foundDep = true;
                            break;
                        }
                    }
                    if (!qryGot || foundDep || !this.loadView(q)) continue;
                    arq.add(q);
                    arn.remove(q.getName());
                }
                if (arq.size() == 0) {
                    if (heavy) break;
                    heavy = true;
                }
                lq.removeAll(arq);
            }
        }
    }
}

