/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.util.LinkResolver;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.ucanaccess.converters.LoadJet;
import net.ucanaccess.jdbc.DBReferenceSingleton;
import net.ucanaccess.jdbc.JackcessOpenerInterface;
import net.ucanaccess.jdbc.OnReloadReferenceListener;
import net.ucanaccess.jdbc.Session;
import net.ucanaccess.jdbc.UcanaccessDriver;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.util.Logger;

public class DBReference {
    private static final String CIPHER_SPEC = "AES";
    private static ArrayList<OnReloadReferenceListener> onReloadListeners = new ArrayList();
    private static String version;
    private File dbFile;
    private Database dbIO;
    private FileLock fileLock = null;
    private String id = this.id();
    private boolean inMemory = true;
    private long lastModified;
    private boolean lockMdb = false;
    private MemoryTimer memoryTimer = new MemoryTimer();
    private boolean readOnly;
    private boolean readOnlyFileFormat;
    private boolean showSchema;
    private File tempHsql;
    private File toKeepHsql;
    private boolean singleConnection;
    private boolean encryptHSQLDB;
    private String encryptionKey;
    private String pwd;
    private JackcessOpenerInterface jko;
    private Map<String, String> externalResourcesMapping;
    private boolean firstConnection = true;
    private Database.FileFormat dbFormat;
    private boolean columnOrderDisplay;

    public DBReference(File fl, Database.FileFormat ff, JackcessOpenerInterface jko, final String pwd) throws IOException, SQLException {
        this.dbFile = fl;
        this.pwd = pwd;
        this.jko = jko;
        this.updateLastModified();
        Logger.turnOffJackcessLog();
        if (!fl.exists() && ff != null) {
            this.dbIO = DatabaseBuilder.create((Database.FileFormat)ff, (File)fl);
        } else {
            this.dbIO = jko.open(fl, pwd);
            try {
                this.readOnlyFileFormat = this.dbIO.getFileFormat().equals((Object)Database.FileFormat.V1997);
                this.dbFormat = this.dbIO.getFileFormat();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dbIO.setLinkResolver(new LinkResolver(){

                public Database resolveLinkedDatabase(Database linkerDb, String linkeeFileName) throws IOException {
                    File linkeeFile = new File(linkeeFileName);
                    Map emr = DBReference.this.externalResourcesMapping;
                    if (!linkeeFile.exists() && emr != null && emr.containsKey(linkeeFile.getAbsolutePath().toLowerCase())) {
                        linkeeFile = new File((String)emr.get(linkeeFile.getAbsolutePath().toLowerCase()));
                    }
                    if (!linkeeFile.exists()) {
                        Logger.logWarning("External file " + linkeeFile.getAbsolutePath() + " does not exist");
                    }
                    Database ldb = DBReference.this.open(linkeeFile, pwd);
                    return ldb;
                }
            });
            this.dbIO.setEnforceForeignKeys(Boolean.valueOf(false));
        }
    }

    public Database open(File dbfl, String pwd) throws IOException {
        Logger.turnOffJackcessLog();
        Database ret = this.jko.open(dbfl, pwd);
        if (this.columnOrderDisplay) {
            ret.setColumnOrder(Table.ColumnOrder.DISPLAY);
        }
        return ret;
    }

    boolean loadedFromKeptMirror(Session session) throws UcanaccessSQLException {
        if (this.toKeepHsql != null && this.toKeepHsql.exists()) {
            if (this.getLastUpdateHSQLDB() >= this.dbFile.lastModified()) {
                return true;
            }
            try {
                this.closeHSQLDB(session);
            }
            catch (Exception e) {
                throw new UcanaccessSQLException(e);
            }
            return false;
        }
        return false;
    }

    public static boolean addOnReloadRefListener(OnReloadReferenceListener action) {
        return onReloadListeners.add(action);
    }

    public static String getVersion() {
        return version;
    }

    public static boolean is2xx() {
        return version.startsWith("2.");
    }

    Connection checkLastModified(Connection conn, Session session) throws Exception {
        int i = 0;
        while (i < Thread.activeCount()) {
            if (this.lastModified >= this.dbFile.lastModified()) {
                return conn;
            }
            Thread.sleep(10L);
            ++i;
        }
        this.updateLastModified();
        this.closeHSQLDB(session);
        System.gc();
        this.dbIO.flush();
        this.dbIO.close();
        this.dbIO = this.open(this.dbFile, this.pwd);
        this.id = this.id();
        new LoadJet(this.getHSQLDBConnection(session), this.dbIO).loadDB();
        this.firstConnection = true;
        return this.getHSQLDBConnection(session);
    }

    private File[] getHSQLDBFiles() {
        if (this.toKeepHsql == null) {
            return new File[0];
        }
        File folder = this.toKeepHsql.getParentFile();
        String name = this.toKeepHsql.getName();
        return new File[]{new File(folder, String.valueOf(name) + ".data"), new File(folder, String.valueOf(name) + ".script"), new File(folder, String.valueOf(name) + ".properties"), new File(folder, String.valueOf(name) + ".log"), new File(folder, String.valueOf(name) + ".lck"), new File(folder, String.valueOf(name) + ".lobs")};
    }

    private long getLastUpdateHSQLDB() {
        long lu = 0L;
        File[] fileArray = this.getHSQLDBFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File hsqlF = fileArray[n2];
            if (hsqlF.exists() && hsqlF.lastModified() > lu) {
                lu = hsqlF.lastModified();
            }
            ++n2;
        }
        if (this.toKeepHsql != null && this.toKeepHsql.exists() && this.toKeepHsql.lastModified() > lu) {
            lu = this.toKeepHsql.lastModified();
        }
        return lu;
    }

    private void closeHSQLDB(Session session) throws Exception {
        this.finalizeHSQLDB(session);
        if (!this.inMemory) {
            if (this.toKeepHsql == null) {
                File folder = this.dbFile.getParentFile();
                File hbase = new File(folder, "Ucanaccess_" + this);
                File[] fileArray = hbase.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File hsqlF = fileArray[n2];
                    hsqlF.delete();
                    ++n2;
                }
                hbase.delete();
            } else if (!this.singleConnection) {
                this.toKeepHsql.delete();
                this.toKeepHsql.createNewFile();
                File[] fileArray = this.getHSQLDBFiles();
                int n = fileArray.length;
                int n3 = 0;
                while (n3 < n) {
                    File hsqlf = fileArray[n3];
                    if (hsqlf.exists()) {
                        hsqlf.delete();
                    }
                    ++n3;
                }
            }
        }
    }

    public void decrementActiveConnection(Session session) {
        this.memoryTimer.decrementActiveConnection(session);
    }

    private void finalizeHSQLDB(Session session) throws Exception {
        this.releaseLock();
        Connection conn = null;
        Statement st = null;
        try {
            try {
                conn = this.getHSQLDBConnection(session);
                st = conn.createStatement();
                st.execute("SHUTDOWN");
            }
            catch (Exception exception) {
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    File getDbFile() {
        return this.dbFile;
    }

    public Database getDbIO() {
        return this.dbIO;
    }

    private void setIgnoreCase(Connection conn) throws SQLException {
        Statement st = null;
        try {
            try {
                st = conn.createStatement();
                st.execute("set ignorecase true");
            }
            catch (Exception exception) {
                if (st != null) {
                    st.close();
                }
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    private void setSintax(Connection conn) throws SQLException {
        Statement st = null;
        try {
            try {
                st = conn.createStatement();
                st.execute("SET DATABASE SQL SYNTAX ora TRUE");
            }
            catch (Exception exception) {
                if (st != null) {
                    st.close();
                }
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public Connection getHSQLDBConnection(Session session) throws SQLException {
        Connection conn = DriverManager.getConnection(this.getHsqlUrl(session), session.getUser() == null ? "Admin" : session.getUser(), session.getPassword());
        if (version == null) {
            version = conn.getMetaData().getDriverVersion();
        }
        if (session.isIgnoreCase()) {
            this.setIgnoreCase(conn);
        }
        if (this.firstConnection) {
            this.setSintax(conn);
            this.firstConnection = false;
        }
        conn.setAutoCommit(false);
        return conn;
    }

    String getId() {
        return this.id;
    }

    private String key(String pwd) throws SQLException {
        Connection conn = null;
        try {
            if (this.encryptionKey == null) {
                String url = "jdbc:hsqldb:mem:" + this.id + "_tmp";
                conn = DriverManager.getConnection(url);
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("CALL  CRYPT_KEY('AES', null) ");
                rs.next();
                this.encryptionKey = rs.getString(1);
            }
            String string = this.encryptionKey;
            return string;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    private String getHsqlUrl(final Session session) throws SQLException {
        try {
            if (this.lockMdb && this.fileLock == null) {
                this.lockMdbFile();
            }
            String enc = "";
            String log = "";
            if (this.encryptHSQLDB) {
                enc = ";crypt_key=" + this.key(CIPHER_SPEC) + ";crypt_type=aes;crypt_lobs=true";
            }
            if (!this.inMemory && this.toKeepHsql == null) {
                log = ";hsqldb.log_data=FALSE";
            }
            if (!this.inMemory && this.tempHsql == null) {
                if (this.toKeepHsql != null) {
                    if (!this.toKeepHsql.exists()) {
                        this.toKeepHsql.createNewFile();
                    }
                    this.tempHsql = this.toKeepHsql;
                } else {
                    File folder = this.dbFile.getParentFile();
                    File hbase = new File(folder, "Ucanaccess_" + this.toString());
                    hbase.mkdir();
                    this.tempHsql = new File(hbase, this.id);
                    this.tempHsql.createNewFile();
                }
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (DBReference.this.toKeepHsql == null) {
                                DBReference.this.closeHSQLDB(session);
                            } else {
                                DBReference.this.finalizeHSQLDB(session);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }));
            }
            return "jdbc:hsqldb:" + (this.inMemory ? "mem:" + this.id : this.tempHsql.getAbsolutePath()) + enc + log;
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    public int getInactivityTimeout() {
        return this.memoryTimer.getInactivityTimeout();
    }

    private String id() {
        return UUID.randomUUID() + this.toString();
    }

    public void incrementActiveConnection() {
        this.memoryTimer.incrementActiveConnection();
    }

    public boolean isReadOnly() throws UcanaccessSQLException {
        if (this.readOnly) {
            this.lockMdbFile();
        }
        return this.readOnlyFileFormat || this.readOnly;
    }

    boolean isShowSchema() {
        return this.showSchema;
    }

    private void lockMdbFile() throws UcanaccessSQLException {
        try {
            File folder = this.dbFile.getParentFile();
            String fileName = this.dbFile.getName();
            int suffixStart = fileName.lastIndexOf(46);
            if (suffixStart < 0) {
                suffixStart = fileName.length();
            }
            String suffix = this.dbFormat != null && (Database.FileFormat.V2010.equals((Object)this.dbFormat) || Database.FileFormat.V2007.equals((Object)this.dbFormat)) ? ".laccdb" : ".ldb";
            File flLock = new File(folder, String.valueOf(fileName.substring(0, suffixStart)) + suffix);
            flLock.createNewFile();
            RandomAccessFile raf = new RandomAccessFile(flLock, "rw");
            FileLock tryLock = raf.getChannel().tryLock();
            if (tryLock == null) {
                this.readOnly = true;
            } else {
                this.fileLock = tryLock;
                this.readOnly = false;
            }
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    public void releaseLock() throws IOException {
        if (this.fileLock != null) {
            this.fileLock.release();
        }
    }

    public void reloadDbIO() throws IOException {
        this.dbIO.close();
        for (OnReloadReferenceListener listener : onReloadListeners) {
            listener.onReload();
        }
        this.dbIO = this.open(this.dbFile, this.pwd);
    }

    public void setInactivityTimeout(int inactivityTimeout) {
        this.memoryTimer.setInactivityTimeout(inactivityTimeout);
    }

    public void setInMemory(boolean inMemory) {
        this.inMemory = inMemory;
    }

    public void setLockMdb(boolean lockMdb) {
        this.lockMdb = lockMdb;
    }

    public void setShowSchema(boolean showSchema) {
        this.showSchema = showSchema;
    }

    void setTempHsql(File tempHsql) {
        this.tempHsql = tempHsql;
    }

    void shutdown(Session session) throws Exception {
        DBReferenceSingleton.getInstance().remove(this.dbFile.getAbsolutePath());
        this.dbIO.flush();
        this.dbIO.close();
        this.closeHSQLDB(session);
    }

    public void updateLastModified() {
        this.lastModified = this.dbFile.lastModified();
    }

    public void setSingleConnection(boolean singleConnection) {
        this.singleConnection = singleConnection;
    }

    public void setEncryptHSQLDB(boolean encryptHSQLDB) {
        this.encryptHSQLDB = encryptHSQLDB;
    }

    public void setExternalResourcesMapping(Map<String, String> externalResourcesMapping) {
        this.externalResourcesMapping = externalResourcesMapping;
    }

    public File getToKeepHsql() {
        return this.toKeepHsql;
    }

    public void setToKeepHsql(File toKeepHsql) {
        this.toKeepHsql = toKeepHsql;
    }

    public boolean isEncryptHSQLDB() {
        return this.encryptHSQLDB;
    }

    public void setColumnOrderDisplay() {
        this.columnOrderDisplay = true;
        if (this.dbIO != null) {
            this.dbIO.setColumnOrder(Table.ColumnOrder.DISPLAY);
        }
    }

    private class MemoryTimer {
        private static final int INACTIVITY_TIMEOUT_DEFAULT = 120000;
        private int activeConnection;
        private int inactivityTimeout = 120000;
        private long lastConnectionTime;
        private Timer timer = new Timer(true);

        private MemoryTimer() {
        }

        private synchronized void decrementActiveConnection(final Session session) {
            --this.activeConnection;
            if (DBReference.this.singleConnection && this.activeConnection == 0) {
                try {
                    DBReference.this.shutdown(session);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            if (DBReference.this.inMemory && this.inactivityTimeout > 0 && this.activeConnection == 0) {
                this.timer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
                            synchronized (UcanaccessDriver.class) {
                                if (System.currentTimeMillis() - MemoryTimer.this.getLastConnectionTime() >= (long)MemoryTimer.this.inactivityTimeout && MemoryTimer.this.getActiveConnection() == 0) {
                                    DBReference.this.shutdown(session);
                                    System.gc();
                                }
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        {
                            return;
                        }
                    }
                }, this.inactivityTimeout);
            }
        }

        private synchronized int getActiveConnection() {
            return this.activeConnection;
        }

        private int getInactivityTimeout() {
            return this.inactivityTimeout;
        }

        private synchronized long getLastConnectionTime() {
            return this.lastConnectionTime;
        }

        private synchronized void incrementActiveConnection() {
            ++this.activeConnection;
            if (DBReference.this.inMemory && this.inactivityTimeout > 0) {
                this.lastConnectionTime = System.currentTimeMillis();
            }
        }

        private void setInactivityTimeout(int inactivityTimeout) {
            this.inactivityTimeout = inactivityTimeout;
        }
    }
}

