/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.FeatureNotSupportedException;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessResultSet;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import org.hsqldb.jdbc.JDBCDatabaseMetaData;

public class UcanaccessDatabaseMetadata
implements DatabaseMetaData {
    private UcanaccessConnection connection;
    private DatabaseMetaData wrapped;

    public UcanaccessDatabaseMetadata(DatabaseMetaData wrapped, UcanaccessConnection connection) {
        this.wrapped = wrapped;
        this.connection = connection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            return this.wrapped.allProceduresAreCallable();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            return this.wrapped.allTablesAreSelectable();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            return this.wrapped.autoCommitFailureClosesAllResultSets();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            return this.wrapped.dataDefinitionCausesTransactionCommit();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            return this.wrapped.dataDefinitionIgnoredInTransactions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        try {
            return this.wrapped.deletesAreDetected(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            return this.wrapped.doesMaxRowSizeIncludeBlobs();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            return this.wrapped.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            table = SQLConverter.escapeIdentifier(table).toUpperCase();
            return this.wrapped.getBestRowIdentifier(catalog, schema, table, scope, nullable);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (this.connection.isShowSchema()) {
            try {
                return this.wrapped.getCatalogs();
            }
            catch (SQLException e) {
                throw new UcanaccessSQLException(e);
            }
        }
        throw new FeatureNotSupportedException();
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            return this.wrapped.getCatalogSeparator();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            return this.wrapped.getCatalogTerm();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        try {
            return this.wrapped.getClientInfoProperties();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            columnNamePattern = this.normalizeName(columnNamePattern);
            table = this.normalizeName(table);
            return new MetadataResultSet(this.wrapped.getColumnPrivileges("PUBLIC", "PUBLIC", table, columnNamePattern));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            columnNamePattern = this.normalizeName(columnNamePattern);
            tableNamePattern = this.normalizeName(tableNamePattern);
            return new MetadataResultSet(this.wrapped.getColumns("PUBLIC", "PUBLIC", tableNamePattern, columnNamePattern));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            parentTable = this.normalizeName(parentTable);
            foreignTable = this.normalizeName(foreignTable);
            return this.wrapped.getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            return this.wrapped.getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            return this.wrapped.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Ucanaccess for access db(Jet) using hasqldb";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            return this.connection.getDbIO().getFileFormat().toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            return this.wrapped.getDefaultTransactionIsolation();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getDriverMajorVersion() {
        return 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Ucanaccess";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        try {
            String version = this.getClass().getPackage().getImplementationVersion();
            return version == null ? "2.x.x" : version;
        }
        catch (Exception e) {
            return "2.x.x";
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            table = this.normalizeName(table);
            if (this.connection.isShowSchema()) {
                return this.wrapped.getExportedKeys("PUBLIC", "PUBLIC", table);
            }
            return new MetadataResultSet(this.wrapped.getExportedKeys("PUBLIC", "PUBLIC", table));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            return this.wrapped.getExtraNameCharacters();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        try {
            columnNamePattern = this.normalizeName(columnNamePattern);
            return this.wrapped.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            return this.wrapped.getFunctions(catalog, schemaPattern, functionNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "`";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            table = this.normalizeName(table);
            if (this.connection.isShowSchema()) {
                return this.wrapped.getImportedKeys("PUBLIC", "PUBLIC", table);
            }
            return new MetadataResultSet(this.wrapped.getImportedKeys("PUBLIC", "PUBLIC", table));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            table = this.normalizeName(table);
            return new MetadataResultSet(this.wrapped.getIndexInfo("PUBLIC", "PUBLIC", table, unique, approximate));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            return this.wrapped.getJDBCMajorVersion();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            return this.wrapped.getJDBCMinorVersion();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            return this.wrapped.getMaxBinaryLiteralLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxCatalogNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            return this.wrapped.getMaxCharLiteralLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxColumnNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInGroupBy();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInIndex();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInOrderBy();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInSelect();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInTable();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            return this.wrapped.getMaxConnections();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxCursorNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            return this.wrapped.getMaxIndexLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxProcedureNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            return this.wrapped.getMaxRowSize();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxSchemaNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            return this.wrapped.getMaxStatementLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            return this.wrapped.getMaxStatements();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxTableNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            return this.wrapped.getMaxTablesInSelect();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxUserNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            return this.wrapped.getNumericFunctions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            table = this.normalizeName(table);
            if (this.connection.isShowSchema()) {
                return this.wrapped.getPrimaryKeys("PUBLIC", "PUBLIC", table);
            }
            return new MetadataResultSet(this.wrapped.getPrimaryKeys("PUBLIC", "PUBLIC", table));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            columnNamePattern = this.normalizeName(columnNamePattern);
            return this.wrapped.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            return this.wrapped.getProcedures(catalog, schemaPattern, procedureNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            return this.wrapped.getProcedureTerm();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            return ((JDBCDatabaseMetaData)this.wrapped).getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.wrapped.getResultSetHoldability();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new FeatureNotSupportedException();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        if (this.connection.isShowSchema()) {
            try {
                return this.wrapped.getSchemas();
            }
            catch (SQLException e) {
                throw new UcanaccessSQLException(e);
            }
        }
        throw new FeatureNotSupportedException();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (this.connection.isShowSchema()) {
            try {
                return this.wrapped.getSchemas(catalog, schemaPattern);
            }
            catch (SQLException e) {
                throw new UcanaccessSQLException(e);
            }
        }
        throw new FeatureNotSupportedException();
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return null;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            return this.wrapped.getSearchStringEscape();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            return this.wrapped.getSQLKeywords();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            return this.wrapped.getSQLStateType();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            return this.wrapped.getStringFunctions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            tableNamePattern = this.normalizeName(tableNamePattern);
            return this.wrapped.getSuperTables(catalog, schemaPattern, tableNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            return this.wrapped.getSuperTypes(catalog, schemaPattern, typeNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            return this.wrapped.getSystemFunctions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            tableNamePattern = this.normalizeName(tableNamePattern);
            return this.wrapped.getTablePrivileges(catalog, schemaPattern, tableNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            tableNamePattern = this.normalizeName(tableNamePattern);
            if (this.connection.isShowSchema()) {
                return this.wrapped.getTables("PUBLIC", "PUBLIC", tableNamePattern, types);
            }
            return new MetadataResultSet(this.wrapped.getTables("PUBLIC", "PUBLIC", tableNamePattern, types));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            return this.wrapped.getTableTypes();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            return this.wrapped.getTimeDateFunctions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try {
            return this.wrapped.getTypeInfo();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            return this.wrapped.getUDTs(catalog, schemaPattern, typeNamePattern, types);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            return this.wrapped.getUserName();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try {
            return this.wrapped.getVersionColumns(catalog, schema, table);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        try {
            return this.wrapped.insertsAreDetected(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            return this.wrapped.isCatalogAtStart();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.wrapped.isReadOnly();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this.wrapped.isWrapperFor(iface);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            return this.wrapped.locatorsUpdateCopy();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    private String normalizeName(String name) {
        String stb;
        if (name == null || name.trim().length() == 0) {
            return name;
        }
        if (name.indexOf("%") >= 0) {
            return name;
        }
        if (name.startsWith("\"") && name.endsWith("\"") && SQLConverter.isListedAsKeyword(stb = name.substring(1, name.length() - 1).toUpperCase())) {
            return stb;
        }
        if (SQLConverter.isListedAsKeyword(name)) {
            return name;
        }
        return SQLConverter.basicEscapingIdentifier(name).toUpperCase();
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            return this.wrapped.nullPlusNonNullIsNull();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            return this.wrapped.nullsAreSortedAtEnd();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            return this.wrapped.nullsAreSortedAtStart();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            return this.wrapped.nullsAreSortedHigh();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            return this.wrapped.nullsAreSortedLow();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.othersDeletesAreVisible(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.othersInsertsAreVisible(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.othersUpdatesAreVisible(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.ownDeletesAreVisible(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.ownInsertsAreVisible(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.ownUpdatesAreVisible(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesLowerCaseIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesLowerCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesMixedCaseIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesMixedCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesUpperCaseIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            return this.wrapped.supportsAlterTableWithAddColumn();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            return this.wrapped.supportsAlterTableWithDropColumn();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            return this.wrapped.supportsANSI92EntryLevelSQL();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            return this.wrapped.supportsANSI92FullSQL();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            return this.wrapped.supportsANSI92IntermediateSQL();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            return this.wrapped.supportsBatchUpdates();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInDataManipulation();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInIndexDefinitions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInProcedureCalls();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            return this.wrapped.supportsColumnAliasing();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            return this.wrapped.supportsConvert();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        try {
            return this.wrapped.supportsConvert(fromType, toType);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            return this.wrapped.supportsCoreSQLGrammar();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            return this.wrapped.supportsCorrelatedSubqueries();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            return this.wrapped.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            return this.wrapped.supportsDataManipulationTransactionsOnly();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            return this.wrapped.supportsDifferentTableCorrelationNames();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            return this.wrapped.supportsExpressionsInOrderBy();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            return this.wrapped.supportsExtendedSQLGrammar();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            return this.wrapped.supportsFullOuterJoins();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            return this.wrapped.supportsGetGeneratedKeys();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            return this.wrapped.supportsGroupBy();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            return this.wrapped.supportsGroupByBeyondSelect();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            return this.wrapped.supportsGroupByUnrelated();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            return this.wrapped.supportsIntegrityEnhancementFacility();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            return this.wrapped.supportsLikeEscapeClause();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            return this.wrapped.supportsLimitedOuterJoins();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            return this.wrapped.supportsMinimumSQLGrammar();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            return this.wrapped.supportsMixedCaseIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.wrapped.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            return this.wrapped.supportsMultipleOpenResults();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            return this.wrapped.supportsMultipleResultSets();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            return this.wrapped.supportsMultipleTransactions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            return this.wrapped.supportsNamedParameters();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            return this.wrapped.supportsNonNullableColumns();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            return this.wrapped.supportsOpenCursorsAcrossCommit();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            return this.wrapped.supportsOpenCursorsAcrossRollback();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            return this.wrapped.supportsOpenStatementsAcrossCommit();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            return this.wrapped.supportsOpenStatementsAcrossRollback();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            return this.wrapped.supportsOrderByUnrelated();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            return this.wrapped.supportsOuterJoins();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            return this.wrapped.supportsPositionedDelete();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            return this.wrapped.supportsPositionedUpdate();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        try {
            return this.wrapped.supportsResultSetConcurrency(type, concurrency);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        try {
            return this.wrapped.supportsResultSetHoldability(holdability);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        try {
            return this.wrapped.supportsResultSetType(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            return this.wrapped.supportsSavepoints();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInDataManipulation();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInIndexDefinitions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInPrivilegeDefinitions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInProcedureCalls();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInTableDefinitions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            return this.wrapped.supportsSelectForUpdate();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        try {
            return this.wrapped.supportsStatementPooling();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            return this.wrapped.supportsStoredFunctionsUsingCallSyntax();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            return this.wrapped.supportsStoredProcedures();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            return this.wrapped.supportsSubqueriesInComparisons();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            return this.wrapped.supportsSubqueriesInExists();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            return this.wrapped.supportsSubqueriesInIns();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            return this.wrapped.supportsSubqueriesInQuantifieds();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            return this.wrapped.supportsTableCorrelationNames();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        try {
            return this.wrapped.supportsTransactionIsolationLevel(level);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            return this.wrapped.supportsTransactions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            return this.wrapped.supportsUnion();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            return this.wrapped.supportsUnionAll();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this.wrapped.unwrap(iface);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        try {
            return this.wrapped.updatesAreDetected(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            return this.wrapped.usesLocalFilePerTable();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            return this.wrapped.usesLocalFiles();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    private class MetadataResultSet
    extends UcanaccessResultSet {
        public MetadataResultSet(ResultSet wrapped) {
            super(wrapped, null);
        }

        @Override
        public Object getObject(int idx) throws SQLException {
            Object obj = super.getObject(idx);
            if ((idx == 1 || idx == 2) && "PUBLIC".equals(obj)) {
                return null;
            }
            return obj;
        }

        @Override
        public String getString(int idx) throws SQLException {
            Object obj = this.getObject(idx);
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            return obj.toString();
        }
    }
}

