/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sqlsheet.stream;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXlsSheetIterator
implements Iterable<Object>,
Iterator<Object> {
    private URL fileName;
    private String sheetName;
    private List<CellValueHolder> columns = new ArrayList<CellValueHolder>();
    private Map<Long, List<CellValueHolder>> rowValues = new HashMap<Long, List<CellValueHolder>>();
    private Long currentSheetRowIndex = 0L;
    private Long currentIteratorRowIndex = 0L;

    public AbstractXlsSheetIterator(URL filename, String sheetName) throws SQLException {
        this.setFileName(filename);
        this.setSheetName(sheetName);
        this.postConstruct();
    }

    protected abstract void postConstruct() throws SQLException;

    protected abstract void processNextRecords() throws SQLException;

    protected abstract void onClose() throws SQLException;

    @Override
    public Iterator<Object> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.getRowValues().get(this.getCurrentIteratorRowIndex() + 1L) != null;
    }

    @Override
    public Object next() {
        try {
            this.getRowValues().remove(this.getCurrentIteratorRowIndex());
            this.setCurrentIteratorRowIndex(this.getCurrentIteratorRowIndex() + 1L);
            this.processNextRecords();
            if (this.getRowValues().get(this.getCurrentIteratorRowIndex() + 1L) == null) {
                this.processNextRecords();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.getRowValues().get(this.getCurrentIteratorRowIndex());
    }

    void addCurrentRowValue(CellValueHolder cellValue) {
        if (this.getRowValues().get(this.getCurrentSheetRowIndex()) == null) {
            this.getRowValues().put(this.getCurrentSheetRowIndex(), new ArrayList());
        }
        this.getRowValues().get(this.getCurrentSheetRowIndex()).add(cellValue);
    }

    CellValueHolder getCurrentRowValue(int column) {
        CellValueHolder result = new CellValueHolder();
        if (this.getRowValues().get(this.getCurrentIteratorRowIndex()) != null && column < this.getRowValues().get(this.getCurrentIteratorRowIndex()).size()) {
            result = this.getRowValues().get(this.getCurrentIteratorRowIndex()).get(column);
        }
        return result;
    }

    CellValueHolder getNextRowValue(int column) {
        CellValueHolder result = new CellValueHolder();
        if (this.getRowValues().get(this.getCurrentIteratorRowIndex() + 1L) != null && column < this.getRowValues().get(this.getCurrentIteratorRowIndex() + 1L).size()) {
            result = this.getRowValues().get(this.getCurrentIteratorRowIndex() + 1L).get(column);
        }
        return result;
    }

    @Override
    public void remove() {
    }

    Date convertDateValue(double value, int formatIndex, String formatString) {
        if (DateUtil.isADateFormat((int)formatIndex, (String)formatString) && DateUtil.isValidExcelDate((double)value)) {
            return DateUtil.getJavaDate((double)value, (boolean)false);
        }
        return null;
    }

    protected URL getFileName() {
        return this.fileName;
    }

    protected void setFileName(URL fileName) {
        this.fileName = fileName;
    }

    protected String getSheetName() {
        return this.sheetName;
    }

    protected void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    protected List<CellValueHolder> getColumns() {
        return this.columns;
    }

    protected void setColumns(List<CellValueHolder> columns) {
        this.columns = columns;
    }

    protected Map<Long, List<CellValueHolder>> getRowValues() {
        return this.rowValues;
    }

    protected void setRowValues(Map<Long, List<CellValueHolder>> rowValues) {
        this.rowValues = rowValues;
    }

    protected Long getCurrentSheetRowIndex() {
        return this.currentSheetRowIndex;
    }

    protected void setCurrentSheetRowIndex(Long currentSheetRowIndex) {
        this.currentSheetRowIndex = currentSheetRowIndex;
    }

    protected Long getCurrentIteratorRowIndex() {
        return this.currentIteratorRowIndex;
    }

    protected void setCurrentIteratorRowIndex(Long currentIteratorRowIndex) {
        this.currentIteratorRowIndex = currentIteratorRowIndex;
    }

    class CellValueHolder {
        String stringValue;
        Double doubleValue;
        Date dateValue;

        CellValueHolder() {
        }

        public String toString() {
            return "CellValueHolder{stringValue='" + this.stringValue + '\'' + ", doubleValue=" + this.doubleValue + ", dateValue=" + this.dateValue + '}';
        }

        public Class getType() {
            if (this.dateValue != null) {
                return this.dateValue.getClass();
            }
            if (this.doubleValue != null) {
                return this.doubleValue.getClass();
            }
            if (this.stringValue != null) {
                return this.stringValue.getClass();
            }
            return Object.class;
        }
    }
}

