/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sqlsheet.stream;

import com.googlecode.sqlsheet.stream.AbstractXlsSheetIterator;
import com.googlecode.sqlsheet.stream.XlsSheetIterator;
import com.googlecode.sqlsheet.stream.XlsStreamConnection;
import com.googlecode.sqlsheet.stream.XlsStreamingResultSetMetaData;
import com.googlecode.sqlsheet.stream.XlsxSheetIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsStreamResultSet
implements ResultSet {
    AbstractXlsSheetIterator iterator;
    private XlsStreamingResultSetMetaData metadata;

    public XlsStreamResultSet(String tableName, XlsStreamConnection connection) throws SQLException {
        try {
            switch (this.getXlsType(connection.xlsFile)) {
                case XLS: {
                    this.iterator = new XlsSheetIterator(connection.xlsFile, tableName);
                    break;
                }
                case XLSX: {
                    this.iterator = new XlsxSheetIterator(connection.xlsFile, tableName);
                    break;
                }
                default: {
                    throw new SQLException("Cannot detect type of XLS file");
                }
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
        this.metadata = new XlsStreamingResultSetMetaData(this.iterator);
    }

    private static Object getObject(AbstractXlsSheetIterator.CellValueHolder cell) throws SQLException {
        if (cell == null) {
            return null;
        }
        if (cell.dateValue != null) {
            return cell.dateValue;
        }
        if (cell.doubleValue != null) {
            return cell.doubleValue;
        }
        if (cell.stringValue != null) {
            return cell.stringValue;
        }
        return null;
    }

    XlsType getXlsType(URL inputXls) throws IOException {
        InputStream input = inputXls.openStream();
        try {
            if (POIFSFileSystem.hasPOIFSHeader((InputStream)inputXls.openStream())) {
                XlsType xlsType = XlsType.XLS;
                return xlsType;
            }
            if (POIXMLDocument.hasOOXMLHeader((InputStream)input)) {
                XlsType xlsType = XlsType.XLSX;
                return xlsType;
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return null;
    }

    private AbstractXlsSheetIterator.CellValueHolder getCell(int jdbcColumn) {
        return this.iterator.getCurrentRowValue(jdbcColumn - 1);
    }

    private AbstractXlsSheetIterator.CellValueHolder getCell(String jdbcColumn) {
        int jdbcColumnIndex = -1;
        boolean found = false;
        for (AbstractXlsSheetIterator.CellValueHolder valueHolder : this.iterator.getColumns()) {
            ++jdbcColumnIndex;
            if (!jdbcColumn.equalsIgnoreCase(valueHolder.stringValue)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Column with name " + jdbcColumn + " not found");
        }
        return this.iterator.getCurrentRowValue(jdbcColumnIndex);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return (T)this.getObject(columnIndex);
    }

    @Override
    public <T> T getObject(String columnName, Class<T> type) throws SQLException {
        return (T)this.getObject(columnName);
    }

    @Override
    public Timestamp getTimestamp(int jdbcColumn) throws SQLException {
        return new Timestamp(((java.util.Date)this.getObject(jdbcColumn)).getTime());
    }

    @Override
    public Timestamp getTimestamp(String jdbcColumn) throws SQLException {
        return new Timestamp(((java.util.Date)this.getObject(jdbcColumn)).getTime());
    }

    @Override
    public boolean getBoolean(int jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return cell != null && Boolean.parseBoolean(cell.stringValue);
    }

    @Override
    public boolean getBoolean(String jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return cell != null && Boolean.parseBoolean(cell.stringValue);
    }

    @Override
    public double getDouble(int jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return cell == null ? 0.0 : cell.doubleValue;
    }

    @Override
    public double getDouble(String jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return cell == null ? 0.0 : cell.doubleValue;
    }

    @Override
    public byte getByte(int jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return (byte)(cell == null ? 0.0 : cell.doubleValue);
    }

    @Override
    public byte getByte(String jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return (byte)(cell == null ? 0.0 : cell.doubleValue);
    }

    @Override
    public float getFloat(int jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return (float)(cell == null ? 0.0 : cell.doubleValue);
    }

    @Override
    public float getFloat(String jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return (float)(cell == null ? 0.0 : cell.doubleValue);
    }

    @Override
    public int getInt(int jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return (int)(cell == null ? 0.0 : cell.doubleValue);
    }

    @Override
    public int getInt(String jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return (int)(cell == null ? 0.0 : cell.doubleValue);
    }

    @Override
    public long getLong(int jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return (long)(cell == null ? 0.0 : cell.doubleValue);
    }

    @Override
    public long getLong(String jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return (long)(cell == null ? 0.0 : cell.doubleValue);
    }

    @Override
    public Object getObject(String jdbcColumn) throws SQLException {
        return XlsStreamResultSet.getObject(this.getCell(jdbcColumn));
    }

    @Override
    public Object getObject(int jdbcColumn) throws SQLException {
        return XlsStreamResultSet.getObject(this.getCell(jdbcColumn));
    }

    @Override
    public short getShort(int jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return (short)(cell == null ? 0.0 : cell.doubleValue);
    }

    @Override
    public short getShort(String jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return (short)(cell == null ? 0.0 : cell.doubleValue);
    }

    @Override
    public String getString(int jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return cell == null ? null : cell.stringValue;
    }

    @Override
    public String getString(String jdbcColumn) throws SQLException {
        AbstractXlsSheetIterator.CellValueHolder cell = this.getCell(jdbcColumn);
        return cell == null ? null : cell.stringValue;
    }

    @Override
    public void updateBoolean(int jdbcColumn, boolean x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBoolean(String jdbcColumn, boolean x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateByte(int jdbcColumn, byte x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateByte(String jdbcColumn, byte x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateDouble(int jdbcColumn, double x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateDouble(String jdbcColumn, double x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateFloat(int jdbcColumn, float x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateFloat(String jdbcColumn, float x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateInt(int jdbcColumn, int x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateInt(String jdbcColumn, int x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateLong(int jdbcColumn, long x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateLong(String jdbcColumn, long x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNull(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNull(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateObject(int jdbcColumn, Object x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateObject(String jdbcColumn, Object x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateShort(int jdbcColumn, short x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateShort(String jdbcColumn, short x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateString(int jdbcColumn, String x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateString(String jdbcColumn, String x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
    }

    @Override
    public void beforeFirst() throws SQLException {
    }

    @Override
    public boolean first() throws SQLException {
        return true;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw this.nyi();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw this.nyi();
    }

    @Override
    public int getRow() throws SQLException {
        return this.iterator.getCurrentIteratorRowIndex().intValue();
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.iterator.hasNext();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.iterator.getCurrentIteratorRowIndex() == 0L;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.iterator.getCurrentIteratorRowIndex() == 1L;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.iterator.hasNext();
    }

    @Override
    public boolean last() throws SQLException {
        return this.iterator.hasNext();
    }

    @Override
    public boolean next() throws SQLException {
        if (this.iterator.hasNext()) {
            this.iterator.next();
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        return false;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void insertRow() throws SQLException {
        throw this.nyi();
    }

    private IllegalStateException nyi() {
        return new IllegalStateException("NYI");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void close() throws SQLException {
        this.iterator.onClose();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw this.nyi();
    }

    @Override
    public int findColumn(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw this.nyi();
    }

    @Override
    public InputStream getAsciiStream(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public InputStream getAsciiStream(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public BigDecimal getBigDecimal(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public BigDecimal getBigDecimal(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public BigDecimal getBigDecimal(int jdbcColumn, int scale) throws SQLException {
        throw this.nyi();
    }

    @Override
    public BigDecimal getBigDecimal(String jdbcColumn, int scale) throws SQLException {
        throw this.nyi();
    }

    @Override
    public InputStream getBinaryStream(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public InputStream getBinaryStream(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw this.nyi();
    }

    @Override
    public byte[] getBytes(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public byte[] getBytes(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Reader getCharacterStream(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Reader getCharacterStream(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw this.nyi();
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw this.nyi();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw this.nyi();
    }

    @Override
    public Date getDate(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Date getDate(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Date getDate(int jdbcColumn, Calendar cal) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Date getDate(String jdbcColumn, Calendar cal) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw this.nyi();
    }

    @Override
    public Time getTime(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Time getTime(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Time getTime(int jdbcColumn, Calendar cal) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Time getTime(String jdbcColumn, Calendar cal) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Timestamp getTimestamp(int jdbcColumn, Calendar cal) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Timestamp getTimestamp(String jdbcColumn, Calendar cal) throws SQLException {
        throw this.nyi();
    }

    @Override
    public URL getURL(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public URL getURL(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public InputStream getUnicodeStream(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public InputStream getUnicodeStream(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateArray(int jdbcColumn, Array x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateArray(String jdbcColumn, Array x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw this.nyi();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw this.nyi();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw this.nyi();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw this.nyi();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw this.nyi();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw this.nyi();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw this.nyi();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateAsciiStream(int jdbcColumn, InputStream x, int length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateAsciiStream(String jdbcColumn, InputStream x, int length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBigDecimal(int jdbcColumn, BigDecimal x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBigDecimal(String jdbcColumn, BigDecimal x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBinaryStream(int jdbcColumn, InputStream x, int length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBinaryStream(String jdbcColumn, InputStream x, int length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBlob(int jdbcColumn, Blob x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBlob(String jdbcColumn, Blob x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBytes(int jdbcColumn, byte[] x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBytes(String jdbcColumn, byte[] x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateCharacterStream(int jdbcColumn, Reader x, int length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateCharacterStream(String jdbcColumn, Reader reader, int length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateClob(int jdbcColumn, Clob x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateClob(String jdbcColumn, Clob x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateDate(int jdbcColumn, Date x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateDate(String jdbcColumn, Date x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateObject(int jdbcColumn, Object x, int scale) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateObject(String jdbcColumn, Object x, int scale) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateRef(int jdbcColumn, Ref x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateRef(String jdbcColumn, Ref x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateRow() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateTime(int jdbcColumn, Time x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateTime(String jdbcColumn, Time x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateTimestamp(int jdbcColumn, Timestamp x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateTimestamp(String jdbcColumn, Timestamp x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw this.nyi();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw this.nyi();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum XlsType {
        XLS,
        XLSX;

    }
}

