/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sqlsheet.stream;

import com.googlecode.sqlsheet.stream.AbstractXlsSheetIterator;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class XlsxSheetIterator
extends AbstractXlsSheetIterator {
    OPCPackage xlsxPackage;
    XMLEventReader reader;
    StylesTable styles;
    ReadOnlySharedStringsTable strings;
    XSSFSheetEventHandler handler;

    public XlsxSheetIterator(URL filename, String sheetName) throws SQLException {
        super(filename, sheetName);
    }

    protected void postConstruct() throws SQLException {
        try {
            this.xlsxPackage = OPCPackage.open((String)this.getFileName().getPath(), (PackageAccess)PackageAccess.READ);
            this.strings = new ReadOnlySharedStringsTable(this.xlsxPackage);
            XSSFReader xssfReader = new XSSFReader(this.xlsxPackage);
            this.styles = xssfReader.getStylesTable();
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            while (iter.hasNext()) {
                InputStream stream = iter.next();
                String currentSheetName = iter.getSheetName();
                if (!currentSheetName.equalsIgnoreCase(this.getSheetName()) && !("\"" + currentSheetName + "\"").equalsIgnoreCase(this.getSheetName())) continue;
                this.handler = new XSSFSheetEventHandler(this.styles, this.strings);
                XMLInputFactory factory = XMLInputFactory.newInstance();
                this.reader = factory.createXMLEventReader(stream);
                while (this.reader.hasNext() && this.getCurrentSheetRowIndex() == 0L) {
                    this.processNextEvent();
                }
                this.processNextRecords();
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    protected void processNextRecords() throws SQLException {
        Long nextRowIndex = this.getCurrentSheetRowIndex() + 2L;
        while (this.reader.hasNext() && !this.getCurrentSheetRowIndex().equals(nextRowIndex)) {
            try {
                this.processNextEvent();
            }
            catch (XMLStreamException e) {
                throw new SQLException(e.getMessage(), e);
            }
        }
    }

    protected void onClose() throws SQLException {
        try {
            if (this.xlsxPackage != null) {
                this.xlsxPackage.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    public void processNextEvent() throws XMLStreamException {
        if (this.reader.hasNext()) {
            XMLEvent event = this.reader.nextEvent();
            XMLEvent nextEvent = this.reader.peek();
            switch (event.getEventType()) {
                case 1: {
                    Characters c;
                    this.handler.startElement(event.asStartElement());
                    if (!nextEvent.isCharacters() || (c = this.reader.nextEvent().asCharacters()).isWhiteSpace()) break;
                    this.handler.characters(c.getData().toCharArray());
                    break;
                }
                case 2: {
                    this.handler.endElement(event.asEndElement());
                }
            }
        }
    }

    class XSSFSheetEventHandler {
        private StylesTable stylesTable;
        private ReadOnlySharedStringsTable sharedStringsTable;
        private boolean vIsOpen;
        private xssfDataType nextDataType;
        private short formatIndex;
        private String formatString;
        private final DataFormatter formatter;
        private int thisColumn = -1;
        private int lastColumnNumber = -1;
        private StringBuffer value;

        public XSSFSheetEventHandler(StylesTable styles, ReadOnlySharedStringsTable strings) {
            this.stylesTable = styles;
            this.sharedStringsTable = strings;
            this.value = new StringBuffer();
            this.nextDataType = xssfDataType.NUMBER;
            this.formatter = new DataFormatter();
        }

        public void startElement(StartElement startElement) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            Iterator<Attribute> attributesIterator = startElement.getAttributes();
            while (attributesIterator.hasNext()) {
                Attribute attr = attributesIterator.next();
                attributes.put(attr.getName().getLocalPart(), attr.getValue());
            }
            if ("inlineStr".equals(startElement.getName().getLocalPart()) || "v".equals(startElement.getName().getLocalPart()) || "is".equals(startElement.getName().getLocalPart())) {
                this.vIsOpen = true;
                this.value.setLength(0);
            } else if ("c".equals(startElement.getName().getLocalPart())) {
                String r = (String)attributes.get("r");
                int firstDigit = -1;
                int c = 0;
                while (c < r.length()) {
                    if (Character.isDigit(r.charAt(c))) {
                        firstDigit = c;
                        break;
                    }
                    ++c;
                }
                this.thisColumn = this.nameToColumn(r.substring(0, firstDigit));
                this.nextDataType = xssfDataType.NUMBER;
                this.formatIndex = (short)-1;
                this.formatString = null;
                String cellType = (String)attributes.get("t");
                String cellStyleStr = (String)attributes.get("s");
                if ("b".equals(cellType)) {
                    this.nextDataType = xssfDataType.BOOL;
                } else if ("e".equals(cellType)) {
                    this.nextDataType = xssfDataType.ERROR;
                } else if ("inlineStr".equals(cellType)) {
                    this.nextDataType = xssfDataType.INLINESTR;
                } else if ("s".equals(cellType)) {
                    this.nextDataType = xssfDataType.SSTINDEX;
                } else if ("str".equals(cellType)) {
                    this.nextDataType = xssfDataType.FORMULA;
                } else if (cellStyleStr != null) {
                    int styleIndex = Integer.parseInt(cellStyleStr);
                    XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
                    this.formatIndex = style.getDataFormat();
                    this.formatString = style.getDataFormatString();
                    if (this.formatString == null) {
                        this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
                    }
                }
            }
        }

        public void endElement(EndElement endElement) {
            AbstractXlsSheetIterator.CellValueHolder thisCellValue = new AbstractXlsSheetIterator.CellValueHolder();
            if ("v".equals(endElement.getName().getLocalPart()) || "c".equals(endElement.getName().getLocalPart()) && xssfDataType.INLINESTR.equals((Object)this.nextDataType)) {
                switch (this.nextDataType) {
                    case BOOL: {
                        char first = this.value.charAt(0);
                        thisCellValue.stringValue = first == '0' ? "FALSE" : "TRUE";
                        break;
                    }
                    case ERROR: {
                        thisCellValue.stringValue = "\"ERROR:" + this.value.toString() + '\"';
                        break;
                    }
                    case FORMULA: {
                        thisCellValue.stringValue = this.value.toString();
                        break;
                    }
                    case INLINESTR: {
                        XSSFRichTextString rtsi = new XSSFRichTextString(this.value.toString());
                        thisCellValue.stringValue = rtsi.toString();
                        break;
                    }
                    case SSTINDEX: {
                        String sstIndex = this.value.toString();
                        try {
                            int idx = Integer.parseInt(sstIndex);
                            XSSFRichTextString rtss = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx));
                            thisCellValue.stringValue = rtss.toString();
                        }
                        catch (NumberFormatException ex) {
                            thisCellValue.stringValue = "Failed to parse SST index '" + sstIndex + "': " + ex.toString();
                        }
                        break;
                    }
                    case NUMBER: {
                        String n = this.value.toString();
                        thisCellValue.stringValue = this.formatString != null ? this.formatter.formatRawCellContents(Double.parseDouble(n), (int)this.formatIndex, this.formatString) : n;
                        thisCellValue.doubleValue = Double.parseDouble(n);
                        thisCellValue.dateValue = XlsxSheetIterator.this.convertDateValue(thisCellValue.doubleValue, this.formatIndex, this.formatString);
                        break;
                    }
                    default: {
                        thisCellValue.stringValue = "(TODO: Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
                    }
                }
                int i = this.lastColumnNumber + 1;
                while (i < this.thisColumn) {
                    if (XlsxSheetIterator.this.getCurrentSheetRowIndex() == 0L) {
                        XlsxSheetIterator.this.getColumns().add(new AbstractXlsSheetIterator.CellValueHolder());
                    } else {
                        AbstractXlsSheetIterator.CellValueHolder empty = new AbstractXlsSheetIterator.CellValueHolder();
                        XlsxSheetIterator.this.addCurrentRowValue(empty);
                    }
                    ++i;
                }
                if (this.lastColumnNumber == -1) {
                    this.lastColumnNumber = 0;
                }
                if (XlsxSheetIterator.this.getCurrentSheetRowIndex() == 0L) {
                    XlsxSheetIterator.this.getColumns().add(thisCellValue);
                } else {
                    XlsxSheetIterator.this.addCurrentRowValue(thisCellValue);
                }
                if (this.thisColumn > -1) {
                    this.lastColumnNumber = this.thisColumn;
                }
            } else if ("row".equals(endElement.getName().getLocalPart())) {
                this.lastColumnNumber = -1;
                XlsxSheetIterator.this.setCurrentSheetRowIndex(XlsxSheetIterator.this.getCurrentSheetRowIndex() + 1L);
            }
        }

        public void characters(char[] ch) {
            if (this.vIsOpen) {
                this.value.append(ch);
            }
        }

        private int nameToColumn(String name) {
            int column = -1;
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                column = (column + 1) * 26 + c - 65;
                ++i;
            }
            return column;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum xssfDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER;

    }
}

