/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.sqlsheet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pcal.sqlsheet.XlsDatabaseMetaData;
import net.pcal.sqlsheet.XlsPreparedStatement;
import net.pcal.sqlsheet.XlsStatement;
import org.apache.poi.ss.usermodel.Workbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XlsConnection
implements Connection {
    private static final Logger logger = Logger.getLogger(XlsConnection.class.getName());
    private Workbook workbook;
    private File saveFile;
    private Properties info;
    private boolean writeRequired;

    XlsConnection(Workbook workbook, Properties info) {
        this(workbook, null, info);
    }

    XlsConnection(Workbook workbook, File saveFile, Properties info) {
        logger.setLevel(Level.SEVERE);
        if (workbook == null) {
            throw new IllegalArgumentException();
        }
        this.workbook = workbook;
        this.saveFile = saveFile;
        this.info = info;
    }

    int getInt(String key, int defaultValue) {
        Object value = this.info.get(key);
        if (value == null) {
            logger.fine(String.format("Key [%s] not present.", key));
            return defaultValue;
        }
        return Integer.parseInt(value.toString());
    }

    Workbook getWorkBook() {
        return this.workbook;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new XlsStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new XlsPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public void close() throws SQLException {
        if (this.saveFile != null && this.writeRequired) {
            try {
                File newFile = File.createTempFile("xlsdriver", "xlsx");
                FileOutputStream fileOut = new FileOutputStream(newFile);
                this.workbook.write((OutputStream)fileOut);
                if (fileOut != null) {
                    try {
                        fileOut.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                File backup = this.backupFile(this.saveFile);
                logger.log(Level.INFO, "Created backup:" + backup.getAbsolutePath());
                if (this.saveFile.exists() && !this.saveFile.delete()) {
                    logger.log(Level.WARNING, "Unable to delete file:" + this.saveFile.getAbsolutePath() + ", you may lose the results.");
                }
                this.moveFile(newFile, this.saveFile);
            }
            catch (IOException ioe) {
                SQLException sqe = new SQLException(ioe.getMessage());
                sqe.initCause(sqe);
                throw sqe;
            }
        }
    }

    private File backupFile(File input) throws IOException {
        File output = null;
        if (input != null) {
            output = File.createTempFile(String.valueOf(input.getName()) + ".", ".bkp", null);
            this.moveFile(input, output);
        }
        return output;
    }

    private void moveFile(File sourceFile, File destFile) throws IOException {
        boolean moved = sourceFile.renameTo(destFile);
        if (!moved) {
            logger.log(Level.WARNING, "Unable to rename file during move:" + sourceFile.getAbsolutePath() + " to " + destFile.getAbsolutePath() + ", performing full copy of data.");
            FileChannel source = null;
            AbstractInterruptibleChannel destination = null;
            try {
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(destFile).getChannel();
                long count = 0L;
                long size = source.size();
                while ((count += ((FileChannel)destination).transferFrom(source, 0L, size - count)) < size) {
                }
            }
            finally {
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
            }
        }
    }

    @Override
    public boolean getAutoCommit() {
        return false;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.nyi();
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.nyi();
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.nyi();
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.nyi();
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.nyi();
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new XlsDatabaseMetaData();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public void setHoldability(int param) throws SQLException {
        this.nyi();
    }

    @Override
    public CallableStatement prepareCall(String str, int param, int param2, int param3) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String str, int param) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String str, int[] values) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String str, String[] str1) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.nyi();
        return false;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String str, int param, int param2, int param3) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.nyi();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.nyi();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public Savepoint setSavepoint(String str) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.nyi();
        return null;
    }

    private void nyi() throws SQLException {
        throw new SQLException("NYI");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.nyi();
        return false;
    }

    public Boolean getWriteRequired() {
        return this.writeRequired;
    }

    public void setWriteRequired(Boolean writeRequired) {
        this.writeRequired = writeRequired;
    }

    @Override
    public String getSchema() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSchema(String string) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void abort(Executor exctr) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNetworkTimeout(Executor exctr, int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

