/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.sqlsheet;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pcal.sqlsheet.XlsResultSet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsResultSetMetaData
implements ResultSetMetaData {
    private List<String> columnNames;
    private final DataFormatter formatter;
    private XlsResultSet resultset;
    Map<Integer, Integer> columnTypeMap = new HashMap<Integer, Integer>();
    static Map<Integer, String> columnTypeNameMap = new HashMap<Integer, String>();
    static Map<Integer, String> columnTypeClassMap = new HashMap<Integer, String>();

    static {
        columnTypeNameMap.put(12, "VARCHAR");
        columnTypeNameMap.put(8, "DOUBLE");
        columnTypeNameMap.put(91, "DATE");
        columnTypeClassMap.put(12, "java.lang.String.class");
        columnTypeClassMap.put(8, "java.lang.Double.class");
        columnTypeClassMap.put(91, "java.sql.Date.class");
    }

    public XlsResultSetMetaData(Sheet sheet, XlsResultSet resultset, int firstSheetRowOffset) throws SQLException {
        if (sheet == null) {
            throw new IllegalArgumentException();
        }
        this.resultset = resultset;
        Row row = sheet.getRow(firstSheetRowOffset - 1);
        if (row == null) {
            throw new SQLException("No header row in sheet");
        }
        this.formatter = new DataFormatter();
        this.columnNames = new ArrayList<String>();
        short c = 0;
        while (c < row.getLastCellNum()) {
            Cell cell = row.getCell((int)c);
            String columnName = this.formatter.formatCellValue(cell);
            while (this.columnNames.contains(columnName)) {
                int suffix = 1;
                columnName = String.valueOf(columnName) + "_" + suffix;
            }
            this.columnNames.add(columnName);
            c = (short)(c + 1);
        }
        int currentRowNumber = resultset.getRow();
        HashMap columnTypeScan = new HashMap();
        while (resultset.next()) {
            int columnId = 1;
            while (columnId <= this.getColumnCount()) {
                int typeCode;
                block30: {
                    block29: {
                        Cell cell = resultset.getCell(columnId);
                        if (cell == null) break block29;
                        int excelCellType = cell.getCellType();
                        switch (excelCellType) {
                            case 4: {
                                typeCode = 12;
                                break block30;
                            }
                            case 1: {
                                typeCode = 12;
                                break block30;
                            }
                            case 0: {
                                typeCode = DateUtil.isCellDateFormatted((Cell)cell) ? 91 : 8;
                                break block30;
                            }
                            case 3: {
                                typeCode = 0;
                                break block30;
                            }
                            case 2: {
                                try {
                                    cell.getStringCellValue();
                                    typeCode = 12;
                                }
                                catch (Exception e) {
                                    cell.getNumericCellValue();
                                    typeCode = 8;
                                }
                                break block30;
                            }
                            case 5: {
                                throw new RuntimeException("The ExcelType ( ERROR ) is not supported - Cell (" + resultset.getRow() + "," + columnId + ")");
                            }
                            default: {
                                throw new RuntimeException("The ExcelType (" + excelCellType + ") is not supported - Cell (" + resultset.getRow() + "," + columnId + ")");
                            }
                        }
                    }
                    typeCode = 0;
                }
                HashMap<Integer, Integer> columnIdTypeMap = (HashMap<Integer, Integer>)columnTypeScan.get(columnId);
                if (columnIdTypeMap == null) {
                    columnIdTypeMap = new HashMap<Integer, Integer>();
                    columnIdTypeMap.put(typeCode, 1);
                    columnTypeScan.put(columnId, columnIdTypeMap);
                } else {
                    Integer columnIdType = (Integer)columnIdTypeMap.get(typeCode);
                    if (columnIdType == null) {
                        columnIdTypeMap.put(typeCode, 1);
                    } else {
                        int count = (Integer)columnIdTypeMap.get(typeCode) + 1;
                        columnIdTypeMap.put(typeCode, count);
                    }
                }
                ++columnId;
            }
            for (Integer columnId2 : columnTypeScan.keySet()) {
                Integer numberOfVarchar = 0;
                Integer numberOfDouble = 0;
                Integer numberOfDate = 0;
                for (Map.Entry columnIdTypeMap : ((Map)columnTypeScan.get(columnId2)).entrySet()) {
                    if ((Integer)columnIdTypeMap.getKey() == 12) {
                        numberOfVarchar = (Integer)columnIdTypeMap.getValue();
                        continue;
                    }
                    if ((Integer)columnIdTypeMap.getKey() == 8) {
                        numberOfDouble = (Integer)columnIdTypeMap.getValue();
                        continue;
                    }
                    if ((Integer)columnIdTypeMap.getKey() != 91) continue;
                    numberOfDate = (Integer)columnIdTypeMap.getValue();
                }
                Integer finalColumnType = null;
                if (numberOfVarchar != 0) {
                    finalColumnType = 12;
                } else {
                    if (numberOfDouble != 0 && numberOfDate == 0) {
                        finalColumnType = 8;
                    }
                    if (numberOfDouble == 0 && numberOfDate != 0) {
                        finalColumnType = 91;
                    }
                }
                if (finalColumnType == null) {
                    finalColumnType = 12;
                }
                this.columnTypeMap.put(columnId2, finalColumnType);
            }
        }
        resultset.absolute(currentRowNumber);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnLabel(int jdbcCol) {
        return this.columnNames.get(jdbcCol - 1);
    }

    @Override
    public String getColumnName(int jdbcCol) {
        return this.columnNames.get(jdbcCol - 1);
    }

    @Override
    public String getCatalogName(int arg0) throws SQLException {
        return null;
    }

    @Override
    public String getColumnClassName(int jdbcColumn) throws SQLException {
        return columnTypeClassMap.get(this.getColumnType(jdbcColumn));
    }

    @Override
    public int getColumnDisplaySize(int arg0) {
        return 0;
    }

    @Override
    public int getColumnType(int jdbcColumn) throws SQLException {
        return this.columnTypeMap.get(jdbcColumn);
    }

    @Override
    public String getColumnTypeName(int jdbcColumn) throws SQLException {
        return columnTypeNameMap.get(this.getColumnType(jdbcColumn));
    }

    @Override
    public int getPrecision(int arg0) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int arg0) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int arg0) throws SQLException {
        return null;
    }

    @Override
    public String getTableName(int arg0) throws SQLException {
        return null;
    }

    @Override
    public boolean isAutoIncrement(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int arg0) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int arg0) throws SQLException {
        return 0;
    }

    @Override
    public boolean isReadOnly(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }
}

