/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.spatial;

import com.mysema.query.spatial.GeometryExpression;
import com.mysema.query.spatial.GeometryOperation;
import com.mysema.query.spatial.SpatialOps;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.StringOperation;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;

public final class GeometryExpressions {
    public static StringExpression asEWKT(GeometryExpression<?> expr) {
        return StringOperation.create(SpatialOps.AS_EWKT, expr);
    }

    public static GeometryExpression<?> fromText(String text) {
        return GeometryOperation.create(Geometry.class, SpatialOps.GEOM_FROM_TEXT, ConstantImpl.create((Object)text));
    }

    public static GeometryExpression<?> fromText(Expression<String> text) {
        return GeometryOperation.create(Geometry.class, SpatialOps.GEOM_FROM_TEXT, text);
    }

    public static <T extends Geometry> GeometryExpression<T> setSRID(Expression<T> expr, int srid) {
        return GeometryOperation.create(expr.getType(), SpatialOps.SET_SRID, expr, ConstantImpl.create((int)srid));
    }

    public static NumberExpression<Double> xmin(GeometryExpression<?> expr) {
        return NumberOperation.create(Double.class, SpatialOps.XMIN, expr);
    }

    public static NumberExpression<Double> xmax(GeometryExpression<?> expr) {
        return NumberOperation.create(Double.class, SpatialOps.XMAX, expr);
    }

    public static NumberExpression<Double> ymin(GeometryExpression<?> expr) {
        return NumberOperation.create(Double.class, SpatialOps.YMIN, expr);
    }

    public static NumberExpression<Double> ymax(GeometryExpression<?> expr) {
        return NumberOperation.create(Double.class, SpatialOps.YMAX, expr);
    }

    public static BooleanExpression dwithin(Expression<? extends Geometry> expr1, Expression<? extends Geometry> expr2, Expression<Double> distance) {
        return BooleanOperation.create(SpatialOps.DWITHIN, (Expression[])new Expression[]{expr1, expr2, distance});
    }

    public static BooleanExpression dwithin(Expression<? extends Geometry> expr1, Expression<? extends Geometry> expr2, double distance) {
        return BooleanOperation.create(SpatialOps.DWITHIN, (Expression[])new Expression[]{expr1, expr2, ConstantImpl.create((Object)distance)});
    }

    public static GeometryExpression<?> extent(Expression<? extends GeometryCollection> collection) {
        return GeometryOperation.create(Geometry.class, SpatialOps.EXTENT, collection);
    }

    public static GeometryExpression<?> collect(Expression<? extends GeometryCollection> collection) {
        return GeometryOperation.create(Geometry.class, SpatialOps.COLLECT, collection);
    }

    public static GeometryExpression<?> collect(Expression<? extends Geometry> expr1, Expression<? extends Geometry> expr2) {
        return GeometryOperation.create(Geometry.class, SpatialOps.COLLECT2, expr1, expr2);
    }

    public static <T extends Geometry> GeometryExpression<T> translate(Expression<T> expr, float deltax, float deltay) {
        return GeometryOperation.create(expr.getType(), SpatialOps.TRANSLATE, new Expression[]{expr, ConstantImpl.create((Object)Float.valueOf(deltax)), ConstantImpl.create((Object)Float.valueOf(deltay))});
    }

    public static <T extends Geometry> GeometryExpression<T> translate(Expression<T> expr, float deltax, float deltay, float deltaz) {
        return GeometryOperation.create(expr.getType(), SpatialOps.TRANSLATE2, new Expression[]{expr, ConstantImpl.create((Object)Float.valueOf(deltax)), ConstantImpl.create((Object)Float.valueOf(deltay)), ConstantImpl.create((Object)Float.valueOf(deltaz))});
    }

    private GeometryExpressions() {
    }
}

