/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.spatial.jts;

import com.mysema.query.spatial.SpatialOps;
import com.mysema.query.spatial.jts.JTSGeometryExpression;
import com.mysema.query.spatial.jts.JTSGeometryOperation;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.StringOperation;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;

public final class JTSGeometryExpressions {
    public static StringExpression asEWKT(JTSGeometryExpression<?> expr) {
        return StringOperation.create(SpatialOps.AS_EWKT, expr);
    }

    public static JTSGeometryExpression<?> fromText(String text) {
        return JTSGeometryOperation.create(Geometry.class, SpatialOps.GEOM_FROM_TEXT, ConstantImpl.create((Object)text));
    }

    public static JTSGeometryExpression<?> fromText(Expression<String> text) {
        return JTSGeometryOperation.create(Geometry.class, SpatialOps.GEOM_FROM_TEXT, text);
    }

    public static <T extends Geometry> JTSGeometryExpression<T> setSRID(Expression<T> expr, int srid) {
        return JTSGeometryOperation.create(expr.getType(), SpatialOps.SET_SRID, expr, ConstantImpl.create((int)srid));
    }

    public static NumberExpression<Double> xmin(JTSGeometryExpression<?> expr) {
        return NumberOperation.create(Double.class, SpatialOps.XMIN, expr);
    }

    public static NumberExpression<Double> xmax(JTSGeometryExpression<?> expr) {
        return NumberOperation.create(Double.class, SpatialOps.XMAX, expr);
    }

    public static NumberExpression<Double> ymin(JTSGeometryExpression<?> expr) {
        return NumberOperation.create(Double.class, SpatialOps.YMIN, expr);
    }

    public static NumberExpression<Double> ymax(JTSGeometryExpression<?> expr) {
        return NumberOperation.create(Double.class, SpatialOps.YMAX, expr);
    }

    public static BooleanExpression dwithin(Expression<? extends Geometry> expr1, Expression<? extends Geometry> expr2, Expression<Double> distance) {
        return BooleanOperation.create(SpatialOps.DWITHIN, (Expression[])new Expression[]{expr1, expr2, distance});
    }

    public static BooleanExpression dwithin(Expression<? extends Geometry> expr1, Expression<? extends Geometry> expr2, double distance) {
        return BooleanOperation.create(SpatialOps.DWITHIN, (Expression[])new Expression[]{expr1, expr2, ConstantImpl.create((Object)distance)});
    }

    public static JTSGeometryExpression<?> extent(Expression<? extends GeometryCollection> collection) {
        return JTSGeometryOperation.create(Geometry.class, SpatialOps.EXTENT, collection);
    }

    public static JTSGeometryExpression<?> collect(Expression<? extends GeometryCollection> collection) {
        return JTSGeometryOperation.create(Geometry.class, SpatialOps.COLLECT, collection);
    }

    public static JTSGeometryExpression<?> collect(Expression<? extends Geometry> expr1, Expression<? extends Geometry> expr2) {
        return JTSGeometryOperation.create(Geometry.class, SpatialOps.COLLECT2, expr1, expr2);
    }

    public static <T extends Geometry> JTSGeometryExpression<T> translate(Expression<T> expr, float deltax, float deltay) {
        return JTSGeometryOperation.create(expr.getType(), SpatialOps.TRANSLATE, new Expression[]{expr, ConstantImpl.create((Object)Float.valueOf(deltax)), ConstantImpl.create((Object)Float.valueOf(deltay))});
    }

    public static <T extends Geometry> JTSGeometryExpression<T> translate(Expression<T> expr, float deltax, float deltay, float deltaz) {
        return JTSGeometryOperation.create(expr.getType(), SpatialOps.TRANSLATE2, new Expression[]{expr, ConstantImpl.create((Object)Float.valueOf(deltax)), ConstantImpl.create((Object)Float.valueOf(deltay)), ConstantImpl.create((Object)Float.valueOf(deltaz))});
    }

    private JTSGeometryExpressions() {
    }
}

