/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AgentConstants;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.AnyLogicLegacyAPI;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.UtilitiesCollection;
import com.anylogic.engine.database.TableInput;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.c;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.internal.km;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AgentList<E extends Agent>
implements c,
Serializable,
Iterable<E> {
    private static final long serialVersionUID = 7760065713819349936L;
    private transient TableInput a = null;
    private static final Function<TableInput, Integer> e = tableInput -> 1;
    @AnyLogicCustomSerialization
    private final transient Agent h;
    @AnyLogicCustomSerialization
    private transient Agent k;

    public AgentList(Agent agent) {
        if (agent == null) {
            ga.a(ae.ind, new Object[]{"owner"});
        }
        this.h = agent;
    }

    public Agent getOwner() {
        return this.h;
    }

    @AnyLogicInternalCodegenAPI
    public abstract void _add(E var1);

    @AnyLogicInternalCodegenAPI
    public abstract boolean _remove(Agent var1);

    @AnyLogicInternalCodegenAPI
    public void setEnvironment(Agent agent) {
        if (this.k != null) {
            this.getOwner().error(ae.lg);
        }
        this.k = agent;
        if (agent != null) {
            agent.ext(AgentConstants.EXT_ENVIRONMENT_INTERACTIVE).register_xjal(this);
        }
    }

    public Agent getEnvironment() {
        return this.k;
    }

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract boolean contains(Object var1);

    abstract km<E> e();

    public E random() {
        int n2 = this.size();
        if (n2 == 0) {
            return null;
        }
        Iterator<E> iterator = this.iterator();
        Agent agent = (Agent)iterator.next();
        int n3 = agent.uniform_discr(0, n2 - 1);
        while (n3 > 0) {
            agent = (Agent)iterator.next();
            --n3;
        }
        return (E)agent;
    }

    public E randomExcept(Agent agent) {
        E e2 = this.random();
        if (e2 == agent) {
            if (this.size() <= 1) {
                return null;
            }
            while ((e2 = this.random()) == agent) {
            }
        }
        return e2;
    }

    public List<E> findAll(Predicate<E> predicate) {
        return UtilitiesCollection.findAll(this, predicate);
    }

    public E findFirst(Predicate<E> predicate) {
        return (E)((Agent)UtilitiesCollection.findFirst(this, predicate));
    }

    public void onChange() {
        km<E> km2 = this.e();
        try {
            while (km2.hasNext()) {
                ((Agent)km2.next()).onChange();
            }
        }
        finally {
            km2.a();
        }
    }

    @AnyLogicLegacyAPI
    public double sum(String string, String string2) {
        return Utilities.a(this, string, string2);
    }

    public double sum(String string) {
        return Utilities.a(this, string);
    }

    @AnyLogicLegacyAPI
    public double average(String string, String string2) {
        return Utilities.e(this, string, string2);
    }

    public double average(String string) {
        return Utilities.e(this, string);
    }

    @Deprecated
    public double min(Collection<? extends Agent> collection, String string, String string2) {
        return this.min(string, string2);
    }

    @AnyLogicLegacyAPI
    public double min(String string, String string2) {
        return Utilities.h(this, string, string2);
    }

    public double min(String string) {
        return Utilities.h(this, string);
    }

    @AnyLogicLegacyAPI
    public double max(String string, String string2) {
        return Utilities.k(this, string, string2);
    }

    public double max(String string) {
        return Utilities.k(this, string);
    }

    public int count(String string) {
        return Utilities.d(this, string);
    }

    @Override
    @Deprecated
    @AnyLogicInternalCodegenAPI
    public final void restoreOwner(Object object) {
        for (Agent agent : this) {
            agent.restoreOwner(object);
        }
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public abstract Iterator<E> iterator();

    public abstract E get(int var1);

    int a(Object object) {
        throw new RuntimeException(ae.gf);
    }

    E k() {
        if (this.isEmpty()) {
            throw new RuntimeException(ae.bj);
        }
        return this.get(0);
    }

    @AnyLogicInternalCodegenAPI
    public E instantiateAgent(int n2) {
        throw new UnsupportedOperationException("This population doesn't support dynamic agent creation. More likely that it was generated in AnyLogic version < 7.2, in this case try rebuilding your model in the latest version of AnyLogic.");
    }

    @AnyLogicInternalCodegenAPI
    public void callSetupParameters(E e2, int n2) {
        this.callSetupParameters(e2, n2, null);
    }

    @AnyLogicInternalCodegenAPI
    public void callCreate(E e2, int n2) {
        this.callCreate(e2, n2, null);
    }

    @AnyLogicInternalCodegenAPI
    public void callSetupParameters(E e2, int n2, TableInput tableInput) {
        ((Agent)e2).setParametersToDefaultValues();
    }

    @AnyLogicInternalCodegenAPI
    public void callCreate(E e2, int n2, TableInput tableInput) {
        ((Agent)e2).create();
    }

    @AnyLogicInternalAPI
    public void fillFromTable(TableInput tableInput) {
        this.fillFromTable(tableInput, null, e, true, true);
    }

    @AnyLogicInternalAPI
    public void fillFromTable(TableInput tableInput, BiConsumer<TableInput, E> biConsumer, boolean bl, boolean bl2) {
        this.fillFromTable(tableInput, biConsumer, e, bl, bl2);
    }

    @AnyLogicInternalAPI
    public void fillFromTable(TableInput tableInput, BiConsumer<TableInput, E> biConsumer, Function<TableInput, Integer> function, boolean bl, boolean bl2) {
        bl |= bl2;
        this.a = tableInput;
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (TableInput tableInput2 = tableInput;){
                while (tableInput2.next()) {
                    int n2 = function.apply(tableInput2);
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = this.size();
                        E e2 = this.instantiateAgent(n4);
                        this.callSetupParameters(e2, n4, tableInput);
                        if (biConsumer != null) {
                            biConsumer.accept(tableInput2, e2);
                        }
                        if (bl) {
                            this.callCreate(e2, n4, tableInput);
                        }
                        if (bl2) {
                            ((Agent)e2).start();
                        }
                        ++n3;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.a = null;
        }
    }

    @AnyLogicInternalCodegenAPI
    public <T> T getValueFromTable(String string, Class<T> clazz) {
        if (this.a == null) {
            throw ga.a("%s: this function may be called only when population is being initialized (see fillFromTable function)", new Object[]{this.h.getNameOf(this)});
        }
        return this.a.getValue(string, clazz);
    }

    abstract Agent[] a();

    @AnyLogicInternalCodegenAPI
    public double getPresentationScaleOnOwnerSpace() {
        return this.isEmpty() ? 1.0 : ((Agent)this.k()).getPresentationScaleOnOwnerSpace();
    }

    @AnyLogicInternalCodegenAPI
    public boolean isPresentationEnabled() {
        return true;
    }
}

