/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.TableFunction;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.ga;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class CustomDistribution
implements Serializable {
    private static final long serialVersionUID = 370375483283313803L;
    public static final InterpolationType INTERPOLATION_NONE = InterpolationType.CUSTOM_DISTRIBUTION_INTERPOLATION_NONE;
    public static final InterpolationType INTERPOLATION_STEP = InterpolationType.CUSTOM_DISTRIBUTION_INTERPOLATION_STEP;
    public static final InterpolationType INTERPOLATION_LINEAR = InterpolationType.CUSTOM_DISTRIBUTION_INTERPOLATION_LINEAR;
    private boolean a = false;
    private Random e;
    @AnyLogicCustomSerialization
    private transient Utilities h;
    private final InterpolationType k;
    private final double[] d;
    private final double[] j;
    private final double[] c;
    private final double l;

    public CustomDistribution(int[] nArray, int[] nArray2) {
        this(nArray, CustomDistribution.a(nArray2, nArray));
        this.a = true;
    }

    public CustomDistribution(int[] nArray, int[] nArray2, Random random) {
        this(CustomDistribution.a(nArray), CustomDistribution.a(nArray2, nArray), random);
        this.a = true;
    }

    public CustomDistribution(int[] nArray, int[] nArray2, Utilities utilities) {
        this(CustomDistribution.a(nArray), CustomDistribution.a(nArray2, nArray), utilities);
        this.a = true;
    }

    public CustomDistribution(int[] nArray, double[] dArray) {
        this(CustomDistribution.a(nArray), CustomDistribution.a(dArray, nArray));
        this.a = true;
    }

    public CustomDistribution(int[] nArray, double[] dArray, Random random) {
        this(CustomDistribution.a(nArray), CustomDistribution.a(dArray, nArray), random);
        this.a = true;
    }

    public CustomDistribution(int[] nArray, double[] dArray, Utilities utilities) {
        this(CustomDistribution.a(nArray), CustomDistribution.a(dArray, nArray), utilities);
        this.a = true;
    }

    private static double[] a(int[] nArray) {
        double[] dArray = new double[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            dArray[n2] = nArray[n2];
            ++n2;
        }
        return dArray;
    }

    public CustomDistribution(double[] dArray, int[] nArray) {
        this(dArray, CustomDistribution.a(nArray, dArray), INTERPOLATION_STEP);
    }

    public CustomDistribution(double[] dArray, int[] nArray, Random random) {
        this(dArray, nArray);
        this.e = random;
    }

    public CustomDistribution(double[] dArray, int[] nArray, Utilities utilities) {
        this(dArray, nArray);
        this.h = utilities;
    }

    public CustomDistribution(double[] dArray, double[] dArray2) {
        this(dArray, CustomDistribution.a(dArray2, dArray), INTERPOLATION_STEP);
    }

    public CustomDistribution(double[] dArray, double[] dArray2, Random random) {
        this(dArray, dArray2);
        this.e = random;
    }

    public CustomDistribution(double[] dArray, double[] dArray2, Utilities utilities) {
        this(dArray, dArray2);
        this.h = utilities;
    }

    private static double[] a(int[] nArray, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n2 = 0;
        int n3 = Math.min(nArray.length, dArray.length);
        while (n2 < n3) {
            dArray2[n2] = nArray[n2];
            ++n2;
        }
        return dArray2;
    }

    private static double[] a(int[] nArray, int[] nArray2) {
        double[] dArray = new double[nArray2.length];
        int n2 = 0;
        int n3 = Math.min(nArray.length, nArray2.length);
        while (n2 < n3) {
            dArray[n2] = nArray[n2];
            ++n2;
        }
        return dArray;
    }

    private static double[] a(double[] dArray, int[] nArray) {
        double[] dArray2 = new double[nArray.length];
        int n2 = 0;
        int n3 = Math.min(dArray.length, nArray.length);
        while (n2 < n3) {
            dArray2[n2] = dArray[n2];
            ++n2;
        }
        return dArray2;
    }

    private static double[] a(double[] dArray, double[] dArray2) {
        return dArray.length == dArray2.length ? dArray : Arrays.copyOf(dArray, dArray2.length);
    }

    public CustomDistribution(double[] dArray, double[] dArray2, InterpolationType interpolationType) {
        int n2;
        boolean bl;
        this.d = dArray;
        this.j = dArray2;
        this.k = interpolationType;
        if (dArray.length != dArray2.length) {
            throw ga.a(this.h, ae.he);
        }
        if (dArray.length <= 1) {
            throw ga.a(this.h, ae.dj);
        }
        do {
            bl = false;
            n2 = 0;
            while (n2 < dArray.length - 1) {
                if (dArray[n2 + 1] < dArray[n2]) {
                    double d2 = dArray[n2];
                    dArray[n2] = dArray[n2 + 1];
                    dArray[n2 + 1] = d2;
                    double d3 = dArray2[n2];
                    dArray2[n2] = dArray2[n2 + 1];
                    dArray2[n2 + 1] = d3;
                    bl = true;
                }
                ++n2;
            }
        } while (bl);
        n2 = 0;
        while (n2 < dArray.length - 1) {
            if (dArray[n2] == dArray[n2 + 1]) {
                throw new RuntimeException(String.format(ae.ie, dArray[n2]));
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < dArray2.length - 1) {
            if (dArray2[n2] < 0.0) {
                throw new RuntimeException(String.format(ae.ef, dArray2[n2]));
            }
            ++n2;
        }
        double d4 = 0.0;
        this.c = new double[dArray.length];
        switch (interpolationType) {
            case CUSTOM_DISTRIBUTION_INTERPOLATION_NONE: {
                int n3 = 0;
                while (n3 < dArray2.length) {
                    this.c[n3] = d4;
                    d4 += dArray2[n3];
                    ++n3;
                }
                break;
            }
            case CUSTOM_DISTRIBUTION_INTERPOLATION_STEP: {
                int n4 = 1;
                while (n4 < dArray.length) {
                    this.c[n4] = d4 += (dArray[n4] - dArray[n4 - 1]) * dArray2[n4 - 1];
                    ++n4;
                }
                break;
            }
            case CUSTOM_DISTRIBUTION_INTERPOLATION_LINEAR: {
                int n5 = 1;
                while (n5 < dArray.length) {
                    this.c[n5] = d4 += (dArray[n5] - dArray[n5 - 1]) * (dArray2[n5] + dArray2[n5 - 1]) / 2.0;
                    ++n5;
                }
                break;
            }
            default: {
                throw new RuntimeException(String.format(ae.nc, new Object[]{interpolationType}));
            }
        }
        if (d4 <= 0.0) {
            throw ga.a(this.h, ae.hi);
        }
        this.l = d4;
    }

    public CustomDistribution(TableFunction tableFunction) {
        this(tableFunction.getArguments(), tableFunction.getValues(), CustomDistribution.a(tableFunction.getInterpolationType()));
    }

    public CustomDistribution(double[] dArray, double[] dArray2, InterpolationType interpolationType, Random random) {
        this(dArray, dArray2, interpolationType);
        this.e = random;
    }

    public CustomDistribution(double[] dArray, double[] dArray2, InterpolationType interpolationType, Utilities utilities) {
        this(dArray, dArray2, interpolationType);
        this.h = utilities;
    }

    public CustomDistribution(TableFunction tableFunction, Random random) {
        this(tableFunction);
        this.e = random;
    }

    public CustomDistribution(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            throw ga.a(this.h, ae.lm);
        }
        Arrays.sort(dArray);
        this.d = dArray;
        this.l = dArray.length - 1;
        this.j = null;
        this.c = null;
        this.k = INTERPOLATION_STEP;
    }

    public CustomDistribution(double[] dArray, Utilities utilities) {
        this(dArray);
        this.h = utilities;
    }

    public CustomDistribution(double[] dArray, Random random) {
        this(dArray);
        this.e = random;
    }

    public CustomDistribution(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            throw ga.a(this.h, ae.lm);
        }
        Arrays.sort(nArray);
        this.d = new double[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            this.d[n2] = nArray[n2];
            ++n2;
        }
        this.l = nArray.length;
        this.j = null;
        this.c = null;
        this.k = INTERPOLATION_NONE;
    }

    public CustomDistribution(int[] nArray, Random random) {
        this(nArray);
        this.e = random;
    }

    public CustomDistribution(int[] nArray, Utilities utilities) {
        this(nArray);
        this.h = utilities;
    }

    private Random k() {
        return this.h != null ? this.h.getDefaultRandomGenerator() : this.e;
    }

    public int getInt(Random random) {
        return (int)Math.floor(this.get(random));
    }

    public double get(Random random) {
        if (this.c == null) {
            if (this.k == INTERPOLATION_STEP) {
                int n2;
                double d2 = Utilities.uniform(0.0, this.l, random);
                int n3 = n2 = (int)Math.ceil(d2);
                while (++n3 < this.d.length && this.d[n3] == this.d[n2]) {
                }
                --n3;
                --n2;
                while (n2 >= 0 && this.d[n2] == this.d[n3]) {
                    --n2;
                }
                if (n2 < 0) {
                    return this.d[0];
                }
                if (n3 == n2) {
                    return this.d[n3];
                }
                double d3 = this.d[n2] + (this.d[n3] - this.d[n2]) * (d2 - (double)n2) / (double)(n3 - n2);
                if (this.a) {
                    d3 = Math.floor(d3);
                }
                return d3;
            }
            int n4 = Utilities.uniform_discr(0, this.d.length - 1, random);
            return this.d[n4];
        }
        double d4 = Utilities.uniform(0.0, this.l, random);
        int n5 = 0;
        int n6 = this.c.length - 1;
        while (n6 - n5 > 1) {
            int n7 = (n5 + n6) / 2;
            if (d4 < this.c[n7]) {
                n6 = n7;
                continue;
            }
            n5 = n7;
        }
        if (this.k == INTERPOLATION_NONE) {
            if (this.c[n6] <= d4) {
                return this.d[n6];
            }
            return this.d[n5];
        }
        if (this.c[n5] == this.c[n6]) {
            return this.d[n5];
        }
        if (this.k == INTERPOLATION_STEP) {
            double d5 = Utilities.uniform(random) * (this.d[n6] - this.d[n5]) + this.d[n5];
            if (this.a) {
                d5 = Math.floor(d5);
            }
            return d5;
        }
        double d6 = this.j[n5];
        double d7 = this.j[n6];
        double d8 = (d6 + d7) / 2.0;
        double d9 = this.a(random, d6 / d8, d7 / d8) * (this.d[n6] - this.d[n5]) + this.d[n5];
        if (this.a) {
            d9 = Math.floor(d9);
        }
        return d9;
    }

    public double get() {
        if (this.k() == null) {
            throw ga.a(this.h, ae.kc);
        }
        return this.get(this.k());
    }

    public int getInt() {
        if (this.k() == null) {
            throw ga.a(this.h, ae.kc);
        }
        return this.getInt(this.k());
    }

    public double get(double d2, double d3, double d4, double d5, Random random) {
        double d6;
        if (d2 > d3) {
            d6 = d3;
            d3 = d2;
            d2 = d6;
        } else if (d2 == d3) {
            return d2;
        }
        if (d5 == 0.0 && (d4 < d2 || d4 > d3)) {
            throw new RuntimeException(ae.gm);
        }
        while ((d6 = this.get(random) * d5 + d4) < d2 || d6 > d3) {
        }
        return d6;
    }

    public double get(double d2, double d3, double d4, double d5) {
        if (this.k() == null) {
            throw ga.a(this.h, ae.kc);
        }
        return this.get(d2, d3, d4, d5, this.k());
    }

    String a() {
        StringBuilder stringBuilder = new StringBuilder();
        this.a(stringBuilder);
        return stringBuilder.toString();
    }

    private void a(StringBuilder stringBuilder) {
        if (this.c == null) {
            stringBuilder.append(ae.jm);
            stringBuilder.append(this.k == INTERPOLATION_STEP ? ae.hb : ae.cj);
        } else {
            stringBuilder.append(ae.fe);
            switch (this.k) {
                case CUSTOM_DISTRIBUTION_INTERPOLATION_NONE: {
                    stringBuilder.append(ae.ca);
                    break;
                }
                case CUSTOM_DISTRIBUTION_INTERPOLATION_STEP: {
                    stringBuilder.append(ae.gn);
                    break;
                }
                case CUSTOM_DISTRIBUTION_INTERPOLATION_LINEAR: {
                    stringBuilder.append(ae.cn);
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(ae.ja);
        stringBuilder.append(ga.d);
        this.a(stringBuilder);
        stringBuilder.append(ga.d);
        stringBuilder.append(ae.gg).append(this.k() == null ? ae.mb : ae.gh);
        stringBuilder.append(ga.d);
        stringBuilder.append(this.d.length);
        if (this.j != null) {
            stringBuilder.append(ae.fh).append(ga.d);
            int n2 = 0;
            while (n2 < this.d.length) {
                stringBuilder.append(Utilities.format(this.d[n2])).append('\t').append(Utilities.format(this.j[n2])).append(ga.d);
                ++n2;
            }
        } else {
            stringBuilder.append(ae.fl).append(ga.d);
            int n3 = 0;
            int n4 = Math.min(100, this.d.length);
            while (n3 < n4) {
                stringBuilder.append(Utilities.format(this.d[n3])).append(ga.d);
                ++n3;
            }
            if (this.d.length > 100) {
                stringBuilder.append("...").append(ga.d);
            }
        }
        return stringBuilder.toString();
    }

    private double a(Random random, double d2, double d3) {
        if (d2 == d3) {
            return Utilities.uniform(random);
        }
        return (Math.sqrt(d2 * d2 + 2.0 * (d3 - d2) * Utilities.uniform(random)) - d2) / (d3 - d2);
    }

    private static InterpolationType a(TableFunction.InterpolationType interpolationType) {
        switch (interpolationType) {
            case INTERPOLATION_NONE: {
                return INTERPOLATION_NONE;
            }
            case INTERPOLATION_LINEAR: {
                return INTERPOLATION_LINEAR;
            }
            case INTERPOLATION_STEP: {
                return INTERPOLATION_STEP;
            }
        }
        throw new RuntimeException(String.format(ae.fa, new Object[]{interpolationType}));
    }

    public static enum InterpolationType {
        CUSTOM_DISTRIBUTION_INTERPOLATION_NONE,
        CUSTOM_DISTRIBUTION_INTERPOLATION_STEP,
        CUSTOM_DISTRIBUTION_INTERPOLATION_LINEAR;

    }
}

