/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Engine;
import com.anylogic.engine.Experiment;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.internal.gj;
import com.anylogic.engine.presentation.Presentation;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class ExperimentRunFast<ROOT extends Agent>
extends Experiment<ROOT> {
    private static final long serialVersionUID = -4736019522965827625L;
    private transient Engine j;
    private transient Thread c;
    private Experiment.State i = IDLE;
    private volatile boolean n = false;
    private long m;
    private long g;

    public ExperimentRunFast(boolean bl) {
        this.j = this.j();
    }

    Engine j() {
        Engine engine = new Engine();
        engine.setExperiment(this);
        this.initDefaultRandomNumberGenerator(engine);
        this.setupEngine(engine);
        return engine;
    }

    @Override
    public Engine getEngine() {
        return this.j;
    }

    @Override
    public final Experiment.State getState() {
        return this.i;
    }

    @Override
    public double getProgress() {
        if (this.i == IDLE) {
            return 0.0;
        }
        if (this.i == FINISHED || this.i == ERROR) {
            return 1.0;
        }
        return 0.1;
    }

    @Override
    public final double getRunTimeSeconds() {
        double d2 = this.i == RUNNING ? (double)(this.g + (System.currentTimeMillis() - this.m)) : (double)this.g;
        return d2 / 1000.0;
    }

    @Override
    public final void run() {
        if (!this.isCommandEnabled(RUN)) {
            return;
        }
        boolean bl = false;
        if (this.i == IDLE) {
            this.i = PLEASE_WAIT;
            this.h();
        } else {
            bl = true;
        }
        this.l();
        this.n = false;
        this.m = System.currentTimeMillis();
        this.i = RUNNING;
        n n2 = new n(bl, this.e());
        n2.start();
        n2.a();
    }

    final boolean c() {
        return this.n;
    }

    abstract String e();

    @Override
    public final void step() {
        if (!this.isCommandEnabled(STEP)) {
            return;
        }
        boolean bl = this.i == IDLE;
        this.i = PLEASE_WAIT;
        if (bl) {
            this.h();
        }
        this.n = true;
        this.m = System.currentTimeMillis();
        Throwable throwable = null;
        try {
            this.i = this.a(bl);
        }
        catch (Throwable throwable2) {
            ga.d(throwable2);
            this.i = ERROR;
            throwable = throwable2;
        }
        this.g += System.currentTimeMillis() - this.m;
        if (throwable != null) {
            this.getExperiment().getPresentation().showErrorDialog(ga.a(throwable), ae.lfh);
        }
    }

    @Override
    public final void pause() {
        if (!this.isCommandEnabled(PAUSE)) {
            return;
        }
        if (Thread.holdsLock(this.getMutexRead_xjal()) || Thread.holdsLock(this.getMutexWrite_xjal())) {
            this.modelExecutionCommandQueue.a(new Runnable(){

                @Override
                public void run() {
                    ExperimentRunFast.this.pause();
                }
            });
            return;
        }
        this.i = PLEASE_WAIT;
        this.n = true;
        this.k();
        this.g += System.currentTimeMillis() - this.m;
        this.i = PAUSED;
    }

    @Override
    public final void stop() {
        if (!this.isCommandEnabled(STOP) && this.getState() != Experiment.RUNNING) {
            return;
        }
        if (Thread.holdsLock(this.getMutexRead_xjal()) || Thread.holdsLock(this.getMutexWrite_xjal())) {
            this.modelExecutionCommandQueue.a(new Runnable(){

                @Override
                public void run() {
                    ExperimentRunFast.this.stop();
                }
            });
            return;
        }
        this.i = PLEASE_WAIT;
        this.n = true;
        this.k();
        this.g += System.currentTimeMillis() - this.m;
        this.i = IDLE;
        System.gc();
    }

    abstract Experiment.State a(boolean var1) throws Throwable;

    private void k() {
        Thread thread = this.c;
        if (thread != null && Thread.currentThread() != thread) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    void h() {
        this.reset();
        this.g = 0L;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.j = gj.a(objectInputStream);
    }

    @Override
    @AnyLogicInternalAPI
    public void registerPresentation_xjal(Presentation presentation) {
        super.registerPresentation_xjal(presentation);
        this.j.setPresentation(presentation);
    }

    private class n
    extends Thread {
        private boolean e = false;
        private final Object h = new Object();
        private final boolean k;

        public n(boolean bl, String string) {
            this.k = bl;
            this.setName(string);
            this.setDaemon(true);
            this.setPriority(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExperimentRunFast.this.c = Thread.currentThread();
            Object object = this.h;
            synchronized (object) {
                this.e = true;
                this.h.notify();
            }
            ExperimentRunFast.this.l();
            object = null;
            try {
                ExperimentRunFast.this.i = ExperimentRunFast.this.a(!this.k);
            }
            catch (Throwable throwable) {
                ga.d(throwable);
                object = throwable;
                ExperimentRunFast.this.i = ERROR;
            }
            ExperimentRunFast experimentRunFast = ExperimentRunFast.this;
            experimentRunFast.g = experimentRunFast.g + (System.currentTimeMillis() - ExperimentRunFast.this.m);
            ExperimentRunFast.this.getExperiment().getPresentation().refresh();
            ExperimentRunFast.this.c = null;
            if (object != null && ExperimentRunFast.this.getEngine() != null) {
                ExperimentRunFast.this.getEngine().a((Throwable)object, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void a() {
            Object object = this.h;
            synchronized (object) {
                while (true) {
                    if (this.e) {
                        return;
                    }
                    try {
                        this.h.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
    }
}

