/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.Dimension;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.ga;
import java.io.Serializable;
import java.util.Arrays;

public class HyperArray
implements Serializable {
    private static final long serialVersionUID = -78811125921911764L;
    public static final int INDEX_CAN_VARY = -1;
    private Dimension[] a;
    private int[] e;
    private double[] h;
    private static /* synthetic */ int[] k;

    public HyperArray(Dimension ... dimensionArray) {
        this.a = dimensionArray;
        this.e = new int[dimensionArray.length];
        int n2 = 1;
        int n3 = 0;
        while (n3 < dimensionArray.length) {
            n2 *= dimensionArray[n3].size();
            this.e[n3] = n3 == 0 ? 1 : this.e[n3 - 1] * dimensionArray[n3 - 1].size();
            ++n3;
        }
        this.h = new double[n2];
    }

    public HyperArray(double[] dArray, Dimension ... dimensionArray) {
        this(dimensionArray);
        System.arraycopy(dArray, 0, this.h, 0, Math.min(this.h.length, dArray.length));
    }

    public HyperArray(double d2, Dimension ... dimensionArray) {
        this(dimensionArray);
        Arrays.fill(this.h, d2);
    }

    public HyperArray(HyperArray hyperArray) {
        this.a = hyperArray.a;
        this.e = hyperArray.e;
        this.h = new double[hyperArray.h.length];
        System.arraycopy(hyperArray.h, 0, this.h, 0, this.h.length);
    }

    public Dimension[] getDimensions() {
        return this.a;
    }

    public int size() {
        return this.h.length;
    }

    public double[] getData() {
        return this.h;
    }

    public int getPosOf(int ... nArray) {
        if (nArray.length != this.a.length) {
            throw ga.k(ae.gdd);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.a.length) {
            int n4 = this.a[n3].getIndexPosition(nArray[n3]);
            if (n4 < 0) {
                throw new RuntimeException(String.format(ae.hll, this.a[n3].getName(), nArray[n3]));
            }
            n2 += n4 * this.e[n3];
            ++n3;
        }
        return n2;
    }

    public double get(int ... nArray) {
        return this.h[this.getPosOf(nArray)];
    }

    public void set(double d2, int ... nArray) {
        this.h[this.getPosOf((int[])nArray)] = d2;
    }

    public void set(double[] dArray) {
        System.arraycopy(dArray, 0, this.h, 0, Math.min(this.h.length, dArray.length));
    }

    public void setData(double[] dArray, int n2) {
        System.arraycopy(dArray, n2, this.h, 0, Math.min(this.h.length, dArray.length));
    }

    public void set(double d2) {
        Arrays.fill(this.h, d2);
    }

    public void copyFrom(HyperArray hyperArray) {
        System.arraycopy(hyperArray.h, 0, this.h, 0, this.h.length);
    }

    void a(HyperArray hyperArray) {
        int n2 = 0;
        int n3 = Math.min(this.h.length, hyperArray.h.length);
        while (n2 < n3) {
            int n4 = n2;
            this.h[n4] = this.h[n4] + hyperArray.h[n2];
            ++n2;
        }
    }

    public double sum() {
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < this.h.length) {
            d2 += this.h[n2];
            ++n2;
        }
        return d2;
    }

    public double prod() {
        double d2 = 1.0;
        int n2 = 0;
        while (n2 < this.h.length) {
            d2 *= this.h[n2];
            ++n2;
        }
        return d2;
    }

    public double average() {
        return this.h.length > 0 ? this.sum() / (double)this.h.length : 0.0;
    }

    public double stddev() {
        if (this.h.length < 2) {
            return 0.0;
        }
        double d2 = 0.0;
        double d3 = this.average();
        int n2 = 0;
        while (n2 < this.h.length) {
            double d4 = this.h[n2] - d3;
            d2 += d4 * d4;
            ++n2;
        }
        return Math.sqrt(d2 / (double)this.h.length / (double)(this.h.length - 1));
    }

    public double min() {
        double d2 = Double.POSITIVE_INFINITY;
        int n2 = 0;
        while (n2 < this.h.length) {
            if (this.h[n2] < d2) {
                d2 = this.h[n2];
            }
            ++n2;
        }
        return d2;
    }

    public double max() {
        double d2 = Double.NEGATIVE_INFINITY;
        int n2 = 0;
        while (n2 < this.h.length) {
            if (this.h[n2] > d2) {
                d2 = this.h[n2];
            }
            ++n2;
        }
        return d2;
    }

    public boolean equal(HyperArray hyperArray) {
        if (!Arrays.equals(this.a, hyperArray.a)) {
            return false;
        }
        return Arrays.equals(this.h, hyperArray.h);
    }

    public boolean equal(double d2) {
        int n2 = 0;
        while (n2 < this.h.length) {
            if (this.h[n2] != d2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean hasNegativeValues() {
        int n2 = 0;
        while (n2 < this.h.length) {
            if (this.h[n2] < 0.0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public double sum(int ... nArray) {
        return this.a(n.a, 0.0, nArray);
    }

    public double prod(int ... nArray) {
        return this.a(n.e, 0.0, nArray);
    }

    public double min(int ... nArray) {
        return this.a(n.h, 0.0, nArray);
    }

    public double max(int ... nArray) {
        return this.a(n.k, 0.0, nArray);
    }

    public void increment(int ... nArray) {
        this.a(n.d, 1.0, nArray);
    }

    public void incrementBy(double d2, int ... nArray) {
        this.a(n.d, d2, nArray);
    }

    public void decrement(int ... nArray) {
        this.a(n.d, -1.0, nArray);
    }

    public void decrementBy(double d2, int ... nArray) {
        this.a(n.d, -d2, nArray);
    }

    public void multiply(double d2, int ... nArray) {
        this.a(n.j, d2, nArray);
    }

    private double a(n n2, double d2, int ... nArray) {
        boolean bl;
        double d3;
        block0 : switch (HyperArray.a()[n2.ordinal()]) {
            case 1: {
                d3 = 0.0;
                break;
            }
            case 2: {
                d3 = 1.0;
                break;
            }
            case 3: {
                d3 = Double.POSITIVE_INFINITY;
                break;
            }
            case 4: {
                d3 = Double.NEGATIVE_INFINITY;
                break;
            }
            case 5: 
            case 6: {
                d3 = 0.0;
                int n3 = 0;
                while (n3 < nArray.length) {
                    if (nArray[n3] == -1) break block0;
                    ++n3;
                }
                n3 = this.getPosOf(nArray);
                switch (HyperArray.a()[n2.ordinal()]) {
                    case 5: {
                        int n4 = n3;
                        this.h[n4] = this.h[n4] + d2;
                        return 0.0;
                    }
                    case 6: {
                        int n5 = n3;
                        this.h[n5] = this.h[n5] * d2;
                        return 0.0;
                    }
                }
            }
            default: {
                throw new RuntimeException("HyperArray.operationOnSubset: illegal operation code: " + (Object)((Object)n2));
            }
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        int n6 = 0;
        while (n6 < nArray.length) {
            if (nArray[n6] == -1) {
                nArray2[n6] = this.a[n6].indexes[0];
            }
            ++n6;
        }
        block21: do {
            n6 = this.getPosOf(nArray2);
            double d4 = this.h[n6];
            switch (HyperArray.a()[n2.ordinal()]) {
                case 1: {
                    d3 += d4;
                    break;
                }
                case 2: {
                    d3 *= d4;
                    break;
                }
                case 3: {
                    if (!(d4 < d3)) break;
                    d3 = d4;
                    break;
                }
                case 4: {
                    if (!(d3 < d4)) break;
                    d3 = d4;
                    break;
                }
                case 5: {
                    this.h[n6] = d4 + d2;
                    break;
                }
                case 6: {
                    this.h[n6] = d4 * d2;
                }
            }
            bl = true;
            int n7 = 0;
            while (n7 < nArray.length) {
                if (nArray[n7] == -1) {
                    int n8 = this.a[n7].getIndexPosition(nArray2[n7]) + 1;
                    if (n8 < this.a[n7].size()) {
                        nArray2[n7] = this.a[n7].indexes[n8];
                        bl = false;
                        continue block21;
                    }
                    nArray2[n7] = this.a[n7].indexes[0];
                }
                ++n7;
            }
        } while (!bl);
        return d3;
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.a.length > 0) {
            stringBuilder.append("[ ");
        }
        int n3 = 0;
        while (n3 < this.a.length) {
            stringBuilder.append(this.a[n3].getName());
            stringBuilder.append(n3 == this.a.length - 1 ? " ]" : ", ");
            ++n3;
        }
        if (this.a.length == 0) {
            return String.valueOf(stringBuilder.toString()) + Utilities.format(this.h[0]);
        }
        Dimension dimension = this.a[0];
        int n4 = 0;
        int n5 = 0;
        while (n5 < dimension.size()) {
            n4 = Math.max(n4, dimension.getIndexName(dimension.indexes[n5]).length());
            ++n5;
        }
        if (this.a.length == 1) {
            n5 = 0;
            while (n5 < dimension.size()) {
                int n6 = dimension.indexes[n5];
                stringBuilder.append(ga.d);
                HyperArray.a(stringBuilder, dimension.getIndexName(n6), n4);
                stringBuilder.append(Utilities.format(this.h[n5]));
                ++n5;
            }
            return stringBuilder.toString();
        }
        Dimension dimension2 = this.a[1];
        int[] nArray = new int[this.a.length];
        int n7 = 2;
        while (n7 < this.a.length) {
            nArray[n7] = this.a[n7].indexes[0];
            ++n7;
        }
        int[] nArray2 = new int[dimension2.size()];
        block4: do {
            int n8;
            if (this.a.length > 2) {
                stringBuilder.append(ga.d).append("[ .., .., ");
                n2 = 2;
                while (n2 < this.a.length) {
                    stringBuilder.append(this.a[n2].getIndexName(nArray[n2]));
                    stringBuilder.append(n2 < this.a.length - 1 ? ", " : " ]:");
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < dimension2.size()) {
                nArray2[n2] = dimension2.getIndexName(dimension2.indexes[n2]).length();
                ++n2;
            }
            n2 = 0;
            while (n2 < dimension.size()) {
                nArray[0] = dimension.indexes[n2];
                n8 = 0;
                while (n8 < dimension2.size()) {
                    nArray[1] = dimension2.indexes[n8];
                    nArray2[n8] = Math.max(nArray2[n8], Utilities.format(this.get(nArray)).length());
                    ++n8;
                }
                ++n2;
            }
            stringBuilder.append(ga.d);
            HyperArray.a(stringBuilder, "", n4);
            n2 = 0;
            while (n2 < dimension2.size()) {
                HyperArray.a(stringBuilder, dimension2.getIndexName(dimension2.indexes[n2]), nArray2[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < dimension.size()) {
                nArray[0] = dimension.indexes[n2];
                stringBuilder.append(ga.d);
                HyperArray.a(stringBuilder, dimension.getIndexName(nArray[0]), n4);
                n8 = 0;
                while (n8 < dimension2.size()) {
                    nArray[1] = dimension2.indexes[n8];
                    HyperArray.a(stringBuilder, Utilities.format(this.get(nArray)), nArray2[n8]);
                    ++n8;
                }
                ++n2;
            }
            n2 = 1;
            n8 = 2;
            while (n8 < this.a.length) {
                int n9 = this.a[n8].getIndexPosition(nArray[n8]) + 1;
                if (n9 < this.a[n8].size()) {
                    nArray[n8] = this.a[n8].indexes[n9];
                    n2 = 0;
                    continue block4;
                }
                nArray[n8] = this.a[n8].indexes[0];
                ++n8;
            }
        } while (n2 == 0);
        return stringBuilder.toString();
    }

    private static void a(StringBuilder stringBuilder, String string, int n2) {
        n2 = n2 - string.length() + 3;
        stringBuilder.append(string);
        int n3 = 0;
        while (n3 < n2) {
            stringBuilder.append(' ');
            ++n3;
        }
    }

    static /* synthetic */ int[] a() {
        if (k != null) {
            return k;
        }
        int[] nArray = new int[n.values().length];
        try {
            nArray[n.d.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[n.k.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[n.h.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[n.e.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[n.j.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[n.a.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        k = nArray;
        return nArray;
    }

    private static enum n {
        a,
        e,
        h,
        k,
        d,
        j;

    }
}

