/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.AnyLogicCustomAliasProposal;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.Locatable2D;
import com.anylogic.engine.Utilities;
import java.io.Serializable;

public class Point
implements Locatable2D,
Serializable,
Cloneable {
    private static final long serialVersionUID = -4566503726441441352L;
    public double x;
    public double y;
    public double z;

    public Point() {
    }

    public Point(Point point) {
        this(point.x, point.y, point.z);
    }

    public Point(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    @AnyLogicCustomAliasProposal(params={"latitude", "longitude"})
    public Point(double d2, double d3) {
        this.x = d2;
        this.y = d3;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Point setLocation(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        return this;
    }

    @AnyLogicCustomAliasProposal(params={"latitude", "longitude"})
    public Point setLocation(double d2, double d3) {
        this.x = d2;
        this.y = d3;
        return this;
    }

    public Point setLatLon(double d2, double d3) {
        this.x = d2;
        this.y = d3;
        return this;
    }

    public Point setLocation(Point point) {
        return this.setLocation(point.x, point.y, point.z);
    }

    public Point add(Point point) {
        this.x += point.x;
        this.y += point.y;
        this.z += point.z;
        return this;
    }

    public Point sub(Point point) {
        this.x -= point.x;
        this.y -= point.y;
        this.z -= point.z;
        return this;
    }

    public double distanceSq(Point point) {
        return Utilities.getDistanceSq(this.x, this.y, this.z, point.x, point.y, point.z);
    }

    public double distanceSq2D(Point point) {
        return Utilities.getDistanceSq(this.x, this.y, point.x, point.y);
    }

    public double distanceSq(double d2, double d3) {
        return Utilities.getDistanceSq(this.x, this.y, d2, d3);
    }

    public double distance(double d2, double d3) {
        return Utilities.getDistance(this.x, this.y, d2, d3);
    }

    public double distanceSq(double d2, double d3, double d4) {
        return Utilities.getDistanceSq(this.x, this.y, this.z, d2, d3, d4);
    }

    public double distance(double d2, double d3, double d4) {
        return Utilities.getDistance(this.x, this.y, this.z, d2, d3, d4);
    }

    public double distance(Point point) {
        return Utilities.getDistance(this.x, this.y, this.z, point.x, point.y, point.z);
    }

    public double distanceGIS(Point point) {
        return Utilities.getDistanceGIS(this.x, this.y, point.x, point.y);
    }

    public double distanceGIS(Point point, LengthUnits lengthUnits) {
        return Utilities.getDistanceGIS(this.x, this.y, point.x, point.y, lengthUnits);
    }

    public double distanceGIS(double d2, double d3) {
        return Utilities.getDistanceGIS(this.x, this.y, d2, d3);
    }

    public double distanceGIS(double d2, double d3, LengthUnits lengthUnits) {
        return Utilities.getDistanceGIS(this.x, this.y, d2, d3, lengthUnits);
    }

    public double distance2D(Point point) {
        return Utilities.getDistance(this.x, this.y, point.x, point.y);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Point clone() {
        try {
            return (Point)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int n2 = 1;
        long l2 = Double.doubleToLongBits(this.x);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.y);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.z);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Point point = (Point)object;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(point.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(point.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(point.z);
    }

    public boolean equals(Point point, double d2) {
        if (point == null) {
            return false;
        }
        return this.a(this.x, point.x, d2) && this.a(this.y, point.y, d2) && this.a(this.z, point.z, d2);
    }

    private boolean a(double d2, double d3, double d4) {
        return Math.abs(d2 - d3) <= d4 * Math.max(Math.abs(d2), Math.abs(d3));
    }

    public Point clone(Point point) {
        return point != null ? point.setLocation(this) : this.clone();
    }

    public double getLatitude() {
        return this.x;
    }

    public double getLongitude() {
        return this.y;
    }
}

