/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.TableFunction;
import com.anylogic.engine.internal.ae;

public class SDUtilities {
    private SDUtilities() {
        throw new UnsupportedOperationException();
    }

    public static double getTableFunctionArea(TableFunction tableFunction, double d2, double d3) {
        if (d2 >= d3) {
            return 0.0;
        }
        SDUtilities.a(tableFunction);
        double[] dArray = tableFunction.getArguments();
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double[] dArray2 = tableFunction.getValues();
        int n2 = tableFunction.a(d2);
        int n3 = tableFunction.a(d3);
        if (n2 == dArray.length - 1) {
            return (d3 - d2) * dArray2[n2];
        }
        double d4 = 0.0;
        if (n3 == 0) {
            d4 += (dArray[n3] - d2) * dArray2[n3];
        }
        if (n3 == dArray.length - 1) {
            d4 += (d3 - dArray[n3]) * dArray2[n3];
            --n3;
        }
        if (n2 == 0) {
            d4 += (dArray[n2] - d2) * dArray2[n2];
        }
        int n4 = n2;
        while (n4 <= n3) {
            double d5 = dArray[n4];
            double d6 = dArray2[n4];
            double d7 = dArray[n4 + 1];
            double d8 = dArray[n4 + 1];
            if (d2 > d5) {
                d6 += (d8 - d6) * (d2 - d5) / (d7 - d5);
                d5 = d2;
            }
            if (d3 < d7) {
                d8 += (d8 - d6) * (d3 - d5) / (d7 - d5);
                d7 = d3;
            }
            d4 += (d7 - d5) * (d8 + d6) / 2.0;
            ++n4;
        }
        return d4;
    }

    public static double lookupExtrapolate(TableFunction tableFunction, double d2) {
        SDUtilities.a(tableFunction);
        double[] dArray = tableFunction.getArguments();
        double[] dArray2 = tableFunction.getValues();
        int n2 = dArray.length - 1;
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            return dArray2[0];
        }
        if (d2 < dArray[0]) {
            return dArray2[0] + (dArray2[1] - dArray2[0]) * (d2 - dArray[0]) / (dArray[1] - dArray[0]);
        }
        if (d2 > dArray[n2]) {
            return dArray2[n2 - 1] + (dArray2[n2] - dArray2[n2 - 1]) * (d2 - dArray[n2 - 1]) / (dArray[n2] - dArray[n2 - 1]);
        }
        return tableFunction.get(d2);
    }

    public static double lookupSlope(TableFunction tableFunction, double d2, double d3) {
        SDUtilities.a(tableFunction);
        double[] dArray = tableFunction.getArguments();
        double[] dArray2 = tableFunction.getValues();
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (d3 < 0.0) {
            if (d2 <= dArray[0] || d2 >= dArray[dArray.length - 1]) {
                return Double.NaN;
            }
        } else if (d3 == 0.0 && (d2 < dArray[0] || d2 > dArray[dArray.length - 1])) {
            return 0.0;
        }
        if (dArray.length == 1) {
            return 0.0;
        }
        int n2 = tableFunction.a(d2);
        if (n2 == dArray.length - 1) {
            --n2;
        }
        double d4 = (dArray2[n2 + 1] - dArray2[n2]) / (dArray[n2 + 1] - dArray[n2]);
        if (d3 == 0.0 && (d2 == dArray[dArray.length - 1] || d2 == dArray[0])) {
            return d4 / 2.0;
        }
        if (d2 == dArray[n2] && n2 > 0) {
            d4 += (dArray2[n2] - dArray2[n2 - 1]) / (dArray[n2] - dArray[n2 - 1]);
            d4 /= 2.0;
        }
        return d4;
    }

    public static double lookupBackward(TableFunction tableFunction, double d2) {
        SDUtilities.a(tableFunction);
        double[] dArray = tableFunction.getArguments();
        double[] dArray2 = tableFunction.getValues();
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (d2 < dArray[0]) {
            return dArray2[0];
        }
        int n2 = tableFunction.a(d2);
        return dArray2[n2];
    }

    public static double lookupForward(TableFunction tableFunction, double d2) {
        SDUtilities.a(tableFunction);
        double[] dArray = tableFunction.getArguments();
        double[] dArray2 = tableFunction.getValues();
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (d2 < dArray[0]) {
            return dArray2[0];
        }
        int n2 = tableFunction.a(d2);
        if (n2 == dArray.length - 1 || dArray[n2] == d2) {
            return dArray2[n2];
        }
        return dArray2[n2 + 1];
    }

    public static double lookupInvert(TableFunction tableFunction, double d2) {
        SDUtilities.a(tableFunction);
        double[] dArray = tableFunction.getArguments();
        double[] dArray2 = tableFunction.getValues();
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            return d2 == dArray2[0] ? dArray[0] : Double.NaN;
        }
        int n2 = 0;
        int n3 = dArray.length - 2;
        while (n2 <= n3) {
            if (dArray2[n2 + 1] >= dArray2[n2] ? d2 >= dArray2[n2] && d2 <= dArray2[n2 + 1] : d2 <= dArray2[n2] && d2 >= dArray2[n2 + 1]) {
                double d3 = dArray[n2];
                if (dArray2[n2] != dArray2[n2 + 1]) {
                    d3 += (dArray[n2 + 1] - dArray[n2]) * (d2 - dArray2[n2]) / (dArray2[n2 + 1] - dArray2[n2]);
                }
                return d3;
            }
            ++n2;
        }
        return Double.NaN;
    }

    private static void a(TableFunction tableFunction) {
        if (tableFunction.getInterpolationType() != TableFunction.INTERPOLATION_LINEAR) {
            throw new IllegalArgumentException(ae.nma);
        }
        if (tableFunction.getOutOfRangeAction() != TableFunction.OUTOFRANGE_NEAREST) {
            throw new IllegalArgumentException(ae.ecb);
        }
    }
}

