/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Pair;
import com.anylogic.engine.internal.ga;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

@AnyLogicInternalAPI
public class TableTransferable
implements Transferable {
    public static final DataFlavor xmlDataFlavor = TableTransferable.e();
    public static final DataFlavor textDataFlavor;
    private static DataFlavor[] a;
    private List<List<Object>> e;
    private List<Integer> h = null;
    private static final SimpleDateFormat k;

    static {
        FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
        if (flavorMap instanceof SystemFlavorMap) {
            SystemFlavorMap systemFlavorMap = (SystemFlavorMap)flavorMap;
            systemFlavorMap.addUnencodedNativeForFlavor(xmlDataFlavor, xmlDataFlavor.getHumanPresentableName());
        }
        textDataFlavor = DataFlavor.stringFlavor;
        a = new DataFlavor[]{textDataFlavor, xmlDataFlavor};
        k = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    public TableTransferable(List<List<Object>> list) {
        this.e = list;
    }

    public TableTransferable(List<List<Object>> list, List<Integer> list2) {
        this(list);
        this.h = list2;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return a;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = a;
        int n2 = a.length;
        int n3 = 0;
        while (n3 < n2) {
            DataFlavor dataFlavor2 = dataFlavorArray[n3];
            if (dataFlavor2.equals(dataFlavor)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(textDataFlavor)) {
            return TableTransferable.toString(this.e);
        }
        if (dataFlavor.equals(xmlDataFlavor)) {
            return TableTransferable.toXmlString(this.e, this.h).getBytes();
        }
        return "";
    }

    public static String toString(List<List<Object>> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (List<Object> list2 : list) {
            Iterator<Object> iterator = list2.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuilder.append('\t');
            }
            stringBuilder.append(ga.d);
        }
        return stringBuilder.toString();
    }

    public static String toXmlString(List<List<Object>> list, List<Integer> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\"?>\n<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"\n xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\">\n<Styles>\n\t<Style ss:ID=\"s70\">\n\t\t<NumberFormat ss:Format=\"dd/mm/yyyy\\ h:mm:ss\"/>\n\t</Style>\n</Styles>\n  <Worksheet ss:Name=\"Sheet1\">\n    <Table>\n");
        for (List<Object> list3 : list) {
            if (list3.size() == 0) continue;
            stringBuilder.append("      <Row>\n");
            boolean bl = list2 != null;
            n n2 = null;
            int n3 = 0;
            while (n3 < list3.size()) {
                Object object = list3.get(n3);
                String string = "String";
                String string2 = null;
                if (bl) {
                    n2 = n.a(list2.get(n3));
                    string = n2.toString();
                    string2 = n2.a(object);
                } else {
                    try {
                        Double.parseDouble(object.toString());
                        string = "Number";
                    }
                    catch (NumberFormatException numberFormatException) {
                        string = "String";
                    }
                    string2 = object.toString();
                }
                stringBuilder.append("        <Cell");
                if (bl && n2 == n.e) {
                    stringBuilder.append(" ss:StyleID=\"s70\"");
                }
                stringBuilder.append("><Data ss:Type=\"");
                stringBuilder.append(string);
                stringBuilder.append("\">");
                stringBuilder.append(string2);
                stringBuilder.append("</Data></Cell>\n");
                ++n3;
            }
            stringBuilder.append("      </Row>\n");
        }
        stringBuilder.append("    </Table>\n  </Worksheet>\n</Workbook>  ");
        return stringBuilder.toString();
    }

    public static byte[] getExcelClipboardData() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Object object = clipboard.getData(xmlDataFlavor);
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            return null;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private static DataFlavor e() {
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = SystemFlavorMap.decodeDataFlavor("XML Spreadsheet");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (dataFlavor == null) {
            dataFlavor = new DataFlavor("xml/x;class=\"[B\"", "XML Spreadsheet");
            SystemFlavorMap systemFlavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
            systemFlavorMap.addUnencodedNativeForFlavor(dataFlavor, "XML Spreadsheet");
            systemFlavorMap.addFlavorForUnencodedNative("XML Spreadsheet", dataFlavor);
            return dataFlavor;
        }
        return dataFlavor;
    }

    public static List<List<Pair<Integer, Object>>> getExcelData(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, byArray.length - 2);
        int n2 = byteArrayInputStream.available();
        char[] cfr_ignored_0 = new char[n2];
        byte[] cfr_ignored_1 = new byte[n2];
        ArrayList<List<Pair<Integer, Object>>> arrayList = new ArrayList<List<Pair<Integer, Object>>>();
        ArrayList<Pair<Integer, Object>> arrayList2 = new ArrayList<Pair<Integer, Object>>();
        try {
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(byteArrayInputStream);
            block2: while (xMLStreamReader.hasNext()) {
                xMLStreamReader.next();
                if (xMLStreamReader.getEventType() == 1) {
                    int n3;
                    int n4;
                    if (xMLStreamReader.getLocalName().equals("Row")) {
                        arrayList2 = new ArrayList();
                        continue;
                    }
                    if (xMLStreamReader.getLocalName().equals("Cell")) {
                        int n5 = xMLStreamReader.getAttributeCount();
                        n4 = 0;
                        while (n4 < n5) {
                            if (xMLStreamReader.getAttributeLocalName(n4).equals("Index")) {
                                n3 = Integer.valueOf(xMLStreamReader.getAttributeValue(n4));
                                while (arrayList2.size() < n3 - 1) {
                                    arrayList2.add(null);
                                }
                                break;
                            }
                            ++n4;
                        }
                        arrayList2.add(null);
                        continue;
                    }
                    if (!xMLStreamReader.getLocalName().equals("Data")) continue;
                    n4 = xMLStreamReader.getAttributeCount();
                    n3 = 0;
                    while (n3 < n4) {
                        if (xMLStreamReader.getAttributeLocalName(n3).equals("Type")) {
                            String string = xMLStreamReader.getAttributeValue(n3);
                            n n6 = n.valueOf(string);
                            Pair<Integer, Object> pair = new Pair<Integer, Object>(n6.a()[0], n6.a(xMLStreamReader.getElementText()));
                            arrayList2.remove(arrayList2.size() - 1);
                            arrayList2.add(pair);
                            continue block2;
                        }
                        ++n3;
                    }
                    continue;
                }
                if (xMLStreamReader.getEventType() != 2 || !xMLStreamReader.getLocalName().equals("Row")) continue;
                arrayList.add(arrayList2);
            }
            xMLStreamReader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
        return arrayList;
    }

    private static Timestamp e(String string) {
        Date date = null;
        try {
            date = k.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    private static enum n {
        a(string -> Double.valueOf(string), object -> object.toString(), 2),
        e(string -> TableTransferable.a(string), object -> object == null ? "" : k.format(object), 93),
        h(string -> string.equals("1"), object -> object == null ? "0" : (object.equals(Boolean.TRUE) ? "1" : "0"), 16, -7),
        k(string -> Double.valueOf(string), object -> object == null ? "0" : object.toString(), 8, 4, 6, -5),
        d(string -> string, object -> object == null ? "" : ga.h(object), -1, 12, 1);

        private final int[] j;
        private final Function<String, Object> c;
        private final Function<Object, String> l;

        private n(Function<String, Object> function, Function<Object, String> function2, int ... nArray) {
            this.c = function;
            this.l = function2;
            this.j = nArray;
        }

        public static n a(Integer n2) {
            n[] nArray = n.values();
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                n n5 = nArray[n4];
                int[] nArray2 = n5.j;
                int n6 = n5.j.length;
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = nArray2[n7];
                    if (n8 == n2) {
                        return n5;
                    }
                    ++n7;
                }
                ++n4;
            }
            return d;
        }

        private int[] a() {
            return this.j;
        }

        private Object a(String string) {
            return this.c.apply(string);
        }

        private String a(Object object) {
            return this.l.apply(object);
        }
    }
}

