/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.AgentList;
import com.anylogic.engine.AnyLogicInternalAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.stream.Stream;

public final class UtilitiesCollection {
    public static <T> List<T> filter(Iterable<T> iterable, Predicate<T> predicate) {
        List<T> list = UtilitiesCollection.h(iterable);
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> filter(T[] TArray, Predicate<T> predicate) {
        List<T> list = UtilitiesCollection.a(TArray.length);
        T[] TArray2 = TArray;
        int n2 = TArray.length;
        int n3 = 0;
        while (n3 < n2) {
            T t = TArray2[n3];
            if (predicate.test(t)) {
                list.add(t);
            }
            ++n3;
        }
        return list;
    }

    public static <T> List<T> findAll(Iterable<T> iterable, Predicate<T> predicate) {
        List<T> list = UtilitiesCollection.h(iterable);
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> findAll(T[] TArray, Predicate<T> predicate) {
        List<T> list = UtilitiesCollection.a(TArray.length);
        T[] TArray2 = TArray;
        int n2 = TArray.length;
        int n3 = 0;
        while (n3 < n2) {
            T t = TArray2[n3];
            if (predicate.test(t)) {
                list.add(t);
            }
            ++n3;
        }
        return list;
    }

    public static <T> T findFirst(Iterable<T> iterable, Predicate<T> predicate) {
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> T findFirst(T[] TArray, Predicate<T> predicate) {
        T[] TArray2 = TArray;
        int n2 = TArray.length;
        int n3 = 0;
        while (n3 < n2) {
            T t = TArray2[n3];
            if (predicate.test(t)) {
                return t;
            }
            ++n3;
        }
        return null;
    }

    public static <T> int count(Iterable<T> iterable, Predicate<T> predicate) {
        int n2 = 0;
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            ++n2;
        }
        return n2;
    }

    public static <T> double max(Iterable<T> iterable, ToDoubleFunction<T> toDoubleFunction) {
        double d2 = Double.NEGATIVE_INFINITY;
        for (T t : iterable) {
            d2 = Math.max(d2, toDoubleFunction.applyAsDouble(t));
        }
        return d2;
    }

    public static <T> double maxWhere(Iterable<T> iterable, ToDoubleFunction<T> toDoubleFunction, Predicate<T> predicate) {
        double d2 = Double.NEGATIVE_INFINITY;
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            d2 = Math.max(d2, toDoubleFunction.applyAsDouble(t));
        }
        return d2;
    }

    public static <T> double min(Iterable<T> iterable, ToDoubleFunction<T> toDoubleFunction) {
        double d2 = Double.POSITIVE_INFINITY;
        for (T t : iterable) {
            d2 = Math.min(d2, toDoubleFunction.applyAsDouble(t));
        }
        return d2;
    }

    public static <T> double minWhere(Iterable<T> iterable, ToDoubleFunction<T> toDoubleFunction, Predicate<T> predicate) {
        double d2 = Double.POSITIVE_INFINITY;
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            d2 = Math.min(d2, toDoubleFunction.applyAsDouble(t));
        }
        return d2;
    }

    public static <T> double sum(Iterable<T> iterable, ToDoubleFunction<T> toDoubleFunction) {
        double d2 = 0.0;
        for (T t : iterable) {
            d2 += toDoubleFunction.applyAsDouble(t);
        }
        return d2;
    }

    public static <T> double sumWhere(Iterable<T> iterable, ToDoubleFunction<T> toDoubleFunction, Predicate<T> predicate) {
        double d2 = 0.0;
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            d2 += toDoubleFunction.applyAsDouble(t);
        }
        return d2;
    }

    public static <T> double average(Iterable<T> iterable, ToDoubleFunction<T> toDoubleFunction) {
        double d2 = 0.0;
        int n2 = 0;
        for (T t : iterable) {
            d2 += toDoubleFunction.applyAsDouble(t);
            ++n2;
        }
        return d2 / (double)n2;
    }

    public static <T> double averageWhere(Iterable<T> iterable, ToDoubleFunction<T> toDoubleFunction, Predicate<T> predicate) {
        double d2 = 0.0;
        int n2 = 0;
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            d2 += toDoubleFunction.applyAsDouble(t);
            ++n2;
        }
        return d2 / (double)n2;
    }

    public static <T> T top(Iterable<T> iterable, ToDoubleFunction<T> toDoubleFunction) {
        double d2 = Double.NEGATIVE_INFINITY;
        T t = null;
        for (T t2 : iterable) {
            double d3 = toDoubleFunction.applyAsDouble(t2);
            if (!(d2 < d3)) continue;
            d2 = d3;
            t = t2;
        }
        return t;
    }

    public static <T> List<T> sortAscending(Iterable<T> iterable, final ToDoubleFunction<T> toDoubleFunction) {
        List<T> list = UtilitiesCollection.h(iterable);
        for (T t : iterable) {
            list.add(t);
        }
        list.sort(new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                double d2 = toDoubleFunction.applyAsDouble(t);
                double d3 = toDoubleFunction.applyAsDouble(t2);
                return Double.compare(d2, d3);
            }
        });
        return list;
    }

    public static <T> List<T> sortDescending(Iterable<T> iterable, final ToDoubleFunction<T> toDoubleFunction) {
        List<T> list = UtilitiesCollection.h(iterable);
        for (T t : iterable) {
            list.add(t);
        }
        list.sort(new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                double d2 = toDoubleFunction.applyAsDouble(t);
                double d3 = toDoubleFunction.applyAsDouble(t2);
                return Double.compare(d3, d2);
            }
        });
        return list;
    }

    @SafeVarargs
    public static <T> boolean addAll(Collection<? super T> collection, T ... TArray) {
        return Collections.addAll(collection, TArray);
    }

    public static <T> boolean addAll(Collection<? super T> collection, Collection<T> collection2) {
        return collection.addAll(collection2);
    }

    private UtilitiesCollection() {
        throw new UnsupportedOperationException();
    }

    private static <T> List<T> h(Iterable<T> iterable) {
        int n2 = iterable instanceof Collection ? ((Collection)iterable).size() : (iterable instanceof AgentList ? ((AgentList)iterable).size() : 10);
        return UtilitiesCollection.a(n2);
    }

    private static <T> List<T> a(int n2) {
        ArrayList arrayList = new ArrayList(n2);
        return arrayList;
    }

    static int a(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        if (iterable instanceof AgentList) {
            return ((AgentList)iterable).size();
        }
        int n2 = 0;
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n2;
        }
        return n2;
    }

    static boolean e(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        if (iterable instanceof AgentList) {
            return ((AgentList)iterable).isEmpty();
        }
        return false;
    }

    @AnyLogicInternalAPI
    @SafeVarargs
    public static <T> Stream<T> streamOfElements(Collection<? extends T> ... collectionArray) {
        return Arrays.stream(collectionArray).flatMap(collection -> collection.stream());
    }

    @AnyLogicInternalAPI
    @SafeVarargs
    public static <T> Stream<T> streamOfElements(Stream<? extends T> ... streamArray) {
        return Arrays.stream(streamArray).flatMap(stream -> stream);
    }
}

