/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.analysis;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.analysis.Chart;
import com.anylogic.engine.analysis.ChartItem;
import com.anylogic.engine.analysis.HistogramData;
import com.anylogic.engine.analysis.h;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.internal.i;
import com.anylogic.engine.internal.m;
import com.anylogic.engine.internal.presentation.e;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Histogram
extends Chart {
    private static final long serialVersionUID = 7136519752178127449L;
    private List<HistogramData> ai;
    private List<Appearance> hn;
    private double lg;
    private double gf;
    private double km;
    private h ba;
    private h ld;
    private transient Rectangle2D.Double cf = new Rectangle2D.Double();

    @Deprecated
    public Histogram(Presentable presentable, boolean bl, int n2, int n3, int n4, int n5, Color color, Color color2, int n6, int n7, int n8, int n9, Color color3, Color color4, Color color5, int n10, Chart.Direction direction, Chart.GridPosition gridPosition, Chart.GridPosition gridPosition2, Color color6, Color color7, boolean bl2, boolean bl3, boolean bl4, double d2, List<HistogramData> list, List<String> list2, List<Appearance> list3) {
        this(presentable, bl, (double)n2, (double)n3, (double)n4, (double)n5, color, color2, (double)n6, (double)n7, (double)n8, (double)n9, color3, color4, color5, (double)n10, direction, gridPosition, gridPosition2, color6, color7, bl2, bl3, bl4, d2, list, list2, list3);
    }

    public Histogram(Presentable presentable, boolean bl, double d2, double d3, double d4, double d5, Color color, Color color2, double d6, double d7, double d8, double d9, Color color3, Color color4, Color color5, double d10, Chart.Direction direction, Chart.GridPosition gridPosition, Chart.GridPosition gridPosition2, Color color6, Color color7, boolean bl2, boolean bl3, boolean bl4, double d11, List<HistogramData> list, List<String> list2, List<Appearance> list3) {
        super(presentable, bl, d2, d3, d4, d5, color, color2, d6, d7, d8, d9, color3, color4, color5, d10, direction, list2);
        this.n.showPDF = bl2;
        this.n.showCDF = bl3;
        this.n.showMean = bl4;
        this.n.relativeBarWidth = d11;
        this.n.gridPositionX = gridPosition;
        this.n.gridPositionY = gridPosition2;
        this.n.gridLineColor = color6;
        this.n.gridTextColor = color7;
        if (list == null) {
            this.ai = new ArrayList<HistogramData>();
            this.hn = new ArrayList<Appearance>();
        } else {
            this.ai = list;
            this.hn = list3;
        }
        this.ai();
    }

    @AnyLogicInternalAPI
    public Histogram(Presentable presentable, int n2, int n3) {
        super(presentable, n2, n3);
        this.ai = this.mf.getShapeChartHistograms(n2, n3);
        this.hn = this.mf.getShapeChartHistogramOptions(n2, n3);
        this.ai();
    }

    public void addHistogram(HistogramData histogramData, String string, Color color, Color color2, Color color3, Color color4, float f2, Color color5) {
        this.addHistogram(histogramData, string, new Appearance(color, color2, color3, color4, f2, color5));
    }

    public void addHistogram(HistogramData histogramData, String string, Appearance appearance) {
        this.ai.add(histogramData);
        this.g.add(string);
        this.hn.add(appearance);
        this.a(string);
        this.j();
    }

    @Override
    protected int a(ChartItem chartItem) {
        int n2 = super.a(chartItem);
        if (n2 >= 0) {
            this.hn.remove(n2);
        }
        return n2;
    }

    public Appearance getAppearance(int n2) {
        return this.hn.get(n2);
    }

    @Override
    public void refresh() {
        this.lg = Double.POSITIVE_INFINITY;
        this.gf = Double.NEGATIVE_INFINITY;
        this.km = 0.0;
        for (HistogramData histogramData : this.ai) {
            if (histogramData.getXMin() < this.lg) {
                this.lg = histogramData.getXMin();
            }
            if (histogramData.getXMax() > this.gf) {
                this.gf = histogramData.getXMax();
            }
            if (!(histogramData.getMaxPDF() > this.km)) continue;
            this.km = histogramData.getMaxPDF();
        }
        this.km *= 100.0;
        if (this.ba != null) {
            this.ba.a(this.lg, this.gf);
        }
        if (this.ld != null) {
            this.ld.a(0.0, this.km);
        }
        super.refresh();
    }

    private void ai() {
        for (HistogramData histogramData : this.ai) {
            if (histogramData != null) continue;
            throw ga.a(this.mf, ae.jfk);
        }
        if (this.g.size() != this.ai.size() || this.hn.size() != this.ai.size()) {
            throw ga.a(this.mf, ae.mea);
        }
        this.m = this.ai;
        if (this.n.gridPositionX != GRID_NONE) {
            this.ba = new h(EAST, false, false, this.n.gridPositionX, com.anylogic.engine.internal.presentation.e.a(), this.n.gridLineColor, this.n.gridTextColor, true);
            this.ba.e(this.n.picWidth, this.n.picHeight);
        }
        if (this.n.gridPositionY != GRID_NONE) {
            this.ld = new h(NORTH, false, false, this.n.gridPositionY, com.anylogic.engine.internal.presentation.e.a(), this.n.gridLineColor, this.n.gridTextColor, true);
            this.ba.e(this.n.picWidth, this.n.picHeight);
            this.ld.a("#0'%'");
        }
        int n2 = 0;
        while (n2 < this.ai.size()) {
            this.a((String)this.g.get(n2));
            ++n2;
        }
    }

    @Override
    protected void a(Graphics2D graphics2D, int n2, int n3) {
        super.a(graphics2D, n2, n3);
        if (this.ba != null) {
            this.ba.e(n2, n3);
        }
        if (this.ld != null) {
            this.ld.e(n2, n3);
        }
        if (this.ai.size() > 0) {
            graphics2D.setClip(0, 0, n2, n3);
            double d2 = this.ba == null ? this.lg : this.ba.h();
            double d3 = this.ba == null ? this.gf : this.ba.k();
            double d4 = (this.ld == null ? this.km : this.ld.k()) / 100.0;
            if (!this.c()) {
                int n4 = 0;
                while (n4 < this.ai.size()) {
                    this.a(graphics2D, n4, false, d2, d3, d4, n2, n3);
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < this.ai.size()) {
                    if (!this.a(n5)) {
                        this.a(graphics2D, n5, true, d2, d3, d4, n2, n3);
                    }
                    ++n5;
                }
                n5 = 0;
                while (n5 < this.ai.size()) {
                    if (this.a(n5)) {
                        this.a(graphics2D, n5, false, d2, d3, d4, n2, n3);
                    }
                    ++n5;
                }
            }
            graphics2D.setClip(null);
        }
        if (this.ba != null) {
            this.ba.a(graphics2D);
        }
        if (this.ld != null) {
            this.ld.a(graphics2D);
        }
    }

    private void a(Graphics2D graphics2D, int n2, boolean bl, double d2, double d3, double d4, int n3, int n4) {
        int n5;
        HistogramData histogramData = this.ai.get(n2);
        Appearance appearance = this.hn.get(n2);
        if (histogramData.count() == 0) {
            return;
        }
        int n6 = histogramData.e();
        int n7 = n6 + histogramData.h();
        double d5 = (histogramData.getXMin() - d2) / (d3 - d2) * (double)n3;
        double d6 = (histogramData.getXMax() - histogramData.getXMin()) / (d3 - d2) * (double)n3;
        double d7 = d6 / (double)histogramData.h();
        double d8 = d7 * this.n.relativeBarWidth;
        double d9 = (d7 - d8) / 2.0;
        if (this.n.showPDF) {
            n5 = n6;
            while (n5 < n7) {
                double d10 = (int)(d5 + (double)(n5 - n6) * d7 + d9);
                double d11 = histogramData.getPDF(n5) / d4 * (double)n4;
                this.a(graphics2D, histogramData, appearance, n5, d10, d8, d11, bl, n4);
                ++n5;
            }
        }
        if (histogramData.c && this.n.showCDF) {
            graphics2D.setColor(bl ? a : appearance.k);
            graphics2D.setStroke(appearance.d);
            n5 = n6;
            while (n5 < n7) {
                int n8 = (int)(d5 + (double)(n5 - n6) * d7);
                int n9 = (int)((double)n4 * (1.0 - (n5 == n6 ? 0.0 : histogramData.getCDF(n5 - 1))));
                int n10 = (int)((double)n4 * (1.0 - histogramData.getCDF(n5)));
                graphics2D.drawLine(n8, n9, n8 + (int)d7, n10);
                ++n5;
            }
        }
        if (this.n.showMean) {
            n5 = (int)(d5 + (histogramData.mean() - histogramData.getXMin()) / (histogramData.getXMax() - histogramData.getXMin()) * d6);
            graphics2D.setColor(bl ? a : appearance.j);
            graphics2D.setStroke(appearance.d);
            graphics2D.drawLine(n5, 0, n5, n4);
        }
    }

    private void a(Graphics2D graphics2D, HistogramData histogramData, Appearance appearance, int n2, double d2, double d3, double d4, boolean bl, int n3) {
        if (!bl && histogramData.c && histogramData.k) {
            if (n2 < histogramData.m) {
                graphics2D.setColor(appearance.a);
            } else {
                if (n2 == histogramData.m) {
                    double d5 = d3 / 2.0;
                    graphics2D.setColor(appearance.a);
                    this.cf.setFrame(d2, (double)n3 - d4, d5, d4);
                    graphics2D.fill(this.cf);
                    graphics2D.setColor(n2 == histogramData.g ? appearance.e : appearance.h);
                    this.cf.setFrame(d2 + d5, (double)n3 - d4, d5, d4);
                    graphics2D.fill(this.cf);
                    return;
                }
                if (histogramData.m < n2 && n2 < histogramData.g) {
                    graphics2D.setColor(appearance.h);
                } else {
                    if (n2 == histogramData.g) {
                        double d6 = d3 / 2.0;
                        graphics2D.setColor(appearance.h);
                        this.cf.setFrame(d2, (double)n3 - d4, d6, d4);
                        graphics2D.fill(this.cf);
                        graphics2D.setColor(appearance.e);
                        this.cf.setFrame(d2 + d6, (double)n3 - d4, d6, d4);
                        graphics2D.fill(this.cf);
                        return;
                    }
                    graphics2D.setColor(appearance.e);
                }
            }
        } else {
            graphics2D.setColor(bl ? a : appearance.h);
        }
        this.cf.setFrame(d2, (double)n3 - d4, d3, d4);
        graphics2D.fill(this.cf);
        if (bl) {
            graphics2D.setColor(e);
            graphics2D.setStroke(com.anylogic.engine.internal.presentation.e.e());
            graphics2D.draw(this.cf);
        }
    }

    @Override
    protected void a(Graphics2D graphics2D, int n2) {
        HistogramData histogramData = this.ai.get(n2);
        Appearance appearance = this.hn.get(n2);
        graphics2D.setColor(histogramData.c && histogramData.k ? appearance.a : appearance.h);
        graphics2D.fillRect(5, 10, 2, 4);
        graphics2D.setColor(appearance.h);
        graphics2D.fillRect(7, 7, 2, 7);
        graphics2D.fillRect(9, 5, 2, 9);
        graphics2D.fillRect(11, 6, 2, 8);
        graphics2D.fillRect(13, 8, 2, 6);
        graphics2D.setColor(histogramData.c && histogramData.k ? appearance.e : appearance.h);
        graphics2D.fillRect(15, 10, 2, 4);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.cf = new Rectangle2D.Double();
    }

    public static class Appearance
    extends m
    implements Serializable {
        private static final String c = "Mean color";
        private static final String l = "CDF line width";
        private static final String f = "CDF color";
        private static final String i = "PDF color";
        private static final String n = "High percent color";
        private static final String m = "Low percent color";
        private static final long serialVersionUID = 1284306480267868680L;
        Color a;
        Color e;
        Color h;
        Color k;
        transient BasicStroke d;
        Color j;

        public Appearance(Color color, Color color2, Color color3, Color color4, float f2, Color color5) {
            this.a = color;
            this.e = color2;
            this.h = color3;
            this.k = color4;
            this.d = new BasicStroke(f2);
            this.j = color5;
        }

        @Override
        protected void e(Map<String, String> map) {
            map.put(m, com.anylogic.engine.internal.i.a(this.a));
            map.put(n, com.anylogic.engine.internal.i.a(this.e));
            map.put(i, com.anylogic.engine.internal.i.a(this.h));
            map.put(f, com.anylogic.engine.internal.i.a(this.k));
            map.put(l, com.anylogic.engine.internal.i.a(this.d.getLineWidth()));
            map.put(c, com.anylogic.engine.internal.i.a(this.j));
        }

        @Override
        protected void a(Map<String, String> map) throws Exception {
            String string = map.get(m);
            if (string == null) {
                throw Appearance.e(m);
            }
            this.a = com.anylogic.engine.internal.i.e(string);
            string = map.get(n);
            if (string == null) {
                throw Appearance.e(n);
            }
            this.e = com.anylogic.engine.internal.i.e(string);
            string = map.get(i);
            if (string == null) {
                throw Appearance.e(i);
            }
            this.h = com.anylogic.engine.internal.i.e(string);
            string = map.get(f);
            if (string == null) {
                throw Appearance.e(f);
            }
            this.k = com.anylogic.engine.internal.i.e(string);
            string = map.get(l);
            if (string == null) {
                throw Appearance.e(l);
            }
            this.d = new BasicStroke((float)com.anylogic.engine.internal.i.a(string));
            string = map.get(c);
            if (string == null) {
                throw Appearance.e(c);
            }
            this.j = com.anylogic.engine.internal.i.e(string);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeFloat(this.d.getLineWidth());
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.d = new BasicStroke(objectInputStream.readFloat());
        }
    }
}

