/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.connectivity;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.Dimension;
import com.anylogic.engine.HyperArray;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.TableFunction;
import com.anylogic.engine.analysis.DataSet;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.presentation.Presentation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelFile
implements Serializable {
    private static final long serialVersionUID = -6295880442986746704L;
    public static final int CELL_TYPE_BLANK = 3;
    public static final int CELL_TYPE_BOOLEAN = 4;
    public static final int CELL_TYPE_ERROR = 5;
    public static final int CELL_TYPE_FORMULA = 2;
    public static final int CELL_TYPE_NUMERIC = 0;
    public static final int CELL_TYPE_STRING = 1;
    private String a;
    private final Pattern e;
    private transient Workbook h;
    private static final int k = 1;
    private static final int d = 2;
    private static final int j = 4;
    private static final int c = 6;
    private int l;
    @AnyLogicCustomSerialization
    private transient Presentable f;
    private String i;

    @Deprecated
    public ExcelFile(String string, boolean bl) {
        this(null, null, string, bl);
    }

    public ExcelFile(Presentable presentable, String string, String string2, boolean bl) {
        this.f = presentable;
        this.i = string;
        if (string2 == null) {
            throw new IllegalArgumentException(ae.mec);
        }
        this.a = string2;
        this.l = bl ? 4 : 0;
        this.e = Pattern.compile("(?:([^\\!]+)\\!)?([a-zA-Z]+)(\\d+)");
    }

    public void setFileName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ae.mec);
        }
        if (string.equals(this.a)) {
            return;
        }
        this.a = string;
        this.setChanged();
        this.l &= 0xFFFFFFFE;
    }

    public void readFile() {
        try {
            InputStream inputStream = null;
            if (this.f != null && this.f.getPresentation().getMode() == Presentation.Mode.MODE_APPLET) {
                Object object = ga.e(this.f, this.i, this.a);
                if (object instanceof URL) {
                    URL uRL = (URL)object;
                    inputStream = uRL.openStream();
                }
            } else {
                inputStream = new FileInputStream(this.a);
                this.l |= 1;
                this.l &= 0xFFFFFFFD;
            }
            this.a(inputStream);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(String.format(ae.ejg, this.a, throwable.toString()), throwable);
        }
    }

    public boolean isLoaded() {
        return this.h != null;
    }

    public void close() {
        this.h = null;
        this.l &= 0xFFFFFFFC;
    }

    public int getCellType(int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, false);
        return cell.getCellType();
    }

    public int getCellType(String string, int n2, int n3) {
        return this.getCellType(this.a(string), n2, n3);
    }

    public boolean getCellBooleanValue(int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, false);
        return cell.getBooleanCellValue();
    }

    public double getCellNumericValue(int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, false);
        return cell.getNumericCellValue();
    }

    public String getCellStringValue(int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, false);
        return cell.getRichStringCellValue().getString();
    }

    public String getCellFormula(int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, false);
        return cell.getCellFormula();
    }

    public byte getCellErrorValue(int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, false);
        return cell.getErrorCellValue();
    }

    public Date getCellDateValue(int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, false);
        return cell.getDateCellValue();
    }

    public Workbook getWorkbook() {
        return this.h;
    }

    public boolean getCellBooleanValue(String string, int n2, int n3) {
        return this.getCellBooleanValue(this.a(string), n2, n3);
    }

    public double getCellNumericValue(String string, int n2, int n3) {
        return this.getCellNumericValue(this.a(string), n2, n3);
    }

    public String getCellStringValue(String string, int n2, int n3) {
        return this.getCellStringValue(this.a(string), n2, n3);
    }

    public String getCellFormula(String string, int n2, int n3) {
        return this.getCellFormula(this.a(string), n2, n3);
    }

    public byte getCellErrorValue(String string, int n2, int n3) {
        return this.getCellErrorValue(this.a(string), n2, n3);
    }

    public Date getCellDateValue(String string, int n2, int n3) {
        return this.getCellDateValue(this.a(string), n2, n3);
    }

    public int getCellType(String string) {
        int[] nArray = this.e(string);
        return this.getCellType(nArray[0], nArray[1], nArray[2]);
    }

    public boolean getCellBooleanValue(String string) {
        int[] nArray = this.e(string);
        return this.getCellBooleanValue(nArray[0], nArray[1], nArray[2]);
    }

    public double getCellNumericValue(String string) {
        int[] nArray = this.e(string);
        return this.getCellNumericValue(nArray[0], nArray[1], nArray[2]);
    }

    public String getCellStringValue(String string) {
        int[] nArray = this.e(string);
        return this.getCellStringValue(nArray[0], nArray[1], nArray[2]);
    }

    public String getCellFormula(String string) {
        int[] nArray = this.e(string);
        return this.getCellFormula(nArray[0], nArray[1], nArray[2]);
    }

    public byte getCellErrorValue(String string) {
        int[] nArray = this.e(string);
        return this.getCellErrorValue(nArray[0], nArray[1], nArray[2]);
    }

    public Date getCellDateValue(String string) {
        int[] nArray = this.e(string);
        return this.getCellDateValue(nArray[0], nArray[1], nArray[2]);
    }

    public int getNumberOfSheets() {
        this.a();
        return this.h.getNumberOfSheets();
    }

    public int getLastRowNum(int n2) {
        this.a();
        Sheet sheet = this.a(n2 - 1);
        return sheet.getLastRowNum() + 1;
    }

    public int getLastRowNum(String string) {
        return this.getLastRowNum(this.a(string));
    }

    public int getFirstRowNum(int n2) {
        this.a();
        Sheet sheet = this.a(n2 - 1);
        return sheet.getFirstRowNum() + 1;
    }

    public int getFirstRowNum(String string) {
        return this.getFirstRowNum(this.a(string));
    }

    public int getFirstCellNum(int n2, int n3) {
        this.a();
        Sheet sheet = this.a(n2 - 1);
        Row row = this.a(sheet, n3 - 1);
        return row.getFirstCellNum() + 1;
    }

    public int getFirstCellNum(String string, int n2) {
        return this.getFirstCellNum(this.a(string), n2);
    }

    public int getLastCellNum(int n2, int n3) {
        this.a();
        Sheet sheet = this.a(n2 - 1);
        Row row = this.a(sheet, n3 - 1);
        return Math.max(0, row.getLastCellNum());
    }

    public int getLastCellNum(String string, int n2) {
        return this.getLastCellNum(this.a(string), n2);
    }

    public boolean cellExists(int n2, int n3, int n4) {
        this.a();
        --n3;
        --n4;
        if (--n2 < 0 || this.h.getNumberOfSheets() <= n2) {
            return false;
        }
        Sheet sheet = this.h.getSheetAt(n2);
        Row row = sheet.getRow(n3);
        if (row == null) {
            return false;
        }
        Cell cell = row.getCell(n4);
        return cell != null;
    }

    public boolean cellExists(String string, int n2, int n3) {
        return this.cellExists(this.a(string), n2, n3);
    }

    public boolean cellExists(String string) {
        int[] nArray = this.e(string);
        return this.cellExists(nArray[0], nArray[1], nArray[2]);
    }

    public void clearCell(int n2, int n3, int n4) {
        try {
            Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, false);
            cell.setCellValue("");
            cell.setCellType(3);
        }
        catch (Exception exception) {}
    }

    public int readTableFunction(TableFunction tableFunction, int n2, int n3, int n4, int n5) {
        if (n5 == 0) {
            int n6 = n3;
            while (this.cellExists(n2, n6, n4) && this.a(this.a(n2 - 1, n6 - 1, n4 - 1, false)) && this.cellExists(n2, n6, n4 + 1) && this.a(this.a(n2 - 1, n6 - 1, n4, false))) {
                ++n6;
            }
            n5 = n6 - n3;
        }
        if (n5 == 0) {
            return 0;
        }
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        int n7 = 0;
        while (n7 < n5) {
            dArray[n7] = this.getCellNumericValue(n2, n3 + n7, n4);
            dArray2[n7] = this.getCellNumericValue(n2, n3 + n7, n4 + 1);
            ++n7;
        }
        tableFunction.setArgumentsAndValues(dArray, dArray2);
        return n5;
    }

    public int readTableFunction(TableFunction tableFunction, String string, int n2, int n3, int n4) {
        return this.readTableFunction(tableFunction, this.a(string), n2, n3, n4);
    }

    public int readTableFunction(TableFunction tableFunction, String string, int n2) {
        int[] nArray = this.e(string);
        return this.readTableFunction(tableFunction, nArray[0], nArray[1], nArray[2], n2);
    }

    public int getCellFormulaType(int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, false);
        return cell.getCachedFormulaResultType();
    }

    public int getCellFormulaType(String string, int n2, int n3) {
        return this.getCellFormulaType(this.a(string), n2, n3);
    }

    public int getCellFormulaType(String string) {
        int[] nArray = this.e(string);
        return this.getCellFormulaType(nArray[0], nArray[1], nArray[2]);
    }

    public String getSheetName(int n2) {
        this.a();
        this.a(n2 - 1);
        return this.h.getSheetName(n2 - 1);
    }

    public int getSheetIndex(String string) {
        return this.a(string);
    }

    public void readHyperArray(HyperArray hyperArray, int n2, int n3, int n4, boolean bl) {
        if (hyperArray == null) {
            throw new RuntimeException(ae.cdi);
        }
        Dimension[] dimensionArray = hyperArray.getDimensions();
        Dimension dimension = dimensionArray[0];
        if (dimensionArray.length == 1) {
            int n5 = dimension.size();
            int n6 = 0;
            while (n6 < n5) {
                double d2 = bl ? this.getCellNumericValue(n2, n3 + n6, n4) : this.getCellNumericValue(n2, n3, n4 + n6);
                int n7 = dimension.getIndexByPosition(n6);
                hyperArray.set(d2, n7);
                ++n6;
            }
        } else if (dimensionArray.length == 2) {
            int n8;
            int n9;
            Dimension dimension2 = dimensionArray[1];
            if (bl) {
                n9 = dimension.size();
                n8 = dimension2.size();
            } else {
                n9 = dimension2.size();
                n8 = dimension.size();
            }
            int n10 = 0;
            while (n10 < n9) {
                int n11 = 0;
                while (n11 < n8) {
                    int n12;
                    int n13;
                    double d3 = this.getCellNumericValue(n2, n3 + n10, n4 + n11);
                    if (bl) {
                        n13 = dimension.getIndexByPosition(n10);
                        n12 = dimension2.getIndexByPosition(n11);
                    } else {
                        n13 = dimension.getIndexByPosition(n11);
                        n12 = dimension2.getIndexByPosition(n10);
                    }
                    hyperArray.set(d3, n13, n12);
                    ++n11;
                }
                ++n10;
            }
        } else {
            throw new RuntimeException(ae.cdi);
        }
    }

    public void readHyperArray(HyperArray hyperArray, String string, int n2, int n3, boolean bl) {
        this.readHyperArray(hyperArray, this.a(string), n2, n3, bl);
    }

    public void readHyperArray(HyperArray hyperArray, String string, boolean bl) {
        int[] nArray = this.e(string);
        this.readHyperArray(hyperArray, nArray[0], nArray[1], nArray[2], bl);
    }

    public void writeFile() {
        this.writeFile(false);
    }

    public void writeFile(boolean bl) {
        if (!bl && (this.l & 2) == 0) {
            return;
        }
        if (this.f != null && this.f.getPresentation() != null && this.f.getPresentation().getMode() == Presentation.Mode.MODE_APPLET) {
            throw new RuntimeException(ae.cjf);
        }
        this.a();
        File file = null;
        File file2 = new File(this.a);
        try {
            if (file2.exists()) {
                int n2 = 2;
                String string = String.valueOf(this.a) + ".bak";
                do {
                    file = new File(string);
                    string = String.valueOf(this.a) + ".bak_" + n2;
                    ++n2;
                } while (file.exists());
                file2.renameTo(file);
            }
        }
        catch (Exception exception) {
            file = null;
        }
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                this.a(fileOutputStream);
            }
            this.l &= 0xFFFFFFFD;
            this.l |= 1;
            try {
                file.delete();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            if (file2.exists()) {
                try {
                    file2.delete();
                }
                catch (Exception exception2) {}
            }
            try {
                file.renameTo(file2);
            }
            catch (Exception exception3) {}
            throw new RuntimeException(exception.toString());
        }
    }

    public void setChanged() {
        this.l |= 2;
    }

    public void createCell(int n2, int n3, int n4) {
        Cell cell;
        this.a();
        Sheet sheet = this.a(n2 - 1);
        Row row = sheet.getRow(n3 - 1);
        if (row == null) {
            row = sheet.createRow(n3 - 1);
        }
        if ((cell = row.getCell(n4 - 1)) == null) {
            row.createCell(n4 - 1);
        }
        this.setChanged();
    }

    public void createCell(String string, int n2, int n3) {
        this.createCell(this.a(string), n2, n3);
    }

    public void createCell(String string) {
        int[] nArray = this.e(string);
        this.createCell(nArray[0], nArray[1], nArray[2]);
    }

    public void setCellValue(boolean bl, int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, true);
        cell.setCellValue(bl);
        this.setChanged();
    }

    public void setCellValue(double d2, int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, true);
        cell.setCellValue(d2);
        this.setChanged();
    }

    public void setCellValue(String string, int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, true);
        cell.setCellValue(this.h.getCreationHelper().createRichTextString(string));
        this.setChanged();
    }

    public void setCellValue(Date date, int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, true);
        cell.setCellValue(date);
        this.setChanged();
    }

    public void setCellFormula(String string, int n2, int n3, int n4) {
        Cell cell = this.a(n2 - 1, n3 - 1, n4 - 1, true);
        cell.setCellFormula(string);
        this.setChanged();
    }

    public void setCellValue(boolean bl, String string, int n2, int n3) {
        this.setCellValue(bl, this.a(string), n2, n3);
    }

    public void setCellValue(double d2, String string, int n2, int n3) {
        this.setCellValue(d2, this.a(string), n2, n3);
    }

    public void setCellValue(String string, String string2, int n2, int n3) {
        this.setCellValue(string, this.a(string2), n2, n3);
    }

    public void setCellValue(Date date, String string, int n2, int n3) {
        this.setCellValue(date, this.a(string), n2, n3);
    }

    public void setCellFormula(String string, String string2, int n2, int n3) {
        this.setCellFormula(string, this.a(string2), n2, n3);
    }

    public void setCellValue(boolean bl, String string) {
        int[] nArray = this.e(string);
        this.setCellValue(bl, nArray[0], nArray[1], nArray[2]);
    }

    public void setCellValue(double d2, String string) {
        int[] nArray = this.e(string);
        this.setCellValue(d2, nArray[0], nArray[1], nArray[2]);
    }

    public void setCellValue(String string, String string2) {
        int[] nArray = this.e(string2);
        this.setCellValue(string, nArray[0], nArray[1], nArray[2]);
    }

    public void setCellValue(Date date, String string) {
        int[] nArray = this.e(string);
        this.setCellValue(date, nArray[0], nArray[1], nArray[2]);
    }

    public void setCellFormula(String string, String string2) {
        int[] nArray = this.e(string2);
        this.setCellFormula(string, nArray[0], nArray[1], nArray[2]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(String.format(ae.lnm, this.a));
        stringBuilder.append(ga.d);
        if (this.h == null) {
            stringBuilder.append(ae.mgk);
        } else {
            int n2 = this.getNumberOfSheets();
            stringBuilder.append(String.format(ae.mdc, n2)).append(ga.d);
            int n3 = 0;
            while (n3 < n2) {
                stringBuilder.append("  ").append(this.h.getSheetName(n3)).append(ga.d);
                ++n3;
            }
        }
        return stringBuilder.toString();
    }

    public int writeDataSet(DataSet dataSet, int n2, int n3, int n4) {
        this.a();
        Sheet sheet = this.a(n2 - 1);
        --n3;
        --n4;
        int n5 = 0;
        while (n5 < dataSet.size()) {
            Cell cell;
            Cell cell2;
            int n6 = n3 + n5;
            Row row = sheet.getRow(n6);
            if (row == null) {
                row = sheet.createRow(n6);
            }
            if ((cell2 = row.getCell(n4)) == null) {
                cell2 = row.createCell(n4);
            }
            if ((cell = row.getCell(n4 + 1)) == null) {
                cell = row.createCell(n4 + 1);
            }
            cell2.setCellValue(dataSet.getX(n5));
            cell.setCellValue(dataSet.getY(n5));
            ++n5;
        }
        this.setChanged();
        return dataSet.size();
    }

    public int writeDataSet(DataSet dataSet, String string, int n2, int n3) {
        return this.writeDataSet(dataSet, this.a(string), n2, n3);
    }

    public int writeDataSet(DataSet dataSet, String string) {
        int[] nArray = this.e(string);
        return this.writeDataSet(dataSet, nArray[0], nArray[1], nArray[2]);
    }

    /*
     * Unable to fully structure code
     */
    public void evaluateFormulas() {
        this.a();
        try {
            var1_1 = null;
            var2_2 = null;
            var3_3 = this.h.getCreationHelper().createFormulaEvaluator();
            var4_4 = 0;
            while (var4_4 < this.h.getNumberOfSheets()) {
                var5_5 = this.h.getSheetAt(var4_4);
                var6_6 = var5_5.rowIterator();
                while (var6_6.hasNext()) {
                    var7_7 = (Row)var6_6.next();
                    var8_8 = var7_7.cellIterator();
                    block7: while (var8_8.hasNext()) {
                        var9_9 = (Cell)var8_8.next();
                        if (var9_9.getCellType() != 2) continue;
                        try {
                            var3_3.evaluateFormulaCell(var9_9);
                            continue;
                        }
                        catch (NotImplementedException var10_10) {
                            var2_2 = var10_10;
                            if (var1_1 == null) {
                                var1_1 = new StringBuilder();
                            }
                            var1_1.append(ga.d);
                            var1_1.append(var10_10.getClass().getCanonicalName());
                            var11_11 = var10_10;
                            ** while (var11_11 != null)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var1_1.append(": ");
                            var1_1.append(var11_11.getLocalizedMessage());
                            var11_11 = var11_11.getCause();
                            continue;
lbl36:
                            // 1 sources

                        }
                    }
                }
                ++var4_4;
            }
            if (var2_2 != null) {
                throw new RuntimeException(String.valueOf(ae.mbb) + var1_1.toString(), var2_2);
            }
        }
        finally {
            this.setChanged();
        }
    }

    private Cell a(int n2, int n3, int n4, boolean bl) {
        Sheet sheet;
        Row row;
        Cell cell;
        this.a();
        if (bl) {
            this.createCell(n2 + 1, n3 + 1, n4 + 1);
        }
        if ((cell = (row = this.a(sheet = this.a(n2), n3)).getCell(n4)) == null) {
            throw new RuntimeException(String.format(ae.kdd, n4 + 1, n3 + 1, n2 + 1));
        }
        return cell;
    }

    private int a(String string) {
        this.a();
        if (string == null) {
            return 1;
        }
        int n2 = this.h.getSheetIndex(string);
        if (n2 < 0) {
            throw new RuntimeException(String.format(ae.bdm, string));
        }
        return n2 + 1;
    }

    private int[] e(String string) {
        if (string == null) {
            throw new RuntimeException(ae.ggc);
        }
        Matcher matcher = this.e.matcher(string);
        if (matcher.matches()) {
            int[] nArray = new int[3];
            String string2 = matcher.group(1);
            nArray[0] = string2 == null ? 1 : this.a(string2);
            String string3 = matcher.group(2);
            string3 = string3.toUpperCase(Locale.ENGLISH);
            nArray[2] = 0;
            int n2 = 1;
            int n3 = string3.length() - 1;
            while (n3 >= 0) {
                char c2 = string3.charAt(n3);
                int n4 = c2 - 65 + 1;
                nArray[2] = nArray[2] + n4 * n2;
                n2 *= 26;
                --n3;
            }
            nArray[1] = Integer.parseInt(matcher.group(3));
            return nArray;
        }
        throw new RuntimeException(String.format(ae.jma, string));
    }

    private boolean a(Cell cell) {
        if (cell.getCellType() == 0) {
            return true;
        }
        return cell.getCellType() == 2 && cell.getCachedFormulaResultType() == 0;
    }

    private void a() {
        if (this.h == null) {
            throw new RuntimeException(ae.ime);
        }
    }

    private Sheet a(int n2) {
        if (n2 < 0 || this.h.getNumberOfSheets() <= n2) {
            throw new RuntimeException(String.format(ae.inc, n2 + 1));
        }
        return this.h.getSheetAt(n2);
    }

    private Row a(Sheet sheet, int n2) {
        Row row = sheet.getRow(n2);
        if (row == null) {
            throw new RuntimeException(String.format(ae.ihd, n2 + 1));
        }
        return row;
    }

    private void a(InputStream inputStream) throws IOException {
        try {
            this.h = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IOException(invalidFormatException);
        }
    }

    private void a(OutputStream outputStream) throws IOException {
        try {
            this.h.write(outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if ((this.l & 6) == 6) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.a(byteArrayOutputStream);
            objectOutputStream.writeObject(byteArrayOutputStream.toByteArray());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if ((this.l & 6) == 6) {
            byte[] byArray = (byte[])objectInputStream.readObject();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.a(byteArrayInputStream);
        } else if ((this.l & 1) == 1) {
            try {
                this.readFile();
            }
            catch (Throwable throwable) {
                System.err.println(throwable.getMessage());
            }
        }
    }
}

