/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.database;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.connectivity.DatabaseExcelStreamingMode;
import com.anylogic.engine.database.DatabaseDescriptor;
import com.anylogic.engine.database.DatabaseType;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.NotImplementedException;

@AnyLogicInternalAPI
public class DatabaseDescriptorFactory {
    private static /* synthetic */ int[] a;

    public static DatabaseDescriptor createCustomDescriptor(String string, String string2, String string3, String string4) {
        return new DatabaseDescriptor(DatabaseType.CUSTOM, string, string2, DatabaseDescriptorFactory.a(string3, string4));
    }

    public static DatabaseDescriptor createMSSQLDescriptor(String string, String string2, String string3, String string4) {
        return new DatabaseDescriptor(DatabaseType.MSSQL, DatabaseType.MSSQL.getDefaultDriverName(), DatabaseDescriptorFactory.a(DatabaseType.MSSQL, null, string, string2), DatabaseDescriptorFactory.a(string3, string4));
    }

    public static DatabaseDescriptor createFileDescriptor(String string, String string2, String string3) {
        return DatabaseDescriptorFactory.createFileDescriptor(string, string2, string3, null);
    }

    public static DatabaseDescriptor createFileDescriptor(String string, String string2, String string3, DatabaseExcelStreamingMode databaseExcelStreamingMode) {
        if (string.endsWith(".xls") || string.endsWith(".xlsx") || string.endsWith(".xlsb") || string.endsWith(".xlsm")) {
            return DatabaseDescriptorFactory.a(DatabaseType.EXCEL, string, DatabaseDescriptorFactory.a(string2, string3), databaseExcelStreamingMode);
        }
        if (string.endsWith(".mdb") || string.endsWith(".accdb")) {
            return DatabaseDescriptorFactory.a(DatabaseType.ACCESS, string, DatabaseDescriptorFactory.a(string2, string3), databaseExcelStreamingMode);
        }
        return null;
    }

    private static DatabaseDescriptor a(DatabaseType databaseType, String string, Properties properties, DatabaseExcelStreamingMode databaseExcelStreamingMode) {
        Serializable serializable;
        File file = new File(string);
        if (!file.exists() && ((File)(serializable = new File(file.getName()))).exists()) {
            file = serializable;
            string = Utilities.getCanonicalPath(file);
        }
        serializable = new DatabaseDescriptor(databaseType, databaseType.getDefaultDriverName(), DatabaseDescriptorFactory.a(databaseType, string, null, null), properties, string);
        if (databaseExcelStreamingMode == DatabaseExcelStreamingMode.WRITE) {
            ((DatabaseDescriptor)serializable).setExcelStreamingMode(DatabaseExcelStreamingMode.WRITE);
        } else if (databaseType == DatabaseType.EXCEL && file.exists() && file.length() > 65536L && file.getName().endsWith(".xlsx")) {
            ((DatabaseDescriptor)serializable).setExcelStreamingMode(DatabaseExcelStreamingMode.READ);
        }
        return serializable;
    }

    private static String a(DatabaseType databaseType, String string, String string2, String string3) {
        switch (DatabaseDescriptorFactory.a()[databaseType.ordinal()]) {
            case 1: {
                return "jdbc:xls:file:" + string;
            }
            case 2: {
                return "jdbc:ucanaccess://" + string + ";jackcessOpener=com.anylogic.database.CryptCodecOpener";
            }
            case 3: {
                return "jdbc:jtds:sqlserver://" + string2 + ":1433/" + string3;
            }
        }
        throw new NotImplementedException("DatabaseType " + (Object)((Object)databaseType) + " not implemented");
    }

    private static Properties a(String string, String string2) {
        Properties properties = new Properties();
        if (string != null) {
            properties.put("user", string);
        }
        if (string2 != null) {
            properties.put("password", string2);
        }
        return properties;
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[DatabaseType.values().length];
        try {
            nArray[DatabaseType.ACCESS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DatabaseType.CUSTOM.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DatabaseType.EXCEL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DatabaseType.MSSQL.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

