/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.database;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.database.DatabaseLoggingObjectDescriptor;
import com.anylogic.engine.database.LoggingType;
import com.anylogic.engine.database.ModelDatabase;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

@AnyLogicInternalAPI
public enum DatabaseLogTableType implements DatabaseLoggingObjectDescriptor
{
    AGENT_TYPES(null, "agent_types_raw", "ID INT PRIMARY KEY, NAME VARCHAR(255)", new DatabaseLoggingObjectDescriptor[0]),
    AGENTS(null, "agents_raw", "ID INT PRIMARY KEY, AGENT_TYPE_ID INT, NAME VARCHAR(255), DATE TIMESTAMP, CONSTRAINT AGENT_TYPE_REF FOREIGN KEY (AGENT_TYPE_ID) REFERENCES %s(Id)", AGENT_TYPES),
    DESTROYED_AGENTS(null, "destroyed_agents_raw", "AGENT_ID INT, DATE TIMESTAMP, CONSTRAINT DESTROYED_AGENT_REF FOREIGN KEY (AGENT_ID) REFERENCES %s(Id)", AGENTS),
    AGENT_PARAMETERS(LoggingType.LOGGING_AGENT_PARAMETERS, "agent_parameters_raw", "AGENT_ID INT, PARAMETER_NAME VARCHAR(255), PARAMETER_VALUE LONGVARCHAR, CONSTRAINT AGENT_PARAMETERS_AGENT_REF FOREIGN KEY (AGENT_ID) REFERENCES %s(Id)", AGENTS),
    AGENT_TYPE_ELEMENTS(null, "agent_type_elements_raw", "ID INT PRIMARY KEY, AGENT_TYPE_ID INT, NAME VARCHAR(255), CONSTRAINT ELEMENT_TO_AGENT_TYPE_REF FOREIGN KEY (AGENT_TYPE_ID) REFERENCES %s(Id)", AGENT_TYPES),
    AGENT_TYPE_STATECHARTS(null, "agent_type_statecharts_raw", "STATECHART_ID INT, ELEMENT_ID INT, CONSTRAINT STATECHARTS_STATECHART_TO_ELEMENT_REF FOREIGN KEY (STATECHART_ID) REFERENCES %1$s(Id),CONSTRAINT STATECHARTS_ELEMENT_TO_ELEMENT_REF FOREIGN KEY (ELEMENT_ID) REFERENCES %1$s(Id)", AGENT_TYPE_ELEMENTS),
    AGENT_ELEMENTS(null, "agent_elements_raw", "ID INT PRIMARY KEY, AGENT_ID INT, NAME VARCHAR(255), CONSTRAINT ELEMENT_TO_AGENT_REF FOREIGN KEY (AGENT_ID) REFERENCES %s(Id)", AGENTS),
    TRACE_LOG(LoggingType.LOGGING_TRACE, "trace_raw", "COUNTER INT GENERATED BY DEFAULT AS IDENTITY, AGENT_ID INT, DATE TIMESTAMP, MESSAGE_TEXT LONGVARCHAR, CONSTRAINT TRACE_LOG_AGENT_REF FOREIGN KEY (AGENT_ID) REFERENCES %s(Id)", AGENTS),
    STATECHART_STATES(LoggingType.LOGGING_STATECHARTS, "statechart_states_raw", "AGENT_ID INT, STATE_ID INT, ENTRY_DATE TIMESTAMP, EXIT_DATE TIMESTAMP, CONSTRAINT STATECHART_STATES_AGENT_REF FOREIGN KEY (AGENT_ID) REFERENCES %1$s(ID),CONSTRAINT STATECHART_STATES_STATE_REF FOREIGN KEY (STATE_ID) REFERENCES %2$s(ID)", AGENTS, AGENT_TYPE_ELEMENTS),
    STATECHART_TRANSITIONS(LoggingType.LOGGING_STATECHARTS, "statechart_transitions_raw", "AGENT_ID INT, TRANSITION_ID INT, FROM_STATE_ID INT, DATE TIMESTAMP, CONSTRAINT STATECHART_AGENT_REF FOREIGN KEY (AGENT_ID) REFERENCES %1$s(ID),CONSTRAINT TRANSITION_REF FOREIGN KEY (TRANSITION_ID) REFERENCES %2$s(ID),CONSTRAINT FROM_STATE_REF FOREIGN KEY (FROM_STATE_ID) REFERENCES %2$s(ID)", AGENTS, AGENT_TYPE_ELEMENTS),
    EVENTS(LoggingType.LOGGING_EVENTS, "events_raw", "EVENT_ID INT, DATE TIMESTAMP, CONSTRAINT EVENT_REF FOREIGN KEY (EVENT_ID) REFERENCES %s(ID)", AGENT_TYPE_ELEMENTS),
    AGENT_MOVEMENT(LoggingType.LOGGING_AGENT_MOVEMENT, "agent_movement_raw", "AGENT_ID INT, SPEED FLOAT, START_DATE TIMESTAMP, STOP_DATE TIMESTAMP, CONSTRAINT MOVEMENT_AGENT_REF FOREIGN KEY (AGENT_ID) REFERENCES %s(ID)", AGENTS),
    AGENT_MESSAGES(LoggingType.LOGGING_AGENT_MESSAGES, "agent_messages_raw", "AGENT_ID INT, SENDER_ID INT, MESSAGE LONGVARCHAR, DATE TIMESTAMP, COUNTER INT GENERATED BY DEFAULT AS IDENTITY, CONSTRAINT MESSAGES_AGENT_REF FOREIGN KEY (AGENT_ID) REFERENCES %1$s(ID),CONSTRAINT MESSAGES_SENDER_AGENT_REF FOREIGN KEY (SENDER_ID) REFERENCES %1$s(ID)", AGENTS),
    FLOWCHART_ENTRIES(LoggingType.LOGGING_FLOWCHART_ENTRIES, "flowchart_entries_raw", "COUNTER INT GENERATED BY DEFAULT AS IDENTITY, AGENT_ID INT, BLOCK_ID INT, ENTRY_DATE TIMESTAMP, CONSTRAINT FLOWCHART_ENTRIES_ENTITY_AGENT_REF FOREIGN KEY (AGENT_ID) REFERENCES %1$s(ID),CONSTRAINT FLOWCHART_ENTRIES_BLOCK_AGENT_REF FOREIGN KEY (BLOCK_ID) REFERENCES %1$s(ID)", AGENTS),
    FLOWCHART_PROCESS_STATES(LoggingType.LOGGING_FLOWCHART_PROCESS_STATES, "flowchart_process_states_raw", "AGENT_ID INT, BLOCK_ID INT, ACTIVITY_TYPE VARCHAR(20), START_DATE TIMESTAMP, STOP_DATE TIMESTAMP, CONSTRAINT FLOWCHART_PROCESS_STATES_ENTITY_AGENT_REF FOREIGN KEY (AGENT_ID) REFERENCES %1$s(ID),CONSTRAINT FLOWCHART_PROCESS_STATES_BLOCK_AGENT_REF FOREIGN KEY (BLOCK_ID) REFERENCES %s(ID)", AGENTS),
    STATISTICS(LoggingType.LOGGING_STATISTICS, "statistics_raw", "AGENT_ID INT, NAME VARCHAR(255), MEAN FLOAT, DEVIATION FLOAT, MINIMUM FLOAT, MAXIMUM FLOAT, MEAN_CONFIDENCE FLOAT, NUMBER INT, CONSTRAINT STATISTICS_AGENT_REF FOREIGN KEY (AGENT_ID) REFERENCES %s(ID)", AGENTS),
    DATASETS(LoggingType.LOGGING_DATASETS, "datasets_raw", "ELEMENT_ID INT, INDEX INT, X FLOAT, Y FLOAT, CONSTRAINT DATASETS_ELEMENT_REF FOREIGN KEY (ELEMENT_ID) REFERENCES %s(ID)", AGENT_ELEMENTS),
    HISTOGRAMS(LoggingType.LOGGING_HISTOGRAMS, "histograms_raw", "ELEMENT_ID INT, START FLOAT, END FLOAT, PDF FLOAT, CDF FLOAT, CONSTRAINT HISTOGRAMS_ELEMENT_REF FOREIGN KEY (ELEMENT_ID) REFERENCES %s(ID)", AGENT_ELEMENTS),
    RESOURCE_UNIT_STATES(LoggingType.LOGGING_RESOURCE_UNIT_STATES, "resource_unit_states_raw", "UNIT_ID INT, POOL_ID INT, USAGE_STATE VARCHAR(20), TASK_TYPE VARCHAR(20), AGENT_ID INT, TASK_ID INT, START_DATE TIMESTAMP, STOP_DATE TIMESTAMP, CONSTRAINT RESOURCE_UNIT_STATES_UNIT_AGENT_REF FOREIGN KEY (UNIT_ID) REFERENCES %1$s(ID),CONSTRAINT RESOURCE_UNIT_STATES_POOL_AGENT_REF FOREIGN KEY (POOL_ID) REFERENCES %1$s(ID),CONSTRAINT RESOURCE_UNIT_STATES_AGENT_AGENT_REF FOREIGN KEY (AGENT_ID) REFERENCES %1$s(ID),CONSTRAINT RESOURCE_UNIT_STATES_TASK_AGENT_REF FOREIGN KEY (TASK_ID) REFERENCES %1$s(ID)", AGENTS),
    RESOURCE_POOL_UTILIZATION(LoggingType.LOGGING_RESOURCE_UTILIZATION, "resource_pool_utilization_raw", "POOL_ID INT, UTILIZATION FLOAT, SIZE INT, CONSTRAINT RESOURCE_POOL_UTILIZATION_POOL_AGENT_REF FOREIGN KEY (POOL_ID) REFERENCES %1$s(ID)", AGENTS),
    RESOURCE_UNIT_UTILIZATION(LoggingType.LOGGING_RESOURCE_UTILIZATION, "resource_unit_utilization_raw", "UNIT_ID INT, POOL_ID INT, UTILIZATION FLOAT, CONSTRAINT RESOURCE_UNIT_UTILIZATION_UNIT_AGENT_REF FOREIGN KEY (UNIT_ID) REFERENCES %1$s(ID),CONSTRAINT RESOURCE_UNIT_UTILIZATION_POOL_AGENT_REF FOREIGN KEY (POOL_ID) REFERENCES %1$s(ID)", AGENTS);

    private final String a;
    private final String e;
    private LoggingType h;
    private Set<LoggingType> k;
    private DatabaseLoggingObjectDescriptor[] d;

    private DatabaseLogTableType(LoggingType loggingType, String string2, String string3, DatabaseLoggingObjectDescriptor ... databaseLoggingObjectDescriptorArray) {
        this.h = loggingType;
        this.d = databaseLoggingObjectDescriptorArray;
        this.a = String.valueOf(string2) + "_log";
        this.e = ModelDatabase.getCreateTableSQL(this.getTableName(), String.format(string3, Arrays.stream(databaseLoggingObjectDescriptorArray).map(databaseLoggingObjectDescriptor -> databaseLoggingObjectDescriptor.getName()).toArray()), true);
    }

    @Deprecated
    public String getTableName() {
        return this.a;
    }

    @Override
    public Set<LoggingType> getLoggingTypes() {
        if (this.k == null) {
            EnumSet<LoggingType> enumSet = EnumSet.noneOf(LoggingType.class);
            if (this.h != null) {
                enumSet.add(this.h);
            }
            DatabaseLoggingObjectDescriptor[] databaseLoggingObjectDescriptorArray = this.d;
            int n2 = this.d.length;
            int n3 = 0;
            while (n3 < n2) {
                DatabaseLoggingObjectDescriptor databaseLoggingObjectDescriptor = databaseLoggingObjectDescriptorArray[n3];
                enumSet.addAll(databaseLoggingObjectDescriptor.getLoggingTypes());
                ++n3;
            }
            this.k = Collections.unmodifiableSet(enumSet);
        }
        return this.k;
    }

    @Override
    public String getName() {
        return this.a;
    }

    @Override
    public String getCreateSQL() {
        return this.e;
    }

    @Override
    public String getType() {
        return "TABLE";
    }
}

