/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.database;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Engine;
import com.anylogic.engine.EventOriginator;
import com.anylogic.engine.ModelProperties;
import com.anylogic.engine.ModelPropertyName;
import com.anylogic.engine.Pair;
import com.anylogic.engine.Statechart;
import com.anylogic.engine.connectivity.ResultSet;
import com.anylogic.engine.database.CodeValue;
import com.anylogic.engine.database.DBInfo;
import com.anylogic.engine.database.DatabaseColumnTypeEnum;
import com.anylogic.engine.database.DatabaseCustomType;
import com.anylogic.engine.database.DatabaseLogFunctions;
import com.anylogic.engine.database.DatabaseLogProperties;
import com.anylogic.engine.database.DatabaseLogTableType;
import com.anylogic.engine.database.DatabaseLogViews;
import com.anylogic.engine.database.DatabaseLoggingObjectDescriptor;
import com.anylogic.engine.database.DatabaseStatements;
import com.anylogic.engine.database.ILogEntry;
import com.anylogic.engine.database.LogEntryFactory;
import com.anylogic.engine.database.LoggingType;
import com.anylogic.engine.database.TableDataExporter;
import com.anylogic.engine.database.TableDataImporter;
import com.anylogic.engine.database.UtilitiesDatabase;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.internal.s.j;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.HSQLDBTemplates;
import com.mysema.query.sql.SQLBindings;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.types.AbstractType;
import com.mysema.query.sql.types.EnumAsObjectType;
import com.mysema.query.sql.types.Type;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class ModelDatabase {
    @AnyLogicInternalAPI
    public static final String CURRENT_VERSION = "7.2.0";
    @AnyLogicInternalAPI
    public static final String DATABASE_DIRECTORY = "database";
    @AnyLogicInternalAPI
    public static final String DATABASE_DB_PATH = "database" + File.separatorChar + "db";
    @AnyLogicInternalAPI
    public static final String PUBLIC_SCHEMA_NAME = "PUBLIC";
    @AnyLogicInternalAPI
    public static final String DROP_SQL_OBJECT = "DROP %s %s IF EXISTS CASCADE";
    @AnyLogicInternalAPI
    public static final String LOG_OBJECT_SUFFIX = "_log";
    @AnyLogicInternalAPI
    public static final String ANYLOGIC_IDENTIFIER_PREFIX = "al_";
    @AnyLogicInternalAPI
    public static final String UNIQUE_AUTOINC_COLUMN_NAME = "al_id";
    @AnyLogicInternalAPI
    public static final String AL_SELECTED_LOG_OBJECTS = "AL_SELECTED_LOG_OBJECTS";
    @AnyLogicInternalAPI
    public static final String AL_SELECTED_LOG_OBJECT_NAME = "NAME";
    @AnyLogicInternalAPI
    public static final String AL_SELECTED_LOG_OBJECT_TYPE = "TYPE";
    @AnyLogicInternalAPI
    public static final String SQL_TABLE = "TABLE";
    @AnyLogicInternalAPI
    public static final String SQL_VIEW = "VIEW";
    @AnyLogicInternalAPI
    public static final String SQL_FUNCTION = "FUNCTION";
    @AnyLogicInternalAPI
    public static final String AL_DB_OBJECTS = "AL_DB_OBJECTS";
    @AnyLogicInternalAPI
    public static final String AL_OBJECT_NAME = "NAME";
    @AnyLogicInternalAPI
    public static final String AL_OBJECT_TYPE = "TYPE";
    @AnyLogicInternalAPI
    public static final String AL_OBJECT_USAGE = "USAGE";
    @AnyLogicInternalAPI
    public static final String AL_OBJECT_USAGE_LOG = "LOG";
    private static final String a = "org.hsqldb.jdbc.JDBCDriver";
    private static String e;
    private static String h;
    private Connection k;
    private Configuration d;
    private final ModelProperties j;
    private static final int c = 65536;
    private static final String l = "CREATE VIEW %s AS %s";
    private LRUCache<DatabaseCacheKey, Object> f = new LRUCache(65536);
    private final DatabaseStatements i = new DatabaseStatements(this);
    private final j n = new j();
    private String m = "sa";
    private String g = "";
    private final DatabaseLogProperties b;
    private Engine ai;
    private Map<Object, ILogEntry> hn = new HashMap<Object, ILogEntry>();
    private static AbstractType<CodeValue> lg;
    private static /* synthetic */ int[] gf;

    static {
        String string = "CREATE ";
        String string2 = "TABLE IF NOT EXISTS %s (%s)";
        e = String.valueOf(string) + string2;
        h = String.valueOf(string) + "CACHED " + string2;
        lg = new AbstractType<CodeValue>(12){

            public Class<CodeValue> getReturnedClass() {
                return CodeValue.class;
            }

            public CodeValue a(java.sql.ResultSet resultSet, int n2) throws SQLException {
                CodeValue codeValue = new CodeValue(null, resultSet.getString(n2));
                return codeValue;
            }

            public void a(PreparedStatement preparedStatement, int n2, CodeValue codeValue) throws SQLException {
                preparedStatement.setString(n2, codeValue.getCode());
            }

            public /* synthetic */ Object getValue(java.sql.ResultSet resultSet, int n2) throws SQLException {
                return this.a(resultSet, n2);
            }

            public /* synthetic */ void setValue(PreparedStatement preparedStatement, int n2, Object object) throws SQLException {
                this.a(preparedStatement, n2, (CodeValue)object);
            }
        };
    }

    @AnyLogicInternalAPI
    public LRUCache<DatabaseCacheKey, Object> getCache() {
        return this.f;
    }

    public <R> Object getCachedValue(SQLBindings sQLBindings, String string, Supplier<R> supplier) {
        DatabaseCacheKey databaseCacheKey = new DatabaseCacheKey(sQLBindings, string);
        Object object = this.f.get(databaseCacheKey);
        if (object == null) {
            object = supplier.get();
            this.f.put(databaseCacheKey, object);
        }
        return object;
    }

    @AnyLogicInternalAPI
    public ModelDatabase(Engine engine, ModelProperties modelProperties, DatabaseLogProperties databaseLogProperties) {
        this.ai = engine;
        this.j = modelProperties;
        this.b = databaseLogProperties;
    }

    @AnyLogicInternalAPI
    public static void createLogSchema(Connection connection) throws SQLException {
        ModelDatabase.deleteExistingLogObjects(connection);
        ModelDatabase.a(connection);
        ModelDatabase.restoreUsersViews(connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AnyLogicInternalAPI
    public static void restoreUsersViews(Connection connection, Collection<String> collection) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Statement statement = connection.createStatement();
            try {
                try (java.sql.ResultSet resultSet = ModelDatabase.a(statement);){
                    while (resultSet.next()) {
                        try {
                            String string = resultSet.getString(1);
                            if (!collection.contains(string)) continue;
                            statement.execute(String.format(l, string, resultSet.getString(2)));
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                if (statement == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            statement.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AnyLogicInternalAPI
    public static void restoreUsersViews(Connection connection) throws SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            Statement statement = connection.createStatement();
            try {
                try (java.sql.ResultSet resultSet = ModelDatabase.a(statement);){
                    while (resultSet.next()) {
                        try {
                            statement.execute(String.format(l, resultSet.getString(1), resultSet.getString(2)));
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                if (statement == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            statement.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private static void a(Connection connection) throws SQLException {
        DatabaseLoggingObjectDescriptor[][] databaseLoggingObjectDescriptorArrayArray = new DatabaseLoggingObjectDescriptor[][]{DatabaseLogFunctions.values(), DatabaseLogTableType.values(), DatabaseLogViews.values()};
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement statement = connection.createStatement();){
            DatabaseLoggingObjectDescriptor[][] databaseLoggingObjectDescriptorArrayArray2 = databaseLoggingObjectDescriptorArrayArray;
            int n2 = databaseLoggingObjectDescriptorArrayArray.length;
            int n3 = 0;
            while (n3 < n2) {
                DatabaseLoggingObjectDescriptor[] databaseLoggingObjectDescriptorArray;
                DatabaseLoggingObjectDescriptor[] databaseLoggingObjectDescriptorArray2 = databaseLoggingObjectDescriptorArray = databaseLoggingObjectDescriptorArrayArray2[n3];
                int n4 = databaseLoggingObjectDescriptorArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    DatabaseLoggingObjectDescriptor databaseLoggingObjectDescriptor = databaseLoggingObjectDescriptorArray2[n5];
                    statement.addBatch(databaseLoggingObjectDescriptor.getCreateSQL());
                    statement.addBatch(databaseLoggingObjectDescriptor.getSaveSQL());
                    ++n5;
                }
                ++n3;
            }
            statement.executeBatch();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteExistingLogObjects(Connection connection) throws SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            Statement statement = connection.createStatement();
            try {
                try (java.sql.ResultSet resultSet = ModelDatabase.e(statement);){
                    List<String> list = ModelDatabase.a(resultSet);
                    for (String string : list) {
                        statement.addBatch(string);
                    }
                    statement.addBatch("DELETE FROM AL_DB_OBJECTS WHERE USAGE = 'LOG'");
                    statement.executeBatch();
                }
                if (statement == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            statement.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static java.sql.ResultSet a(Statement statement) throws SQLException {
        return statement.executeQuery("SELECT al_views.view_name, al_views.view_definition FROM al_views LEFT OUTER JOIN information_schema.views ON information_schema.views.table_name = al_views.view_name");
    }

    private static List<String> a(java.sql.ResultSet resultSet) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (resultSet.next()) {
            try {
                arrayList.add(0, String.format(DROP_SQL_OBJECT, resultSet.getString("TYPE"), resultSet.getString("NAME")));
            }
            catch (EnumConstantNotPresentException enumConstantNotPresentException) {}
        }
        return arrayList;
    }

    private static java.sql.ResultSet e(Statement statement) throws SQLException {
        return statement.executeQuery("SELECT TYPE, NAME FROM AL_DB_OBJECTS WHERE USAGE = 'LOG'");
    }

    @AnyLogicInternalAPI
    public static String getCreateTableSQL(String string, String string2, boolean bl) {
        return String.format(bl ? h : e, string, string2);
    }

    @AnyLogicInternalAPI
    DatabaseStatements a() {
        return this.i;
    }

    public void log(ILogEntry iLogEntry) {
        try {
            this.a(iLogEntry, false);
        }
        catch (SQLException sQLException) {
            System.err.println(ga.a(sQLException));
        }
    }

    private void a(ILogEntry iLogEntry, boolean bl) throws SQLException {
        Object object;
        if (!bl && iLogEntry.isCompound()) {
            ILogEntry iLogEntry2;
            object = iLogEntry.getCompoundKey();
            ILogEntry iLogEntry3 = iLogEntry2 = iLogEntry.isCompoundLast() ? this.hn.remove(object) : this.hn.put(object, iLogEntry);
            if (iLogEntry2 != null) {
                iLogEntry.initCompound(iLogEntry2);
            }
            if (!iLogEntry.isCompoundLast()) {
                return;
            }
        }
        do {
            if ((object = iLogEntry.getSQLStatement(this)) == null) {
                return;
            }
            if (iLogEntry.isBatch()) {
                object.executeBatch();
                continue;
            }
            object.execute();
        } while (iLogEntry.nextStatement());
    }

    public int getAgentTypeId(Agent agent) {
        Class<?> clazz = ga.e(agent);
        Integer n2 = this.b.j.get(clazz);
        if (n2 == null) {
            int n3 = this.h();
            n2 = n3;
            this.b.j.put(clazz, n2);
            UtilitiesDatabase.logIfNeeded(agent, LoggingType.LOGGING, true, () -> LogEntryFactory.agentTypeLogEntry(n3, clazz.getName()));
        }
        return n2;
    }

    @AnyLogicInternalAPI
    private final int h() {
        return this.b.a++;
    }

    private int k() {
        return this.b.k++;
    }

    @AnyLogicInternalAPI
    public int generateAgentElementId() {
        return this.b.d++;
    }

    @AnyLogicInternalAPI
    public int generateAgentId() {
        return this.b.e++;
    }

    public int getEventId(EventOriginator eventOriginator) {
        return this.getAgentTypeElementId(LoggingType.LOGGING_EVENTS, eventOriginator.getAgent(), eventOriginator.getName());
    }

    public int getStatechartId(Statechart statechart) {
        return this.getAgentTypeElementId(LoggingType.LOGGING_STATECHARTS, statechart.getAgent(), statechart.getName());
    }

    public int getAgentTypeElementId(LoggingType loggingType, Agent agent, String string) {
        Pair<Integer, String> pair = new Pair<Integer, String>(agent.getAgentTypeId(), string);
        Integer n2 = this.b.c.get(pair);
        if (n2 == null) {
            int n3 = this.k();
            n2 = n3;
            this.b.c.put(pair, n2);
            UtilitiesDatabase.logIfNeeded(agent, loggingType, true, () -> LogEntryFactory.agentTypeElementLogEntry(n3, agent, string));
        }
        return n2;
    }

    public int getAgentTypeStateId(Agent agent, Statechart statechart, short s) {
        int n2 = agent.getAgentTypeId();
        long l2 = ByteBuffer.allocate(8).putInt(n2).putInt(s).getLong(0);
        Integer n3 = this.b.l.get(l2);
        if (n3 == null) {
            int n4 = this.k();
            n3 = n4;
            this.b.l.put(l2, n3);
            UtilitiesDatabase.logIfNeeded(agent, LoggingType.LOGGING_STATECHARTS, true, () -> LogEntryFactory.agentTypeElementLogEntry(n4, agent, agent.getNameOfState(s)));
            UtilitiesDatabase.logIfNeeded(agent, LoggingType.LOGGING_STATECHARTS, true, () -> LogEntryFactory.statechartElementLogEntry(agent, statechart, n4));
        }
        return n3;
    }

    private DatabaseCustomType[] d() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String string = this.j.getStringProperty((Object)ModelPropertyName.DB_DESCRIPTOR_CLASS);
        if (string != null) {
            DBInfo dBInfo = (DBInfo)Class.forName(string).newInstance();
            return dBInfo.getCustomTypes();
        }
        return null;
    }

    @AnyLogicInternalAPI
    public Connection getConnection() {
        if (this.k == null) {
            this.k = this.j();
        }
        return this.k;
    }

    @AnyLogicInternalAPI
    public void disconnect() {
        if (this.k != null) {
            try {
                try {
                    for (ILogEntry iLogEntry : this.hn.values()) {
                        this.a(iLogEntry, true);
                    }
                    this.hn.clear();
                    this.i.a();
                    this.c();
                }
                finally {
                    this.k.close();
                    this.k = null;
                }
            }
            catch (Exception exception) {
                throw ga.k(exception);
            }
        }
    }

    private Connection j() {
        try {
            this.d = this.l();
            try {
                Class.forName(a);
            }
            catch (Exception exception) {
                throw ga.a("Database driver %s couldn't be found in the classpath.", new Object[]{a});
            }
            Connection connection = DriverManager.getConnection(this.f(), this.m, this.g);
            this.e(connection);
            return connection;
        }
        catch (Exception exception) {
            throw ga.a((Throwable)exception, "Error during database initialization");
        }
    }

    @AnyLogicInternalAPI
    public void resetBeforeStart() throws Exception {
        Connection connection = this.k;
        if (connection == null) {
            return;
        }
        this.b.resetBeforeStart();
        this.hn.clear();
        this.e(connection);
    }

    private void e(Connection connection) throws Exception {
        if (LoggingType.LOGGING.isLoggingOn(this.ai)) {
            this.h(connection);
        }
        try {
            TableDataImporter tableDataImporter = (TableDataImporter)Class.forName(this.j.getStringProperty("DB_DESCRIPTOR_CLASS")).newInstance();
            tableDataImporter.importTableDataOnStartup(connection);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
            throw ga.a((Throwable)exception, "Error during database initialization");
        }
    }

    private void c() throws Exception {
        try {
            TableDataExporter tableDataExporter = (TableDataExporter)Class.forName(this.j.getStringProperty("DB_DESCRIPTOR_CLASS")).newInstance();
            tableDataExporter.exportTableDataOnFinish(this.k);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
            throw ga.a((Throwable)exception, "Error during export from database");
        }
    }

    @AnyLogicInternalAPI
    private void h(Connection connection) throws SQLException {
        if (this.b.f) {
            ModelDatabase.createLogSchema(connection);
            this.b.f = false;
        }
        DatabaseLogTableType[] databaseLogTableTypeArray = DatabaseLogTableType.values();
        int n2 = databaseLogTableTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DatabaseLogTableType databaseLogTableType = databaseLogTableTypeArray[n3];
            this.b.h.add(databaseLogTableType.getTableName());
            ++n3;
        }
    }

    private Configuration l() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        SQLTemplates sQLTemplates = HSQLDBTemplates.builder().printSchema().build();
        sQLTemplates.setSupportsUnquotedReservedWordsAsIdentifier(true);
        Configuration configuration = new Configuration(sQLTemplates);
        DatabaseCustomType[] databaseCustomTypeArray = this.d();
        int n2 = databaseCustomTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DatabaseCustomType databaseCustomType = databaseCustomTypeArray[n3];
            switch (ModelDatabase.e()[databaseCustomType.getCategory().ordinal()]) {
                case 3: {
                    configuration.register(databaseCustomType.getTableName(), databaseCustomType.getColumnName(), lg);
                    break;
                }
                case 2: {
                    Class<?> clazz = Class.forName(databaseCustomType.getReference());
                    EnumAsObjectType enumAsObjectType = new EnumAsObjectType(clazz);
                    configuration.register(databaseCustomType.getTableName(), databaseCustomType.getColumnName(), (Type)enumAsObjectType);
                    break;
                }
                case 1: {
                    break;
                }
            }
            ++n3;
        }
        return configuration;
    }

    private String f() throws IOException {
        String string = new File(DATABASE_DB_PATH).getCanonicalPath();
        String string2 = this.j.getStringProperty((Object)ModelPropertyName.DATABASE_CONNECTION_MODE);
        if (string2 != null && string2.toLowerCase().equals("file")) {
            return "jdbc:hsqldb:file:" + string + ";shutdown=true";
        }
        if (string2 != null && string2.toLowerCase().equals("server")) {
            String string3 = this.j.getStringProperty((Object)ModelPropertyName.DATABASE_ALIAS);
            if (string3 == null || string3.trim().isEmpty()) {
                throw ga.a("%s property not found", new Object[]{ModelPropertyName.DATABASE_ALIAS});
            }
            return "jdbc:hsqldb:hsql://" + this.j.getStringProperty((Object)ModelPropertyName.DATABASE_SERVER_HOST) + ":" + this.j.getStringProperty((Object)ModelPropertyName.DATABASE_SERVER_PORT) + "/" + string3 + ";file:" + string;
        }
        throw ga.k("Property DATABASE_CONNECTION_MODE in model.properties file is missing or invalid.");
    }

    @AnyLogicInternalAPI
    public Configuration getDSLConfiguration() {
        return this.d;
    }

    @AnyLogicInternalAPI
    public java.sql.ResultSet select(String string) {
        try {
            return this.getConnection().createStatement().executeQuery(string);
        }
        catch (SQLException sQLException) {
            throw ga.k(sQLException);
        }
    }

    @AnyLogicInternalAPI
    public java.sql.ResultSet execute(String string) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.getConnection().createStatement();){
                return statement.executeQuery(string);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            throw ga.k(sQLException);
        }
    }

    @AnyLogicInternalAPI
    public java.sql.ResultSet selectFrom(String string) {
        return this.select(String.format("select * from %s;", string));
    }

    public void importFromExternalDB(Connection connection, String string, String string2, boolean bl, boolean bl2) {
        try {
            UtilitiesDatabase.copyDatabaseTable(connection, this.getConnection(), string, string2, bl, bl2);
        }
        catch (SQLException sQLException) {
            throw ga.k(sQLException);
        }
    }

    public void exportToExternalDB(String string, Connection connection, String string2, boolean bl, boolean bl2) {
        try {
            UtilitiesDatabase.copyDatabaseTable(this.getConnection(), connection, string, string2, bl, bl2);
        }
        catch (SQLException sQLException) {
            throw ga.k(sQLException);
        }
    }

    public ResultSet wrapResultSet(java.sql.ResultSet resultSet) {
        com.anylogic.engine.connectivity.Statement statement;
        try {
            statement = this.n.a(resultSet.getStatement(), false);
        }
        catch (Exception exception) {
            statement = null;
        }
        return this.n.a(statement, resultSet, true);
    }

    static /* synthetic */ int[] e() {
        if (gf != null) {
            return gf;
        }
        int[] nArray = new int[DatabaseColumnTypeEnum.values().length];
        try {
            nArray[DatabaseColumnTypeEnum.CODE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DatabaseColumnTypeEnum.OPTIONS_LIST.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DatabaseColumnTypeEnum.SQL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        gf = nArray;
        return nArray;
    }

    @AnyLogicInternalAPI
    public static class DatabaseCacheKey {
        private String a;
        private List<Object> e;

        public DatabaseCacheKey(SQLBindings sQLBindings) {
            this.a = sQLBindings.getSQL();
            this.e = sQLBindings.getBindings();
        }

        public DatabaseCacheKey(SQLBindings sQLBindings, String string) {
            this.a = String.valueOf(sQLBindings.getSQL()) + string;
            this.e = sQLBindings.getBindings();
        }

        public DatabaseCacheKey(String string, Object ... objectArray) {
            this.a = string;
            this.e = Arrays.asList(objectArray);
        }

        public DatabaseCacheKey(String string, String string2, Object ... objectArray) {
            this.a = String.valueOf(string2) + string;
            this.e = Arrays.asList(objectArray);
        }

        public int hashCode() {
            int n2 = 1;
            n2 = 31 * n2 + (this.e == null ? 0 : this.e.hashCode());
            n2 = 31 * n2 + (this.a == null ? 0 : this.a.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            DatabaseCacheKey databaseCacheKey = (DatabaseCacheKey)object;
            if (this.e == null ? databaseCacheKey.e != null : !this.e.equals(databaseCacheKey.e)) {
                return false;
            }
            return !(this.a == null ? databaseCacheKey.a != null : !this.a.equals(databaseCacheKey.a));
        }
    }

    @AnyLogicInternalAPI
    public static class LRUCache<A, B>
    extends LinkedHashMap<A, B> {
        private static final long serialVersionUID = -9034931629652579411L;
        private final int a;

        public LRUCache(int n2) {
            super(16, 0.75f, true);
            this.a = n2;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<A, B> entry) {
            return super.size() > this.a;
        }
    }
}

