/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.gis;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.gis.GISMarkupDescriptor;
import java.io.File;
import java.util.List;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Fun;
import org.mapdb.HTreeMap;
import org.mapdb.Hasher;
import org.mapdb.Serializer;

@AnyLogicInternalAPI
public class AnyLogicMapDB {
    public static final String databaseFolder = "cache";
    public static final String databaseName = "giscache";
    public static final String nominatimSearchCache = "NominatimSearchCache";
    public static final String CACHE_PATH = "CacheDirectory_xjal";
    private static transient DB a;

    public static synchronized DB getDatabase() {
        if (a == null) {
            String string = System.getProperty(CACHE_PATH);
            if (string == null) {
                string = "";
            } else if (!string.endsWith(File.separator)) {
                string = String.valueOf(string) + File.separator;
            }
            File file = new File(String.valueOf(string) + databaseFolder);
            if (!file.exists()) {
                file.mkdir();
            }
            file = new File(file, databaseName);
            try {
                a = DBMaker.newFileDB((File)file).closeOnJvmShutdown().encryptionEnable("AnyLogic").make();
            }
            catch (Error error) {
                a = DBMaker.newFileDB((File)file).closeOnJvmShutdown().encryptionEnable("AnyLogic").readOnly().make();
            }
        }
        return a;
    }

    public static HTreeMap<int[], byte[]> getTileCache(DB dB, String string) {
        return dB.createHashMap(string).hasher(Hasher.INT_ARRAY).keySerializer(Serializer.INT_ARRAY).valueSerializer(Serializer.BYTE_ARRAY).counterEnable().makeOrGet();
    }

    public static BTreeMap<Fun.Tuple5<Boolean, Boolean, Boolean, Integer, String>, List<GISMarkupDescriptor>> getNominatimSearchCache(DB dB) {
        return dB.createTreeMap(nominatimSearchCache).valuesOutsideNodesEnable().keySerializer((BTreeKeySerializer)new BTreeKeySerializer.Tuple5KeySerializer(null, null, null, null, null, null, null, null, null)).counterEnable().makeOrGet();
    }

    public static HTreeMap<double[], double[]> getRouteCache(DB dB, String string) {
        return dB.createHashMap(string).hasher(Hasher.DOUBLE_ARRAY).keySerializer(Serializer.DOUBLE_ARRAY).valueSerializer(Serializer.DOUBLE_ARRAY).counterEnable().makeOrGet();
    }
}

