/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.gis;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AreaUnits;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.gis.IGeographicSearchEntry;
import com.anylogic.engine.markup.GISRegion;
import com.anylogic.engine.presentation.LineStyle;
import java.awt.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class GISMultiRegion
implements IGeographicSearchEntry,
Serializable,
Iterable<GISRegion> {
    private static final long serialVersionUID = 4225187817261873757L;
    private final List<GISRegion> a = new ArrayList<GISRegion>();
    private double e = -1.0;
    private String h;

    public GISMultiRegion() {
    }

    public GISMultiRegion(String string, GISRegion ... gISRegionArray) {
        this.h = string;
        if (gISRegionArray != null) {
            this.addAll(Arrays.asList(gISRegionArray));
        }
    }

    @Override
    public String getTitle() {
        return this.h;
    }

    public void setTitle(String string) {
        this.h = string;
    }

    public List<GISRegion> getRegions() {
        return Collections.unmodifiableList(this.a);
    }

    public boolean add(GISRegion gISRegion) {
        boolean bl = this.a.add(gISRegion);
        this.a();
        return bl;
    }

    public boolean addAll(Collection<GISRegion> collection) {
        boolean bl = this.a.addAll(collection);
        if (!collection.isEmpty()) {
            this.a();
        }
        return bl;
    }

    public boolean remove(GISRegion gISRegion) {
        boolean bl = this.a.remove(gISRegion);
        if (bl) {
            this.a();
        }
        return bl;
    }

    public boolean removeAll(Collection<GISRegion> collection) {
        boolean bl = this.a.removeAll(collection);
        if (bl) {
            this.a();
        }
        return bl;
    }

    public void setVisible(boolean bl) {
        for (GISRegion gISRegion : this.a) {
            gISRegion.setVisible(bl);
        }
    }

    public void setFillColor(Paint paint) {
        for (GISRegion gISRegion : this.a) {
            gISRegion.setFillColor(paint);
        }
    }

    public void setLineColor(Paint paint) {
        for (GISRegion gISRegion : this.a) {
            gISRegion.setLineColor(paint);
        }
    }

    public void setLineWidth(double d2) {
        for (GISRegion gISRegion : this.a) {
            gISRegion.setLineWidth(d2);
        }
    }

    public void setLineStyle(LineStyle lineStyle) {
        for (GISRegion gISRegion : this.a) {
            gISRegion.setLineStyle(lineStyle);
        }
    }

    @Override
    public Iterator<GISRegion> iterator() {
        return this.a.iterator();
    }

    public GISRegion randomRegionInside() {
        if (this.a == null || this.a.size() == 0) {
            return null;
        }
        Agent agent = this.a.get(0).getSpace();
        return this.randomRegionInside(agent.getEngine().getDefaultRandomGenerator());
    }

    public GISRegion randomRegionInside(Random random) {
        if (this.a == null || this.a.size() == 0) {
            return null;
        }
        double d2 = this.area();
        double d3 = Utilities.uniform(0.0, d2, random);
        double d4 = 0.0;
        for (GISRegion gISRegion : this.a) {
            if (!((d4 += gISRegion.area()) > d3)) continue;
            return gISRegion;
        }
        return this.a.get(this.a.size() - 1);
    }

    public double area() {
        double d2 = this.e;
        if (d2 < 0.0) {
            d2 = 0.0;
            for (GISRegion gISRegion : this.a) {
                d2 += gISRegion.area();
            }
            this.e = d2;
        }
        return d2;
    }

    public double area(AreaUnits areaUnits) {
        return AreaUnits.SQ_METER.convertTo(this.area(), areaUnits);
    }

    private void a() {
        this.e = -1.0;
    }
}

