/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.gis;

import com.anylogic.engine.gis.AbstractGISRouteProvider;
import com.anylogic.engine.gis.RoutingMethod;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.presentation.SharedUtils;
import com.anylogic.engine.markup.Curve;
import com.anylogic.engine.markup.GISMarkupSegmentLine;
import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.LevelGraph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.LocationIndexTreeSC;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;
import java.io.File;
import java.util.ArrayList;

public class GraphHopperRouteProvider
extends AbstractGISRouteProvider {
    private static final long serialVersionUID = 4444172578851461686L;
    private transient GraphHopper a;
    private String e;
    private String h;
    private RoutingMethod k;

    public GraphHopperRouteProvider(String string, String string2, RoutingMethod routingMethod) {
        this.e = string;
        this.h = string2;
        this.k = routingMethod;
    }

    @Override
    Curve a(double d2, double d3, double d4, double d5) {
        return this.getPathData(new double[]{d2, d3, d4, d5});
    }

    public Curve getPathData(double ... dArray) {
        Curve<GISMarkupSegmentLine> curve = new Curve<GISMarkupSegmentLine>();
        GHResponse gHResponse = this.a(dArray);
        PointList pointList = gHResponse.getPoints();
        int n2 = pointList.size();
        if (n2 == 0) {
            return curve;
        }
        if (pointList.getLat(0) != dArray[0] || pointList.getLon(0) != dArray[1]) {
            curve.addSegment(new GISMarkupSegmentLine(dArray[0], dArray[1], pointList.getLat(0), pointList.getLon(0)));
        }
        int n3 = 0;
        while (n3 < pointList.size() - 1) {
            curve.addSegment(new GISMarkupSegmentLine(pointList.getLat(n3), pointList.getLon(n3), pointList.getLat(n3 + 1), pointList.getLon(n3 + 1)));
            ++n3;
        }
        if (pointList.getLat(n2 - 1) != dArray[dArray.length - 2] || pointList.getLon(n2 - 1) != dArray[dArray.length - 1]) {
            curve.addSegment(new GISMarkupSegmentLine(pointList.getLat(n2 - 1), pointList.getLon(n2 - 1), dArray[dArray.length - 2], dArray[dArray.length - 1]));
        }
        curve.initialize();
        return curve;
    }

    @Override
    public double getDistance(double d2, double d3, double d4, double d5) {
        GHResponse gHResponse = this.a(new double[]{d2, d3, d4, d5});
        return gHResponse.getDistance();
    }

    private GHResponse a(double ... dArray) {
        ArrayList<GHPoint> arrayList = new ArrayList<GHPoint>();
        int n2 = 0;
        while (n2 < dArray.length) {
            arrayList.add(new GHPoint(dArray[n2], dArray[n2 + 1]));
            n2 += 2;
        }
        GHRequest gHRequest = new GHRequest(arrayList);
        gHRequest.setAlgorithm(this.h);
        gHRequest.putHint("simplifyRequest", (Object)true);
        gHRequest.putHint("douglas.minprecision", (Object)this.getPrecisionInMeters());
        gHRequest.setWeighting(this.k == RoutingMethod.FASTEST ? "fastest" : "shortest");
        GHResponse gHResponse = this.a().route(gHRequest);
        return gHResponse;
    }

    private GraphHopper a() {
        if (this.a == null) {
            String string = new File(this.e).getAbsolutePath();
            if (!SharedUtils.folderContainsGraphHopperRoutingGraph(string)) {
                throw new RuntimeException(String.format(ae.naa, string));
            }
            this.a = GraphHopperRouteProvider.createGraphhopperInstance();
            this.a.setMemoryMapped();
            if (!this.a.load(new File(this.e).getAbsolutePath())) {
                throw new RuntimeException(ae.nja);
            }
        }
        return this.a;
    }

    public static GraphHopper createGraphhopperInstance() {
        return new GraphHopper(){

            protected LocationIndex createLocationIndex(Directory directory) {
                Object object = this.getGraph() instanceof LevelGraph ? new LocationIndexTreeSC((LevelGraph)this.getGraph(), directory) : new LocationIndexTree((Graph)this.getGraph(), directory);
                object.setResolution(4000);
                object.setSearchRegion(true);
                LocationIndexTree locationIndexTree = object;
                if (!locationIndexTree.loadExisting()) {
                    locationIndexTree.prepareIndex();
                }
                return locationIndexTree;
            }
        }.forDesktop();
    }
}

