/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.gis;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.IRouteProvider;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.markup.Curve;
import com.anylogic.engine.markup.GISMarkupSegment;

public interface IGISRouteProvider
extends IRouteProvider<Curve<GISMarkupSegment>> {
    public Curve<GISMarkupSegment> getPathData(double var1, double var3, double var5, double var7);

    public double getDistance(double var1, double var3, double var5, double var7);

    @Override
    default public Curve<GISMarkupSegment> getPathData(Point point, Point point2, Curve<GISMarkupSegment> curve) {
        curve = this.getPathData(point.getLatitude(), point.getLongitude(), point2.getLatitude(), point2.getLongitude());
        return curve;
    }

    @AnyLogicInternalAPI
    default public Curve<GISMarkupSegment> getPathData(Point ... pointArray) {
        double[] dArray = new double[pointArray.length * 2];
        int n2 = 0;
        while (n2 < pointArray.length) {
            dArray[n2 * 2] = pointArray[n2].getLatitude();
            dArray[n2 * 2 + 1] = pointArray[n2].getLongitude();
            ++n2;
        }
        Curve<GISMarkupSegment> curve = this.getPathData(dArray);
        return curve;
    }

    @AnyLogicInternalAPI
    default public Curve<GISMarkupSegment> getPathData(double ... dArray) {
        throw new RuntimeException("Unsupported method");
    }

    @Override
    default public double getDistance(Point point, Point point2) {
        return this.getDistance(point.getLatitude(), point.getLongitude(), point2.getLatitude(), point2.getLongitude());
    }

    @Override
    default public Position getPositionAtOffset(Curve<GISMarkupSegment> curve, double d2, Position position) {
        if (d2 == 0.0) {
            curve.getEndPoint(position);
            position.verticalRotation = Double.NaN;
            position.rotation = Double.NaN;
            return position;
        }
        position = curve.getPositionAtOffset(curve.length() - d2, position);
        return position;
    }

    @Override
    default public double getLength(Curve<GISMarkupSegment> curve) {
        return curve.length();
    }
}

