/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.gis;

import com.graphhopper.reader.OSMNode;
import com.graphhopper.reader.OSMRelation;
import com.graphhopper.reader.OSMWay;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodedDoubleValue;
import java.util.Set;

public class RailEncoder
extends AbstractFlagEncoder {
    public RailEncoder() {
        super(5, 5.0);
        this.intendedValues.add("railway");
        this.intendedValues.add("train");
    }

    public long acceptWay(OSMWay oSMWay) {
        String string = oSMWay.getTag("railway");
        if (string == null) {
            if (oSMWay.hasTag("route", (Set)this.intendedValues)) {
                return this.acceptBit | this.ferryBit;
            }
            return 0L;
        }
        if (!"rail".equals(string)) {
            return 0L;
        }
        return this.acceptBit;
    }

    public long handleRelationTags(OSMRelation oSMRelation, long l2) {
        return l2;
    }

    public String toString() {
        return "rail";
    }

    protected double a(OSMWay oSMWay) {
        String string = oSMWay.getTag("railway");
        Integer n2 = 100;
        if (n2 == null) {
            throw new IllegalStateException("car, no speed found for:" + string);
        }
        return n2.intValue();
    }

    public long handleNodeTags(OSMNode oSMNode) {
        return 0L;
    }

    public long handleWayTags(OSMWay oSMWay, long l2, long l3) {
        long l4;
        if ((l2 & this.acceptBit) == 0L) {
            return 0L;
        }
        if ((l2 & this.ferryBit) == 0L) {
            double d2 = this.a(oSMWay);
            double d3 = this.getMaxSpeed(oSMWay);
            if (d3 > 0.0) {
                d2 = d3 * 0.9;
            }
            l4 = this.setSpeed(0L, d2);
            l4 = oSMWay.hasTag("oneway", (Set)this.oneways) || oSMWay.hasTag("junction", (Object)"roundabout") ? (oSMWay.hasTag("oneway", (Object)"-1") ? (l4 |= this.backwardBit) : (l4 |= this.forwardBit)) : (l4 |= this.directionBitMask);
        } else {
            l4 = this.handleFerryTags(oSMWay, 100.0, 100.0, 100.0);
            l4 |= this.directionBitMask;
        }
        return l4;
    }

    public int defineWayBits(int n2, int n3) {
        n3 = super.defineWayBits(n2, n3);
        this.speedEncoder = new EncodedDoubleValue("Speed", n3, this.speedBits, this.speedFactor, 100L, 100);
        return n3 + this.speedBits;
    }
}

