/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Graph;
import com.anylogic.engine.graph.GraphUtils;
import com.anylogic.engine.graph.Vertex;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class GraphPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    @AnyLogicCustomSerialization
    private transient Graph a;
    @AnyLogicCustomSerialization
    private transient Vertex e;
    @AnyLogicCustomSerialization
    private transient Vertex h;
    @AnyLogicCustomSerialization
    private transient List<Vertex> k;
    @AnyLogicCustomSerialization
    private transient List<Edge> d;

    public GraphPath(Graph graph, List<Vertex> list) {
        this(graph);
        this.a(list);
    }

    private GraphPath(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Argument 'graph' is null");
        }
        this.a = graph;
        this.d = new LinkedList<Edge>();
        this.k = new LinkedList<Vertex>();
    }

    private void a(List<Vertex> list) {
        if (list == null) {
            return;
        }
        this.k.addAll(list);
        this.d.addAll(GraphUtils.getPathEdges(list));
        if (list.isEmpty()) {
            return;
        }
        this.e = list.get(0);
        this.h = list.get(list.size() - 1);
    }

    public Graph getGraph() {
        return this.a;
    }

    public Vertex getSourceVertex() {
        return this.e;
    }

    public Vertex getTargetVertex() {
        return this.h;
    }

    public List<Vertex> getVertices() {
        return this.k;
    }

    public List<Edge> getEdges() {
        return this.d;
    }

    public GraphPath getReversedPath() {
        LinkedList<Vertex> linkedList = new LinkedList<Vertex>(this.k);
        Collections.reverse(linkedList);
        LinkedList<Edge> linkedList2 = new LinkedList<Edge>(this.d);
        Collections.reverse(linkedList2);
        GraphPath graphPath = new GraphPath(this.a);
        graphPath.k = linkedList;
        graphPath.d = linkedList2;
        graphPath.e = this.h;
        graphPath.h = this.e;
        return graphPath;
    }

    public void dispose() {
        this.a = null;
        this.e = null;
        this.h = null;
        this.k.clear();
        this.d.clear();
    }
}

