/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.graph.AbstractGraphNode;
import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Graph;
import com.anylogic.engine.graph.IGraphNodeInfo;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class Vertex
extends AbstractGraphNode<IGraphNodeInfo>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @AnyLogicCustomSerialization
    private transient Graph a;
    @AnyLogicCustomSerialization
    private transient Set<Edge> e;
    @AnyLogicCustomSerialization
    private transient Set<Edge> h;
    @AnyLogicCustomSerialization
    private transient Set<Edge> k;

    protected Vertex(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Argument 'graph' is null");
        }
        this.a = graph;
        this.e = new LinkedHashSet<Edge>();
        this.h = new LinkedHashSet<Edge>();
        this.k = new LinkedHashSet<Edge>();
    }

    public Graph getGraph() {
        return this.a;
    }

    public Set<Edge> getInternalEdges() {
        return this.e;
    }

    public Set<Edge> getExternalEdges() {
        return this.h;
    }

    public Set<Edge> getIncidents() {
        return this.k;
    }

    public void addIncident(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (edge.getSource() == this) {
            this.e.add(edge);
        } else if (edge.getTarget() == this) {
            this.h.add(edge);
        } else {
            throw new IllegalArgumentException("Incorrect 'edge' state");
        }
        this.k.add(edge);
    }

    public void removeIncident(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (edge.getSource() == this) {
            this.e.remove(edge);
        } else if (edge.getTarget() == this) {
            this.h.remove(edge);
        } else {
            throw new IllegalArgumentException("Incorrect 'edge' state");
        }
        this.k.remove(edge);
    }

    public Edge findEdge(Vertex vertex, boolean bl) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'target' is null");
        }
        Set<Edge> set = this.k;
        if (bl) {
            set = this.e;
        }
        Edge edge = null;
        for (Edge edge2 : set) {
            if (edge2.getOpposite(this) != vertex) continue;
            edge = edge2;
            break;
        }
        return edge;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.a = null;
        this.e.clear();
        this.h.clear();
        this.k.clear();
    }
}

