/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms;

import com.anylogic.engine.Utilities;
import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.GraphPath;
import com.anylogic.engine.graph.Vertex;
import com.anylogic.engine.graph.algorithms.GraphNodeInfos;
import com.anylogic.engine.graph.algorithms.IEdgeGeometryInfo;
import com.anylogic.engine.graph.algorithms.IGeometryInfoFactory;
import com.anylogic.engine.graph.algorithms.IVertexGeometryInfo;
import java.util.Collection;
import java.util.Map;

public final class GeometryUtils {
    private GeometryUtils() {
        throw new UnsupportedOperationException();
    }

    public static <T extends IVertexGeometryInfo> T addGeometryInfo(Vertex vertex, IGeometryInfoFactory iGeometryInfoFactory, Map<String, Object> map) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'vertex' is null");
        }
        if (iGeometryInfoFactory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        Object t = iGeometryInfoFactory.createVertexInfo(vertex, map);
        vertex.addInfo(GraphNodeInfos.Geometry.getName(), t);
        return t;
    }

    public static <T extends IVertexGeometryInfo> T getGeometryInfo(Vertex vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'vertex' is null");
        }
        if (!vertex.isSupportedInfo(GraphNodeInfos.Geometry.getName())) {
            throw new IllegalArgumentException("Argument 'vertex' not supported geometry info");
        }
        return (T)((IVertexGeometryInfo)vertex.getInfo(GraphNodeInfos.Geometry.getName()));
    }

    public static <T extends IEdgeGeometryInfo> T addGeometryInfo(Edge edge, IGeometryInfoFactory iGeometryInfoFactory, Map<String, Object> map) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (iGeometryInfoFactory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        Object t = iGeometryInfoFactory.createEdgeInfo(edge, map);
        edge.addInfo(GraphNodeInfos.Geometry.getName(), t);
        return t;
    }

    public static <T extends IEdgeGeometryInfo> T getGeometryInfo(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (!edge.isSupportedInfo(GraphNodeInfos.Geometry.getName())) {
            throw new IllegalArgumentException("Argument 'edge' not supported geometry info");
        }
        return (T)((IEdgeGeometryInfo)edge.getInfo(GraphNodeInfos.Geometry.getName()));
    }

    public static boolean isIntersectedLine(Vertex vertex, Vertex vertex2, Collection<Edge> collection, boolean bl) {
        Object t = GeometryUtils.getGeometryInfo(vertex);
        double d2 = t.getX();
        double d3 = t.getY();
        Object t2 = GeometryUtils.getGeometryInfo(vertex2);
        double d4 = t2.getX();
        double d5 = t2.getY();
        return GeometryUtils.isIntersectedLine(d2, d3, d4, d5, collection, bl);
    }

    public static boolean isIntersectedLine(double d2, double d3, double d4, double d5, Collection<Edge> collection, boolean bl) {
        boolean bl2 = false;
        Point point = new Point();
        for (Edge edge : collection) {
            double d6;
            double d7;
            double d8;
            Object t = GeometryUtils.getGeometryInfo(edge);
            double d9 = t.getSourceX();
            boolean bl3 = GeometryUtils.isIntersectedLine(point, d2, d3, d4, d5, d9, d8 = t.getSourceY(), d7 = t.getTargetX(), d6 = t.getTargetY(), bl);
            if (!bl3) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public static boolean isIntersectedLine(Edge edge, Edge edge2, boolean bl) {
        return GeometryUtils.isIntersectedLine(new Point(), edge, edge2, bl);
    }

    public static boolean isIntersectedLine(Point point, Edge edge, Edge edge2, boolean bl) {
        Vertex vertex = edge.getSource();
        Vertex vertex2 = edge.getTarget();
        Vertex vertex3 = edge2.getSource();
        Vertex vertex4 = edge2.getTarget();
        return GeometryUtils.isIntersectedLine(point, vertex, vertex2, vertex3, vertex4, bl);
    }

    public static boolean isIntersectedLine(Vertex vertex, Vertex vertex2, Vertex vertex3, Vertex vertex4, boolean bl) {
        return GeometryUtils.isIntersectedLine(new Point(), vertex, vertex2, vertex3, vertex4, bl);
    }

    public static boolean isIntersectedLine(Point point, Vertex vertex, Vertex vertex2, Vertex vertex3, Vertex vertex4, boolean bl) {
        Object t = GeometryUtils.getGeometryInfo(vertex);
        double d2 = t.getX();
        double d3 = t.getY();
        Object t2 = GeometryUtils.getGeometryInfo(vertex2);
        double d4 = t2.getX();
        double d5 = t2.getY();
        Object t3 = GeometryUtils.getGeometryInfo(vertex3);
        double d6 = t3.getX();
        double d7 = t3.getY();
        Object t4 = GeometryUtils.getGeometryInfo(vertex4);
        double d8 = t4.getX();
        double d9 = t4.getY();
        return GeometryUtils.isIntersectedLine(point, d2, d3, d4, d5, d6, d7, d8, d9, bl);
    }

    public static boolean isIntersectedLine(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, boolean bl) {
        return GeometryUtils.intersectionSegments(new Point(), d2, d3, d4, d5, d6, d7, d8, d9, bl) != null;
    }

    public static boolean isIntersectedLine(Point point, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, boolean bl) {
        return GeometryUtils.intersectionSegments(point, d2, d3, d4, d5, d6, d7, d8, d9, bl) != null;
    }

    public static Point intersectionSegments(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, boolean bl) {
        return GeometryUtils.intersectionSegments(new Point(), d2, d3, d4, d5, d6, d7, d8, d9, bl);
    }

    public static Point intersectionSegments(Point point, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, boolean bl) {
        Point point2 = null;
        if (!bl && (d2 == d6 && d3 == d7 || d2 == d8 && d3 == d9 || d4 == d6 && d5 == d7 || d4 == d8 && d5 == d9)) {
            return point2;
        }
        point2 = GeometryUtils.a(point, d2, d3, d4, d5, d6, d7, d8, d9);
        return point2;
    }

    private static Point a(Point point, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return (point = GeometryUtils.e(point, d2, d3, d4, d5, d6, d7, d8, d9)) != null && GeometryUtils.a(point, d2, d3, d4, d5) && GeometryUtils.a(point, d6, d7, d8, d9) ? point : null;
    }

    private static Point e(Point point, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = (d5 - d3) / (d4 - d2);
        double d11 = (d9 - d7) / (d8 - d6);
        if (d10 == Double.POSITIVE_INFINITY) {
            d10 = 1.0E25;
        }
        if (d10 == Double.NEGATIVE_INFINITY) {
            d10 = -1.0E25;
        }
        if (d11 == Double.POSITIVE_INFINITY) {
            d11 = 1.0E25;
        }
        if (d11 == Double.NEGATIVE_INFINITY) {
            d11 = -1.0E25;
        }
        double d12 = d3 - d10 * d2;
        double d13 = d7 - d11 * d6;
        if (d10 == d11) {
            return null;
        }
        point.a = (d13 - d12) / (d10 - d11);
        point.e = 0.0;
        if (Math.abs(d4 - d2) > Math.abs(d8 - d6)) {
            point.e = d10 * point.a + d12;
        } else {
            point.e = d11 * point.a + d13;
        }
        return point;
    }

    private static final boolean a(Point point, double d2, double d3, double d4, double d5) {
        if (Math.abs(d4 - d2) > Math.abs(d5 - d3)) {
            return d4 >= d2 && d4 >= point.a && point.a >= d2 || d4 < d2 && d2 >= point.a && point.a >= d4;
        }
        return d5 >= d3 && d5 >= point.e && point.e >= d3 || d5 < d3 && d3 >= point.e && point.e >= d5;
    }

    public static double getDistance(Vertex vertex, Vertex vertex2) {
        Object t = GeometryUtils.getGeometryInfo(vertex);
        double d2 = t.getX();
        double d3 = t.getY();
        Object t2 = GeometryUtils.getGeometryInfo(vertex2);
        double d4 = t2.getX();
        double d5 = t2.getY();
        return GeometryUtils.getDistance(d2, d3, d4, d5);
    }

    public static double getDistance(double d2, double d3, double d4, double d5) {
        return Utilities.getDistance(d2, d3, d4, d5);
    }

    public static double getDistanceFromPointToLine(double d2, double d3, double d4, double d5, double d6, double d7) {
        return Utilities.getDistanceFromPointToLine(d4, d5, d6, d7, d2, d3);
    }

    public static double getPathLength(GraphPath graphPath) {
        if (graphPath == null) {
            throw new IllegalArgumentException("Argument 'path' is null");
        }
        double d2 = 0.0;
        for (Edge edge : graphPath.getEdges()) {
            Object t = GeometryUtils.getGeometryInfo(edge);
            d2 += t.getLength();
        }
        return d2;
    }

    public static boolean isCircleLineIntersect(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10;
        double d11 = d4 - d2;
        double d12 = d5 - d3;
        double d13 = d11 * d11 + d12 * d12;
        double d14 = 2.0 * (d11 * (d2 - d6) + d12 * (d3 - d7));
        double d15 = d6 * d6 + d7 * d7;
        d15 += d2 * d2 + d3 * d3;
        d15 -= 2.0 * (d6 * d2 + d7 * d3);
        double d16 = d14 * d14 - 4.0 * d13 * (d15 -= d8 * d8);
        if (d16 < 0.0) {
            return false;
        }
        double d17 = (-d14 + Math.sqrt(d14 * d14 - 4.0 * d13 * d15)) / (2.0 * d13);
        double d18 = d2 + d17 * d11;
        double d19 = d3 + d17 * d12;
        d17 = (-d14 - Math.sqrt(d14 * d14 - 4.0 * d13 * d15)) / (2.0 * d13);
        double d20 = d2 + d17 * d11;
        double d21 = d3 + d17 * d12;
        if (GeometryUtils.getDistance(d2, d3, d6, d7) < GeometryUtils.getDistance(d4, d5, d6, d7)) {
            d10 = d4;
            d9 = d5;
        } else {
            d10 = d2;
            d9 = d3;
        }
        return GeometryUtils.getDistance(d10, d9, d18, d19) < GeometryUtils.getDistance(d2, d3, d4, d5) || GeometryUtils.getDistance(d10, d9, d20, d21) < GeometryUtils.getDistance(d2, d3, d4, d5);
    }

    public static final class Point {
        private double a;
        private double e;

        public Point() {
            this(0.0, 0.0);
        }

        public Point(double d2, double d3) {
            this.a = d2;
            this.e = d3;
        }

        public void setX(double d2) {
            this.a = d2;
        }

        public double getX() {
            return this.a;
        }

        public void setY(double d2) {
            this.e = d2;
        }

        public double getY() {
            return this.e;
        }
    }
}

