/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.shortestpath;

import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Graph;
import com.anylogic.engine.graph.GraphPath;
import com.anylogic.engine.graph.IGraphNodeFilter;
import com.anylogic.engine.graph.Vertex;
import com.anylogic.engine.graph.algorithms.shortestpath.IAStarAlgorithmCosts;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class AStarAlgorithm {
    private Graph a;
    private IAStarAlgorithmCosts e;
    private IGraphNodeFilter h;

    public AStarAlgorithm(Graph graph, IAStarAlgorithmCosts iAStarAlgorithmCosts, IGraphNodeFilter iGraphNodeFilter) {
        if (graph == null) {
            throw new IllegalArgumentException("Argument 'graph' is null");
        }
        if (iAStarAlgorithmCosts == null) {
            throw new IllegalArgumentException("Argument 'costs' is null");
        }
        this.a = graph;
        this.e = iAStarAlgorithmCosts;
        this.h = iGraphNodeFilter;
    }

    public Graph getGraph() {
        return this.a;
    }

    public IAStarAlgorithmCosts getCosts() {
        return this.e;
    }

    public IGraphNodeFilter getFilter() {
        return this.h;
    }

    public GraphPath compute(Vertex vertex, Vertex vertex2) {
        return this.compute(vertex, vertex2, false);
    }

    public GraphPath compute(Vertex vertex, Vertex vertex2, boolean bl) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'sourceVertex' is null");
        }
        if (vertex2 == null) {
            throw new IllegalArgumentException("Argument 'targetVertex' is null");
        }
        if (!this.a.getVertices().contains(vertex)) {
            throw new IllegalArgumentException("Argument 'sourceVertex' not found in graph");
        }
        if (!this.a.getVertices().contains(vertex2)) {
            throw new IllegalArgumentException("Argument 'targetVertex' not found in graph");
        }
        HashMap<Vertex, Double> hashMap = new HashMap<Vertex, Double>();
        HashMap<Vertex, Double> hashMap2 = new HashMap<Vertex, Double>();
        HashMap<Vertex, Vertex> hashMap3 = new HashMap<Vertex, Vertex>();
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        HashSet<Vertex> hashSet2 = new HashSet<Vertex>();
        PriorityQueue<Vertex> priorityQueue = new PriorityQueue<Vertex>(this.a.getVertices().size(), new n(hashMap));
        hashMap.put(vertex, 0.0);
        hashSet.add(vertex);
        priorityQueue.add(vertex);
        GraphPath graphPath = null;
        while (!priorityQueue.isEmpty()) {
            Vertex vertex3 = priorityQueue.poll();
            if (!this.a(vertex3)) continue;
            if (vertex3 == vertex2) {
                graphPath = this.a(vertex, vertex2, hashMap3);
                break;
            }
            hashSet.remove(vertex3);
            hashSet2.add(vertex3);
            Set<Edge> set = bl ? vertex3.getInternalEdges() : vertex3.getIncidents();
            for (Edge edge : set) {
                Vertex vertex4;
                if (!this.a(edge) || !this.a(vertex4 = edge.getOpposite(vertex3)) || hashSet2.contains(vertex4)) continue;
                double d2 = this.a(edge, vertex4, hashMap);
                if (!hashSet.contains(vertex4)) {
                    hashMap3.put(vertex4, vertex3);
                    double d3 = this.a(vertex4, vertex2);
                    hashMap.put(vertex4, d2);
                    hashMap2.put(vertex4, d3);
                    hashSet.add(vertex4);
                    priorityQueue.add(vertex4);
                    continue;
                }
                if (!((Double)hashMap.get(vertex4) > d2)) continue;
                hashMap.put(vertex4, d2);
                hashMap3.put(vertex4, vertex3);
            }
        }
        return graphPath;
    }

    private boolean a(Vertex vertex) {
        return this.h == null ? true : this.h.accept(vertex);
    }

    private boolean a(Edge edge) {
        return this.h == null ? true : this.h.accept(edge);
    }

    private double a(Edge edge, Vertex vertex, Map<Vertex, Double> map) {
        Vertex vertex2 = edge.getOpposite(vertex);
        double d2 = map.get(vertex2);
        boolean bl = edge.getTarget() == vertex;
        double d3 = this.e.getEdgeGCost(edge, bl);
        double d4 = d2 + d3;
        return d4;
    }

    private double a(Vertex vertex, Vertex vertex2) {
        double d2 = this.e.getVertexHCost(vertex, vertex2);
        return d2;
    }

    private GraphPath a(Vertex vertex, Vertex vertex2, Map<Vertex, Vertex> map) {
        LinkedList<Vertex> linkedList = new LinkedList<Vertex>();
        Vertex vertex3 = vertex2;
        do {
            if (vertex3 == null) {
                return null;
            }
            linkedList.addFirst(vertex3);
        } while ((vertex3 = map.get(vertex3)) != vertex);
        linkedList.addFirst(vertex);
        return new GraphPath(this.a, linkedList);
    }

    public void dispose() {
        this.a = null;
        this.e = null;
        this.h = null;
    }

    private class n
    implements Comparator<Vertex> {
        private Map<Vertex, Double> e;

        public n(Map<Vertex, Double> map) {
            this.e = map;
        }

        public int a(Vertex vertex, Vertex vertex2) {
            double d2;
            if (vertex == null) {
                return 1;
            }
            if (vertex2 == null) {
                return -1;
            }
            if (vertex == vertex2) {
                return 0;
            }
            double d3 = this.e.get(vertex);
            if (d3 > (d2 = this.e.get(vertex2).doubleValue())) {
                return 1;
            }
            if (d3 < d2) {
                return -1;
            }
            return 0;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((Vertex)object, (Vertex)object2);
        }
    }
}

