/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.triangulation;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Vertex;
import com.anylogic.engine.graph.algorithms.triangulation.Triangulation;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class Triangle
implements Serializable {
    private static final long serialVersionUID = 1L;
    @AnyLogicCustomSerialization
    private transient Triangulation a;
    @AnyLogicCustomSerialization
    private transient Set<Vertex> e;
    @AnyLogicCustomSerialization
    private transient Set<Edge> h;
    @AnyLogicCustomSerialization
    private transient Set<Triangle> k;

    protected Triangle(Triangulation triangulation, Edge edge, Edge edge2, Edge edge3) {
        if (triangulation == null) {
            throw new IllegalArgumentException("Argument 'triangulation' is null");
        }
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge1' is null");
        }
        if (edge2 == null) {
            throw new IllegalArgumentException("Argument 'edge2' is null");
        }
        if (edge3 == null) {
            throw new IllegalArgumentException("Argument 'edge3' is null");
        }
        this.a = triangulation;
        this.a();
        this.initialize(edge, edge2, edge3);
    }

    private void a() {
        this.e = new LinkedHashSet<Vertex>();
        this.h = new LinkedHashSet<Edge>();
        this.k = new LinkedHashSet<Triangle>();
    }

    protected void initialize(Edge edge, Edge edge2, Edge edge3) {
        this.h.add(edge);
        this.h.add(edge2);
        this.h.add(edge3);
        if (this.h.size() != 3) {
            throw new RuntimeException("Cannot create triangle");
        }
        this.e.addAll(edge.getIncidents());
        this.e.addAll(edge2.getIncidents());
        this.e.addAll(edge3.getIncidents());
        if (this.e.size() != 3) {
            throw new RuntimeException("Cannot create triangle");
        }
    }

    public Triangulation getTriangulation() {
        return this.a;
    }

    public Set<Vertex> getVertices() {
        return this.e;
    }

    public Set<Edge> getEdges() {
        return this.h;
    }

    public Set<Triangle> getIncidents() {
        return this.k;
    }

    public void addIncident(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        Set<Edge> set = this.getEdge(triangle);
        if (set.isEmpty()) {
            throw new IllegalArgumentException("Incorrect 'triangle' state");
        }
        this.k.add(triangle);
    }

    public void removeIncident(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        if (!this.k.contains(triangle)) {
            throw new IllegalArgumentException("Incorrect 'triangle' not found");
        }
        this.k.remove(triangle);
    }

    public Set<Vertex> getVertices(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        LinkedHashSet<Vertex> linkedHashSet = new LinkedHashSet<Vertex>(this.e);
        linkedHashSet.retainAll(triangle.getVertices());
        return linkedHashSet;
    }

    public Set<Edge> getEdge(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        LinkedHashSet<Edge> linkedHashSet = new LinkedHashSet<Edge>(this.h);
        linkedHashSet.retainAll(triangle.getEdges());
        return linkedHashSet;
    }

    public Triangle getOppositeTriangle(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (!this.h.contains(edge)) {
            throw new IllegalArgumentException("Argument 'edge' not found in tirangle");
        }
        Triangle triangle = null;
        for (Triangle triangle2 : this.k) {
            if (!triangle2.getEdges().contains(edge)) continue;
            triangle = triangle2;
            break;
        }
        return triangle;
    }

    public Edge getEdge(Vertex vertex, Vertex vertex2) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'sourceVertex' is null");
        }
        if (vertex2 == null) {
            throw new IllegalArgumentException("Argument 'targetVertex' is null");
        }
        if (!this.e.contains(vertex)) {
            throw new IllegalArgumentException("Argument 'sourceVertex' not found in triangle");
        }
        if (!this.e.contains(vertex2)) {
            throw new IllegalArgumentException("Argument 'targetVertex' not found in triangle");
        }
        Edge edge = null;
        for (Edge edge2 : this.h) {
            Vertex vertex3 = edge2.getSource();
            Vertex vertex4 = edge2.getTarget();
            if ((vertex3 != vertex || vertex4 != vertex2) && (vertex3 != vertex2 || vertex4 != vertex)) continue;
            edge = edge2;
            break;
        }
        return edge;
    }

    public void dispose() {
        this.a = null;
        this.e.clear();
        this.h.clear();
        this.k.clear();
    }
}

